package com.bcxin.platform.service.insurance.manage;

import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.domain.insurance.ComInsGuaProject;
import com.bcxin.platform.dto.excel.InsExcelVo;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.ComInsPrincipalDTO;
import com.bcxin.platform.mapper.ins.ComInsGuaProjectManageMapper;
import com.bcxin.platform.mapper.ins.ComInsManageMapper;
import com.bcxin.platform.mapper.ins.ComInsPrincipalManageMapper;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.*;

/**
 * <p>
 *  保险审核
 * </p>
 *
 * @author 李勇强
 * @since 2018-01-31 17:07:42
 */
@Service
public class ComInsManageServiceImpl implements ComInsManageService {

    @Autowired
    private ComInsManageMapper comInsMapper;
    @Autowired
    private ComInsGuaProjectManageMapper comInsGuaProjectMapper;
    @Autowired
    private ComInsPrincipalManageMapper comInsPrincipalMapper;



    /**
     * 企业保险查询分页
     * @param dto
     * @return
     */
    @Override
    public List<Map<String,Object>> pageComInsList(ComInsDTO dto) {
        /*查询有效记录*/
        List<Map<String,Object>> list = comInsMapper.getComInsPage(dto);
        return list;
    }

    /**
     * 查询企业保险信息
     * @param dto
     * @return
     * @throws V5BusinessException
     */
    @Override
    public Result getComInsInfo(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComInsId() == null) {
            throw new V5BusinessException(Result.ERROR, "参数comInsId不能为空");
        }
        Map<String, Object> rec = comInsMapper.selectById(dto.getComInsId());
        List<ComInsGuaProject> list = comInsGuaProjectMapper.selectItemsById(dto.getComInsId());
        Map<String, Object> m = Maps.newHashMap();
        m.put("comIns", rec);
        m.put("comInsGuaProjectList", list);
        return Result.success("", m);
    }

    @Override
    public Map<String, Object> getComInsInfo(String comInsId) throws V5BusinessException {
        if (StringUtils.isEmpty(comInsId)) {
            throw new V5BusinessException(Result.ERROR, "参数comInsId不能为空");
        }
        Map<String, Object> rec = comInsMapper.selectById(Long.parseLong(comInsId));
        return rec;
    }

    /**
     * <b> 根据企业ID，查询保险负责人列 </b>
     * @author ZXF
     * @create 2019/05/17 0017 16:45
     * @version
     * @注意事项 </b>
     */
    @Override
    public List<Map> selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException(Result.ERROR, "参数comId不能为空");
        }
        List<Map> list = comInsPrincipalMapper.selectPrincipalByComId(dto);
        return list;
    }

    /**
     * <b> 修改在保人数 </b>
     * @author ZXF
     * @create 2019/12/27 0027 16:09
     * @version
     * @注意事项 </b>
     */
    @Override
    public Result updatePerNum(ComInsDTO dto) {
        comInsMapper.updatePerNum(dto);
        return Result.success(Result.SUCCESS_MSG);
    }

    /**
     * <b> 保险推荐报表下载 </b>
     * @author ZXF
     * @create 2020/04/07 0007 16:31
     * @version
     * @注意事项 </b>
     */
    @Override
    public void downInsSchedule(HttpServletResponse response) {
        try {
            OutputStream os = null;
            ExcelUtil<InsExcelVo> util = new ExcelUtil(InsExcelVo.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String("保险推荐报表.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            List<InsExcelVo> listMap = comInsMapper.downInsSchedule();
            util.exportExcel(listMap, "保险推荐报表", 65535, os);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
