package com.bcxin.platform.service.grant;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.grant.ComBhAccount;
import com.bcxin.platform.dto.grant.ComBhAccountDTO;

import java.util.List;

/**
 * 企业渤海银行
 * @author llc
 * @date 2020-08-11
 */
public interface ComBhAccountService {

    /**
     * 获取企业渤海账户
     * @param comBhAccount
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result getComBhAccount(ComBhAccount comBhAccount) throws V5BusinessException;


    /**
     * 获取企业渤海账户余额
     * @param comBhAccount
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result getComBhAccountAmount(ComBhAccount comBhAccount) throws V5BusinessException;


    /**
     * 企业开户发送验证码
     * @param dto
     * @author llc
     * @date 2020-08-25
     * @return
     */
    Result sendOpenAccountVerifyCode(ComBhAccountDTO dto) throws V5BusinessException;

    /**
     * 注册企业渤海账户
     * @param dto
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result saveComBhAccount(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 修改企业渤海账户
     * @param dto
     * @author llc
     * @date 2020-08-12
     * @return
     */
    Result updateComBhAccount(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 查询渤海银行列表
     * @param comBhAccount
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result getBhBankList(ComBhAccount comBhAccount) throws V5BusinessException;


    /**
     * 发送验证码
     * @param dto
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result sendVerifyCode(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 渤海银账户充值
     * @param dto
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result bhAccountRecharge(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 渤海银账户提现
     * @param dto
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result bhAccountWithdrawa(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 获取账户历史明细列表
     * @param dto
     * @author llc
     * @date 2020-08-11
     * @return
     */
    Result getAccountHistoryDetailList(ComBhAccountDTO dto) throws V5BusinessException;


    /**
     * 修改手机
     * @param dto
     * @author llc
     * @date 2020-10-12
     * @return
     */
    Result updateMobilePhone(ComBhAccountDTO dto) throws V5BusinessException;

    /**
     * <b> 企业渤海账户列表查询 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:38
     * @version
     * @注意事项 </b>
     */
    List<ComBhAccountDTO> pageComBhAccountList(ComBhAccountDTO dto);

    /**
     * <b> 获取账户历史明细明细列表 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:38
     * @version
     * @注意事项 </b>
     */
    List pagePaymentDetailsList(ComBhAccountDTO dto) throws V5BusinessException;

    /**
     * <b> 获取企业渤海账户 </b>
     * @author ZXF
     * @create 2020/08/17 0017 14:38
     * @version
     * @注意事项 </b>
     */
    ComBhAccountDTO getComBhAccount(String comId);

    /**
     * <b> 修改发薪权限 </b>
     * @author ZXF
     * @create 2020/09/16 0016 13:31
     * @version
     * @注意事项 </b>
     */
    Result updateOpenSalaryAuth(ComBhAccountDTO dto);
}