package com.bcxin.platform.service.attend.impl;

import java.util.List;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.bcxin.platform.mapper.attend.AttendWifiMapper;
import com.bcxin.platform.domain.attend.AttendWifi;
import com.bcxin.platform.service.attend.AttendWifiService;
import com.bcxin.platform.common.core.text.Convert;
import javax.annotation.Resource;

/**
 * 考勤wifiService业务层处理
 * 
 * @author lin
 * @date 2022-04-09
 */
@Service
@Transactional
public class AttendWifiServiceImpl implements AttendWifiService{

    @Autowired
    private AttendWifiMapper attendWifiMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询考勤wifi
     * 
     * @param id 考勤wifiID
     * @return 考勤wifi
     */
    @Override
    public AttendWifi findById(Long id){
        return attendWifiMapper.findById(id);
    }

    /**
     * 查询考勤wifi列表
     * 
     * @param attendWifi 考勤wifi
     * @return 考勤wifi
     */
    @Override
    public List<AttendWifi> selectList(AttendWifi attendWifi){
        return attendWifiMapper.selectList(attendWifi);
    }

    /**
     * 修改考勤wifi
     * 
     * @param attendWifi 考勤wifi
     * @return 结果
     */
    @Override
    public int update(AttendWifi attendWifi){
        if(attendWifi.getId() == null){
            attendWifi.setCreateTime(DateUtils.getNowDate());
            attendWifi.setId(idWorker.nextId());
        }else{
            AttendWifi dbAttendWifi = attendWifiMapper.findById(attendWifi.getId());
            BeanUtils.copyPropertiesIgnore(attendWifi,dbAttendWifi,true);
            BeanUtils.copyPropertiesIgnore(dbAttendWifi,attendWifi,false);
        }
        attendWifi.setUpdateTime(DateUtils.getNowDate());
        return attendWifiMapper.save(attendWifi);
    }

    /**
     * 删除考勤wifi对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendWifiMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除考勤wifi信息
     * 
     * @param id 考勤wifiID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendWifiMapper.deleteById(id);
    }
}
