package com.bcxin.platform.mapper.product;


import com.bcxin.platform.domain.product.ProductCoupon;
import com.bcxin.platform.dto.product.ProductCouponDownloadDto;
import com.bcxin.platform.dto.product.ProductCouponDto;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 产品优惠券
 *
 * @author llc
 * @date 2020-12-16
 */
@Component
public interface ProductCouponMapper{

    /**
     * 获取优惠券
     * @param productCouponId
     * @param productCategoryType
     * @author llc
     * @date 2020-12-16
     * @return
     */
    ProductCoupon getProductCouponById(@Param("productCouponId") Long productCouponId, @Param("productCategoryType") String productCategoryType);

    /**
     * 更新优惠券
     * @param productCoupon
     * @author llc
     * @date 2020-12-16
     * @return
     */
    Integer updateProductCouponById(ProductCoupon productCoupon);


    /**
     * 查询产品优惠券
     *
     * @param productCouponId 产品优惠券ID
     * @return 产品优惠券
     */
    ProductCoupon selectProductCouponById(Long productCouponId);

    /**
     * 查询产品优惠券列表
     *
     * @param productCoupon 产品优惠券
     * @return 产品优惠券集合
     */
    List<ProductCouponDownloadDto> selectProductCouponList(ProductCouponDto productCoupon);

    /**
     * 删除产品优惠券
     *
     * @param productCouponId 产品优惠券ID
     * @return 结果
     */
    int deleteProductCouponById(Long productCouponId);

    /**
     * 批量删除产品优惠券
     *
     * @param productCouponIds 需要删除的数据ID
     * @return 结果
     */
    int deleteProductCouponByIds(String[] productCouponIds);

    /****
     * 保存
     * @param productCoupon
     * @return
     */
    int save(ProductCoupon productCoupon);

    /****
     * 选择修改
     * @param productCoupon
     * @return
     */
    int updateSelective(ProductCoupon productCoupon);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<ProductCoupon> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<ProductCoupon> findByBatchId(@Param("list")List<ProductCoupon> list);

}