package com.bcxin.platform.dto.order;

import com.bcxin.platform.domain.order.ComOrder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;
import java.util.Map;

@Data
public class ComOrderVo extends ComOrder {

    /** 订单详情列表字符串 */
    @ApiModelProperty(value = "订单详情列表字符串")
    private String orderDetailListStr;

    /** 产品范畴 */
    @ApiModelProperty(value = "产品范畴")
    private String productCategory;

    /** 短信验证码 */
    @ApiModelProperty(value = "短信验证码")
    private String activeCode;

    /** 分配组织 */
    @ApiModelProperty(value = "分配组织")
    private String assignedOrgName;

    /** 订单号 */
    @ApiModelProperty(value = "订单号")
    private String orderNo;


    /** 订单详情列表 */
    @ApiModelProperty(value = "订单详情列表")
    private List<Map<String,Object>> orderDetailList;

    /**
     * 企业名称
     */
    private String comName;

    private String startDate;

    private String endDate;

    /**
     * 订单状态，0：正常 1：到期，仅查询时返回 2：停用
     */
    private String status;
}
