package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 考勤打卡日历套-日历对象 tb_attend_calendar_detail
 * 
 * @author lin
 * @date 2021-08-10
 */
@Data
public class AttendCalendarRestDetailDto implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 日历ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 日历类型 1-休息日 2-法定假日 */
    @Excel(name = "日历类型")
    private String calendarType;

    /** 日期 */
    @Excel(name = "日期", width = 30, dateFormat = "yyyy-MM-dd")
    private String restDate;


    /** 日历套ID */
    @Excel(name = "日历套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long calendarId;

    /** 日历套名称 */
    @Excel(name = "日历套名称")
    private String calendarName;

    /**
     * 操作者
     */
    @Excel(name = "操作者")
    private String operator;

    /**
     * 操作时间
     */
    @Excel(name = "操作时间")
    private String operationTime;

    /** 请求参数 */
    private Map<String, Object> params;

}
