package com.bcxin.platform.domain.insurance;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

/**
 * <b> 企业保险购买人员明细 </b>
 * @author ZXF
 * @create 2021/05/27 0027 16:30
 * @version
 * @注意事项 </b>
 */
@TableName("com_online_ins_per")
@Data
@DisMultiTenancy
public class ComOnlineInsPer extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 保险人员明细Id
     */
	private Long insPerDetailId;

    /**
     * 证件号码
     */
	private String idCardNo;

    /**
     * 姓名
     */
	private String name;

    /**
     * 人员id
     */
	private Long perId;

    /**
     * 企业保险ID
     */
	private Long comInsId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getInsPerDetailId() {
		return insPerDetailId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComInsId() {
		return comInsId;
	}
}
