package com.bcxin.platform.domain.insurance;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

import java.util.Date;

/**
 * <b> 企业保险负责人 </b>
 * @author ZXF
 * @create 2019/05/17 0017 16:03
 * @version
 * @注意事项 </b>
 */
@TableName("com_ins_principal")
@Data
@DisMultiTenancy
public class ComInsPrincipal extends BaseEntity {

    private static final long serialVersionUID = 1L;

	private Long comId;

	private Long perId;

	private Long createBy;

	private Date createTime;

    /**
     * 证件号码
     */
	private String idCardNo;
	/**
	 * 姓名
	 */
	private String name;
	/**
	 * 手机
	 */
	private String mobilePhone;
	/**
	 * 部门名称
	 */
	private String departName;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getPerId() {
		return perId;
	}
}
