package com.bcxin.platform.domain.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.common.utils.validator.group.QueryGroup;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 考勤结果统计对象 tb_attend_report
 * 
 * @author lin
 * @date 2021-08-30
 */
@Data
public class AttendReport extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /** 报表ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /** 部门ID */
    @Excel(name = "部门ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    /** 公司ID */
    @Excel(name = "公司ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    /** 日期 */
    @Excel(name = "日期")
    @NotBlank(message="查询日期不能为空", groups = {QueryGroup.class})
    private String reportDate;


    private String minShiftType;

    private String maxShiftType;

    /** 报表类型 1日报 2月报 */
    @Excel(name = "报表类型 1日报 2月报")
    private String attendReportType;

    /** 结果状态 0异常1正常2缺卡3迟到4早退5缺勤 */
    @Excel(name = "结果状态 ")
    private String attendResultStatus;

    /** 应出勤时数 */
    @Excel(name = "应出勤时数")
    private Double shiftHour;

    /** 实际出勤时数 */
    @Excel(name = "实际出勤时数")
    private Double workHour;

    /** 应出勤次数 */
    @Excel(name = "应出勤次数")
    private Integer shiftNum;

    /** 实际出勤次数 */
    @Excel(name = "实际出勤次数")
    private Integer workNum;

    /** 出勤天数 */
    @Excel(name = "出勤天数")
    private Integer workCount;

    /** 休息天数 */
    @Excel(name = "休息天数")
    private Integer restCount;

    /** 旷工时数 */
    @Excel(name = "旷工时数")
    private Double absenteeism;

    /** 早退分钟数 */
    @Excel(name = "早退分钟数")
    private Integer leaveEarly;

    /** 早退次数 */
    @Excel(name = "早退次数")
    private Integer leaveEarlyCount;

    /** 迟到分钟数 */
    @Excel(name = "迟到分钟数")
    private Integer lateMin;

    /** 迟到次数 */
    @Excel(name = "迟到次数")
    private Integer lateCount;


    /** 漏卡次数 */
    @Excel(name = "漏卡次数")
    private Integer missCard;

    /** 请假时数 */
    @Excel(name = "请假时数")
    private Double leaveHour;

    /** 公出时数 */
    @Excel(name = "公出时数")
    private Double businessOut;

    /** 加班时数 */
    @Excel(name = "加班时数")
    private Double overtime;

    /** 出差时数 */
    @Excel(name = "出差时数")
    private Double businessTrip;

    private String tlkPerId;

}
