/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.quartz.util;

import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.spring.SpringUtils;
import com.bcxin.platform.quartz.domain.SysJob;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public class JobInvokeUtil {
    public static void invokeMethod(SysJob sysJob) throws Exception {
        String invokeTarget = sysJob.getInvokeTarget();
        String beanName = JobInvokeUtil.getBeanName(invokeTarget);
        String methodName = JobInvokeUtil.getMethodName(invokeTarget);
        List<Object[]> methodParams = JobInvokeUtil.getMethodParams(invokeTarget);
        if (!JobInvokeUtil.isValidClassName(beanName)) {
            Object bean = SpringUtils.getBean((String)beanName);
            JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
        } else {
            Object bean = Class.forName(beanName).newInstance();
            JobInvokeUtil.invokeMethod(bean, methodName, methodParams);
        }
    }

    private static void invokeMethod(Object bean, String methodName, List<Object[]> methodParams) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (StringUtils.isNotNull(methodParams) && methodParams.size() > 0) {
            Method method = bean.getClass().getDeclaredMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
            method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
        } else {
            Method method = bean.getClass().getDeclaredMethod(methodName, new Class[0]);
            method.invoke(bean, new Object[0]);
        }
    }

    public static boolean isValidClassName(String invokeTarget) {
        return StringUtils.countMatches((CharSequence)invokeTarget, (CharSequence)".") > 1;
    }

    public static String getBeanName(String invokeTarget) {
        String beanName = StringUtils.substringBefore((String)invokeTarget, (String)"(");
        return StringUtils.substringBeforeLast((String)beanName, (String)".");
    }

    public static String getMethodName(String invokeTarget) {
        String methodName = StringUtils.substringBefore((String)invokeTarget, (String)"(");
        return StringUtils.substringAfterLast((String)methodName, (String)".");
    }

    public static List<Object[]> getMethodParams(String invokeTarget) {
        String methodStr = StringUtils.substringBetween((String)invokeTarget, (String)"(", (String)")");
        if (StringUtils.isEmpty((String)methodStr)) {
            return null;
        }
        String[] methodParams = methodStr.split(",");
        LinkedList<Object[]> classs = new LinkedList<Object[]>();
        for (int i = 0; i < methodParams.length; ++i) {
            String str = StringUtils.trimToEmpty((String)methodParams[i]);
            if (StringUtils.contains((CharSequence)str, (CharSequence)"'")) {
                classs.add(new Object[]{StringUtils.replace((String)str, (String)"'", (String)""), String.class});
                continue;
            }
            if (StringUtils.equals((CharSequence)str, (CharSequence)"true") || StringUtils.equalsIgnoreCase((CharSequence)str, (CharSequence)"false")) {
                classs.add(new Object[]{Boolean.valueOf(str), Boolean.class});
                continue;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)"L")) {
                classs.add(new Object[]{Long.valueOf(StringUtils.replaceIgnoreCase((String)str, (String)"L", (String)"")), Long.class});
                continue;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)str, (CharSequence)"D")) {
                classs.add(new Object[]{Double.valueOf(StringUtils.replaceIgnoreCase((String)str, (String)"D", (String)"")), Double.class});
                continue;
            }
            classs.add(new Object[]{Integer.valueOf(str), Integer.class});
        }
        return classs;
    }

    public static Class<?>[] getMethodParamsType(List<Object[]> methodParams) {
        Class[] classs = new Class[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = (Class)os[1];
            ++index;
        }
        return classs;
    }

    public static Object[] getMethodParamsValue(List<Object[]> methodParams) {
        Object[] classs = new Object[methodParams.size()];
        int index = 0;
        for (Object[] os : methodParams) {
            classs[index] = os[0];
            ++index;
        }
        return classs;
    }
}

