package com.bcxin.platform.mapper.wallet;

import com.bcxin.platform.domain.wallet.ComWalletProcess;
import org.apache.ibatis.annotations.Param;

/**
 * 企业钱包开户流程
 *
 * @author llc
 * @date 2019-06-21
 */
public interface ComWalletProcessMapper {

    /**
     * 获取企业钱包服务当前开通步骤
     *
     * @param comId
     * @return
     * @author llc
     * @date 2019-06-21
     */
    ComWalletProcess getComWalletCurrentProcess(@Param("comId") Long comId);


    /**
     * 更新企业钱包开户流程
     *
     * @param comWalletProcess
     * @return
     * @author llc
     * @date 2019-06-24
     */
    int updateComWalletProcess(ComWalletProcess comWalletProcess);

    /**
     * 插入企业钱包开户流程
     *
     * @param comId
     * @return
     * @author lp
     * @date 2019-09-05
     */
    int insertComWalletProcess(@Param("comId") Long comId,@Param("type") String type);

}