package com.bcxin.platform.mapper.grant;


import com.bcxin.platform.domain.grant.ComBhAccount;
import com.bcxin.platform.dto.grant.ComBhAccountDTO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 企业渤海银行
 *
 * @author llc
 * @date 2020-08-11
 */
public interface ComBhAccountMapper{

    /**
     * 查询企业渤海账户
     * @param comId
     * @author llc
     * @date 2020-08-11
     * @return
     */
    ComBhAccount getComBhAccountByComId(@Param("comId") Long comId);

    /**
     * 注册企业渤海账户
     * @param comBhAccount
     * @author llc
     * @date 2020-08-11
     * @return
     */
    int insertComBhAccount(ComBhAccount comBhAccount);


    /**
     * 修改企业渤海账户
     * @param comBhAccount
     * @author llc
     * @date 2020-08-12
     * @return
     */
    int updateComBhAccount(ComBhAccount comBhAccount);

    /**
     * <b> 企业渤海账户列表查询 </b>
     * @author ZXF
     * @create 2020/08/17 0017 15:01
     * @version
     * @注意事项 </b>
     */
    List<ComBhAccountDTO> pageComBhAccountList(ComBhAccountDTO dto);

    int updateOpenSalaryAuth(ComBhAccountDTO dto);
}