package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendCalendarRestDetail;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡日历套-日历-假日Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarRestDetailMapper {

    /**
     * 查询考勤打卡日历套-日历-假日
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 考勤打卡日历套-日历-假日
     */
    AttendCalendarRestDetail findById(Long id);

    /**
     * 查询考勤打卡日历套-日历-假日列表
     * 
     * @param attendCalendarRestDetailDto 考勤打卡日历套-日历-假日
     * @return 考勤打卡日历套-日历-假日集合
     */
    List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarRestDetailDto);

    /**
     * 删除考勤打卡日历套-日历-假日
     * 
     * @param id 考勤打卡日历套-日历-假日ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤打卡日历套-日历-假日
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendCalendarRestDetail
     * @return
     */
    int save(AttendCalendarRestDetail attendCalendarRestDetail);

    /****
     * 选择修改
     * @param attendCalendarRestDetail
     * @return
     */
    int updateSelective(AttendCalendarRestDetail attendCalendarRestDetail);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendCalendarRestDetail> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendCalendarRestDetail> findByBatchId(@Param("list") List<AttendCalendarRestDetail> list);

    int deleteByCalendarIds(String[] calendarIds);
}
