package com.bcxin.platform.dto.attend;

import com.bcxin.platform.common.annotation.Excel;
import com.bcxin.platform.common.core.domain.BaseEntity;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/11 0011 14:21
 */
@Data
public class AttendPerDto extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 考勤人员ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long id;

    /** 人员ID */
    @Excel(name = "人员ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long perId;

    /** 考勤套ID */
    @Excel(name = "考勤套ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long attendId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comId;

    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long deptId;

    private String name;
    /**
     * 证件号码
     */
    @ApiModelProperty(value = "证件号码")
    private String idCardNo;
    /**
     * 手机号
     */
    @ApiModelProperty(value = "手机号")
    private String mobilePhone;

    private String departName;

    private String perType;

    private String attendName;

    /**
     * 操作者
     */
    private String operator;

    /**
     * 操作时间
     */
    private String operationTime;

    private List<Long> perIds;
}
