package com.bcxin.platform.domain.insurance;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import lombok.Data;

/**
 * <b> 企业保险保障项目 </b>
 * @author ZXF
 * @create 2021/05/27 0027 17:07
 * @version
 * @注意事项 </b>
 */
@TableName("com_ins_gua_project")
@Data
@DisMultiTenancy
public class ComInsGuaProject extends BaseEntity{

    private static final long serialVersionUID = 1L;

    /**
     * 保障项目ID
     */
	private Long guaranteeProjectId;
    /**
     * 是否逻辑删除
     */
	private String isDelete;
    /**
     * 保障项目
     */
	private String guaranteeProject;
    /**
     * 保障金额
     */
	private String guaranteeAmount;
    /**
     * 顺序
     */
	private Integer seq;
    /**
     * 企业保险ID
     */
	private Long comInsId;

	@JsonSerialize(using=ToStringSerializer.class)
	public Long getGuaranteeProjectId() {
		return guaranteeProjectId;
	}


	@JsonSerialize(using=ToStringSerializer.class)
	public Long getComInsId() {
		return comInsId;
	}

}
