package com.bcxin.platform.util.log;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.platform.util.constants.CommonConst;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 记录业务日志
 * </p>
 *
 * @author liyongqiang
 * @since 2018-01-05 10:34:04
 */
public class BusinessLogUtil {

	// 简单demo 案例
	// Map<String, Object> paramMap = new HashMap();
	// paramMap.put("businessType", "CE0001");// 业务类型
	// paramMap.put("currentApprovalLevel", 0); // 当前复核级次
	// paramMap.put("partyType", DictConst.PARTYTYPE_QY); // 当事人类型
	// paramMap.put("partyId", Long.parseLong("394804217337872384")); // 当事人ID
	// paramMap.put("comId", comEquipDTO.getComId()); // 企业ID
	// paramMap.put("businessHandlStatus",DictConst.BUSINESSHANDLSTATUS_SHTG);
	// // 业务办理状态
	// paramMap.put("handlePerId", 1); // 业务经办人ID
	// paramMap.put("url"，
	// "http://localhost:8093/public/businessLog/create-business-log");//调用的地址

	// 接口参数
	// businessLogId 业务日志ID（如果是新经办业务不能填写，如果是复核、打回、打回重办业务必须填写） [long]
	// businessType 业务类型代码 （参考config_business里的配置） 是 [string] CB0002 查看
	// currentApprovalLevel 当前复核级次 （如果是经办业务，为0） 是 [int] 0 查看
	// partyId 当事人ID （如果是新经办业务，必填，且和当事人类型相对应，如果当事人为企业，这个是企业ID；如果当事人为人员，则为人员ID）
	// [long] 394806567213465600 查看
	// partyType 当事人类型 （如果是新经办业务，必填，企业和人员，参考码表） [string] 1 查看
	// comId 企业ID （当前所在企业ID） [long] 394806567213465600 查看
	// businessHandlStatus 业务办理状态 （参考码表，新经办业务均为审核通过） 是 [string] 1 查看
	// remarks 备注 （如果为审核不通过和打回业务，则必须填） [string]
	// handlePerId 业务经办人ID 是 [long] 395575987607175168 查看
	// handleTime 业务经办时间 （如果不填，则服务取当前时间） [datetime]

	// 接口回调参数
	// businessLogId 业务日志ID 是 [long] 398047183552643072
	// reviewMark 复核标志（根据返回的复核标志来处理业务数据） 是 [string] 1

	/**
	 * 获取业务日志id
	 *
	 * @param paramMap
	 * @return
	 */
	public static Map<String, Object> getBusinessLogId(Map<String, Object> paramMap) {
		Map<String, Object> logResultMap = new HashMap<>();
		try {
			String result = HttpUtil.post(paramMap.get("url").toString(), paramMap);
			JSONObject jsonback = JSONUtil.parseObj(result);
			String retType = jsonback.get("retType").toString();
			if (CommonConst.RETTYPE_SUCCESS.equals(retType)) {
				logResultMap.put("status", retType);
				logResultMap.put("businessLogId", jsonback.getJSONObject("data").get("businessLogId").toString());
				logResultMap.put("reviewMark", jsonback.getJSONObject("data").get("reviewMark").toString());
			} else {
				logResultMap.put("status", CommonConst.RETTYPE_FAIL);
			}
		} catch (Exception e) {
			e.printStackTrace();
			logResultMap.put("status", CommonConst.RETTYPE_FAIL);
		}
		return logResultMap;
	}
}
