package com.bcxin.platform.service.wallet.manage;


import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.domain.wallet.ComWalletAccount;
import com.bcxin.platform.domain.wallet.ComWalletChangeEvent;
import com.bcxin.platform.dto.SearchParamDTO;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * <b> 企业钱包信息接口 </b>
 * @author ZXF
 * @create 2019/09/02 0002 14:56
 * @version
 * @注意事项 </b>
 */
public interface ComWalletManageService {


    /**
     * <b> 企业钱包列表的分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletList(SearchParamDTO dto);

    /**
     * <b> 对账数据分页查询 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletReconciliationList(SearchParamDTO dto);

    /**
     * <b> 企业钱包账户-收支明细分页查询 </b>
     * @author ZXF
     * @create 2020/11/11 0011 14:06
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletAccountDetailList(SearchParamDTO dto);

    /**
     * <b> 查询企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    Result getComWalletAccountByComId(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 查询所有企业钱包账户 </b>
     * @author ZXF
     * @create 2022/07/25 0025 13:53
     * @version
     * @注意事项 </b>
     */
    void taskComWalletAccountByAllComId() throws V5BusinessException;

    /**
     * <b> 更新企业钱包账户 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:48
     * @version
     * @注意事项 </b>
     */
    Result updateComWalletAccount(ComWalletAccount comWalletAccount) throws V5BusinessException;

    /**
     * <b> 获取企业钱包账户交易明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 10:36
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> getComWalletAccountTradeDetail(SearchParamDTO dto,Integer page,Integer rows) throws V5BusinessException;

    /**
     * <b> 电子回单 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:19
     * @version
     * @注意事项 </b>
     */
    Result getComAccountTradeVoucher(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 交易凭证 </b>
     * @author ZXF
     * @create 2019/09/03 0003 14:20
     * @version
     * @注意事项 </b>
     */
    Result getComAccountPayVoucher(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 托底账户收支明细 </b>
     * @author ZXF
     * @create 2019/09/03 0003 15:42
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageAccountBaseRecord(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 获取所有银行编码下拉数据 </b>
     * @author ZXF
     * @create 2019/09/02 0002 17:05
     * @version
     * @注意事项 </b>
     */
    Result getAllBankCodeData();

    /**
     * <b> 获得钱包信息修改审批列表 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:41
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletApproveList(SearchParamDTO dto);

    /**
     * <b> 获得钱包信息修改审批信息-详情 </b>
     * @author ZXF
     * @create 2019/09/11 0011 10:41
     * @version
     * @注意事项 </b>
     */
    Result getComWalletApproveById(SearchParamDTO dto) throws V5BusinessException;

    /**
     * <b> 获得钱包信息修改字段信息列 </b>
     * @author ZXF
     * @create 2019/09/02 0002 14:46
     * @version
     * @注意事项 </b>
     */
    List<Map<String,Object>> pageComWalletChangeList(SearchParamDTO dto);

    /**
     * <b> 钱包信息变更保存 </b>
     * @author ZXF
     * @create 2019/09/11 0011 14:38
     * @version
     * @注意事项 </b>
     */
    Result updateComWalletApproveStatus(ComWalletChangeEvent comWalletChangeEvent) throws V5BusinessException;

    /**
     * <b> 用于定时器捞取托底户接口数据 </b>
     * @author ZXF
     * @create 2019/10/11 0011 17:13
     * @version
     * @注意事项 </b>
     */
    void accountBaseRecordJob() throws Exception;

    /**
     * <b> 导出企业钱包账户对账数据 </b>
     * @author ZXF
     * @create 2019/10/16 0016 14:56
     * @version
     * @注意事项 </b>
     */
    Result exprokComWalletReconciliation(SearchParamDTO dto, HttpServletResponse response) throws V5BusinessException;
}
