package com.bcxin.platform.service.attend;

import com.bcxin.oaflow.dto.MakeUpCardDto;
import com.bcxin.platform.domain.attend.AttendClock;
import com.bcxin.platform.domain.attend.AttendClockDetail;
import com.bcxin.platform.dto.attend.AttendClockDto;
import com.bcxin.platform.dto.attend.AttendClockStateDto;

import java.util.List;

/**
 * 考勤打卡记录Service接口
 * 
 * @author lin
 * @date 2021-08-27
 */
public interface AttendClockService{

    /**
     * 查询考勤打卡记录
     * 
     * @param id 考勤打卡记录ID
     * @return 考勤打卡记录
     */
    AttendClock findById(Long id);

    /**
     * 查询考勤打卡记录列表
     * 
     * @param attendClock 考勤打卡记录
     * @return 考勤打卡记录集合
     */
    List<AttendClockDto> selectList(AttendClockDto attendClock);


    /**
     * 编辑考勤打卡记录
     * 
     * @param attendClock 考勤打卡记录
     * @return 结果
     */
    int update(AttendClock attendClock);

    /**
     * 保存考勤打卡记录
     *
     * @param attendClockDetail 考勤打卡记录
     * @return 结果
     */
    int saveClock(AttendClockDetail attendClockDetail);

    /**
     * 批量删除考勤打卡记录
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    int updateState(AttendClockStateDto clockDetailDto);

    List<MakeUpCardDto> getMissCard(AttendClockDto searchDto);
}
