package com.bcxin.platform.domain.log;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.util.BaseEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 短信接口日志
 * 
 * @author zxf
 * @since 2018-10-19 14:22:14
 */
@TableName("sys_sms_log")
public class SysSmsLog extends BaseEntity<SysSmsLog> {
	private static final long serialVersionUID = 231475054L;

	/** 接口日志ID */
	@ApiModelProperty(value = "短信日志ID")
	private Long smsId;

	/** 创建时间 */
	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	/** 手机号码 */
	@ApiModelProperty(value = "手机号码")
	private String phone;

	/** 短信内容 */
	@ApiModelProperty(value = "短信内容")
	private String msgcontext;

	public SysSmsLog(){}

	public SysSmsLog(Long smsId, Date createTime, String phone, String msgcontext){
		this.smsId = smsId;
		this.createTime = createTime;
		this.phone = phone;
		this.msgcontext = msgcontext;
	}

	public Long getSmsId() {
		return smsId;
	}

	public void setSmsId(Long smsId) {
		this.smsId = smsId;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	@Override
	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getPhone() {
		return phone;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public String getMsgcontext() {
		return msgcontext;
	}

	public void setMsgcontext(String msgcontext) {
		this.msgcontext = msgcontext;
	}
}