package com.bcxin.platform.config;

import com.alibaba.fastjson.JSONObject;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * 日志切面拦截
 * @author zhangye
 */
@Aspect // 定义一个切面
@Configuration
public class LogRecordAspect {
	private static final Logger logger = LoggerFactory.getLogger(LogRecordAspect.class);

	// 定义切点Pointcut
	@Pointcut("execution(* com.bcxin.platform.web.controller..*.*(..))")
	public void excudeService() {
	}

	// 把一个字符串的第一个字母大写、效率是最高的、
	private static String getMethodName(String fildeName) throws Exception {
		byte[] items = fildeName.getBytes();
		if (Character.isLowerCase(items[0])) {
			items[0] = (byte) ((char) items[0] - 'a' + 'A');
		}
		return new String(items);
	}

	@Around("excudeService()")
	public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
		RequestAttributes ra = RequestContextHolder.getRequestAttributes();
		ServletRequestAttributes sra = (ServletRequestAttributes) ra;
		HttpServletRequest request = sra.getRequest();
		String url = request.getRequestURL().toString();
		String method = request.getMethod();
		String uri = request.getRequestURI();
		String queryString = JSONObject.toJSONString(request.getParameterMap());
		String createBy = (request.getAttribute("createBy") == null || request.getAttribute("createBy").equals("")) ? null
				: request.getAttribute("createBy").toString();
		Long comId = (request.getAttribute("comId") == null || request.getAttribute("comId").equals("")) ? null
				: Long.valueOf(request.getAttribute("comId").toString());
//		String sessionId = (request.getAttribute("sessionId") == null || request.getAttribute("sessionId").equals(""))
//				? null : request.getAttribute("sessionId").toString();

		logger.info("请求开始, 各个参数, url: {}, method: {}, uri: {}, params: {}", url, method, uri, queryString);
		// result的值就是被拦截方法的返回值
		if (createBy != null) {
			Object[] args = pjp.getArgs();
			for (Object obj : args) {
				Class clazz = obj.getClass();
				while (clazz != null) {
					Field[] fields = clazz.getDeclaredFields();
					if (fields != null && fields.length > 0) {
						for (Field item : fields) {
							if (item.getName().equals("createBy")) {
								item.setAccessible(true);
								try {
									if (item.getGenericType().toString().equals("class java.lang.Long")) {
										item.set(obj, Long.parseLong(createBy));
									}else{
										item.set(obj,createBy);
									}
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
							if (item.getName().equals("updateBy")) {
								item.setAccessible(true);
								try {
									if (item.getGenericType().toString().equals("class java.lang.Long")) {
										item.set(obj, Long.parseLong(createBy));
									}else{
										item.set(obj,createBy);
									}
								} catch (Exception e) {
									e.printStackTrace();
								}
							}
							if (item.getName().equals("comId")) {
								if (comId != null) {
									if (item.getGenericType().toString().equals("class java.lang.Long")) {
										item.setAccessible(true);
										try {
											item.set(obj, comId);
										} catch (Exception e) {
											e.printStackTrace();
										}
									}
								}
							}
//							if (item.getName().equals("sessionId")) {
//								item.setAccessible(true);
//								try {
//									item.set(obj, sessionId);
//								} catch (Exception e) {
//									e.printStackTrace();
//								}
//							}
							if (item.getGenericType().toString().equals("class java.lang.String")) {
								if (!Modifier.isFinal(item.getModifiers()) && !Modifier.isStatic(item.getModifiers())) {
									Method m = (Method) obj.getClass().getMethod("get" + getMethodName(item.getName()));
									if (m != null && m.invoke(obj) != null) {
										item.setAccessible(true);
										try {
											item.set(obj, m.invoke(obj).toString().trim());
										} catch (Exception e) {
											e.printStackTrace();
										}
									}
								}
							}
						}
					}
					clazz = clazz.getSuperclass();
				}
			}
		}
		Object result = pjp.proceed();
		return result;
	}
}
