/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.platform.service.insurance;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.poi.excel.ExcelReader;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.obpm.mapper.ObpmUserMapper;
import com.bcxin.platform.common.exception.V5BusinessException;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.IdcardUtils;
import com.bcxin.platform.common.utils.Result;
import com.bcxin.platform.common.utils.StringUtils;
import com.bcxin.platform.common.utils.blb.AjaxResult;
import com.bcxin.platform.common.utils.blb.InsPreservationDetailVo;
import com.bcxin.platform.domain.insurance.ComIns;
import com.bcxin.platform.domain.insurance.ComInsBootScheme;
import com.bcxin.platform.domain.insurance.ComInsGuaProject;
import com.bcxin.platform.domain.temporary.ComProject;
import com.bcxin.platform.dto.excel.InsPerExcelBean;
import com.bcxin.platform.dto.excel.NotIncludedInsurancePerExcelBean;
import com.bcxin.platform.dto.excel.UnderWarrantyPerExcelBean;
import com.bcxin.platform.dto.excel.UninsuredPerExcelBean;
import com.bcxin.platform.dto.insurance.BLBAPIDTO;
import com.bcxin.platform.dto.insurance.BLBComInfoDTO;
import com.bcxin.platform.dto.insurance.BSEnum;
import com.bcxin.platform.dto.insurance.ComInsDTO;
import com.bcxin.platform.dto.insurance.ComInsPrincipalDTO;
import com.bcxin.platform.dto.insurance.ComOnlineInsPerDTO;
import com.bcxin.platform.dto.insurance.InsPerDTO;
import com.bcxin.platform.mapper.company.ComBaseInfoMapper;
import com.bcxin.platform.mapper.company.PerBaseInfoMapper;
import com.bcxin.platform.mapper.insurance.ComInsGuaProjectMapper;
import com.bcxin.platform.mapper.insurance.ComInsMapper;
import com.bcxin.platform.mapper.insurance.ComInsPrincipalMapper;
import com.bcxin.platform.mapper.insurance.ComOnlineInsPerMapper;
import com.bcxin.platform.mapper.insurance.ComOnlineInsSignMapper;
import com.bcxin.platform.mapper.temporary.ComProjectMapper;
import com.bcxin.platform.service.bbd.BbdTestService;
import com.bcxin.platform.service.blb.BlbTestService;
import com.bcxin.platform.service.common.CommonService;
import com.bcxin.platform.service.insurance.ComInsService;
import com.bcxin.platform.service.oauth.RedisUtil;
import com.bcxin.platform.util.BLBSyncDataException;
import com.bcxin.platform.util.DateUtils;
import com.bcxin.platform.util.PageInfoUtils;
import com.bcxin.platform.util.ThreadPool;
import com.bcxin.platform.util.excel.ExcelUtil;
import com.bcxin.platform.util.http.MD5Util;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service(value="comInsService")
@Transactional(value="transactionManager")
public class ComInsServiceImpl
implements ComInsService {
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private ComOnlineInsPerMapper comOnlineInsPerMapper;
    @Resource
    private ComOnlineInsSignMapper comOnlineInsSignMapper;
    @Resource
    private ComInsMapper comInsMapper;
    @Resource
    private ComProjectMapper comProjectMapper;
    @Resource
    private ComInsGuaProjectMapper comInsGuaProjectMapper;
    @Resource
    private ComInsPrincipalMapper comInsPrincipalMapper;
    @Resource
    private PerBaseInfoMapper perBaseInfoMapper;
    @Resource
    private ObpmUserMapper obpmUserMapper;
    @Resource
    private ComBaseInfoMapper comBaseInfoMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private IdWorker idWorker;
    @Resource
    private BlbTestService blbTestService;
    @Resource
    private BbdTestService bbdTestService;
    @Resource
    private RedisUtil redisUtil;

    @Override
    public Result getComInsPage(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil.get((String)this.blbTestService.blbActivateUserLinkUrl(dto.getComId(), ""));
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.comInsMapper.getComInsPage(dto);
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(list));
    }

    @Override
    public Result getPerInsPage(ComInsDTO dto) throws V5BusinessException {
        if (dto.getCreateBy() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.comInsMapper.getPerInsPage(dto.getCreateBy());
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(list));
    }

    @Override
    public Result getPerInsPageNew(ComInsDTO dto) throws V5BusinessException {
        if (dto.getCreateBy() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map<String, Object>> list = this.comInsMapper.getPerInsPageNew(dto.getComId(), dto.getIdCard());
        return Result.success((String)"", new PageInfoUtils<Map<String, Object>>(list));
    }

    @Override
    public Result getComInsByIdcard(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getIdCard() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570idCard\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success((String)"", this.comInsMapper.getComInsByIdcard(dto));
    }

    @Override
    public Result findComInsByIdcard(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPerId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] perIds = new String[]{String.valueOf(dto.getPerId())};
        String idCardNo = this.perBaseInfoMapper.getIdCardNosByPerIds(perIds);
        if (StringUtils.isEmpty((String)idCardNo)) {
            throw new V5BusinessException("-1", "idCardNo\u4e0d\u5b58\u5728");
        }
        dto.setIdCard(idCardNo);
        return Result.success((String)"", this.comInsMapper.getComInsByIdcardAndXS(dto));
    }

    @Override
    public Result getComInsDetail(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map<String, Object> rec = this.comInsMapper.selectById(dto.getComInsId());
        List<ComInsGuaProject> list = this.comInsGuaProjectMapper.selectItemsById(dto.getComInsId());
        HashMap m = Maps.newHashMap();
        m.put("comIns", rec);
        m.put("comInsGuaProjectList", list);
        return Result.success((String)"", (Object)m);
    }

    @Override
    public Result saveComInsUnderline(ComInsDTO dto) throws V5BusinessException {
        if (dto.getProductName().length() > 20) {
            throw new V5BusinessException("-1", "\u4fdd\u9669\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc720\u4e2a\u5b57\u7b26");
        }
        if (!this.checkPolicyNo(dto)) {
            return Result.fail((String)"\u4fdd\u5355\u53f7\u5df2\u5b58\u5728\uff01");
        }
        dto.setBuyMode("2");
        IdWorker id = this.idWorker;
        Long comInsId = id.nextId();
        dto.setInsAddEventId(1L);
        if ("null".equals(dto.getPolicyUrl())) {
            dto.setPolicyUrl("");
        }
        boolean sg = false;
        if (dto.getComInsId() == null) {
            dto.setComInsId(comInsId);
            dto.setBuyTime(new Date());
            this.comInsMapper.insert(dto);
        } else {
            sg = true;
            this.comInsMapper.update(dto);
        }
        if ("1".equals(dto.getIsBlbBuy())) {
            String platformSign = this.commonService.getSystemConfig("PLATFORM_SIGN");
            String token = MD5Util.buildMD5(dto.getPolicyNo() + platformSign);
            this.blbTestService.blbSetSign(token, dto.getPolicyNo(), platformSign);
        }
        this.comInsGuaProjectMapper.delete(dto.getComInsId());
        List list = JSON.parseArray((String)dto.getComInsGuaProjectList(), ComInsGuaProject.class);
        if (dto.getComInsGuaProjectList() != null) {
            int i = 1;
            for (ComInsGuaProject rec : list) {
                rec.setSeq(i++);
                rec.setGuaranteeProjectId(id.nextId());
                rec.setComInsId(dto.getComInsId());
                rec.setComId(dto.getComId());
                this.comInsGuaProjectMapper.insert(rec);
            }
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)String.valueOf(dto.getComInsId()));
    }

    private boolean checkPolicyNo(ComInsDTO dto) {
        Integer count = this.comInsMapper.isPolicyNo(dto);
        if (dto.getComInsId() == null) {
            return count == 0;
        }
        Integer c_count = this.comInsMapper.isPolicyNo(dto);
        return c_count != 0 ? true : count == 0;
    }

    @Override
    public Result deleteComInsUnderline(ComInsDTO dto) throws V5BusinessException {
        this.comOnlineInsPerMapper.delXXPerInfo(dto.getComInsId());
        if (this.comInsMapper.delete(dto.getComInsId()) == 0) {
            throw new V5BusinessException("-1", "\u64cd\u4f5c\u5931\u8d25");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public Result saveAuthFile(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comInsId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)dto.getAuthFileUrl())) {
            throw new V5BusinessException("-1", "\u53c2\u6570authFileUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ComIns comIns = new ComIns();
        comIns.setAuthFileUrl(dto.getAuthFileUrl());
        comIns.setComInsId(dto.getComInsId());
        comIns.setUpdateTime(new Date());
        comIns.setUpdateBy(dto.getPerId());
        if (this.comInsMapper.update(comIns) == 0) {
            throw new V5BusinessException("-1", "\u64cd\u4f5c\u5931\u8d25:");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result initSavePrincipal(Long comId, Long perId, Long createBy) {
        if (perId == null) {
            return Result.fail((String)"\u672a\u9009\u62e9\u4eba\u5458\uff01");
        }
        List<Map> cnoList = this.perBaseInfoMapper.getByComIdAndPerId(comId, createBy, perId);
        if (cnoList.size() == 0) {
            return Result.fail((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u4eba\u5458\u4fe1\u606f\uff01");
        }
        int resval = this.comInsPrincipalMapper.insertBatchPrincipal(cnoList);
        if (resval == 0) {
            return Result.fail((String)"\u4fdd\u9669\u8d1f\u8d23\u4eba\u4fe1\u606f\u66f4\u65b0\u5f02\u5e38\uff01");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getOnlineInsBlbLink(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil.get((String)this.blbTestService.blbActivateUserLinkUrl(dto.getComId(), ""));
        String url = this.blbTestService.blbLinkUrl(dto.getComId(), "");
        return Result.success((String)"", (Object)url);
    }

    @Override
    public Result activateOnlineInsBlbUserLink(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = this.blbTestService.blbActivateUserLinkUrl(dto.getComId(), "");
        return Result.success((String)"", (Object)url);
    }

    @Override
    public Result getOnlineInsBlbDetailLink(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String url = this.blbTestService.getBlbDetailLinkUrl(dto.getOrderId());
        return Result.success((String)"", (Object)url);
    }

    @Override
    public Result getOnlineInsBlbPreservationPageLink(ComInsBootScheme dto) {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HttpUtil.get((String)this.blbTestService.blbActivateUserLinkUrl(dto.getComId(), ""));
        String url = this.blbTestService.getBlbPreservationPageLinkUrl();
        return Result.success((String)"", (Object)url);
    }

    @Override
    public Result getOnlineInsBlbOrderPageLink(ComInsDTO dto) {
        String blbUrl = this.blbTestService.getBlbOrderPageLinkUrl(dto.getBusinessType());
        return Result.success((String)"", (Object)blbUrl);
    }

    @Override
    public Result getOnlineInsBlbReportPageLink(ComInsDTO dto) {
        String blbUrl = this.blbTestService.getBlbReportPageLinkUrl();
        return Result.success((String)"", (Object)blbUrl);
    }

    @Override
    public Result getBlbProList(ComInsBootScheme dto) {
        String result = this.blbTestService.getBlbProList();
        List resList = (List)JSON.parseObject((String)result, List.class);
        return Result.success((String)"", (Object)resList);
    }

    @Override
    public AjaxResult findCompnayAndPersonByUserid(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<BLBComInfoDTO> company = this.comInsMapper.getCompanyByComID(dto.getComId());
        if (company.size() == 0) {
            BLBComInfoDTO bciDto = new BLBComInfoDTO();
            bciDto.setKind("1");
            company.add(bciDto);
        }
        String person_num = this.commonService.getSystemConfig("BLB_INS_NUM");
        List<BLBComInfoDTO> persons = this.comInsMapper.getPersonByComID(dto.getComId(), Integer.parseInt(person_num));
        company.addAll(persons);
        return AjaxResult.success((String)"", company);
    }

    @Override
    public AjaxResult findPerIdsByCacheId(ComInsDTO dto) {
        String key = this.redisUtil.REDIS_PREFIX_KEY + ":INS:" + dto.getCacheId();
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        this.stringRedisTemplate.delete((Object)key);
        if (result == null) {
            return AjaxResult.fail((String)"CODE-9900", (String)"key\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", null);
        }
        List list = JSON.parseArray((String)result, InsPreservationDetailVo.class);
        return AjaxResult.success((String)"", (Object)list);
    }

    @Override
    public Result findCompnayAndPersonByCacheId(ComInsDTO dto) {
        String key = this.redisUtil.REDIS_PREFIX_KEY + ":INS:" + dto.getCacheId();
        String result = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        this.stringRedisTemplate.delete((Object)key);
        if (result == null) {
            return Result.fail((String)"key\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664");
        }
        List list = JSON.parseArray((String)result, BLBComInfoDTO.class);
        return Result.success((String)"", (Object)list);
    }

    @Override
    public Result getOnlineInsBlbPreservationLink(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getReviseType())) {
            throw new V5BusinessException("-1", "\u4fdd\u5168\u7c7b\u578b\u589e\u51cf\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getPerIds())) {
            throw new V5BusinessException("-1", "\u4fdd\u5168\u4eba\u5458ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IdWorker id = this.idWorker;
        String cacheId = BSEnum.get(dto.getBusinessType()) + "-cacheIdForInsPerIds" + id.nextId();
        String[] strArr = dto.getPerIds().split(",");
        ArrayList mapList = Lists.newArrayList();
        HashMap map = null;
        for (String str : strArr) {
            map = Maps.newHashMap();
            map.put("perId", str);
            mapList.add(map);
        }
        List<InsPreservationDetailVo> vo = this.comOnlineInsPerMapper.getBlbVoByPerIds(dto.getOrderId(), mapList);
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId), (Object)JSON.toJSONString(vo), 480L, TimeUnit.SECONDS);
        String blbUrl = this.blbTestService.getBlbPreservationLinkUrl(dto.getReviseType(), dto.getOrderId(), cacheId);
        return Result.success((String)"", (Object)blbUrl);
    }

    @Override
    public Result saveInsBlbAddPreservationService(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getPerIds())) {
            throw new V5BusinessException("-1", "\u4fdd\u5168\u4eba\u5458ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] strArr = dto.getPerIds().split(",");
        ArrayList mapList = Lists.newArrayList();
        HashMap map = null;
        for (String str : strArr) {
            map = Maps.newHashMap();
            map.put("perId", str);
            mapList.add(map);
        }
        List<InsPreservationDetailVo> vo = this.comOnlineInsPerMapper.getBlbVoByPerIdsWithNotOrder(dto.getOrderId(), mapList);
        if (vo.size() == 0) {
            throw new V5BusinessException("-1", "\u672a\u5339\u914d\u5230\u4eba\u5458\u4fe1\u606f");
        }
        return this.blbTestService.blbAddPreservationService(String.valueOf(dto.getComId()), dto.getOrderId(), JSONArray.toJSONString(vo), DateUtils.formatDate(dto.getStartTime(), "yyyy-MM-dd"));
    }

    @Override
    public Result saveInsBlbMinusPreservationService(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getPerIds())) {
            throw new V5BusinessException("-1", "\u4fdd\u5168\u4eba\u5458ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] strArr = dto.getPerIds().split(",");
        ArrayList mapList = Lists.newArrayList();
        HashMap map = null;
        for (String str : strArr) {
            map = Maps.newHashMap();
            map.put("perId", str);
            mapList.add(map);
        }
        List<InsPreservationDetailVo> vo = this.comOnlineInsPerMapper.getBlbVoByPerIds(dto.getOrderId(), mapList);
        if (vo.size() == 0) {
            throw new V5BusinessException("-1", "\u672a\u5339\u914d\u5230\u4eba\u5458\u4fe1\u606f");
        }
        return this.blbTestService.blbMinusPreservationService(String.valueOf(dto.getComId()), dto.getOrderId(), JSONArray.toJSONString(vo), DateUtils.getTomorrow());
    }

    @Override
    public Result saveInsBlbMinusPreservationByNotIncluded(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getInsPerDetailIds())) {
            throw new V5BusinessException("-1", "\u5728\u4fddID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] strArr = dto.getInsPerDetailIds().split(",");
        ArrayList mapList = Lists.newArrayList();
        HashMap map = null;
        for (String str : strArr) {
            map = Maps.newHashMap();
            map.put("insPerDetailId", str);
            mapList.add(map);
        }
        String idCards = this.comOnlineInsPerMapper.getBlbVoByInsPerDetailIds(dto.getOrderId(), mapList);
        if (StringUtils.isEmpty((String)idCards)) {
            throw new V5BusinessException("-1", "\u672a\u5339\u914d\u5230\u5728\u4fdd\u4eba\u5458\u4fe1\u606f");
        }
        return this.blbTestService.blbMinusPreservationByNotIncluded(String.valueOf(dto.getComId()), dto.getOrderId(), idCards, DateUtils.getTomorrow());
    }

    @Override
    public Result findCompnayAndPersonPutCache(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getPerIds())) {
            throw new V5BusinessException("-1", "\u4eba\u5458ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IdWorker id = this.idWorker;
        String cacheId = BSEnum.get(dto.getBusinessType()) + "-cacheIdForInsPerIds" + id.nextId();
        String[] strArr = dto.getPerIds().split(",");
        ArrayList<BLBComInfoDTO> list = new ArrayList<BLBComInfoDTO>();
        List<BLBComInfoDTO> company = this.comInsMapper.getCompanyByComID(dto.getComId());
        BLBComInfoDTO com = company.get(0);
        ComProject project = null;
        if ("1".equals(dto.getBusinessType())) {
            if (Strings.isNullOrEmpty((String)dto.getTlkProjectId())) {
                throw new V5BusinessException("-1", "\u6d3b\u52a8\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
            }
            project = this.comProjectMapper.getItemsBytlkProjectId(dto.getTlkProjectId());
        }
        if (com == null) {
            com = new BLBComInfoDTO();
            com.setKind("1");
        }
        if (project != null) {
            com.setProject_name(project.getProjectName());
            com.setProject_address(project.getAddress());
            com.setProject_start_time(DateUtils.formatTime(project.getStartTime()));
            com.setProject_end_time(DateUtils.formatTime(project.getEndTime()));
        }
        list.add(com);
        List<BLBComInfoDTO> persons = this.comInsMapper.getPersonByperIds(strArr);
        list.addAll(persons);
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId), (Object)JSON.toJSONString(list), 480L, TimeUnit.SECONDS);
        String blbUrl = this.blbTestService.getCompnayAndPersonPutCacheUrl(dto.getReviseType(), cacheId);
        return Result.success((String)"", (Object)blbUrl);
    }

    @Override
    public AjaxResult saveOrderInfo(BLBAPIDTO dto) throws BLBSyncDataException {
        Long cid;
        ComProject comProject;
        IdWorker id = this.idWorker;
        dto.setBuyMode("1");
        dto.setBlbOrderId(dto.getOrderId());
        dto.setInsAddEventId(1L);
        dto.setBlbProductCode(dto.getProductCode());
        List<Map> list = this.comInsMapper.selectByBlbOrderId(dto.getBlbOrderId());
        if (StringUtils.isNotEmpty((String)dto.getProjectName()) && (comProject = this.comProjectMapper.getItemsByProjectName(dto.getProjectName())) != null) {
            dto.setTlkProjectId(comProject.getTlkProjectId());
        }
        if (list.size() == 0) {
            cid = id.nextId();
            dto.setComInsId(cid);
            this.comInsMapper.insert(dto);
        } else {
            Map map = list.get(0);
            cid = Long.parseLong((String)map.get("comInsId"));
            dto.setComInsId(cid);
            this.comInsMapper.update(dto);
        }
        List userList = JSON.parseArray((String)dto.getUserList(), Map.class);
        ArrayList userListAll = Lists.newArrayList();
        userList.forEach(val -> {
            HashMap rec = Maps.newHashMap();
            rec.put("comInsId", cid);
            rec.put("idCardNo", String.valueOf(val.get("idCardNo")));
            rec.put("name", String.valueOf(val.get("name")));
            rec.put("insPerDetailId", id.nextId());
            rec.put("createTime", new Date());
            rec.put("comId", dto.getComId());
            userListAll.add(rec);
        });
        if (userListAll.size() == 0) {
            throw new BLBSyncDataException("CODE-4000", "\u63a5\u53d7\u5230\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u4efb\u4f55\u6570\u636e\u66f4\u65b0", null);
        }
        int resval = this.comOnlineInsPerMapper.insertBatchPerInfo(userListAll);
        if (resval != userListAll.size()) {
            throw new BLBSyncDataException("CODE-1000", "\u8ba2\u5355\u521d\u59cb\u5316\u4eba\u5458\u63d2\u5165\u5931\u8d25\uff0c\u63d2\u5165\u6761\u6570\u548c\u5e94\u63d2\u5165\u6570\u4e0d\u7b26\u5408" + resval + "/" + userList.size(), null);
        }
        if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
            List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), userListAll);
            if (tlkRelationIds.size() > 0) {
                this.obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
            }
        } else {
            if (StringUtils.isNotEmpty((String)dto.getPolicyUrl())) {
                String piUrl = this.obpmUserMapper.getProjectInsureUrl(dto.getTlkProjectId());
                JSONArray arr = new JSONArray();
                JSONObject obj = new JSONObject();
                obj.put("name", (Object)(dto.getPolicyNo() + ".pdf"));
                obj.put("path", (Object)dto.getPolicyUrl());
                if (StringUtils.isNotEmpty((String)piUrl)) {
                    if (!piUrl.contains(dto.getPolicyUrl())) {
                        arr = JSONArray.parseArray((String)piUrl);
                        arr.add((Object)obj);
                        piUrl = arr.toJSONString();
                    }
                } else {
                    arr.add((Object)obj);
                    piUrl = arr.toJSONString();
                }
                this.obpmUserMapper.updateProjectInsureUrl(dto.getTlkProjectId(), piUrl);
            }
            this.obpmUserMapper.updateInsureByIdcardNos("1", dto.getPolicyNo(), dto.getTlkProjectId(), userListAll);
        }
        this.changeInsPerCount(cid);
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult saveOfflineOrderPerson(BLBAPIDTO dto) throws BLBSyncDataException {
        IdWorker id = this.idWorker;
        List<Map> list = this.comInsMapper.selectByBlbPolicyNo(dto.getPolicyNo());
        if (list.size() == 0) {
            throw new BLBSyncDataException("CODE-4001", "\u4fdd\u5355\u4e0d\u5b58\u5728", null);
        }
        Map map = list.get(0);
        dto.setTlkProjectId(String.valueOf(map.get("tlkProjectId")));
        long cid = Long.parseLong((String)map.get("comInsId") + "");
        List userList = JSON.parseArray((String)dto.getUserList(), Map.class);
        ArrayList userListAll = Lists.newArrayList();
        userList.forEach(val -> {
            HashMap rec = Maps.newHashMap();
            rec.put("comInsId", cid);
            rec.put("idCardNo", String.valueOf(val.get("idCardNo")));
            rec.put("name", String.valueOf(val.get("name")));
            rec.put("insPerDetailId", id.nextId());
            rec.put("createTime", new Date());
            rec.put("comId", String.valueOf(map.get("comId")));
            userListAll.add(rec);
        });
        if (userListAll.size() == 0) {
            throw new BLBSyncDataException("CODE-4000", "\u63a5\u53d7\u5230\u7684\u6570\u636e\u5217\u8868\u4e3a\u7a7a\uff0c\u65e0\u4efb\u4f55\u6570\u636e\u66f4\u65b0", null);
        }
        this.comOnlineInsPerMapper.delXXPerInfo(cid);
        int resval = this.comOnlineInsPerMapper.insertBatchPerInfo(userListAll);
        if (resval != userListAll.size()) {
            throw new BLBSyncDataException("CODE-1000", "\u8ba2\u5355\u521d\u59cb\u5316\u4eba\u5458\u63d2\u5165\u5931\u8d25\uff0c\u63d2\u5165\u6761\u6570\u548c\u5e94\u63d2\u5165\u6570\u4e0d\u7b26\u5408" + resval + "/" + userList.size(), null);
        }
        if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
            List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), userListAll);
            if (tlkRelationIds.size() > 0) {
                this.obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
            }
        } else {
            if (StringUtils.isNotEmpty((String)dto.getPolicyUrl())) {
                String piUrl = this.obpmUserMapper.getProjectInsureUrl(dto.getTlkProjectId());
                JSONArray arr = new JSONArray();
                JSONObject obj = new JSONObject();
                obj.put("name", (Object)(dto.getPolicyNo() + ".pdf"));
                obj.put("path", (Object)dto.getPolicyUrl());
                if (StringUtils.isNotEmpty((String)piUrl)) {
                    if (!piUrl.contains(dto.getPolicyUrl())) {
                        arr = JSONArray.parseArray((String)piUrl);
                        arr.add((Object)obj);
                        piUrl = arr.toJSONString();
                    }
                } else {
                    arr.add((Object)obj);
                    piUrl = arr.toJSONString();
                }
                this.obpmUserMapper.updateProjectInsureUrl(dto.getTlkProjectId(), piUrl);
            }
            this.obpmUserMapper.updateInsureByIdcardNos("1", dto.getPolicyNo(), dto.getTlkProjectId(), userListAll);
        }
        this.changeInsPerCount(cid);
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult savePolicyUrl(BLBAPIDTO dto) throws BLBSyncDataException {
        if (StringUtils.isEmpty((String)dto.getOrderId())) {
            throw new BLBSyncDataException("CODE-4001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        if (StringUtils.isEmpty((String)dto.getPolicyUrl())) {
            throw new BLBSyncDataException("CODE-4002", "\u7535\u5b50\u4fdd\u5355\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        int count = this.comInsMapper.updatePolicyUrlByOrderId(dto.getOrderId(), dto.getPolicyUrl());
        if (count == 0) {
            throw new BLBSyncDataException("CODE-4003", "\u7535\u5b50\u4fdd\u5355\u5730\u5740\u66f4\u65b0\u5931\u8d25", null);
        }
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult deletePolicy(BLBAPIDTO dto) throws BLBSyncDataException {
        if (StringUtils.isEmpty((String)dto.getOrderId())) {
            throw new BLBSyncDataException("CODE-4001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        this.comInsMapper.deleteComInsByBlbOrderId(dto.getOrderId());
        this.comOnlineInsPerMapper.delPerByBlbOrderId(dto.getOrderId());
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult savePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
        List<Map> list = this.comInsMapper.selectByBlbOrderId(dto.getOrder_no());
        if (list.size() == 0) {
            return AjaxResult.fail((String)"CODE-9001", (String)("\u540c\u6b65\u5931\u8d25\uff0c\u4fdd\u9669\u8ba2\u5355(ID:" + dto.getOrder_no() + ")\u4e0d\u5b58\u5728"), null);
        }
        dto.setTlkProjectId(String.valueOf(list.get(0).get("tlkProjectId")));
        IdWorker id = this.idWorker;
        ArrayList addList = Lists.newArrayList();
        JSONObject jsonObject = JSON.parseObject((String)dto.getCardList());
        Integer count = Integer.valueOf(String.valueOf(jsonObject.get((Object)"count")));
        ArrayList cnoList = Lists.newArrayList();
        HashMap map = null;
        for (int i = 0; i <= count; ++i) {
            String row = String.valueOf(jsonObject.get((Object)(i + "")));
            if ("1".equals(row.split("#")[2])) {
                HashMap rec = Maps.newHashMap();
                rec.put("comInsId", String.valueOf(list.get(0).get("comInsId")));
                rec.put("idCardNo", row.split("#")[0]);
                rec.put("name", row.split("#")[1]);
                rec.put("insPerDetailId", id.nextId());
                rec.put("createTime", new Date());
                rec.put("comId", dto.getUser_id());
                addList.add(rec);
                continue;
            }
            if ("2".equals(row.split("#")[2])) {
                map = Maps.newHashMap();
                map.put("idCardNo", row.split("#")[0]);
                cnoList.add(map);
                continue;
            }
            throw new BLBSyncDataException("CODE-9002", "\u51fa\u73b0\u8fdd\u89c4\u6570\u636e\uff0c\u672a\u6807\u8bc6\u589e\u5458\u548c\u51cf\u5458\uff0c\u653e\u5f03\u672c\u6b21\u540c\u6b65", null);
        }
        if (addList.size() != 0) {
            int resval = this.comOnlineInsPerMapper.insertBatchPerInfo(addList);
            if (resval != addList.size()) {
                throw new BLBSyncDataException("CODE-9003", "\u8ba2\u5355\u521d\u59cb\u5316\u4eba\u5458\u63d2\u5165\u5931\u8d25\uff0c\u63d2\u5165\u6761\u6570\u548c\u5e94\u63d2\u5165\u6570\u4e0d\u7b26\u5408" + resval + "/" + addList.size(), null);
            }
            if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
                List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(dto.getUser_id(), addList);
                if (tlkRelationIds.size() > 0) {
                    this.obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
                }
            } else {
                this.obpmUserMapper.updateInsureByIdcardNos("1", String.valueOf(list.get(0).get("policyNo")), dto.getTlkProjectId(), addList);
            }
        }
        if (cnoList.size() != 0) {
            this.comOnlineInsPerMapper.delPerInfo(String.valueOf(list.get(0).get("comInsId")), cnoList);
            if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
                List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(dto.getUser_id(), cnoList);
                if (tlkRelationIds.size() > 0) {
                    this.obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
                }
            } else {
                this.obpmUserMapper.updateInsureByIdcardNos("0", "", dto.getTlkProjectId(), cnoList);
            }
        }
        BLBAPIDTO rec = new BLBAPIDTO();
        rec.setComInsId(Long.valueOf(String.valueOf(list.get(0).get("comInsId"))));
        Map cnt = this.comInsMapper.countByComInsId(rec.getComInsId());
        rec.setPerNum(Integer.valueOf(String.valueOf(cnt.get("cnt"))));
        int resval = this.comInsMapper.update(rec);
        if (resval == 0) {
            throw new BLBSyncDataException("CODE-9004", "\u4fdd\u9669\u8bb0\u5f55\u8868com_online_ins_per\u4fee\u6539\u5931\u8d25", null);
        }
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult saveOfflinePerservationInfo(BLBAPIDTO dto) throws BLBSyncDataException {
        List<Map> list = this.comInsMapper.selectByBlbPolicyNo(dto.getPolicyNo());
        if (list.size() == 0) {
            return AjaxResult.fail((String)"CODE-9001", (String)("\u540c\u6b65\u5931\u8d25\uff0c\u4fdd\u9669\u8ba2\u5355(PolicyNo:" + dto.getPolicyNo() + ")\u4e0d\u5b58\u5728"), null);
        }
        dto.setTlkProjectId(String.valueOf(list.get(0).get("tlkProjectId")));
        IdWorker id = this.idWorker;
        ArrayList addList = Lists.newArrayList();
        JSONObject jsonObject = JSON.parseObject((String)dto.getCardList());
        Integer count = Integer.valueOf(String.valueOf(jsonObject.get((Object)"count")));
        ArrayList cnoList = Lists.newArrayList();
        HashMap map = null;
        Map mapIns = list.get(0);
        String comInsId = mapIns.get("comInsId") + "";
        String comId = mapIns.get("comId") + "";
        for (int i = 0; i <= count; ++i) {
            String row = String.valueOf(jsonObject.get((Object)(i + "")));
            if ("1".equals(row.split("#")[2])) {
                HashMap rec = Maps.newHashMap();
                rec.put("comInsId", comInsId);
                rec.put("idCardNo", row.split("#")[0]);
                rec.put("name", row.split("#")[1]);
                rec.put("insPerDetailId", id.nextId());
                rec.put("createTime", new Date());
                rec.put("comId", comId);
                addList.add(rec);
                continue;
            }
            if ("2".equals(row.split("#")[2])) {
                map = Maps.newHashMap();
                map.put("idCardNo", row.split("#")[0]);
                cnoList.add(map);
                continue;
            }
            throw new BLBSyncDataException("CODE-9002", "\u51fa\u73b0\u8fdd\u89c4\u6570\u636e\uff0c\u672a\u6807\u8bc6\u589e\u5458\u548c\u51cf\u5458\uff0c\u653e\u5f03\u672c\u6b21\u540c\u6b65", null);
        }
        if (addList.size() != 0) {
            int resval = this.comOnlineInsPerMapper.insertBatchPerInfo(addList);
            if (resval != addList.size()) {
                throw new BLBSyncDataException("CODE-9003", "\u8ba2\u5355\u521d\u59cb\u5316\u4eba\u5458\u63d2\u5165\u5931\u8d25\uff0c\u63d2\u5165\u6761\u6570\u548c\u5e94\u63d2\u5165\u6570\u4e0d\u7b26\u5408" + resval + "/" + addList.size(), null);
            }
            if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
                List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(comId, addList);
                if (tlkRelationIds.size() > 0) {
                    this.obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
                }
            } else {
                this.obpmUserMapper.updateInsureByIdcardNos("1", dto.getPolicyNo(), dto.getTlkProjectId(), addList);
            }
        }
        if (cnoList.size() != 0) {
            this.comOnlineInsPerMapper.delPerInfo(comInsId, cnoList);
            if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
                List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(comId, cnoList);
                if (tlkRelationIds.size() > 0) {
                    this.obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
                }
            } else {
                this.obpmUserMapper.updateInsureByIdcardNos("0", "", dto.getTlkProjectId(), cnoList);
            }
        }
        BLBAPIDTO rec = new BLBAPIDTO();
        rec.setComInsId(Long.valueOf(comInsId));
        Map cnt = this.comInsMapper.countByComInsId(rec.getComInsId());
        rec.setPerNum(Integer.valueOf(String.valueOf(cnt.get("cnt"))));
        int resval = this.comInsMapper.update(rec);
        if (resval == 0) {
            throw new BLBSyncDataException("CODE-9004", "\u4fdd\u9669\u8bb0\u5f55\u8868com_online_ins_per\u4fee\u6539\u5931\u8d25", null);
        }
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public AjaxResult sendInsUnpaidMsg(BLBAPIDTO dto) throws BLBSyncDataException {
        if (dto.getComId() == null) {
            return AjaxResult.fail((String)"CODE-9005", (String)"comId\u4e0d\u80fd\u4e3a\u7a7a", null);
        }
        return AjaxResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", null);
    }

    @Override
    public Result promptInitEnterpriseIns(ComInsDTO dto) throws V5BusinessException {
        Map blbOnlineMap;
        List<Map> guaProjects;
        if (dto.getComId() == null) {
            return Result.fail((String)"\u4f01\u4e1aID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HashMap result = Maps.newHashMap();
        List<Map> list = this.comInsMapper.selectOnlineByComId(dto.getComId(), null);
        if (list.size() == 0) {
            result.put("isIns", "0");
            return Result.success((String)"", (Object)result);
        }
        boolean isPerCntRight = true;
        boolean isGuaProjectRight = true;
        Map perCnt = this.comInsMapper.getInsPerCntIsRight(dto.getComId());
        if (perCnt != null && "0".equals(String.valueOf(perCnt.get("isPerCntRight")))) {
            isPerCntRight = false;
            result.put("diffPerCnt", perCnt.get("diffCnt"));
        }
        if ((guaProjects = this.comInsMapper.getInsGuaProjectIsRight(dto.getComId())).size() != 0) {
            for (Map guaProject : guaProjects) {
                if (!"0".equals(String.valueOf(guaProject.get("isGood")))) continue;
                isGuaProjectRight = false;
                break;
            }
        }
        if ((blbOnlineMap = this.getBlbInsMap(dto)).keySet().size() > 0) {
            for (Map guaProject : guaProjects) {
                String guaShouldBeCode = String.valueOf(guaProject.get("guaProjectCode"));
                Double guaShouldBeFee = Double.valueOf(String.valueOf(guaProject.get("shouldBe")));
                Double guaBlbFee = Double.valueOf(String.valueOf(blbOnlineMap.get(guaShouldBeCode)));
                if (!(guaShouldBeFee > guaBlbFee)) continue;
                isGuaProjectRight = true;
                break;
            }
        }
        if (!isPerCntRight && isGuaProjectRight) {
            result.put("isIns", "1");
            return Result.success((String)"", (Object)result);
        }
        if (isPerCntRight && !isGuaProjectRight) {
            result.put("isIns", "2");
            return Result.success((String)"", (Object)result);
        }
        if (!isPerCntRight && !isGuaProjectRight) {
            result.put("isIns", "3");
            return Result.success((String)"", (Object)result);
        }
        result.put("isIns", "9");
        return Result.success((String)"", (Object)result);
    }

    private Map getBlbInsMap(ComInsDTO dto) throws V5BusinessException {
        HashMap blbGuaMap = Maps.newHashMap();
        try {
            List<Map> list = this.comInsMapper.selectOnlineByComId(dto.getComId(), 1);
            String result = this.blbTestService.getBlbProList();
            List resList = JSON.parseArray((String)result, Map.class);
            for (Map comInsRow : list) {
                String productCode = String.valueOf(comInsRow.get("blbProductCode") == null ? "" : comInsRow.get("blbProductCode").toString());
                for (Map blbProRow : resList) {
                    if (!productCode.equals(String.valueOf(blbProRow.get("proCode")))) continue;
                    List res = JSON.parseArray((String)String.valueOf(blbProRow.get("resList")), Map.class);
                    for (Map r : res) {
                        if (r.get("fcy") == null || r.get("guaProjectCode") == null) continue;
                        blbGuaMap.put(r.get("guaProjectCode"), NumberUtil.div((Double)Double.valueOf(String.valueOf(r.get("fcy"))), (Double)new Double(10000.0)));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", "\u83b7\u53d6\u4fdd\u9669\u4ea7\u54c1\u5217\u8868\u5931\u8d25");
        }
        return blbGuaMap;
    }

    @Override
    public Result promptInitPerAddDelIns(ComInsDTO dto) {
        HashMap result = Maps.newHashMap();
        List<Map> list = this.comInsMapper.selectOnlineByComId(dto.getComId(), 1);
        if (list.size() == 0) {
            result.put("isIns", "0");
            return Result.success((String)"", (Object)result);
        }
        result.put("isIns", "1");
        String needInsPerIds = this.comOnlineInsPerMapper.getInsingPerIds(dto.getComId());
        result.put("needInsPerIds", needInsPerIds);
        String needNoInsPerIds = this.comOnlineInsPerMapper.getNoInsPerIds(dto.getComId());
        result.put("needNoInsPerIds", needNoInsPerIds);
        return Result.success((String)"", (Object)result);
    }

    @Override
    public Result saveBookScheme(ComInsBootScheme dto) throws V5BusinessException {
        IdWorker id = this.idWorker;
        dto.setComInsBootSchemeId(id.nextId());
        dto.setCreateTime(new Date());
        this.comOnlineInsPerMapper.saveBootScheme(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result getBootSchemePdfLink(ComInsDTO dto) {
        String pdfUrl;
        String province = "";
        if ("450000".equals(dto.getProvince())) {
            province = "GX";
        }
        if ("610000".equals(dto.getProvince())) {
            province = "SX";
        }
        if ("100000".equals(dto.getProvince())) {
            province = "SC";
        }
        if ("null".equals(pdfUrl = this.commonService.getSystemConfig("BCXIN_" + province + "_" + dto.getProCode()))) {
            return Result.fail((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7684pdf");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)pdfUrl);
    }

    @Override
    public Result promptCompanyInitGen(ComInsDTO dto) {
        String pic = this.commonService.getSystemConfig("BCXIN_PROMPT_PIC");
        if ("null".equals(pic)) {
            return Result.fail((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u6e29\u99a8\u63d0\u793a\u56fe\u7247\u5730\u5740");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)pic);
    }

    @Override
    public Result sendInsPromptToCompany(ComInsDTO dto) throws V5BusinessException {
        Map insRule = this.comInsMapper.getInsRuleByComId(dto.getComId());
        if (insRule != null) {
            if ("0".equals(String.valueOf(insRule.get("isSendSysNotice")))) {
                return Result.success((String)"");
            }
            List<Map> list = this.comInsMapper.getComAdminInfo(dto.getComId());
            if (list.size() != 0) {
                boolean mark = false;
                if ("1".equals(String.valueOf(insRule.get("sendCycleType")))) {
                    Map cnt = this.comInsMapper.getComHisMsgCnt(dto.getComId(), "010203");
                    if (Convert.toInt((Object)NumberUtil.sub((Double)Convert.toDouble(insRule.get("sendTimes")), (Double)Convert.toDouble(cnt.get("total")))) > 0) {
                        mark = true;
                    }
                } else {
                    int currDayOfWeek = DateUtils.dayOfWeek(DateUtils.formatDate(new Date(), new Object[0]));
                    if (String.valueOf(insRule.get("weekSend")).indexOf(Convert.toStr((Object)currDayOfWeek)) >= 0) {
                        mark = true;
                    }
                }
                if (mark) {
                    // empty if block
                }
            }
        }
        return Result.success((String)"", (Object)"\u6ca1\u6709\u53ef\u4ee5\u7528\u7684\u4fdd\u9669\u89c4\u5219");
    }

    @Override
    public Result getInsBootPage(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map> list = this.comInsMapper.getInsBootPage(dto);
        return Result.success((String)"", new PageInfoUtils<Map>(list));
    }

    @Override
    public Result getOnlineInsPerList(ComOnlineInsPerDTO dto) throws V5BusinessException {
        String idCardNoJson = dto.getIdCardNoJson();
        if (StringUtils.isEmpty((String)idCardNoJson)) {
            throw new V5BusinessException("-2", "\u79bb\u804c\u4eba\u5458\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long comId = dto.getComId();
        List idCardNoList = JSON.parseArray((String)idCardNoJson, String.class);
        HashMap<String, Object> condition = new HashMap<String, Object>();
        condition.put("comId", comId);
        condition.put("list", idCardNoList);
        List<Map> resultMapList = this.comOnlineInsPerMapper.getOnlineInsPerList(condition);
        return Result.success((String)"", resultMapList);
    }

    @Override
    public Result delAllLosePerInfo() throws V5BusinessException {
        String aDay = DateUtils.formatDate(DateUtils.addMonths((Date)new Date(), (int)1), "yyyy-MM-dd");
        String bDay = DateUtils.formatDate(DateUtils.addDays((Date)new Date(), (int)15), "yyyy-MM-dd");
        String cDay = DateUtils.formatDate(DateUtils.addDays((Date)new Date(), (int)3), "yyyy-MM-dd");
        List<Map<String, String>> bList = this.comInsMapper.findMaturingPolicy(aDay, bDay, cDay);
        String dDay = DateUtils.formatDate(new Date(), "yyyy-MM-dd");
        List<String> delInsList = this.comOnlineInsPerMapper.allLoseTlkRelationIds();
        this.comOnlineInsPerMapper.delAllLosePerInfo();
        if (delInsList.size() > 0) {
            this.obpmUserMapper.updateInsureByIds("0", delInsList);
            List<String> list = this.comInsMapper.allLoseTlkProjectIds();
            this.obpmUserMapper.updateInsureByPids("0", "", list);
        }
        return Result.success((String)"");
    }

    @Override
    public Result findUninsuredPerList(InsPerDTO dto) throws V5BusinessException {
        PageInfoUtils<Map> pageInfoUtils;
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        if ("-1".equals(dto.getDepartId())) {
            dto.setOrgType("1");
        }
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ("1".equals(dto.getBusinessType())) {
            List<Map> list = this.comOnlineInsSignMapper.findUninsuredPerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsSignMapper.findUninsuredPerListCount(dto));
        } else {
            List<Map> list = this.comOnlineInsPerMapper.findUninsuredPerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsPerMapper.findUninsuredPerListCount(dto));
        }
        HttpUtil.get((String)this.blbTestService.blbActivateUserLinkUrl(dto.getComId(), ""));
        return Result.success((String)"", pageInfoUtils);
    }

    @Override
    public void exportUninsuredPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
        if ("-1".equals(dto.getDepartId())) {
            dto.setOrgType("1");
        }
        try {
            List<UninsuredPerExcelBean> list = "1".equals(dto.getBusinessType()) ? this.comOnlineInsSignMapper.exportUninsuredPerList(dto) : this.comOnlineInsPerMapper.exportUninsuredPerList(dto);
            ServletOutputStream os = null;
            ExcelUtil<UninsuredPerExcelBean> util = new ExcelUtil<UninsuredPerExcelBean>(UninsuredPerExcelBean.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u672a\u6295\u4fdd\u4eba\u5458\u6e05\u5355.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            util.exportExcel(list, "\u672a\u6295\u4fdd\u4eba\u5458\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "\u672a\u6295\u4fdd\u4eba\u5458\u5bfc\u51fa\u5931\u8d25\uff0cERROR:" + e.getMessage());
        }
    }

    @Override
    public Result findFilterPerList(InsPerDTO dto) throws V5BusinessException {
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map> list = "1".equals(dto.getBusinessType()) ? this.comOnlineInsSignMapper.findFilterPerList(dto) : this.comOnlineInsPerMapper.findFilterPerList(dto);
        return Result.success((String)"", new PageInfoUtils<Map>(list));
    }

    @Override
    public Result findUnderWarrantyPerList(final InsPerDTO dto) throws V5BusinessException {
        PageInfoUtils<Map> pageInfoUtils;
        List<Map> list;
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        if ("-1".equals(dto.getDepartId())) {
            dto.setOrgType("1");
        }
        if ("1".equals(dto.getBusinessType())) {
            list = this.comOnlineInsSignMapper.findUnderWarrantyPerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsSignMapper.findUnderWarrantyPerListCount(dto));
        } else {
            list = this.comOnlineInsPerMapper.findUnderWarrantyPerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsPerMapper.findUnderWarrantyPerListCount(dto));
        }
        ScheduledThreadPoolExecutor threadPool = ThreadPool.getScheduledThreadPoolExecutor();
        threadPool.execute(new Runnable(){

            @Override
            public void run() {
                ComInsServiceImpl.this.perBaseInfoMapper.updateIdcardNoByComId(dto.getComId());
            }
        });
        return Result.success((String)"", pageInfoUtils);
    }

    @Override
    public void exportUnderWarrantyPerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
        if ("-1".equals(dto.getDepartId())) {
            dto.setOrgType("1");
        }
        try {
            List<UnderWarrantyPerExcelBean> list = "1".equals(dto.getBusinessType()) ? this.comOnlineInsSignMapper.exportUnderWarrantyPerList(dto) : this.comOnlineInsPerMapper.exportUnderWarrantyPerList(dto);
            ServletOutputStream os = null;
            ExcelUtil<UnderWarrantyPerExcelBean> util = new ExcelUtil<UnderWarrantyPerExcelBean>(UnderWarrantyPerExcelBean.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u5df2\u6295\u4fdd\u4eba\u5458\u6e05\u5355.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            util.exportExcel(list, "\u5df2\u6295\u4fdd\u4eba\u5458\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "\u5df2\u6295\u4fdd\u4eba\u5458\u5bfc\u51fa\u5931\u8d25\uff0cERROR:" + e.getMessage());
        }
    }

    @Override
    public Result findNotIncludedInsurancePerList(InsPerDTO dto) throws V5BusinessException {
        PageInfoUtils<Map> pageInfoUtils;
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        if ("1".equals(dto.getBusinessType())) {
            List<Map> list = this.comOnlineInsSignMapper.findNotIncludedInsurancePerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsSignMapper.findNotIncludedInsurancePerListCount(dto));
        } else {
            List<Map> list = this.comOnlineInsPerMapper.findNotIncludedInsurancePerList(dto);
            pageInfoUtils = new PageInfoUtils<Map>(list);
            pageInfoUtils.setOther(this.comOnlineInsPerMapper.findNotIncludedInsurancePerListCount(dto));
        }
        return Result.success((String)"", pageInfoUtils);
    }

    @Override
    public void exportNotIncludedInsurancePerList(InsPerDTO dto, HttpServletResponse response) throws V5BusinessException {
        try {
            List<NotIncludedInsurancePerExcelBean> list = "1".equals(dto.getBusinessType()) ? this.comOnlineInsSignMapper.exportNotIncludedInsurancePerList(dto) : this.comOnlineInsPerMapper.exportNotIncludedInsurancePerList(dto);
            ServletOutputStream os = null;
            ExcelUtil<NotIncludedInsurancePerExcelBean> util = new ExcelUtil<NotIncludedInsurancePerExcelBean>(NotIncludedInsurancePerExcelBean.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u5df2\u6295\u4fdd\u672a\u5f55\u5165\u4eba\u5458\u6e05\u5355.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            util.exportExcel(list, "\u5df2\u6295\u4fdd\u672a\u5f55\u5165\u4eba\u5458\u6e05\u5355", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "\u5df2\u6295\u4fdd\u672a\u5f55\u5165\u4eba\u5458\u5bfc\u51fa\u5931\u8d25\uff0cERROR:" + e.getMessage());
        }
    }

    @Override
    public Result findYIncumbencyPerCount(InsPerDTO dto) throws V5BusinessException {
        int count = this.comOnlineInsPerMapper.findYIncumbencyPerCount(dto);
        return Result.success((String)"", (Object)count);
    }

    @Override
    public Result findOfflineOrOnlinePolicy(InsPerDTO dto) throws V5BusinessException {
        List<Map> list = this.comInsMapper.findOfflineOrOnlinePolicy(dto);
        return Result.success((String)"", list);
    }

    @Override
    public Result addBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
        this.comInsMapper.addBatchFilterPerson(dto.getComId(), dto.getPerIds().split(","));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result delBatchFilterPerson(ComInsDTO dto) throws V5BusinessException {
        this.comInsMapper.delBatchFilterPerson(dto.getComId(), dto.getPerIds().split(","));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result findUnderWarrantyPerListCount(InsPerDTO dto) throws V5BusinessException {
        Integer count = this.comOnlineInsPerMapper.findUnderWarrantyPerListCount(dto);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)count);
    }

    @Override
    public Result addBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
        int resval;
        if (StringUtils.isEmpty((String)dto.getIdCards())) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\uff01");
        }
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u4fdd\u5355ID\u4fe1\u606f\uff01");
        }
        Map<String, Object> comInsMap = this.comInsMapper.selectById(dto.getComInsId());
        if (comInsMap == null || !"2".equals(String.valueOf(comInsMap.get("buyMode")))) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u4e0d\u7b26\u5408\u5173\u8054\u7ebf\u4e0b\u4fdd\u5355\u6761\u4ef6\uff01");
        }
        dto.setTlkProjectId(String.valueOf(comInsMap.get("tlkProjectId")));
        ArrayList addList = Lists.newArrayList();
        String[] idCardArr = dto.getIdCards().split(",");
        IdWorker id = this.idWorker;
        HashMap rec = null;
        for (String c : idCardArr) {
            rec = Maps.newHashMap();
            rec.put("comInsId", String.valueOf(dto.getComInsId()));
            rec.put("idCardNo", c);
            rec.put("insPerDetailId", id.nextId());
            rec.put("createTime", new Date());
            rec.put("comId", dto.getComId());
            addList.add(rec);
        }
        if (addList.size() != 0 && (resval = this.comOnlineInsPerMapper.insertBatchPerInfo(addList)) != addList.size()) {
            throw new V5BusinessException("-1", "\u7ebf\u4e0b\u4fdd\u5355\u4eba\u5458\u4fe1\u606f\u5173\u8054\u5f02\u5e38\uff01");
        }
        if (StringUtils.isEmpty((String)dto.getTlkProjectId())) {
            List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), addList);
            if (tlkRelationIds.size() > 0) {
                this.obpmUserMapper.updateInsureByIds("1", tlkRelationIds);
            }
        } else {
            this.obpmUserMapper.updateInsureByIdcardNos("1", String.valueOf(comInsMap.get("policyNo")), dto.getTlkProjectId(), addList);
        }
        return Result.success((String)"\u5173\u8054\u6210\u529f\uff01");
    }

    @Override
    public Result updateComInsRemark(ComInsDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getRemark())) {
            throw new V5BusinessException("-1", "\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u4fdd\u5355ID\u4fe1\u606f\uff01");
        }
        this.comInsMapper.updateComInsRemark(dto.getComInsId(), dto.getRemark());
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result minusBatchRelevancePer(ComInsDTO dto) throws V5BusinessException {
        int resval;
        if (StringUtils.isEmpty((String)dto.getIdCards())) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u4eba\u5458\u8eab\u4efd\u8bc1\u4fe1\u606f\uff01");
        }
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u8ba2\u5355ID\u4fe1\u606f\uff01");
        }
        Map<String, Object> comInsMap = this.comInsMapper.selectById(dto.getComInsId());
        if (comInsMap == null || !"2".equals(String.valueOf(comInsMap.get("buyMode")))) {
            throw new V5BusinessException("-1", "\u8ba2\u5355\u4e0d\u7b26\u5408\u7ebf\u4e0b\u51cf\u5458\u6761\u4ef6\uff01");
        }
        String[] idCardArr = dto.getIdCards().split(",");
        ArrayList cnoList = Lists.newArrayList();
        HashMap map = null;
        for (String car : idCardArr) {
            map = Maps.newHashMap();
            map.put("idCardNo", car);
            cnoList.add(map);
        }
        if (cnoList.size() != 0 && (resval = this.comOnlineInsPerMapper.delPerInfo(String.valueOf(dto.getComInsId()), cnoList)) == 0) {
            throw new V5BusinessException("-1", "\u7ebf\u4e0b\u4fdd\u5355\u4eba\u5458\u4fe1\u606f\u79fb\u9664\u5f02\u5e38\uff01");
        }
        List<String> tlkRelationIds = this.comOnlineInsPerMapper.findTlkRelationIds(String.valueOf(dto.getComId()), cnoList);
        if (tlkRelationIds.size() > 0) {
            this.obpmUserMapper.updateInsureByIds("0", tlkRelationIds);
        }
        return Result.success((String)"\u79fb\u9664\u6210\u529f\uff01");
    }

    @Override
    public Result sendInsuranceOperationMsg() {
        String perIds = "";
        List<Map> list = this.comOnlineInsPerMapper.countUninsuredPerAndCom();
        for (Map map : list) {
        }
        list = this.comOnlineInsPerMapper.countYIncumbencyPerAndCom();
        for (Map map : list) {
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result delBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getPerIds())) {
            return Result.fail((String)"\u672a\u9009\u62e9\u4eba\u5458\uff01");
        }
        String[] perIdArr = dto.getPerIds().split(",");
        int resval = this.comInsPrincipalMapper.delBatchPrincipal(dto.getComId(), perIdArr);
        if (resval == 0) {
            return Result.fail((String)"\u4fdd\u9669\u8d1f\u8d23\u4eba\u4fe1\u606f\u5220\u9664\u5f02\u5e38\uff01");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result insertBatchPrincipal(ComInsPrincipalDTO dto) throws V5BusinessException {
        return this.savePrincipal(dto.getComId(), dto.getPerIds(), dto.getPerId());
    }

    private Result savePrincipal(Long comId, String perIds, Long createBy) {
        if (StringUtils.isEmpty((String)perIds)) {
            return Result.fail((String)"\u672a\u9009\u62e9\u4eba\u5458\uff01");
        }
        String[] perIdArr = perIds.split(",");
        String idCards = this.perBaseInfoMapper.getIdCardNosByPerIds(perIdArr);
        if (StringUtils.isEmpty((String)idCards)) {
            return Result.fail((String)"\u672a\u5339\u914d\u5230\u4eba\u5458\uff0c\u6216\u672a\u5b8c\u5584\u8eab\u4efd\u8bc1\u4fe1\u606f\uff01");
        }
        List<Map> cnoList = this.perBaseInfoMapper.getByComIdAndCardNo(comId, createBy, perIdArr);
        if (cnoList.size() == 0) {
            return Result.fail((String)"\u672a\u5339\u914d\u5230\u5bf9\u5e94\u4eba\u5458\u4fe1\u606f\uff01");
        }
        int resval = this.comInsPrincipalMapper.insertBatchPrincipal(cnoList);
        if (resval == 0) {
            return Result.fail((String)"\u4fdd\u9669\u8d1f\u8d23\u4eba\u4fe1\u606f\u66f4\u65b0\u5f02\u5e38\uff01");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result selectPrincipalByComId(ComInsPrincipalDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PageHelper.startPage((int)dto.getPageNumber(), (int)dto.getPageSize());
        List<Map> list = this.comInsPrincipalMapper.selectPrincipalByComId(dto.getComId());
        return Result.success((String)"", new PageInfoUtils<Map>(list));
    }

    @Override
    public Result findBlbPerName() throws V5BusinessException {
        String idCards;
        int m = 0;
        int n = 500;
        for (int i = 0; i < 200 && !StringUtils.isEmpty((String)(idCards = this.comOnlineInsPerMapper.findIdCardByEmptyName(m, n))) && !"null".equals(idCards); ++i) {
            List list;
            m = n;
            n += 500;
            Result res = this.blbTestService.blbPerName(idCards);
            if (!res.getRetType().equals("0") || res.getData() == null || (list = JSON.parseArray((String)String.valueOf(res.getData()), Map.class)).size() <= 0) continue;
            this.comOnlineInsPerMapper.saveTempInsPerName(list);
            this.comOnlineInsPerMapper.updateNameByIdCards();
            this.comOnlineInsPerMapper.deleteTempInsPerName();
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @Override
    public Result batchUploadInsPer(Long importBatchId, Long comId, MultipartFile file) throws Exception {
        List<Map<String, Object>> excellist;
        try (InputStream in = file.getInputStream();){
            ExcelReader reader = cn.hutool.poi.excel.ExcelUtil.getReader((InputStream)in);
            reader.isIgnoreEmptyRow();
            excellist = reader.read(2, 6, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "Excel\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff01");
        }
        excellist = this.screenValidData(excellist);
        if (excellist.size() == 0) {
            return Result.fail((String)"Excel\u6587\u4ef6\u65e0\u6709\u6548\u6570\u636e");
        }
        this.comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
        this.comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist, importBatchId);
        this.comOnlineInsPerMapper.checkIdCardNoInPerBaseInfo(importBatchId, comId);
        this.comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
        this.comOnlineInsPerMapper.checkIdCardNoInsurance(importBatchId, comId);
        Integer errCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0", importBatchId);
        Integer successCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1", importBatchId);
        HashMap param = Maps.newHashMap();
        param.put("importBatchId", String.valueOf(importBatchId));
        param.put("errCount", String.valueOf(errCount));
        param.put("successCount", String.valueOf(successCount));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)param);
    }

    @Override
    public Result batchUploadInsPer(String tlkProjectId, Long importBatchId, Long comId, MultipartFile file) throws Exception {
        List<Map<String, Object>> excellist;
        try (InputStream in = file.getInputStream();){
            ExcelReader reader = cn.hutool.poi.excel.ExcelUtil.getReader((InputStream)in);
            reader.isIgnoreEmptyRow();
            excellist = reader.read(2, 6, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "Excel\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff01");
        }
        excellist = this.screenValidData(excellist);
        if (excellist.size() == 0) {
            return Result.fail((String)"Excel\u6587\u4ef6\u65e0\u6709\u6548\u6570\u636e");
        }
        this.comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
        this.comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist, importBatchId);
        this.comOnlineInsSignMapper.checkIdCardNoInPerBaseInfo(tlkProjectId, importBatchId, comId);
        this.comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
        this.comOnlineInsSignMapper.checkIdCardNoInsurance(tlkProjectId, importBatchId, comId);
        Integer errCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0", importBatchId);
        Integer successCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1", importBatchId);
        HashMap param = Maps.newHashMap();
        param.put("importBatchId", String.valueOf(importBatchId));
        param.put("errCount", String.valueOf(errCount));
        param.put("successCount", String.valueOf(successCount));
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)param);
    }

    @Override
    public Result minusBatchUploadInsPer(Long importBatchId, Long comId, MultipartFile file) throws Exception {
        List<Map<String, Object>> excellist;
        try (InputStream in = file.getInputStream();){
            ExcelReader reader = cn.hutool.poi.excel.ExcelUtil.getReader((InputStream)in);
            reader.isIgnoreEmptyRow();
            excellist = reader.read(2, 6, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new V5BusinessException("-2", "Excel\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff01");
        }
        excellist = this.screenValidData(excellist);
        if (excellist.size() == 0) {
            return Result.fail((String)"Excel\u6587\u4ef6\u65e0\u6709\u6548\u6570\u636e");
        }
        this.comOnlineInsPerMapper.deleteTempBatchInsPerImport(importBatchId);
        this.comOnlineInsPerMapper.saveTempBatchInsPerImport(excellist, importBatchId);
        this.comOnlineInsPerMapper.checkIdCardNoRepeat(importBatchId);
        this.comOnlineInsPerMapper.checkIsZb(importBatchId, comId);
        Integer errCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("0", importBatchId);
        Integer successCount = this.comOnlineInsPerMapper.countErrOrSuccessTempBatchInsPerImport("1", importBatchId);
        List<Map<String, String>> mapList = this.comOnlineInsPerMapper.findValidMinusInsByImportBatchId(importBatchId, comId);
        HashMap param = Maps.newHashMap();
        param.put("importBatchId", String.valueOf(importBatchId));
        param.put("errCount", String.valueOf(errCount));
        param.put("successCount", String.valueOf(successCount));
        param.put("minusInsList", mapList);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)param);
    }

    private List<Map<String, Object>> screenValidData(List<Map<String, Object>> excellist) {
        String[] keys = new String[]{"name", "idCardNo", "birthday", "idCardType", "perType", "sex", "mobilePhone", "number", "isSuccess", "errorMsg"};
        ArrayList mlist = Lists.newArrayList();
        for (Map<String, Object> map : excellist) {
            if (StringUtils.isEmpty((String)String.valueOf(map.get("\u59d3\u540d"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u804c\u4e1a"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u8bc1\u4ef6\u53f7\u7801"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u624b\u673a\u53f7"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u51fa\u751f\u65e5\u671f"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u8bc1\u4ef6\u7c7b\u578b"))) && StringUtils.isEmpty((String)String.valueOf(map.get("\u6027\u522b")))) continue;
            HashMap newMap = Maps.newHashMap();
            boolean isNull = false;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String val = String.valueOf(entry.getValue());
                switch (entry.getKey()) {
                    case "\u59d3\u540d": {
                        newMap.put(keys[0], val);
                        break;
                    }
                    case "\u8bc1\u4ef6\u53f7\u7801": {
                        newMap.put(keys[1], val);
                        break;
                    }
                    case "\u51fa\u751f\u65e5\u671f": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = val.replace(" 00:00:00", "");
                        }
                        newMap.put(keys[2], val);
                        break;
                    }
                    case "\u8bc1\u4ef6\u7c7b\u578b": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = "\u5c45\u6c11\u8eab\u4efd\u8bc1".equals(val) ? "0" : ("\u62a4\u7167".equals(val) ? "3" : ("\u53f0\u80de\u8bc1".equals(val) ? "4" : ("\u56de\u4e61\u8bc1".equals(val) ? "5" : "")));
                        }
                        newMap.put(keys[3], val);
                        break;
                    }
                    case "\u804c\u4e1a": {
                        newMap.put(keys[4], val);
                        break;
                    }
                    case "\u6027\u522b": {
                        if (StringUtils.isNotEmpty((String)val)) {
                            val = "\u7537".equals(val) ? "1" : ("\u5973".equals(val) ? "2" : "");
                        }
                        newMap.put(keys[5], val);
                        break;
                    }
                    case "\u624b\u673a\u53f7": {
                        newMap.put(keys[6], val);
                        break;
                    }
                    case "\u5e8f\u53f7": {
                        newMap.put(keys[7], val);
                        break;
                    }
                }
                if (!StringUtils.isEmpty((String)val) || !StringUtils.isNotEmpty((String)entry.getKey())) continue;
                isNull = true;
            }
            if (isNull) {
                newMap.put(keys[8], "0");
                newMap.put(keys[9], "\u5b58\u5728\u7a7a\u503c\u6216\u6570\u636e\u4e0d\u5408\u6cd5");
            } else {
                String errMsg = "";
                if ("0".equals(String.valueOf(newMap.get(keys[1]))) && !IdcardUtils.validateCard((String)String.valueOf(newMap.get(keys[1])))) {
                    errMsg = "\u8eab\u4efd\u8bc1\u53f7\u7801\u9519\u8bef\uff1b";
                }
                try {
                    int age = DateUtil.ageOfNow((String)String.valueOf(newMap.get(keys[2])));
                    if (age < 16 || age > 65) {
                        errMsg = errMsg + "\u5e74\u9f84\u4e0d\u7b26\u5408\u6295\u4fdd\u6761\u4ef6\uff1b";
                    }
                }
                catch (Exception e) {
                    errMsg = errMsg + "\u51fa\u751f\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff1b";
                }
                String car = String.valueOf(newMap.get(keys[4]));
                if (car.length() > 1 || !"1234".contains(car)) {
                    errMsg = errMsg + "\u804c\u4e1a\u7f16\u7801\u9519\u8bef\uff1b";
                }
                if (!ComInsServiceImpl.validateMobile(String.valueOf(newMap.get(keys[6])))) {
                    errMsg = errMsg + "\u624b\u673a\u53f7\u7801\u9519\u8bef\uff1b";
                }
                if (StringUtils.isNotEmpty((String)errMsg)) {
                    newMap.put(keys[8], "0");
                    newMap.put(keys[9], errMsg);
                } else {
                    newMap.put(keys[8], "1");
                    newMap.put(keys[9], "");
                }
            }
            mlist.add(newMap);
        }
        return mlist;
    }

    public static boolean validateMobile(String mobile) {
        Pattern p = null;
        Matcher m = null;
        boolean b = false;
        p = Pattern.compile("^[1][3,4,5,6,7,8,9][0-9]{9}$");
        m = p.matcher(mobile);
        b = m.matches();
        return b;
    }

    @Override
    public Result downErrInsPer(String importBatchId, HttpServletResponse response) {
        try {
            ServletOutputStream os = null;
            ExcelUtil<InsPerExcelBean> util = new ExcelUtil<InsPerExcelBean>(InsPerExcelBean.class);
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String("\u9519\u8bef\u4eba\u5458\u4fe1\u606f.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            List<InsPerExcelBean> list = this.comOnlineInsPerMapper.findErrTempBatchInsPerImport(Long.parseLong(importBatchId));
            util.exportExcel(list, "\u9519\u8bef\u4eba\u5458\u4fe1\u606f", 65535, (OutputStream)os);
        }
        catch (Exception e) {
            throw new V5BusinessException("-1", "\u5bfc\u51faExcel\u9519\u8bef\u4eba\u5458\u5931\u8d25");
        }
        return Result.success((String)"\u5bfc\u51faExcel\u9519\u8bef\u4eba\u5458\u6210\u529f");
    }

    @Override
    public Result tempBatchInsPerToAddPreservationService(ComInsDTO dto) throws V5BusinessException {
        if (Strings.isNullOrEmpty((String)dto.getImportBatchId())) {
            throw new V5BusinessException("-1", "\u6279\u6b21ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getOrderId())) {
            throw new V5BusinessException("-1", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<InsPreservationDetailVo> vo = this.comOnlineInsPerMapper.getBlbVoByTempBatchInsPerImport(Long.parseLong(dto.getImportBatchId()));
        if (vo.size() == 0) {
            throw new V5BusinessException("-1", "\u672a\u5339\u914d\u5230\u4eba\u5458\u4fe1\u606f");
        }
        return this.blbTestService.blbAddPreservationService(String.valueOf(dto.getComId()), dto.getOrderId(), JSONArray.toJSONString(vo), DateUtils.formatDate(dto.getStartTime(), "yyyy-MM-dd"));
    }

    @Override
    public Result tempBatchInsPerToRelevance(ComInsDTO dto) throws V5BusinessException {
        int resval;
        if (Strings.isNullOrEmpty((String)dto.getImportBatchId())) {
            throw new V5BusinessException("-1", "\u6279\u6b21ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getComInsId() == null) {
            throw new V5BusinessException("-1", "\u672a\u68c0\u7d22\u5230\u4fdd\u5355ID\u4fe1\u606f");
        }
        List<InsPreservationDetailVo> list = this.comOnlineInsPerMapper.getBlbVoByTempBatchInsPerImport(Long.parseLong(dto.getImportBatchId()));
        if (list.size() == 0) {
            throw new V5BusinessException("-1", "\u672a\u5339\u914d\u5230\u4eba\u5458\u4fe1\u606f");
        }
        int num = this.comInsMapper.offlineResidualFelatableQuantity(dto.getComInsId());
        if (num - list.size() < 0) {
            throw new V5BusinessException("-1", "\u5bfc\u5165\u4eba\u5458\u6570\u91cf\u8d85\u51fa\u5728\u4fdd\u4eba\u6570");
        }
        ArrayList addList = Lists.newArrayList();
        IdWorker id = this.idWorker;
        for (InsPreservationDetailVo vo : list) {
            HashMap rec = Maps.newHashMap();
            rec.put("comInsId", String.valueOf(dto.getComInsId()));
            rec.put("idCardNo", vo.getId_card());
            rec.put("name", vo.getName());
            rec.put("insPerDetailId", id.nextId());
            rec.put("createTime", new Date());
            rec.put("comId", dto.getComId());
            addList.add(rec);
        }
        if (addList.size() != 0 && (resval = this.comOnlineInsPerMapper.insertBatchPerInfo(addList)) != addList.size()) {
            throw new V5BusinessException("-1", "\u7ebf\u4e0b\u4fdd\u5355\u4eba\u5458\u4fe1\u606f\u5173\u8054\u5f02\u5e38\uff01");
        }
        return Result.success((String)"\u5173\u8054\u6210\u529f\uff01");
    }

    @Override
    public Result findCompnayAndTempBatchInsPerPutCache(ComInsDTO dto) throws V5BusinessException {
        if (dto.getComId() == null) {
            throw new V5BusinessException("-1", "comId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNullOrEmpty((String)dto.getImportBatchId())) {
            throw new V5BusinessException("-1", "\u6279\u6b21ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IdWorker id = this.idWorker;
        String cacheId = BSEnum.get(dto.getBusinessType()) + "-cacheIdForInsPerIds" + id.nextId();
        ArrayList<BLBComInfoDTO> list = new ArrayList<BLBComInfoDTO>();
        List<BLBComInfoDTO> company = this.comInsMapper.getCompanyByComID(dto.getComId());
        BLBComInfoDTO com = company.get(0);
        ComProject project = null;
        if ("1".equals(dto.getBusinessType())) {
            if (Strings.isNullOrEmpty((String)dto.getTlkProjectId())) {
                throw new V5BusinessException("-1", "\u6d3b\u52a8\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
            }
            project = this.comProjectMapper.getItemsBytlkProjectId(dto.getTlkProjectId());
        }
        if (com == null) {
            com = new BLBComInfoDTO();
            com.setKind("1");
        }
        if (project != null) {
            com.setProject_name(project.getProjectName());
            com.setProject_address(project.getAddress());
            com.setProject_start_time(DateUtils.formatTime(project.getStartTime()));
            com.setProject_end_time(DateUtils.formatTime(project.getEndTime()));
        }
        list.add(com);
        List<BLBComInfoDTO> persons = this.comOnlineInsPerMapper.getTempBatchInsPerByImportBatchId(Long.parseLong(dto.getImportBatchId()));
        list.addAll(persons);
        this.stringRedisTemplate.opsForValue().set((Object)(this.redisUtil.REDIS_PREFIX_KEY + ":INS:" + cacheId), (Object)JSON.toJSONString(list), 480L, TimeUnit.SECONDS);
        String blbUrl = this.blbTestService.getCompnayAndPersonPutCacheUrl(dto.getReviseType(), cacheId);
        return Result.success((String)"", (Object)blbUrl);
    }

    @Override
    public Result syncInsNumTaskToBLB() throws V5BusinessException {
        String policyNos = this.comInsMapper.findPolicysByOfflineBLBSign();
        if (StringUtils.isEmpty((String)policyNos)) {
            return Result.success((String)"\u6682\u65e0\u7b26\u5408\u6761\u4ef6\u7684\u4fdd\u5355\uff01");
        }
        String token = MD5Util.buildMD5(policyNos);
        Result result = this.blbTestService.blbZBNum(token, policyNos);
        if ("-1".equals(result.getRetType())) {
            return result;
        }
        if (result.getData() == null) {
            return Result.fail((String)"\u672a\u627e\u5230\u6570\u636e\uff01");
        }
        List list = JSONArray.parseArray((String)String.valueOf(result.getData()), Map.class);
        this.comInsMapper.updateZBNumByPolicyNo(list);
        return Result.success((String)"");
    }

    @Override
    public Result reportList(BLBAPIDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getStatus())) {
            throw new V5BusinessException("-1", "status\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getPerId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] perIds = new String[]{String.valueOf(dto.getPerId())};
        String idCardNo = this.perBaseInfoMapper.getIdCardNosByPerIds(perIds);
        if (StringUtils.isEmpty((String)idCardNo)) {
            throw new V5BusinessException("-1", "idCardNo\u4e0d\u5b58\u5728");
        }
        dto.setIdCardNo(idCardNo);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.reportList(dto.getIdCardNo(), dto.getStatus(), dto.getComId()));
    }

    @Override
    public Result findPolicyByIdCard(BLBAPIDTO dto) throws V5BusinessException {
        if (dto.getPerId() == null) {
            throw new V5BusinessException("-1", "\u53c2\u6570perId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String[] perIds = new String[]{String.valueOf(dto.getPerId())};
        String idCardNo = this.perBaseInfoMapper.getIdCardNosByPerIds(perIds);
        if (StringUtils.isEmpty((String)idCardNo)) {
            throw new V5BusinessException("-1", "idCardNo\u4e0d\u5b58\u5728");
        }
        dto.setIdCardNo(idCardNo);
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.findPolicyByIdCard(dto.getIdCardNo(), dto.getComId()));
    }

    @Override
    public Result getReportById(BLBAPIDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getReportId())) {
            throw new V5BusinessException("-1", "reportId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.getReportById(dto.getReportId(), dto.getComId()));
    }

    @Override
    public Result getFileIdByPath(BLBAPIDTO dto) throws V5BusinessException {
        if (StringUtils.isEmpty((String)dto.getPath())) {
            throw new V5BusinessException("-1", "path\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.getFileIdByPath(dto.getPath(), dto.getComId()));
    }

    @Override
    public Result saveReport(BLBAPIDTO dto) throws V5BusinessException {
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.saveReport(dto.getComId()));
    }

    @Override
    public Result saveUploadFile(BLBAPIDTO dto) throws V5BusinessException {
        return Result.success((String)"\u64cd\u4f5c\u6210\u529f\uff01", (Object)this.blbTestService.saveUploadFile(dto.getComId()));
    }

    private void changeInsPerCount(Long comInsId) {
        if (comInsId == null) {
            return;
        }
        new Thread(() -> this.comInsMapper.changeInsPerCount(comInsId)).start();
    }
}

