package com.bcxin.identify.util.huawei;

/**
 * <b> 华为云会议错误码参考枚举 </b>
 * @author ZXF
 * @create 2020/04/16 0016 16:09
 * @version
 * @注意事项 </b>
 */
public enum ErrorEnum {

    ERROR_000000001("000000001", "服务器正忙"),
    ERROR_000000002("000000002", "服务器正忙"),
    ERROR_000000003("000000003", "服务器正忙"),
    ERROR_000000004("000000004", "会话超时，请重新登录"),
    ERROR_000000008("000000008", "系统正在升级，暂时不可访问。如对您造成不便，十分抱歉"),
    ERROR_000000010("000000010", "服务器正忙"),
    ERROR_111070001("111070001", "请求错误"),
    ERROR_111070002("111070002", "对不起，您的权限不足，请联系企业管理员"),
    ERROR_111070003("111070003", "系统处理失败"),
    ERROR_111070004("111070004", "鉴权失败"),
    ERROR_111070005("111070005", "会议不存在"),
    ERROR_111070006("111070006", "个人云会议室不存在"),
    ERROR_111070007("111070007", "会议接入号不存在"),
    ERROR_111070008("111070008", "会议通知失败"),
    ERROR_111070009("111070009", "会议密码不能为空"),
    ERROR_111070010("111070010", "权限不足，无法查看会议"),
    ERROR_111070101("111070101", "系统处理失败"),
    ERROR_111071001("111071001", "系统处理失败"),
    ERROR_111071002("111071002", "系统处理失败"),
    ERROR_111071003("111071003", "创建会议失败，请稍后重试"),
    ERROR_111071004("111071004", "云会议室不允许来宾在主持人入会前入会"),
    ERROR_111071005("111071005", "会议时间冲突，请到“我的会议”查看该时段已预订的会议"),
    ERROR_111071007("111071007", "会议不存在"),
    ERROR_111071008("111071008", "查询会议列表失败"),
    ERROR_111071011("111071011", "会议尚未开始"),
    ERROR_111071013("111071013", "会议开始时间不能早于系统当前时间"),
    ERROR_111071014("111071014", "会议开始时间超出最大预订时间范围"),
    ERROR_111071052("111071052", "会议被锁定，请稍后重试"),
    ERROR_111071053("111071053", "会议被锁定，请稍后重试"),
    ERROR_111071058("111071058", "当前会议还未召开，请耐心等待"),
    ERROR_111071059("111071059", "与会方数超出上限"),
    ERROR_111071060("111071060", "企业未配置并发会议资源，无法使用个人会议ID和随机会议ID发起会议"),
    ERROR_111071063("111071063", "您未被分配云会议室，无法创建会议"),
    ERROR_111071064("111071064", "会议时间冲突，无法创建会议"),
    ERROR_111071065("111071065", "正在召开会议，无法编辑会议详情"),
    ERROR_111071066("111071066", "与会方数量超出上限"),
    ERROR_111071067("111071067", "会议正在召开中，不允许取消会议"),
    ERROR_111071069("111071069", "您选定的时间中没有会议"),
    ERROR_111071070("111071070", "周期会议子会议不允许修改直播房间"),
    ERROR_111071071("111071071", "结束会议失败"),
    ERROR_111071072("111071072", "会议已经结束"),
    ERROR_111072001("111072001", "申请会议资源失败"),
    ERROR_111072002("111072002", "释放会议资源失败"),
    ERROR_111072003("111072003", "会议正在结束"),
    ERROR_111072004("111072004", "正在创建会议"),
    ERROR_111072005("111072005", "会议尚未开始"),
    ERROR_111072006("111072006", "会议已经结束"),
    ERROR_111072007("111072007", "邀请与会方失败"),
    ERROR_111072008("111072008", "与会方不存在"),
    ERROR_111072009("111072009", "挂断与会方失败"),
    ERROR_111072010("111072010", "功能还在建设中，敬请期待"),
    ERROR_111072011("111072011", "会议状态错误"),
    ERROR_111072012("111072012", "会场会控操作失败"),
    ERROR_111072013("111072013", "云会议室当前正在被其他会议使用"),
    ERROR_111072014("111072014", "会议已结束"),
    ERROR_111072015("111072015", "会议尚未开始"),
    ERROR_111072016("111072016", "会议不存在"),
    ERROR_111072020("111072020", "当前会议不支持录制"),
    ERROR_111072021("111072021", "录播资源不足"),
    ERROR_111072031("111072031", "与会人的呼叫号码、手机号和邮箱不能同时为空"),
    ERROR_111072050("111072050", "会议被锁定"),
    ERROR_111072065("111072065", "会议ID不存在或密码错误，请确认后重试"),
    ERROR_111073001("111073001", "用户不存在"),
    ERROR_111073002("111073002", "部门不存在"),
    ERROR_111073003("111073003", "查询用户信息失败"),
    ERROR_111073004("111073004", "部门名称格式错误"),
    ERROR_111073005("111073005", "查询部门失败"),
    ERROR_111073006("111073006", "网络不佳，请稍后重试"),
    ERROR_111073007("111073007", "当前云会议室无法使用，请联系企业管理员"),
    ERROR_111074001("111074001", "会议主持人已经存在"),
    ERROR_111074002("111074002", "无会议主持人权限"),
    ERROR_111074003("111074003", "延长会议失败，会议已达到最大时长"),
    ERROR_111074004("111074004", "延长会议失败，服务处理异常"),
    ERROR_111075001("111075001", "系统处理失败"),
    ERROR_111075002("111075002", "系统处理失败"),
    ERROR_111080001("111080001", "请求消息参数错误"),
    ERROR_111080002("111080002", "用户无权限进行该操作"),
    ERROR_111080003("111080003", "系统处理失败"),
    ERROR_111080004("111080004", "与会方不存在或已被删除"),
    ERROR_111081001("111081001", "与会方正在通话中"),
    ERROR_111081002("111081002", "与会方所在会议不存在或已结束"),
    ERROR_111081003("111081003", "系统申请会议资源出错"),
    ERROR_111081004("111081004", "系统释放会议资源出错"),
    ERROR_111081005("111081005", "系统申请会议资源出错"),
    ERROR_111081006("111081006", "认证失败"),
    ERROR_111081007("111081007", "会议已经被锁定"),
    ERROR_111081008("111081008", "当前会议尚未开始，请耐心等待"),
    ERROR_111082001("111082001", "暂不支持该会议操作"),
    ERROR_112010001("112010001", "系统处理失败"),
    ERROR_112010002("112010002", "系统处理失败"),
    ERROR_112010003("112010003", "系统处理失败"),
    ERROR_112010004("112010004", "系统处理失败"),
    ERROR_112010006("112010006", "系统处理失败（错误码：112010006）"),
    ERROR_112010008("112010008", "系统处理失败"),
    ERROR_112010014("112010014", "系统处理失败（错误码：112010014）"),
    ERROR_112100009("112100009", "查询失败"),
    ERROR_112100010("112100010", "删除失败"),
    ERROR_112100012("112100012", "认证失败"),
    ERROR_112100022("112100022", "直播房间名称已存在"),
    ERROR_112100025("112100025", "直播地址已存在"),
    ERROR_112100026("112100026", "直播房间已被占用，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_112100027("112100027", "该直播房间已删除，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_112100030("112100030", "音视频推流地址已存在"),
    ERROR_112100031("112100031", "辅流演示推流地址已存在"),
    ERROR_112100033("112100033", "正在使用直播房间，删除或修改失败"),
    ERROR_112100034("112100034", "保存成功。与会方已达上限（500方），请调整与会方数量"),
    ERROR_112100040("112100040", "禁止修改备站点配置"),
    ERROR_112100044("112100044", "系统内部错误"),
    ERROR_115021001("115021001", "系统会议资源不足"),
    ERROR_115021002("115021002", "系统处理失败"),
    ERROR_115021003("115021003", "系统处理失败"),
    ERROR_115021004("115021004", "系统会议资源不足"),
    ERROR_115022001("115022001", "企业会议资源不足"),
    ERROR_115025001("115025001", "该直播房间已被占用，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_115025002("115025002", "该直播房间已删除，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_115025003("115025003", "系统处理失败（错误码：15025003）"),
    ERROR_115029001("115029001", "系统处理失败"),
    ERROR_115029002("115029002", "系统处理失败"),
    ERROR_115029003("115029003", "系统处理失败"),
    ERROR_115029999("115029999", "系统处理失败"),
    ERROR_118000000("118000000", "会议密码错误"),
    ERROR_118000001("118000001", "会话超时，请重新登录"),
    ERROR_201000000("201000000", "无效的TOKEN"),
    ERROR_201000001("201000001", "系统正忙，请稍后重试"),
    ERROR_201000002("201000002", "请求eSight重定向服务器失败，请检查对接配置、eSight重定向服务器是否正常"),
    ERROR_201000003("201000003", "请求短信邮件服务器失败，请检查对接短信邮件是否正常"),
    ERROR_201000004("201000004", "Id为空"),
    ERROR_201000005("201000005", "数据不存在"),
    ERROR_201000006("201000006", "该手机号的国家码错误"),
    ERROR_201000007("201000007", "邮箱地址不能为空"),
    ERROR_201000008("201000008", "邮箱地址和手机号不能同时为空"),
    ERROR_201000009("201000009", "请求ECS失败，请检查对接配置和ECS服务器是否正常"),
    ERROR_201000010("201000010", "请求云盘失败，请检查对接配置"),
    ERROR_201000011("201000011", "请求nginx地址失败，请检查对接配置"),
    ERROR_201000012("201000012", "备用站点仅支持部分查询操作。"),
    ERROR_201000013("201000013", "OBS服务请求失败"),
    ERROR_201000014("201000014", "未选择上传的隐私声明"),
    ERROR_201000015("201000015", "上传隐私声明失败"),
    ERROR_201000016("201000016", "上传的隐私声明语言错误"),
    ERROR_201000017("201000017", "隐私声明下载失败"),
    ERROR_201000018("201000018", "文件未上传"),
    ERROR_201000019("201000019", "请求PushCenter失败，请检查对接配置和PushCenter服务器是否正常"),
    ERROR_201000020("201000020", "请求PushCenter失败，请检查参数配置"),
    ERROR_201000021("201000021", "当前正在更新SP或企业的资源，请稍后重试"),
    ERROR_201010000("201010000", "SP不存在"),
    ERROR_201010001("201010001", "SP名称已存在"),
    ERROR_201010002("201010002", "SP域名已存在"),
    ERROR_201010003("201010003", "租户ID已存在"),
    ERROR_201010004("201010004", "SP下已存在企业，不能删除"),
    ERROR_201010005("201010005", "最大子企业数不得少于SP已创建的企业数"),
    ERROR_201010007("201010007", "SP的资源数不能少于代管企业的资源总数"),
    ERROR_201020000("201020000", "企业不存在"),
    ERROR_201020001("201020001", "企业名称已存在"),
    ERROR_201020002("201020002", "企业域名已存在"),
    ERROR_201020003("201020003", "租户ID已存在"),
    ERROR_201020004("201020004", "企业已分配的会议资源总数超过您购买的会议资源，请检查分配给该企业的会议资源数量"),
    ERROR_201020005("201020005", "SP无电话外呼权限，无法为其下企业配置该权限"),
    ERROR_201020006("201020006", "您能创建的企业数量已超过最大限制，如有需要，请前往华为云会议官网购买更多资源"),
    ERROR_201020007("201020007", "企业下还存在用户或终端，无法删除"),
    ERROR_201020008("201020008", "企业数量超过系统限制"),
    ERROR_201020009("201020009", "直播房间名称已存在"),
    ERROR_201020011("201020011", "敏感词数量超过最大值"),
    ERROR_201020020("201020020", "企业用户账号数不能少于已添加的用户数"),
    ERROR_201020021("201020021", "企业的硬件终端数量不能少于已添加的硬件终端数"),
    ERROR_201020022("201020022", "企业管理员邮箱已存在"),
    ERROR_201020023("201020023", "开启云盘后，企业管理员邮箱不能为空"),
    ERROR_201030000("201030000", "部门不存在"),
    ERROR_201030001("201030001", "同级部门名称已存在"),
    ERROR_201030002("201030002", "添加部门超时，请稍后重试"),
    ERROR_201030003("201030003", "部门层级超过最大值"),
    ERROR_201030004("201030004", "父部门不能是自己或其子部门"),
    ERROR_201030005("201030005", "部门下存在用户或硬件终端，不能删除"),
    ERROR_201030006("201030006", "不能删除最高级部门"),
    ERROR_201030007("201030007", "该部门的子部门数量超过最大值"),
    ERROR_201030008("201030008", "同一个企业下，部门编码重复"),
    ERROR_201030009("201030009", "指定可访问的部门列表为空或部分部门不存在"),
    ERROR_201040000("201040000", "用户不存在"),
    ERROR_201040001("201040001", "帐号已存在"),
    ERROR_201040002("201040002", "用户邮箱和手机号不能都为空"),
    ERROR_201040003("201040003", "仅支持普通用户升级为企业管理员"),
    ERROR_201040004("201040004", "禁止删除默认管理员"),
    ERROR_201040005("201040005", "用户总数超过限制，请检查购买的会议用户数"),
    ERROR_201040006("201040006", "该帐号不是普通企业成员或硬终端用户"),
    ERROR_201040007("201040007", "验证码校验失败"),
    ERROR_201040008("201040008", "账号非管理员"),
    ERROR_201040009("201040009", "用户不存在"),
    ERROR_201040011("201040011", "验证码已发送，请稍后重试"),
    ERROR_201040012("201040012", "验证码校验失败次数超过上限，您的帐号已被锁定，请稍后重试"),
    ERROR_201040013("201040013", "身份验证已超时，请返回上一步通过手机或邮箱验证身份"),
    ERROR_201040014("201040014", "该用户不允许删除。"),
    ERROR_201040015("201040015", "邮箱地址不能为空"),
    ERROR_201040016("201040016", "密码安全性低，请设置其他密码"),
    ERROR_201040017("201040017", "用户ID已存在"),
    ERROR_201040018("201040018", "第三方电子白板接入账号数量已达上限，请检查企业购买的会议资源"),
    ERROR_201040019("201040019", "免费注册用户已达上限"),
    ERROR_201040020("201040020", "用户的邮箱或手机已存在"),
    ERROR_201040021("201040021", "第三方帐号已存在"),
    ERROR_201040022("201040022", "禁止停用、启用或删除该用户"),
    ERROR_201040023("201040023", "当前企业用户或电子白板正在被系统停用或启用，请稍后再试"),
    ERROR_201040025("201040025", "该手机号的国家码错误"),
    ERROR_201040026("201040026", "邮箱地址不能为空"),
    ERROR_201040027("201040027", "邮箱地址和手机号不能同时为空"),
    ERROR_201050000("201050000", "设备不存在"),
    ERROR_201050001("201050001", "SN码已存在"),
    ERROR_201050002("201050002", "设备名称已存在"),
    ERROR_201050003("201050003", "支持激活码的设备，其管理员手机和邮箱不能都为空"),
    ERROR_201050004("201050004", "设备类型不支持激活码"),
    ERROR_201050005("201050005", "终端总数超过限制，请检查购买的硬件终端资源"),
    ERROR_201050006("201050006", "您购买的硬件终端资源不足，不能激活使用"),
    ERROR_201050007("201050007", "暂不支持该终端类型，请检查系统配置"),
    ERROR_201050008("201050008", "该设备型号不支持投影码"),
    ERROR_201050009("201050009", "该设备型号须配置投影码生成模式"),
    ERROR_201050010("201050010", "一天内重置设备激活码次数已达到最大值（5次）"),
    ERROR_201050011("201050011", "当前企业该类型设备正在被系统停用或启用，请稍后再试"),
    ERROR_201060000("201060000", "会议接入号不存在"),
    ERROR_201060001("201060001", "会议类型与鉴权类型不匹配"),
    ERROR_201060002("201060002", "会议接入号已存在，请确认后重试"),
    ERROR_201060003("201060003", "会议接入号不作为前缀，例如已存在接入号+86571，则新的接入号不能为+8657或+865711"),
    ERROR_201060004("201060004", "会议接入号已存在"),
    ERROR_201060005("201060005", "SP名下没有该会议接入号"),
    ERROR_201060006("201060006", "会议接入号已分配给SP下属企业，无法直接回收"),
    ERROR_201060007("201060007", "删除失败。该会议接入号已分配给SP，请回收后再删除"),
    ERROR_201060008("201060008", "修改失败，已有会议接入号使用该号码前缀"),
    ERROR_201060009("201060009", "会议接入号与前缀不匹配"),
    ERROR_201070000("201070000", "号码池不存在"),
    ERROR_201070001("201070001", "起始号码与结束号码长度不一致或起始号码大于结束号码"),
    ERROR_201070002("201070002", "新增号段与现有号段有部分号码重复，请检查号段区间"),
    ERROR_201070003("201070003", "该号段已被企业使用，不能修改或删除"),
    ERROR_201070004("201070004", "系统没有空闲号码，请稍后重试"),
    ERROR_201070010("201070010", "修改失败，已有号码段使用该号码前缀"),
    ERROR_201070011("201070011", "起始号码或结束号码与号码前缀不匹配，或与号码前缀相同"),
    ERROR_201080000("201080000", "云会议室不存在"),
    ERROR_201080001("201080001", "启用云会议室失败，请检查购买的云会议室套餐资源"),
    ERROR_201080002("201080002", "个人会议ID已经被使用，请刷新页面重试"),
    ERROR_201080003("201080003", "该个人会议ID无效"),
    ERROR_201080004("201080004", "云会议室未分配给该用户"),
    ERROR_201080005("201080005", "删除云会议室失败，云会议室数量不能少于购买的套餐数量"),
    ERROR_201080006("201080006", "主持人密码和来宾密码不能相同"),
    ERROR_201080007("201080007", "起始与结束ID长度不一致或起始ID大于结束ID"),
    ERROR_201080008("201080008", "云会议室ID段已存在"),
    ERROR_201080009("201080009", "云会议室ID段已分配，不能修改或删除"),
    ERROR_201080010("201080010", "系统无可用的云会议室ID"),
    ERROR_201080011("201080011", "初始化云会议室ID或个人会议ID超时，请检查系统ID段是否充足。"),
    ERROR_201080012("201080012", "一个硬终端只能分配一个云会议室"),
    ERROR_201080013("201080013", "当前仅支持分配云会议室给TE10、TE20、HUAWEI"),
    ERROR_201080014("201080014", "无可用的云会议室"),
    ERROR_201090000("201090000", "专用云会议室套餐不存在"),
    ERROR_201090001("201090001", "专用云会议室套餐包名称已存在"),
    ERROR_201090002("201090002", "云会议室套餐分配冲突"),
    ERROR_201090003("201090003", "云会议室套餐包分配后，名称不能修改"),
    ERROR_201090004("201090004", "云会议室套餐未分配给该SP"),
    ERROR_201090005("201090005", "可分配的云会议室套餐超过限制，请检查购买的云会议室套餐资源"),
    ERROR_201090006("201090006", "系统管理员分配给SP的专用云会议室套餐数量少于SP已分配给企业的数量"),
    ERROR_201090007("201090007", "专用云会议室资源已分配给企业，SP无法回收"),
    ERROR_201090008("201090008", "SP管理员分配给企业的专用云会议室套餐数量，不能少于企业已分配给用户的数量"),
    ERROR_201090010("201090010", "专用云会议室套餐包已分配给SP，不能删除"),
    ERROR_201090011("201090011", "给企业分配的云会议室个数，每次不能超过1000个"),
    ERROR_201090012("201090012", "云会议室套餐未分配给该企业"),
    ERROR_201100000("201100000", "文件大小超过限制"),
    ERROR_201100001("201100001", "文件大小超过限制"),
    ERROR_201100002("201100002", "文件格式错误"),
    ERROR_201100003("201100003", "文件内容为空"),
    ERROR_201100004("201100004", "文件内容为空或文件格式不符合要求"),
    ERROR_201100005("201100005", "文件行数超过限制"),
    ERROR_201100006("201100006", "相同类型的任务正在运行，请稍后重试"),
    ERROR_201100007("201100007", "任务未结束，记录不能删除"),
    ERROR_201100008("201100008", "不支持校验该表"),
    ERROR_201100010("201100010", "导入失败，用户已经存在"),
    ERROR_201100012("201100012", "导入的文件与系统提供的模板不匹配，请下载最新的模板"),
    ERROR_201110000("201110000", "分组不存在"),
    ERROR_201110001("201110001", "同级分组名称已存在"),
    ERROR_201110002("201110002", "分组层级超过最大值"),
    ERROR_201110003("201110003", "每级分组数量超过最大值"),
    ERROR_201110004("201110004", "父分组不能是自己或其子分组"),
    ERROR_201110005("201110005", "该分组下存在企业，不能删除"),
    ERROR_201110006("201110006", "不能删除根分组"),
    ERROR_201120000("201120000", "企业资源ID不存在"),
    ERROR_201120001("201120001", "SP资源不足，无法分配给企业"),
    ERROR_201120002("201120002", "企业内资源ID重复"),
    ERROR_201120003("201120003", "资源的过期时间应大于当前时间"),
    ERROR_201120004("201120004", "资源操作禁止编辑"),
    ERROR_201130000("201130000", "文件下载失败"),
    ERROR_201130001("201130001", "未选择上传的隐私声明"),
    ERROR_201130002("201130002", "上传隐私声明失败"),
    ERROR_201130003("201130003", "上传隐私声明输入参数错误"),
    ERROR_201130004("201130004", "下载输入参数错误"),
    ERROR_201130005("201130005", "下载的文件不存在"),
    ERROR_201130006("201130006", "下载的文件不存在"),
    ERROR_201130007("201130007", "文件大小不能超过2M"),
    ERROR_201130008("201130008", "文件类型不是.docx"),
    ERROR_201200001("201200001", "应用名称已存在"),
    ERROR_201200002("201200002", "应用名称为空"),
    ERROR_201200003("201200003", "该应用不存在"),
    ERROR_201200004("201200004", "插件应用不存在"),
    ERROR_201200005("201200005", "该APP下存在关联应用，请先删除关联应用"),
    ERROR_201200006("201200006", "该插件应用已存在"),
    ERROR_201200007("201200007", "插件应用名称已存在"),
    ERROR_202010002("202010002", "没有操作权限"),
    ERROR_202010007("202010007", "数据已存在"),
    ERROR_202030001("202030001", "部门代码不存在，无法查询部门相关信息"),
    ERROR_202040001("202040001", "更新头像失败，请重试"),
    ERROR_206010000("206010000", "用户名或密码错误"),
    ERROR_206010005("206010005", "登录超时，请重新登录"),
    ERROR_206010007("206010007", "帐号未激活，无权限登录"),
    ERROR_206010008("206010008", "用户信息不存在或者未激活，无权登录"),
    ERROR_206010010("206010010", "获取验证码失败"),
    ERROR_206010011("206010011", "验证码不能为空"),
    ERROR_206010012("206010012", "验证码校验失败"),
    ERROR_206010013("206010013", "跳转登录失败"),
    ERROR_206010022("206010022", "SSO登录失败"),
    ERROR_206010023("206010023", "当前企业域名或帐户不支持SSO登录"),
    ERROR_206010026("206010026", "企业域名已被使用"),
    ERROR_206010028("206010028", "请使用SSO登录"),
    ERROR_206020000("206020000", "鉴权信息无效"),
    ERROR_206030000("206030000", "系统中不存在该用户"),
    ERROR_206030001("206030001", "验证码错误或失效，请重新获取"),
    ERROR_206030002("206030002", "验证码错误"),
    ERROR_206030003("206030003", "发送验证码失败"),
    ERROR_206030004("206030004", "请{{sendLeftTime}}秒后重新发送"),
    ERROR_206030005("206030005", "系统不支持修改密码"),
    ERROR_206030006("206030006", "旧密码错误"),
    ERROR_206030007("206030007", "新密码长度不符合要求"),
    ERROR_206030008("206030008", "密码复杂度不满足要求"),
    ERROR_206030009("206030009", "设置的密码不能与最近旧密码相同"),
    ERROR_206030010("206030010", "密码不能包含3个以上重复字符"),
    ERROR_206030011("206030011", "修改密码后，5分钟内不能更新密码"),
    ERROR_206030012("206030012", "密码不能与帐号或其逆序帐号相同"),
    ERROR_206030013("206030013", "新密码相较于旧密码至少要有两个不同的字符"),
    ERROR_206030014("206030014", "密码格式不正确"),
    ERROR_206030015("206030015", "用户已被锁定，请{{lockLeftTime}}秒后重试"),
    ERROR_206030016("206030016", "您当前没有权限重置密码"),
    ERROR_206030017("206030017", "鉴权失败"),
    ERROR_206030018("206030018", "一天内忘记密码次数已达到最大值（10次）"),
    ERROR_206030019("206030019", "验证码输入错误次数超过最大值，请重新获取"),
    ERROR_206030020("206030020", "发送短信失败"),
    ERROR_206030021("206030021", "发送邮件失败"),
    ERROR_206030022("206030022", "发送重置密码失败"),
    ERROR_206030023("206030023", "发送验证码失败"),
    ERROR_206030024("206030024", "发送短信失败，所属企业没有发送短信权限"),
    ERROR_206030025("206030025", "您的公司未开通短信业务，发送验证码失败。请通过邮箱获取验证码。"),
    ERROR_206030027("206030027", "一天内重置密码次数已达到最大值（5次）"),
    ERROR_206030028("206030028", "系统已开启SSO登录，不支持修改密码"),
    ERROR_209000001("209000001", "服务器正忙"),
    ERROR_209000002("209000002", "会话超时，请重新登录"),
    ERROR_209000003("209000003", "对不起，您没有权限进行此操作"),
    ERROR_209000004("209000004", "此用户已被锁定，请{{time}}秒后重试"),
    ERROR_209000005("209000005", "会话超时，请重新登录"),
    ERROR_209000006("209000006", "网络不佳，请稍后重试"),
    ERROR_209000007("209000007", "用户不存在"),
    ERROR_11070001("11070001", "请求非法"),
    ERROR_11070002("11070002", "权限不足"),
    ERROR_11070003("11070003", "系统处理失败"),
    ERROR_18000000("18000000", "用户鉴权失败"),
    ERROR_18000001("18000001", "usg*token鉴权失败"),
    ERROR_18000002("18000002", "usg鉴权账号锁定"),
    ERROR_11070005("11070005", "会议不存在"),
    ERROR_11070006("11070006", "VMR个人会议室不存在"),
    ERROR_11070007("11070007", "接入号不存在"),
    ERROR_11070008("11070008", "会议通知失败"),
    ERROR_11070009("11070009", "需要鉴权密码"),
    ERROR_11070010("11070010", "用户无权查看会议"),
    ERROR_11070100("11070100", "获取召开会议异常"),
    ERROR_11070101("11070101", "开始会议异常"),
    ERROR_11070102("11070102", "申请IVR资源异常"),
    ERROR_11070103("11070103", "开始IVR会议异常"),
    ERROR_11070104("11070104", "申请会场资源异常"),
    ERROR_11070105("11070105", "开始子会议异常"),
    ERROR_11070106("11070106", "创建级联通道异常"),
    ERROR_11070107("11070107", "移动会场申请资源异常"),
    ERROR_11070108("11070108", "开启会议异常"),
    ERROR_11070109("11070109", "获取召开vmr会议异常"),
    ERROR_11070110("11070110", "邀请会场异常"),
    ERROR_11070111("11070111", "请求token为空"),
    ERROR_11070112("11070112", "重命名会场异常"),
    ERROR_11070113("11070113", "会场挂断异常"),
    ERROR_11070114("11070114", "会场批量挂断异常"),
    ERROR_11070115("11070115", "删除与会者异常"),
    ERROR_11070116("11070116", "批量删除与会者异常"),
    ERROR_11070117("11070117", "预定周期会议异常"),
    ERROR_11070118("11070118", "修改周期会议异常"),
    ERROR_11070119("11070119", "创建周期会议异常"),
    ERROR_11070120("11070120", "区域信息获取失败"),
    ERROR_11071001("11071001", "系统处理失败"),
    ERROR_11071002("11071002", "系统处理失败"),
    ERROR_11071003("11071003", "会议号不存在"),
    ERROR_11071004("11071004", "VMR会议不允许来宾在主持人入会前入会"),
    ERROR_11071005("11071005", "VMR会议冲突"),
    ERROR_11071006("11071006", "VMR会议时长不足"),
    ERROR_11071007("11071007", "会议不存在"),
    ERROR_11071008("11071008", "查询会议列表失败"),
    ERROR_11071009("11071009", "不支持修改VMR会议为立即会议"),
    ERROR_11071010("11071010", "不支持修改VMR标识"),
    ERROR_11071011("11071011", "VMR会议未到准备时间点"),
    ERROR_11071012("11071012", "非VMR会议"),
    ERROR_11071013("11071013", "会议开始时间小于系统当前时间"),
    ERROR_11071014("11071014", "会议开始时间超出最大预约时间范围"),
    ERROR_11071015("11071015", "会议时长超出范围"),
    ERROR_11071016("11071016", "参数为空"),
    ERROR_11071017("11071017", "与会方数超出范围"),
    ERROR_11071018("11071018", "媒体类型非法"),
    ERROR_11071019("11071019", "会议类型非法"),
    ERROR_11071020("11071020", "周期会议时，必须携带周期会议参数"),
    ERROR_11071021("11071021", "会议时长超出范围"),
    ERROR_11071022("11071022", "会议主题超长"),
    ERROR_11071023("11071023", "groupuri超长"),
    ERROR_11071024("11071024", "邮箱地址不合法"),
    ERROR_11071025("11071025", "手机号不合法"),
    ERROR_11071026("11071026", "部门名称过长"),
    ERROR_11071027("11071027", "入会欢迎词开关不在范围内"),
    ERROR_11071028("11071028", "入会提示音开关不在范围内"),
    ERROR_11071029("11071029", "离会提示音开关不在范围内"),
    ERROR_11071030("11071030", "会议提醒非法"),
    ERROR_11071031("11071031", "会议是否启用网络录制取值非法"),
    ERROR_11071032("11071032", "会议是否自动启动录制取值非法"),
    ERROR_11071033("11071033", "会预定者的用户类型非法"),
    ERROR_11071034("11071034", "加密类型非法"),
    ERROR_11071035("11071035", "语言非法"),
    ERROR_11071036("11071036", "是否自动延长会议取值非法"),
    ERROR_11071037("11071037", "vmrid超长"),
    ERROR_11071038("11071038", "录播类型非法"),
    ERROR_11071039("11071039", "主流直播地址超长"),
    ERROR_11071040("11071040", "辅流直播地址超长"),
    ERROR_11071041("11071041", "周期会议时，起始日期为空"),
    ERROR_11071042("11071042", "周期会议时，结束日期为空"),
    ERROR_11071043("11071043", "周期会议时，周期类型非法"),
    ERROR_11071044("11071044", "周期会议时，interval非法"),
    ERROR_11071045("11071045", "周期会议时，point为空"),
    ERROR_11071046("11071046", "周期会议时，point非法"),
    ERROR_11071047("11071047", "vmrFlag非法"),
    ERROR_11071048("11071048", "recordAuxStream非法"),
    ERROR_11071049("11071049", "multiStreamFlag非法"),
    ERROR_11071050("11071050", "audienceFlag非法"),
    ERROR_11071051("11071051", "直播频道ID不存在"),
    ERROR_11071052("11071052", "匿名登录锁定"),
    ERROR_11071053("11071053", "链接登录锁定"),
    ERROR_11071054("11071054", "会议ID不足"),
    ERROR_11071055("11071055", "会议ID申请失败"),
    ERROR_11071056("11071056", "会议ID释放失败"),
    ERROR_11071057("11071057", "直播房间已被占用"),
    ERROR_11071058("11071058", "VMR会议来宾不允许激活会议"),
    ERROR_11071059("11071059", "与会方超出专用VMR套餐的最大与会人数"),
    ERROR_11071060("11071060", "企业未购买会议并发方数，不允许预约随机ID/固定ID会议"),
    ERROR_11071061("11071061", "参数校验失败"),
    ERROR_11071062("11071062", "JSON转换失败"),
    ERROR_11071063("11071063", "非VMR会议室拥有者"),
    ERROR_11071064("11071064", "VMR会议冲突,当前已有会议正在召开"),
    ERROR_11071065("11071065", "会议正在召开中，不允许编辑会议"),
    ERROR_11071066("11071066", "预约/修改会议，与会人数超出上限"),
    ERROR_11071067("11071067", "会议正在召开中，不允许取消会议"),
    ERROR_11071068("11071068", "会议密码加密失败"),
    ERROR_11071069("11071069", "您的选定时间中没有会议"),
    ERROR_11071070("11071070", "周期会议子会议不允许修改直播房间"),
    ERROR_11071071("11071071", "结束在线会议失败"),
    ERROR_11071072("11071072", "会议已结束不能入会"),
    ERROR_11072001("11072001", "申请资源失败"),
    ERROR_11072002("11072002", "释放资源失败"),
    ERROR_11072003("11072003", "会议正在结束"),
    ERROR_11072004("11072004", "会议正在开始"),
    ERROR_11072005("11072005", "会议还未开始"),
    ERROR_11072006("11072006", "会议已经结束"),
    ERROR_11072007("11072007", "邀请会场失败"),
    ERROR_11072008("11072008", "会场不存在"),
    ERROR_11072009("11072009", "挂断会场失败"),
    ERROR_11072010("11072010", "功能不支持"),
    ERROR_11072011("11072011", "会议状态非法"),
    ERROR_11072012("11072012", "会场会控操作失败"),
    ERROR_11072013("11072013", "当前VMR会议非目标会议"),
    ERROR_11072014("11072014", "VMR会议已过期"),
    ERROR_11072015("11072015", "VMR会议还未开始"),
    ERROR_11072016("11072016", "会议不存在"),
    ERROR_11072020("11072020", "非录播会议不支持录制"),
    ERROR_11072021("11072021", "录制资源不足"),
    ERROR_11072022("11072022", "录播调动失败"),
    ERROR_11072023("11072023", "会议中没有与会人"),
    ERROR_11072024("11072024", "请确保会议中已有会场入会"),
    ERROR_11072025("11072025", "语音会议不支持该功能"),
    ERROR_11072026("11072026", "语音会场不支持该操作"),
    ERROR_11072027("11072027", "手动设置的多画面中无法显示语音会场"),
    ERROR_11072028("11072028", "手动设置的多画面中需最少设置一个会场"),
    ERROR_11072029("11072029", "手工设置的多画面最多只允许一个辅流子画面"),
    ERROR_11072030("11072030", "声控多画面模式下，每个子画面最多只允许一个用户"),
    ERROR_11072031("11072031", "与会者的入会号码不允许为空"),
    ERROR_11072032("11072032", "与会者的入会号码长度超过系统允许的最大值(127字符)"),
    ERROR_11072033("11072033", "与会者的入会号码格式非法(支持SIP、TEL号码格式)"),
    ERROR_11072034("11072034", "与会者的名称长度超过系统允许的最大值(96字符)"),
    ERROR_11072035("11072035", "与会者的角色类型不在系统允许的取值范围内[0,2]"),
    ERROR_11072036("11072036", "与会者的邮箱地址长度超过系统允许的最大值(96字符)"),
    ERROR_11072037("11072037", "与会者的手机号码长度超过系统允许的最大值(127字符)"),
    ERROR_11072038("11072038", "与会者入会后是否静音的取值不在系统允许的取值范围内[0,1]"),
    ERROR_11072039("11072039", "与会者是否自动邀请的取值不在系统允许的取值范围内[0,1]"),
    ERROR_11072040("11072040", "主持人选看类型取值不在系统允许的取值范围内[0,2]"),
    ERROR_11072041("11072041", "设置多画面检查：设置多画面方式取值不在系统允许的取值范围内[0,1]"),
    ERROR_11072042("11072042", "轮询显示时间取值不在系统允许的取值范围内[10,120]"),
    ERROR_11072043("11072043", "画面类型不允许为空"),
    ERROR_11072044("11072044", "画面类型非法"),
    ERROR_11072045("11072045", "开关项取值不在系统允许的取值范围内[0,1]"),
    ERROR_11072046("11072046", "与会者的名称不允许为空"),
    ERROR_11072047("11072047", "与会者的名称超过系统允许的最大值(64字符)"),
    ERROR_11072048("11072048", "不支持多画面，请联系管理员开启MCU配置"),
    ERROR_11072049("11072049", "等待响应超时，您可以重新尝试"),
    ERROR_11072050("11072050", "会议被锁定"),
    ERROR_11072051("11072051", "会议显示模式为空"),
    ERROR_11072052("11072052", "会议显示模式不在系统允许的取值范围内{Fixed,VAS}"),
    ERROR_11072053("11072053", "会议画面类型不在系统允许的取值范围内[0,1]"),
    ERROR_11072054("11072054", "横幅或字幕类型为空"),
    ERROR_11072055("11072055", "横幅或字幕的内容为空"),
    ERROR_11072056("11072056", "横幅或字幕的内容长度超过2000字节"),
    ERROR_11072057("11072057", "请求消息体为空"),
    ERROR_11072058("11072058", "子画面索引大于画面总数"),
    ERROR_11072059("11072059", "会议中没有主持人"),
    ERROR_11072060("11072060", "当前普通与会方类型不支持该操作"),
    ERROR_11072061("11072061", "当前主持人正在轮询观看会场，不能单独选看其他会场或会议多画面"),
    ERROR_11072062("11072062", "当前主持人与会方类型不支持该操作"),
    ERROR_11072063("11072063", "录制资源重新申请错误码"),
    ERROR_11072064("11072064", "失败次数过多，帐号被锁定，请({{time}})秒后重试"),
    ERROR_11072065("11072065", "会议ID不存在或密码错误，请确认后重试"),
    ERROR_11072066("11072066", "企业未购买录播空间"),
    ERROR_11072067("11072067", "企业录播空间已满"),
    ERROR_11072068("11072068", "启动直播失败"),
    ERROR_11072069("11072069", "不允许指定会议主持人举手发言"),
    ERROR_11072070("11072070", "来宾不允许进行该操作"),
    ERROR_11072071("11072071", "仅能对自己进行操作"),
    ERROR_11072072("11072072", "没有会控能力的与会者不允许设置为主持人"),
    ERROR_11072073("11072073", "推送消息已过期"),
    ERROR_11072074("11072074", "云下会场不能成为主持人"),
    ERROR_11073001("11073001", "用户不存在"),
    ERROR_11073002("11073002", "组织不存在"),
    ERROR_11073003("11073003", "用户非法"),
    ERROR_11073004("11073004", "组织非法"),
    ERROR_11073005("11073005", "查询组织失败"),
    ERROR_11073006("11073006", "申请匿名账号失败"),
    ERROR_11073007("11073007", "专用VMR会议室状态不可用"),
    ERROR_11074001("11074001", "会议主持人已经存在"),
    ERROR_11074002("11074002", "无会议主持人权限"),
    ERROR_11074003("11074003", "延长会议失败，会议已达到最大时长"),
    ERROR_11074004("11074004", "延长会议失败，服务处理异常"),
    ERROR_11075001("11075001", "系统处理失败"),
    ERROR_11075002("11075002", "系统处理失败"),
    ERROR_11075003("11075003", "json转换异常"),
    ERROR_11076001("11076001", "会场被终端主持人挂断"),
    ERROR_11076002("11076002", "会场被portal管理员挂断"),
    ERROR_11076003("11076003", "超出VMR最大与会方数"),
    ERROR_11076004("11076004", "企业并发数不足"),
    ERROR_11076005("11076005", "会场无响应"),
    ERROR_11076006("11076006", "会场不存在"),
    ERROR_11076007("11076007", "会场离线"),
    ERROR_11076008("11076008", "会场正忙"),
    ERROR_11076009("11076009", "会场拒绝接听"),
    ERROR_11076010("11076010", "会场挂断"),
    ERROR_11076011("11076011", "媒体资源不足"),
    ERROR_11076012("11076012", "PSTN服务未开通"),
    ERROR_11076013("11076013", "申请地址本鉴权信息失败"),
    ERROR_11076014("11076014", "SIP呼叫超时"),
    ERROR_11076099("11076099", "通用错误"),
    ERROR_11077001("11077001", "RSE设备信息不存在"),
    ERROR_11078000("11078000", "没有可用Region"),
    ERROR_11078001("11078001", "没有可用Global"),
    ERROR_11078002("11078002", "多region分发region错误"),
    ERROR_11079000("11079000", "大参数查询xml解析失败"),
    ERROR_11079001("11079001", "匿名账号分配xml解析失败"),
    ERROR_11080001("11080001", "请求消息参数错误"),
    ERROR_11080002("11080002", "用户无权限进行该操作"),
    ERROR_11080003("11080003", "系统处理失败"),
    ERROR_11080004("11080004", "会场不存在或已被删除"),
    ERROR_11081001("11081001", "会场正在通话中"),
    ERROR_11081002("11081002", "会场所在会议不存在或已结束"),
    ERROR_11081003("11081003", "系统申请资源出错"),
    ERROR_11081004("11081004", "系统释放资源出错"),
    ERROR_11081005("11081005", "系统申请资源出错"),
    ERROR_11081006("11081006", "认证失败"),
    ERROR_11081007("11081007", "会议已经被锁定"),
    ERROR_11081008("11081008", "会议未到入会时间"),
    ERROR_11082001("11082001", "不支持该会控"),
    ERROR_11083001("11083001", "RSE设备不存在"),
    ERROR_11089002("11089002", "链接入会XML解析失败"),
    ERROR_11090001("11090001", "数据入会失败"),
    ERROR_11090002("11090002", "数据入会超时"),
    ERROR_15029999("15029999", "系统处理失败"),
    ERROR_15029001("15029001", "系统处理失败"),
    ERROR_15029002("15029002", "系统处理失败"),
    ERROR_15029003("15029003", "系统处理失败"),
    ERROR_15021001("15021001", "系统资源不足"),
    ERROR_15021002("15021002", "系统处理失败"),
    ERROR_15021003("15021003", "系统处理失败"),
    ERROR_15021004("15021004", "系统处理失败"),
    ERROR_15021005("15021005", "系统资源不足"),
    ERROR_15021006("15021006", "系统处理失败"),
    ERROR_15022001("15022001", "企业资源不足"),
    ERROR_15022003("15022003", "企业资源不足"),
    ERROR_15025001("15025001", "直播房间已被占用，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_15025002("15025002", "该直播房间已删除，请返回“创建会议>高级参数”界面重新选择"),
    ERROR_15025003("15025003", "系统处理失败（释放直播房间失败）"),
    ERROR_12010004("12010004", "系统处理失败"),
    ERROR_12010003("12010003", "系统处理失败"),
    ERROR_12010002("12010002", "系统处理失败"),
    ERROR_12010001("12010001", "系统处理失败"),
    ERROR_12010005("12010005", "系统处理失败"),
    ERROR_12010006("12010006", "系统处理失败"),
    ERROR_12010007("12010007", "系统处理失败"),
    ERROR_12010008("12010008", "系统处理失败"),
    ERROR_12010009("12010009", "系统处理失败"),
    ERROR_12010010("12010010", "系统处理失败"),
    ERROR_12010011("12010011", "系统处理失败"),
    ERROR_12010012("12010012", "系统处理失败"),
    ERROR_12010013("12010013", "系统处理失败"),
    ERROR_12010014("12010014", "系统处理失败0成功"),
    ERROR_12100000("12100000", "业务处理异常"),
    ERROR_12100001("12100001", "密码不能为空！"),
    ERROR_12100002("12100002", "参数格式异常"),
    ERROR_12100003("12100003", "数据未获取到"),
    ERROR_12100004("12100004", "数据重复"),
    ERROR_12100006("12100006", "请求的类型不支持"),
    ERROR_12100007("12100007", "保存通知模板失败"),
    ERROR_12100008("12100008", "保存数据失败"),
    ERROR_12100009("12100009", "查询数据失败"),
    ERROR_12100010("12100010", "删除数据失败"),
    ERROR_12100011("12100011", "需要重置密码"),
    ERROR_12100012("12100012", "旧密码错误"),
    ERROR_12100013("12100013", "新密码不能与旧密码相同!"),
    ERROR_12100014("12100014", "密码复杂度不够,安全性低"),
    ERROR_12100015("12100015", "长度不符合要求"),
    ERROR_12100016("12100016", "RSE在会议中"),
    ERROR_12100017("12100017", "RSE待删除"),
    ERROR_12100018("12100018", "查询会议列表失败"),
    ERROR_12100019("12100019", "用户已被锁定，请稍后重新登录"),
    ERROR_12100020("12100020", "json转换异常"),
    ERROR_12100021("12100021", "参数校验失败"),
    ERROR_12100022("12100022", "频道名称已存在"),
    ERROR_12100023("12100023", "修改系统配置项失败，会议ID前缀重复！"),
    ERROR_12100024("12100024", "修改系统配置项失败，会议ID前缀只能增加，不能修改和删除！"),
    ERROR_12100025("12100025", "直播房间地址已存在"),
    ERROR_12100026("12100026", "直播房间已被使用"),
    ERROR_12100027("12100027", "直播房间不存在"),
    ERROR_12100028("12100028", "直播房间释放失败"),
    ERROR_12100029("12100029", "请求缺失头域"),
    ERROR_12100030("12100030", "音视频推流地址已存在"),
    ERROR_12100031("12100031", "辅流演示推流地址已存在"),
    ERROR_12100032("12100032", "密码安全性低，请设置其他密码"),
    ERROR_12100033("12100033", "直播房间被占用时，修改/删除操作失败"),
    ERROR_12100034("12100034", "因为与会者数量超出上限只保存部分");

    private String error_code;

    private String error_msg;

    public String getError_code() {
        return error_code;
    }

    public String getError_msg() {
        return error_msg;
    }

    private ErrorEnum(String error_code, String error_msg){
        this.error_code=error_code;
        this.error_msg=error_msg;
    }

    public static String errorMsg(String error_code){
        for(ErrorEnum e : ErrorEnum.values()){
            if(error_code.contains(e.getError_code())){
                return e.getError_msg();
            }
        }
        return "";
    }
}
