package com.bcxin.identify.util;


import java.util.LinkedList;
import java.util.List;

public class JsonConverUtil {

    /**
     * <b> Json字符串key首字母大小写转换 </b>
     * @param str json字符串
     * @param rule 转换类型：1.大写，其它.小写
     * @author ZXF
     * @create 2019/06/24 0024 14:06
     * @version
     * @注意事项 </b>
     */
    public static String jsonParamNameFirstOneConvert(String str, Integer rule) {
        String splitRule0 = "", splitRule1 = ":", splitRule2 = ",\"", splitRule3 = "\"", splitRule4 = "{", splitRule5 = "[";
        String[] split = str.split(splitRule1);
        List<String> params = new LinkedList<>();
        for (int i = 0; i < split.length; i++) {
            if (i == (split.length - 1)) {
                break;
            }
            String[] ss = split[i].split(splitRule2);
            String result = ss[ss.length - 1].replace(splitRule3, splitRule0).replace(splitRule4, splitRule0).replace(splitRule5, splitRule0);
            params.add(result);
        }
        for (String param : params) {
            String newParam = null;
            if (rule.equals(1)) {
                newParam = toUpperCaseFirstOne(param);
            } else {
                newParam = toLowerCaseFirstOne(param);
            }
            str = str.replace(param, newParam);
        }
        return str;
    }

    /**
     * <b> 首字母转小写 </b>
     * @author ZXF
     * @create 2019/06/24 0024 14:06
     * @version
     * @注意事项 </b>
     */
    public static String toLowerCaseFirstOne(String s) {
        if(Character.isLowerCase(s.charAt(0))) {
            return s;
        }else {
            return (new StringBuilder()).append(Character.toLowerCase(s.charAt(0))).append(s.substring(1)).toString();
        }
    }

    /**
     * <b> 首字母转大写 </b>
     * @author ZXF
     * @create 2019/06/24 0024 14:06
     * @version
     * @注意事项 </b>
     */
    public static String toUpperCaseFirstOne(String s) {
        if(Character.isUpperCase(s.charAt(0))) {
            return s;
        }else {
            return (new StringBuilder()).append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).toString();
        }
    }
}
