package com.bcxin.identify.api.tencent.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.bcxin.identify.api.tencent.dto.BroadcastDto;
import com.bcxin.identify.api.tencent.service.TencentIMService;
import com.bcxin.identify.business.domain.dto.PushUni2DTO;
import com.bcxin.identify.config.exception.BusinessException;
import com.bcxin.identify.util.HttpUtils;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.common.JwtUtil;
import com.bcxin.identify.util.common.StringUtil;
import com.bcxin.identify.util.sys.ConfigUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.jsonwebtoken.Claims;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * <b> 负责对外接口 </b>
 * @author ZXF
 * @create 2021/01/28 0028 13:20
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/identify/api/tencent")
@Slf4j
public class TencentController {

    @Resource
    private TencentIMService tencentIMService;

    /**
     * <b> 腾讯IM获取sig </b>
     * @author ZXF
     * @create 2021/01/30 0030 10:33
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-tencent-sig")
    @ResponseBody
    public Result getTencentSig(HttpServletRequest request) {
        String name = request.getParameter("name");
        String mobilePhone = request.getParameter("mobilePhone");
        String photoUrl = request.getParameter("photoUrl");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/get-tencent-sig】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("name",name);
        params.put("mobilePhone",mobilePhone);
        params.put("photoUrl",photoUrl);
        if (StrUtil.isEmpty(params.get("name"))
                || StrUtil.isEmpty(params.get("mobilePhone"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/get-tencent-sig】腾讯IM获取sig对流程开始。");
        Result result = tencentIMService.getTencentSig(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/get-tencent-sig】腾讯IM获取sig对流程结束。");
        return result;
    }

//    public static void main(String[] args) {
//        String a = "苏畅;hBGO6sgF,李冬琳;IrPm27fI,邱艺东;f298iEVG,任瑶瑶;afd6PgXW,马洋洋;AFYZPwFI,林晨辉;bp46nJsr,严鹏;L4snq9l9,刘希平;BI1ZEWdO,黄雪晴;eWvq2UlA,陈清波;qINFI3kV,龙梦菲;tMZJRiZg,何道宽;VIll5bRv,陈羿良;3gZIHmOZ,牛俊;eoFAIwEy,苏雅玲;ieVufgMb,余恭娘;VyMuvG3j,王巧静;t2D12AOU,曾庆鼎;Lo0fVnct,王诺兰;oa0eOLeP,黄瑞芬;e6lNwVLv,郭建敏;R1k2sKKC,张红全;wZjswdYd,白杰静;swPmoMCq,周倾然;vGxSnR5Y,施艺玲;nMXpIvOI,高玉青;bRaL4vB5,梁文赠;ofJhI271,吴素琴;65bNiwL4,阙定明;6YTV75Cq,王贺;BAfb3pVM,钟云奇;rIpcvaKN,何艺汀;dos7lVst,朱晓云;cfXSYCWn,王明艳;otVRyPUP,林颜腾;PdnyIYrY,周西国;dNh7F1Bv,余北华;YTAsc3mu,林萍萍;eg5jPvo9,周妤;7OsSfNbh,许雨晴;8EtgT3Zp,陈术;l8VUlM88,陈荣林;eeRDKfJQ,黄坤山;85BMIeAt,唐泽峰;QN48bWce,王利华;x9Os1J3i,李德川;BM9FyxMA,蔡智宏;PXZdMBTh,王从兰;Sy0uCXIK,赖婷婷;tfv5L71m,何世刚;XRRa1PJ1,赵婕;MeR7LQgb,孙新华;qeCu9eim,沈素桃;2zLWilR0,丁晓红;ILXOJStx,陈永辉;EmKWON6E,王可欣;gFhiKvYN,高倩;wo335Aoa,侯铎;mQhcBax5,罗嗣荣;tWDKAZAT,姜慧金;A7aASOZ2,王进喜;WRr9IhAu,洪赞成;tisGGkRY,张永跃;dPVF4ZdN,周文国;PyOzs5Cp,洪小芳;oDUrNCw2,毛艳雄;uvT5N6Mx,曾娜群;ePullTsu,陈慧雅;hQrMiGqm,裴猛猛;1voM46Pn,陈吉汀;Sb61htsM,杨丽红;00vqXsLZ,吴周唐;lQZjyHvt,蔡欣如;Qr4MexUi,赵汉林;P41KlhKQ,陈小萍;se9GXY90,陈晓锋;9vwNxOtA,林秀巧;h96qdEk8,叶羽莎;H1p81fyk,陶冠良;MfBoMsyc,李旭鹏;t9QN4JJ2,彭海鸿;qLJ6CHno,陈德英;8cavGBqs,李倩倩;fOKdlJXx,叶建新;xKRWtBtq,陈晓真;rpPjmm5a,李碧;TUAGLlvP,杨小华;tXwcBrI1,付卫红;iYZP2olb,钟德清;kVK88nsn,陈文生;kWGPVMXw,郑丹妮;Vy3DEURh,高里;daBtzFF6,叶色转;9rOmjcwy,胡清林;ZoGjBMjm,林志钡;YMxBsQPe,徐春艳;tBzmbt5e,乔雪松;C32VPcR3,宋祖云;KgvvJagI,洪燕萍;CKvHKdYK,刘海艳;OOhY9Uyh,林智毅;ZbuUDqpM,李龙州;vUYXNYKP,蔡树雪;rfCcqYqt,王志阳;tsWOGMLk,郭俊峰;HfcPsWMB,陈翔锋;dOIal8pk,陈秀娟;3PZiL9Hg,陈粤闽;HL3VKMdk,董为好;KO1dLlLc,吴启梅;kndnHdgX,谢桥妹;G5CoWBTl,许燕婷;qJmkbgEJ,江艳;1gwhpJGB,刘远崧;w5cYggrW,曾秋香;ocbC0Vhz,张宗斌;L3jwpXXk,姜美玉;dpeB7JPS,占乔春;mFZGLUhD,聂磊;83PKRnuQ,陈铭松;B3gyl6HW,林良辉;ix46zrxx,李晏怡;Tg5S0XsL,彭丹;LqVYKowe,王璐;UEk3L7Rs,江文陶;wu395S0i,吴晨华;zPauiZpT,周鸿鹭;CJmYNWWG,李雯;7bdINlNp,陈江源;i4Hj6AFc,廖泽珊;dC23XlTs,饶家永;Ls2TeSFB,梁左明;eojuRVRa,方泽华;VLc94RA9,佘莉君;e2mUU3A7,孙国臣;zdWmgVqP,杜晓静;F6fcVdAz,詹永明;7Bsn6eXn,纪安奇;UpDOkgTp,卢金辉;EdFabNuo,施彩玲;poSM2yEt,完颜家贝;91QPn1wC,蔡玉那;4elaFuzs,王小舜;3jutHlOn,林珍玲;ZmLHjGxz,白晓龙;FhnGLS1R,张利平;qTtHkf36,吴泗海;rOd98Qui,陈浩;2aSEQCfz,宋迎强;hVSVmNcc,甘慧芳;Bb0mTh41,陈洁;fzG72N7K,贾国情;jwLeaEQ8,林汇集;hBMFbAHV,姚宝玉;Y2bswIPV,许进添;63phTCZQ,段豫佳;6Bvu0u6U,陈琼华;3qxOVYmf,毛金秀;H5LZ6YKw,龚志伟;SSIEWmhq,胡梅;TOY180nY,付洺由;2sZ2ENGG,李恒;3pLTQNvC,林永城;EMRBQwYC,郑粤;r6q4yUEP,胡艳雄;EzmJRVr0,唐绮;nJODwEk5,吴艳平;w6LHNOr0,蔡淑敏;VA86sOQh,巫文进;Z8YjEcKP,吕国俊;zHQcgZP7,赖奕君;RRkNcV3n,卢艺彬;gYP8UdZg,宋金菊;eVgV09n8,陈惠莲;YtcNx7aQ,赖镇平;vZC8QZMK,黄小兰;3a2VV5Ce,郭燕雪;ZI7IyTgm,张进;GcCI9Nb6,徐珊珊;7fF8KPAN,苏友福;PVYZwFbz,李芳;rEojmf8Z,徐雅玲;7oLg7y24,游文娟;bl5vXye0,肖春华;U4kqD3nn,杨芝侠;PPseZMHK,宋书凝;0hxNtouD,郑添辉;1qjuLY8V,何富平;fVBLmJQz,韦小兰;BQyUPHhS,叶立琳;rzf1JGzB,林国辉;R7z1EIId,林翔;xH3pkTnE,谢真;gDHkfc1O,刘中维;OUifYMOY,罗文涛;cUo4WJPo,乔恩影;QAa4yrIs,吴梦云;jtnbt7Vw,曾嘉;dRaIilBb,陈阳;1LMpdH0a,陈艺棕;DKIRsnQ7,张晓辉;2uHjaYBS,刘美玲;S5NLVJML,郭丽芳;AoPWKa9n,洪建卫;tYB1NJPY,魏志强;OTGOcwET,朱有仙;7hNZc54w,陈婷;Y41BcuXb,李云鹏;vx4SMkZv,张贵敏;R4ViaiGe,林荣昌;mwxeZqBA,李元发;NADChgKG,黄彬城;AkCPbY2C,孙祥;6MBdNd8W,江秀芳;HNb4Jql8,江婷;tbMjYbMg,薛秋芬;ZBztdnrr,邓维;FP82l6gl,黄华政;YwniNwdv,林海松;rMbkYW3m,朱汉生;JY0lqnDQ,董云;kx7bEa56,毛丽莹;iVXfujoN,黄长缨;tAU8vLqP,杨燕;SPpfdTRn,汤元彰;AhboMI7A,杨小燕;hYJ8JfCh,戴燕汉;9hjGV96y,张曼莉;lcmCe6HG,方晓晴;zXKMgEPt,吴海燕;mUxu7vca,占彩英;dxss5v4L,熊先丽;pzx9GnSP,徐秀清;OyAKRO42,王晓珍;H9rEFsIL,郑丽玉;19VJRC0g,吕木侦;dpPZOPJR,李敏;GV3O5SGV,钟晓连;UTUHHIWD,胡明姣;ZVHqOHaY,杨晓玲;cJDofgfl,谢冬红;EKt4LY2E,徐南后;I03dSClj,邱月;0F8FrGde,葛胜武;KeE5fv3G,苏友福;R6zIpusD,任国藩;9rBqTFEh,乔恩影;GHRE4cok,邵全莉;azACIyc7,张秋菊;EcJeBBk0,陈珊;XqL1mNy7,黄翠兰;UF1wWyXC,由于;RNyUIlQq,任义权;MVtpB7PU,雷怀彦;oy17tZzX,柯思雨;zb2uGSdJ,倪碧松;wBKJE8q9,冯子昌;SmIKfZOL,许淑琴;0pKBNZvB,米尔布拉·杰力力;s4pLmlrD,张兴红;GQaQQIop,乔恩影;csn4t6sO,严贵林;mqnCqDks,谢俊林;8m6AgSSz,曾霄;pSuhgEC7,吴慧莉;iI9ClhMw,朱有仙;bFGpU6GF,陶丽丽;YnOeAAAZ,张根珠;i3OIZPuS,张素花;fF6D24Pq,修玉蓉;x9UTAegg,吴俊毅;guwweQ7J,刘聪花;jFO6rsmJ,王锦钰;w0uZD6MI,刘亚东;98A4Wpba,魏起地;cfyykNZB,李元发;dIOaOXoD,林艺红;bpXiPFhY,宋亮;9gXNmrB8,徐成;VCusy0VH,张世瑛;DYazlUfi,苏婷婷;CDgPpj7R,林志阳;2k7KUCUS,黄瑞珍;UuL1ayUl,吴小花;kH75gBDW,王哲;qAELmPcR,陈鸿杰;FiwKWDuw,吴小玲;5dWdF2mK,全秀琼;rODMGI5D,张晨鹦;fE48DxHK,李华;G8JRBoSt,陈宏超;1luH1yAf,巫稳金;qE4ICvxU,陈月娇;7gGkckZR,江珠琴;QFOZLCU4,吴若冰;3mmlhP3W,杨婷红;XswdrZIN,洪昊;dAppQggV,刘翎;HFKmuMso,江雅宝;c01KYuBn,黄莆媛;MOEAWLB2,何天金;mmd8Aow3,范林燕;pe7iUkDa,郑建鹏;MAOXVn3e,孙杰;oTEPnhT1,赖慧珍;SJVK2bfg,郎亚芬;40LIH5ap,黄菊梅;FHqFhq8K,赖桂英;7Rs2hK2C,钟少文;1TdvR7u3,王召琼;P5PGGxkE,缪树开;TtpeM5Zy,李秀露;NMW18djF,孙运丰;A00PpdtT,韦桂海;ar0Z2XfN,张文英;qDbolFWF,袁冰梅;0cursnCp,周龙英;DfNYTGgW,苏茂台;7lBVIYNM,王龙桃;k2iZQuDQ,吴艺强;WV7DfMmm,赵焕明;AEdXZTLX,莫朝有;gMqJNRSU,吴聪聪;425fe0yb,陈蓉;K9c8dFjo,李宏峰;p7Zt7MDC,叶迪溪;aOsY1B5T,叶伟;AQmba35m,刘炜;cu3Xp4Bz,张晓婷;u7PfLcio,杨淑霞;Sh1spn2u,杜佾斌;rjroihhc,张苑芳;7kZJUCmX,刘幼菊;hHKxFMWO,刘爱华;34eMRFTp,蔡建坤;b1lqZ7Bk,陈永清;HggobeH1,李慧;OTwxEp5r,章海玉;Yx5AXti1,余宏峥;6WGeSGps,鲍建勤;HhCWK8Wz,孙林;Jl0YW2pT,张溪水;12NKMlIz,谭德焱;g9N43x0O,黄国锋;gI1cTIOM,阙廉庭;EvYT7cOY,李秋绕;aheO7DQ5,傅胜龙;cr6fXrfN,何亮;qYkW1daj,刘新疆;rDfiMkza,吴杨韩;p1RtDz1K,邓小英;gSTpHh0V,佘青;cKRIuID4,张绍锋;S6TFfgxy,龚佳祥;JZG9gN8E,何春妍;AyXosnhB,豆成斌;dy8w4k7K,陈智恒;DM96Ms1N,胡翔;R2ceNYiw,李治;vBAMIA9z,谢志敢;kTpSA1Gl,陈晓峰;AXv8QnTz,聂茂盛;QDB3t5o6,李宇飞;Qr2MkZFr,黄丽君;95TPwTsJ,洪佳怡;dWKlowy2,林历帆;nj72vTyp,陈靖琦;iv6V3Mfg,赵引弟;VBcvBzib,许焱晖;EVNUKCQ9,李颢;SLs5ow8c,谢晓芳;OrZTjIKg,赖小丽;lhL5LgtK,叶雅萍;DopxoX9M,陈顺愿;pagrLFOZ,徐泽南;z5ZDjRyN,藏炜轩;4069WLMl,袁敏;mQX6ydIX,杨俊华;E3RkYiNI,胡申城;ZjhlsAbA,高清景;Otgm5CGt,张晓斌;5KYJsLvc,魏华明;z73eE30X,张于;moDqUvMb,郑秀连;sfqUlNbf,洪海浪;5Et4isbA,谢萍;k5vaHjYn,杨瑜芬;8xAYeeqr,杨小龙;JbzTX7AC,严远驰;kWl2bWhY,彭睿思;js4RBkcq,欧建杭;Sqz2hcYA,高海霞;UadIWCGq,王琼;zIn0YipD,赖晓勤;hmYiBvMJ,曾娜卿;igljhBST,林寶城;pa7mby4q,李晓璐;AYSTcrp6,邹思敏;CSDQ6J8J,朱玉华;PaERNA52,刘敬乾;W5woi9Gi,丁晓芳;ax0zpvD0,曾雪云;JjXT1v1f,李子璇;jlUZYHcm,廖玉丽;3QlAmk0c,程贺;4MF1Im4H,林菁;qIUc5YAB,李丽凤;e8gZRsIi,江春飞;ruUMmKRb,彭伟伟;nNVEQXiC,吴若冰;JcyVDgji,谷运香;UKJyZ6XZ,庄丽芳;ak15CEKr,郑泽兴;gaSR4yxQ,何奕欣;grwfcKec,李帮建;JQkYO23I,王晓红;Kd8oLJzG,余晓丽;CPFAuTaF,聂文兵;i1EabyUb,吴圆胜;F1vOUOjO,胡荣华;RSHyMaOe,余永得;nfu5xQMW,吴顺强;X4NrjIfP,王巧林;98nmG2rP,陈航;3ziTrY8I,李春财;LwSe2cVC,吕玉云;t93Skw5I,吕小军;Er3kHpiM,颜秋巧;NdNicEOS,潘抒凡;ab63dcNs,林南松;f0cA9MIu,黄莉;5tk3aqNk,沈永莲;Sr7DKLxy,刘艳虹;Te2wMjLJ,马祎凯;KCoopzpA,黄希凡;7jUBkyP1,段云;l31unfUW,邓小凤;DjEGDZjB,郭震南;vAGjSg92,谷立娟;bHnvIJyO,孔维笑;5OSGI4v2,李强;xbqVqcf4,李丽;a0hdFsO7,郭晓曼;EuFXErky,洪小龙;ai3ie0IO,吴志军;R0dzQV4L,黄坤元;yTQIVa76,余建妹;9xkY7HJh,陈萍萍;Lwv1TJ20,林彩兰;Ac67jple,张洪;iLCA5oCw,方遒;HNREjKpH,谢芳;aNgc8Yn6,占曼雅;o6ZQNBh7,刘俊佳;vxAJKkJc,王哲;fKKvtnvp,吕晓军;X8Thrwtw,管晓丽;SooZGfDD,张雪玉;ZooihgCl,陈绍林;jdnSAL8q,田洪;n19yNlJi,沈在维;tK4T4C9Z,张敏;JKm1lK2T,傅智杰;BCYCXYcd,黄敏;4cg3Rr4M,苏明凯;fRvjvSvu,杨波;Yd7nI0in,钟文静;K0GnkvXX,王玉丽;Te1e8K4C,胡志杰;qZ9giCuF,潘春凌;5zhyOKEK,曾华圣;tWboR9is,朱伟杰;4LqWW2oN,郑杰;pw8HEEqH,苏新庆;8a3qvDTB,凌泽宾;0R6EueR4,杨群;lUkzXQ4Y,玉张;53BUy0uP,赖小宝;yK2DGJDf,许伏香;SX5CqZS3,刘金花;RDvjOT4E,吴永平;vvzz3em9,杨明英;Hmkx3LZ3,赵新霞;uoBf60fI,张玉娟;fARxZ72v,刘红香;XI5wCODY,汤松茹;71rk2a1A,董惠珍;geNpGNhj,黄海涵;jGeVte5J,陈佳伟;O8K6ii4D,赖梓斌;l1gVeqov,谢莉芬;lQKmRi6S,齐春博;Gr00iEeE,尹丽红;xiTQ70Q8,吴淑贞;xmRHhX53,侯金连;CiOFKwlz,张琼;vA31FIsi,张鑫泉;qok7IuWf,游凤花;xAYwE2xx,李小娟;EcgiEtCq,朱毅鑫;HLlzOyWl,李共林;w91Ia3FK,吴秋嫣;5NUCQr6Q,郑雨晴;wr9fSatf,邹江腾;HKdYxXSg,黄薇雯;vWJOC5E2,彭子全;DRR6kmpz,李菲;6OAy7V8L,吴莉;7Pu70l9n,黄进;sFMujLRJ,吴夏兰;eXnRmYtR,黄艺彬;OH5VuXJR,陈龚斌;WfQXzuTl,刘庆云;mUmUTRap,雍华国;XtgkadED,郑城凤;NO88GgDN,钟月新;HcSg4tOj,杨木德;p3Y98BnZ,苗西安;BiH4Gr3F,张亚;It3zzkAo,张金泉;MF2upv1A,李铭轩;JP7tWlY2,谢晓红;U416dStv,陈娟娟;9L9Kd3hf,吴振杰;OXLzJQev,苏小明;QHYw7wCx,杨志荣;rSa6OODU,林金环;ngPF012R,苏景华;nMnxo7UI,何沐霞;rWXQUP2E,高春梅;v1YfCV90,范静;15682817448,陈晓佳;ohTxy29V,喻剑东;P5XLwfKl,李小金;SvT14oRw,薛淇;EKjFRyKD,罗翠华;KEYRDduj,谢桂蓉;k9O3lwHI,许勇;eYqVNXCP,谢志芬;0yO6zTRG,罗梓恒;utIfxpcT,徐久红;KeJ0wYdC,肖智聪;B1DSv4rf,王泉安;fidOx4zp,刘天友;kKhIVqZ3,陈银银;ViZbQaL4,黄庆云;px6ODOni,张明远;frRpGQsb,华慧莲;i1meJAHb,钟瑞军;mnRQ3zyQ,叶岳友;TkeeVY3f,丁俊芳;u1eMO9S9,刘玉平;O5vzZ9LD,冯志伟;UAXcyed7,陈贵珍;CNUERb4u,陈小青;kUQYnIDz,蔡璐;nLMd1zZX,张萌雪;amFWG3N2,林园珠;irCFhyNU,温庆锋;NbfrqbJH,吴志英;gqXRPjej,朱玄;T9Y68yS6,刘飞萍;li2eUXpW,史燕燕;UqdHe8tS,陈秀美;KZKUaN1C,徐玉洪;VVJriUlB,陈伟超;mewDg74f,陈木旺;BFG3ky5m,黄文婷;Y91BxKXn,陈艺英;FVIfpvRc,徐礼杰;16KosQZR,郑俊杰;BxRpmk1c,郭亚燕;doxadeUj,庄碰毛;GUcQwloE,郑城凤;4pk8FSbH,李召启;E2VHhotd,金晓梅;XXs33ct0,冯丽萍;Oh88PTJQ,柯凌蛟;iO87wBoi,马艳;WxPffeRW,邹丽真;PvVnQKlp,谭风燕;To65nXaL,孙磊磊;z5o4MXoM,洪志雄;DNn9KL2A,许嘉玲;xvwhbXUC,杜立名;63Rljev4,黄丽颖;LvgV8wGc,成玉霞;pSTilJso,宋文峰;8A9bpLc3,刘景景;YUMFg32b,郑玮杰;5JqK7pVK,郑枝妹;cDSYKuGb,纪跃进;rGm3oik0,王耀明;CiBN3taa,杨晓军;rkifwjq7,李丽萍;NuF23UDG,李招健;DU3EwMaP,谢春梅;ZcozvS1k,黄幸武;gU3VwJQA,林诗妍;Yy5G8Cvb,周涛;PHjQvaBB,李程;2OYoHbS3,李丹丹;bWZtm206,杨瑞芬;pgZmV3Xa,郑艺军;xJG5K8RJ,马加娟;tzt9t61R,龙玉梅;4U7FjEOt,徐健;bqj8OJ2n,杨晓燕;oyZZ20g8,王美生;BQOPeqp0,周琼芳;WL6wY0mO,罗晨茜;0OsqSFfK,陈建龙;bU3zhS9a,郑琪;rnId7cd0,吴陆勇;Sy2h3uE9,韩海玉;9udAWgzd,姚丽粉;KhAe4Rf9,马爱梅;FSs87nlF,蒲灏君;xKSyZ6KA,蔡丽羡;Z9MkYlaX,朱碧碧;rulaYjZb,陈夏玲;JFzS03S2,曾德盛;gfenvHg4,淦克通;WkjENytg,张武敌;GjF3pEBU,袁红娟;ikRMFSPz,吴笛;iQkGJxcz,程乐天;itzkynRL,石源;3lOgFKV5,王土发;QV7xX0Ip,卢丽娟;X9M4JKAh,邓发娟;ovYW0wLd,何泉凤;smT6V8eD,侯翠瑜;DzRrZsG9,黄清河;3jJS8fVW,孙杰;Y9jCKmmu,罗江木;IaDhpZxw,陈琴妹;xqaGelMw,谢洪涛;4wyhYfQC,廖春林;irJyJapV,尹欣;ZlfMHauf,王旭;hkQjpJCL,李哲;Lj0ZGDU8,张碧云;RBhaLYYz,曾巍林;N8V44YNn,胡宇凡;mSSOQ7KV,韩京清;7JyoQFFd,陈根长;tvmm0lk1,吴百计;cNb2vvKq,朱玄;qG4dnwFj,陈晓琳;FC9AF6hr,陈林玲;L6RN38TD,许盛枝;ewgxbUbY,郭朝省;NU9W8fpJ,石新滑;p6Fc2cFr,黄克;0fhXNzQY,林煜雄;fOMoLgf6,张荣辉;ipB87gV4,潘泽辉;kNswHKuN,李莉莎;GfYqN95Y,江素惠;C4fudMQ9,苏坤宁;ZLKlAQ4P,洪梅芬;7A1J6bng,肖德和;DXpIVoZc,程慧敏;8HrFx31X,刘丽琼;0VZViF3h,林巧珍;Vfjfu6yz,吴启棠;8LYJQZYE,朱文元;VNPNlgUd,陈笑钦;CDl22XJ4,黄方梅;dZtPFow3,牛佳彬;f7xfnI8Z,杨淑贤;gNuzyfzw,陈琳;TM3m65R0,林雄清;MUpny4F5,刘慧芳;oJj6Wsz1,杜纯发;WPw6DYf7,吴恒镕;qF4moj1h,陈丽君;5jT2roqO,黄小芹;Evt2iYAE,陈耀峰;0hG0b9dj,吴速英;A0PK6ecm,岳文文;W7uLmHUl,林清英;S07V83jK,杨智心;DzgsgRYp,叶细美;tcGx0FCU,周珍春;XAEoTdWl,张玉萍;lYs3CxQb,纪雪金;sSUHCPoM,黄延;GfqVjigb,曾绍蕖;2s3aZdKn,陈进永;ogQ2fB7t,郑玉婷;f0izyiMm,陈振威;FtScdO7l,韩天虎;IsKARY59,杨晓军;SkeEBoGG,洪春妹;xZSDNaAN,罗云;QzWgLIrR,胡逢仙;EZQs9lnu,林青青;Ajh0XFaq,李俊刚;6j7AuXz2,张翠霞;NS7erztZ,马跃;J2lEaPMC,郑振伟;Nu7dUflL,陈新花;4eldzFw6,廖春林;MUOImZGi,单卫灵;BIF1sGwz,钟俐俐;koHiAzhr,侯海秋;tRKLFnnG,林丽勤;SzJReJtX,王利琴;qX77Ypmr,许婉婷;V483gzwO,陈晓萍;hZv0CSgm,郑梅华;hEAYZMBW,周珍乐;Rqk8JJ4B,庄艺玲;w4eetoWZ,兰加威;yBZx8ddd,刘建华;N21JEtzr,邱满琴;qRynr4WI,蔡明叶;DVYHopLp,林芳磊;Z6cm02nz,林香英;6WaY4AxB,林水妹;XcpuuhLl,王小霞;YliM0TbB,叶宏琛;ftcZxZx0,陈春兰;yvajwLUX,蒋诗雨;KCq9gVZh,李加汀;lPx7HukM,陈怡超;l6f3NEDH,梁水洋;PFCa0tWD,庄鹭杰;ZCbFW7PW,邓红飞;Nx24LyxZ,陈志远;lD3GaWd9,刘慧燕;9TA8GHCu,邹智祥;16WA0UhH,曾观女;YFyE7jMB,周雅婷;h6PwlR8b,郑玉琳;anRYXzxb,甘协龙;gq1TuS0N,许湫凤;FPz8zqeb,李碧潭;xB0AK8Rt,刘文玉;Qn5djSpC,陈延龙;I5QjchmE,许湫凤;5rXzuCEA,柯春梅;k7K5z9E6,谢月红;YMUMIf86,辛碧华;o07yr1CY,杨志东;5tqf7T2p,胡超玲;MnQRmgdm,陈秋霞;XfTqDfDs,朱笑燕;mOEz3bpB,杨珠华;Fk3hFZ6x,陈春燕;SbwkvF8B,孟鑫怡;IfgifCJe,李敏;DySScr8h,陈秉映;bBn7lVPY,姬栓峰;9RwsyKC4,翁明忠;ruFslcxX,吴秋玉;Wo3jpjnM,蔡艺斌;H9D5oDYX,李冬斌;UcNKUpHe,康美静;vj9CnwVf,潘锋刚;MNNIlJVu,杨永锋;su7XFhHk,张英桃;hkZLKDut,华海燕;64SrcII4,吴兰花;MOtvaaTF,廖燕玲;6QX6q0q9,郑汝静;LCwPzudO,叶子琳;WmdPRMLx,王淑;pvdX9lOr,肖邵鹏;0HJx27fp,郑振兴;UoCcvRsR,刘宗旺;7jNY3cWW,王佳伟;UWER4fEF,张河远;sMpgO0xc,林勇平;wCRqqxGP,叶娇阳;HhP7lmWT,丁建军;WQbBOADP,曾国州;57obsjal,邓小双;5hGOiWvB,刘玉红;48Wgg8Ia,魏雪琴;a9CBmMZK,张青青;9VDcuEDv,赖丽珍;7ehtkbxv,谢丽芳;TKg42Tms,江娟;mXZDLuYM,孙思思;aAGhz3vz,游丽萍;atVHSFUW,赵情辉;tiXlpeaG,张弛;IFjjQRdX,廖文敏;rUw672mJ,邓小芳;r0jjvuVR,王小红;nET4f6Ce,林淑娟;CbtEc5gb,林晓奖;KaCdlhpU,解凤雷;eQ8qQOHd,李文建;gYD7o5PZ,丁莹莹;beRQBYBU,陈佳玲;jO0TdOGt,林文琦;csL4sAP6,陈辅民;YpjFG6NT,吴庆燕;V31sKM2W,陈秋玉;9ayhA9MK,张耀文;EHEN9PdH,卢丽林;hfkXUChp,卢舟霞;WOeJRid3,翁华明;5EStBOUo,钟美玲;GfVcu78k,王佩佩;qiKGNc09,黄玉裕;K3F4skTI,吴耿豪;6Nnn1HIh,王清礼;U5rHlGkc,陈蕾婷;zIhmV4Lt,林灿烨;Sx0heBQo,周建华;jBcjmfEy,张学梅;7L4Uhm8N,颜福才;XpL3A3qj,曾华星;V3ocmWrB,周苏琦;Jb2f18Re,韦小燕;O9XYciqW,洪佳怡;XWlkAuDT,赖东方;rRoR8Avz,邓利东;6hIPJx0h,马丽华;aQUpTu0W,郑诗琦;9WFka9S1,吴晓春;2BzBZQrH,范梅烨;9wbDH2vG,瓮玲莉;ssWx2Uwg,王婧;XkcoAIMh,罗斯文;HT7fdc4c,李雅平;23fQg1bO,蔡小丽;TnH60dQ7,廖细香;r4X1887H,马文军;eP4ispZv,蔡燕煌;Y7cTexEC,唐琳;d3RcOCmp,郭丰;kmMQl2Bx,项德火;oSnXrEYr,王天平;XuiFRAbN,黄慕蓉;6NPjPA78,黄柳芳;th0ykMZS,黄凯容;SoI4OeJr,陈晋林;uBfx9103,李忠;KIjJeXEJ,赖少华;qTeGAyxA,张洁梅;G9z0lMYc,吴秀金;Sp7Swhc6,何美玲;Zzi02Prv,黄祖业;GRd5lFgq,王佳怡;esF0diae,赵小红;89V1lIh7,何牡芳;o1rKaMQ7,温彩丽;ZnslqHVB,许美芬;uzfjf3yu,吴祺浩;XSJDo5jl,黄艳;uQaOcoCB,曾水春;DnQGeqd4,黄德娣;GUFd7TIX,王连华;4F0fYIDi,欧阳梅桂;yWZqiko0,赖国英;IDs92Ybx,陈婉滨;QNOGtZPm,陈伟祥;WkoWD1pR,刘波;q8rMqcNt,许娟;ma1t8rfM,谢春;wzfJ2tp1,陈妹;NqUBITSz,李香娣;fjSP30Xh,刘廉鹏;oZH5tgwN,黄思寒;DNZnhWj7,赖彩英;7w7yNF9g,陈海燕;ZaddoPFD,梁财坤;mozoXwoA,陈惠观;recLVENI,陈龙海;Wgp8IUdg,熊淋;hHDjb6e4,朱春秋;3QA4azht,罗玉琴;vNZXrOw2,林瑞环;9PVIvEGq,吴静娥;Hfcbgmup,李美艳;4YAnbrId,蔡沄舟;TwJR3HoJ,林福利;sc17axCX,朱春秋;Okdmprb5,罗礼宝;Lwcg4a9G,温晴;bEkaNZrO,李秋燕;OMLFABJI,卢璐芬;4gRItEUk,王燕;sUFEnsba,蔡水枝;37MiQq2J,冯惠珍;1TeAuwi6,马洪涛;DBhCDzLl,陈小殷;tF0gPr6i,蔡金发;PYfi59jC,严思聪;LgvzGaxi,高少义;30rbLbM8,郭雪榕;nPPCnMWS,李焕彬;70tdcWyf,张启豪;oGrnhMsa,邱龙海;569uIK8u,王兴菊;zaJXjrwS,徐俊勇;UAMUBKJ1,谢海红;pd44cx9C,范维海;ByPmkFbL,陈标;xJsZnkNA,余炳林;U5GgmPgX,蔡敏;sziJ9TFe,林诗妍;68YN7PnP,方克春;L01iHdg4,朱喜孟;K2wdtoSn,陈美艳;2S1hN1rS,林应云;RJxtB4Vq,林斯青;8CXEUs6e,余兰英;HKWwLuae,朱朝仕;h33JExHR,林新芳;EI18CDR4,林永福;vjdVkLeF,叶敏;pDHBOO3n,廖燕霞;zMceihhC,胡晶堂;nnJ0Zuhn,陈三宝;iTNKME2S,王婷婷;SR9Zizlq,陈雪莲;P43fzxsk,温安然;YCGyYpcl,冯德锐;YGXH1mcU,邱燕丽;yKhZujn1,张绍文;RkUo9xhC,谢升;xlithOmb,罗春燕;Y6DxVvce,张梅梅;S6WphOC9,王连华;tKdn4RZi,邹志强;B6wYjbaH,林鹏城;oVfRnkKD,朱荣祥;ysBbfiLk,陈梦伶;5kWNxbTb,余华平;aJq8RcJp,林思洁;7DYBg58j,李晓英;DybL1byE,鞠毅;iccHRG4j,苏明秋;kuCYh1Mr,戴维福;MuRpuThO,廖建树;b3Z8ZV8h,陈宝连;zU1N26hZ,戴小茹;jTI10DhY,曾文;7HRrCfID,陈瑞安;YcwcrGaa,黄惠践;jA9kfifT,周燕群;nM5CkP4h,金美子;hmOBahpr,肖家财;6eCMZEQH,阙志煌;XyiDbFOy,黄金奖;ZNTew5Ui,黄淑灵;x5Xs5HcI,刘泰宗;EUpLTpFa,符学瑞;eybMwxEp,于越;ptABLD8N,杨惠春;qRJJWcwz,陈丽先;CiKV0glK,詹立鉴;X69tHK9m,李国伟;slbRc7n4,黄金英;kfvMqRbw,谢雪兰;QdXtdl7o,高艳;Go6P8Bjx,阙晓炜;kxdKbRJv,邹婉婷;ycWJD3Pe,范远良;aS8abQoI,邓华秀;Kt6iuQDv,许素航;we66Zl45,田英英;yPZLBOT6,王志远;cneslwLA,陈小飞;TVJBustT,叶静;9z02Cube,黄建平;lsMP8FHf,李宏超;0IMLxB9Q,李强;c9pi6Y1H,戴军;ppSPBHHk,喻奎;TsgCkabA,李菊英;pPBr7fjO,陈国贤;tO7T91Tx,吴思琪;CmusRhrl,肖忠保;UTdIoveg,李米田;EBgsv60q,林诗诗;lBCkDZuU,苏长江;jrerXEhm,涂煌煌;WQEpGvfy,吕丹;Wr4tgOuq,李秀静;v6P7t9M6,崔宁臻;Ozfexz6x,甘海涛;R3AoPeTc,李倩倩;4DTvefS5,王志金;oEPz4Dpq,黄艳芳;K4MIZ2gR,严宗伯;3Qc0E9SE,林俊;6h8ODRH5,柯仲逵;u68pFt9u,阮慧明;d85g5rHY,肖东阳;5C23urTy,周云华;6IwXyZOB,郑枝香;XsjyCe8f,刘敏敏;fbzruoqu,林海松;HQMCx7JJ,李火荣;NoCFQOgk,黄剑;BTEO3fxI,纪景辉;k5ugbpCx,陈芳;IITUW3oK,阳卫红;Tfw1At4y,刘嘉雯;I472sVrQ,袁帅;rvEakWlq,雷秀英;FVqlN6El,朱瑞云;Sy16Ag0B,吴春华;DpYdGjcX,訾成龙;eR39aZuv,魏鸣枝;4f5st9nX,郭俊刚;Ecfuj7Uv,李照刚;hrqMoqCq,李建亚;PpAbcSj0,施锚锚;ywZFrrMA,余珊萍;Tf5hXPci,朱娟华;yyDWkPxF,黄秀英;8UURUHZo,梁胜江;aznpzAqZ,吴帅;WdiIe3DH,陈小珍;JySvAsxD,林周宁;hRlivCMB,王倩;pYzUyP9B,卢宏坤;DbX9J9Ee,高建盛;73vkt89n,蔡真玲;trxPfHfA,钟丽金;YZvRVdrk,简艺娟;x9o3iXmR,田娟绸;80MdMNsZ,张建军;mmlWg96f,陈丽萍;Ge26aZHB,白尕红;6ueJzZiG,万长华;IgLhcxwa,董慧;qsieMvuX,陈学灿;TGlM5EHG,陈咏梅;WK8a5F7x,唐晓东;U45gYYMh,王芳;Fg1KNH33,钟小萍;3EvjH1Mr,蔡萍萍;9cBxYQrW,杨伦基;SteoAXpY,邱淑英;oQYgBJBi,林小玲;YEY69ReU,余馨怡;Q2kZ2TMc,黄丽蓉;yUMogh3B,张丽玲;PhTlLE79,吴贵华;4sPlPBr1,杨巍杰;3GFq4A5q,阮文彬;JW9abqpI,朱文玲;V9wkwVf6,熊彬;raITJFJU,郑艺军;BlCt15PI,付婷;cRMQVvPu,于德忠;y2AuJNdy,刘红梅;kMYqiH8M,陈加欣;79hqh2Cl,邵玉玲;R4sXytJs,刘舒婷;lrejrrBA,林一斌;sdiBQFas,陈仲梅;0CYOIST1,丁丽平;Bd1QzjHf,陈萍;6VasEsgy,刘海燕;bRAdeoTJ,张韶芬;e7xlgzd0,陈文福;2stgPel6,黄培涛;vwn0qSie,李永顺;IrbCWigg,黄登楠;wRK1Gueu,王赟;KEVt5ejv,俞继铭;eXsilc2l,朱玉康;qsoYNiTn,林小妹;fjwWZ0Rc,张圆;vOYw7tfk,陈开桦;Ncf2aKVW,聂丽华;wS3MhtTZ,姚敏敏;wMcUOtPg,黄子汉;XyQbncBM,严立根;cRqnApmc,徐宏;i4NGXid5,林璐瑶;iThzZPAo,林圣杰;GkOFpdb6,徐乐;9wOgSPNJ,聂春梅;4zvV5WjH,李国;VRkslVzw,许登城;bleLBpff,陈永清;Cspdo3Ga,侯玉琴;J2uYQEUn,李波;NKYy3g34,刘毅;vw9zJlRs,温纯纯;la8eHyMS,白志华;ZGTPyKjx,陈霖睿;OvsTEYb9,孙少平;d8rSlOHg,郑志杰;Ja1lQZFw,李小兵;1uagSsZf,曾宪林;yV1hoYfd,何建海;t9sdOOOO,汤住勋;ggLNJ0yF,徐盈盈;ZwRaJBIY,叶晓红;kZW6SM3F,林毅强;vS3atXOg,孙倩;QfECvZwn,曾宝华;3XKR2Jjg,江闽;yfmv1tnF,李小平;idRbyapk,吴坤国;1wvsJkep,彭小云;klTEMT2K,杨美兰;I3D2omuN,段晓兵;jMByDwyC,肖妹灵;zFP5Bvsi,林婷;DdSwHVtP,熊锦萍;mUtK1dlj,林香勤;9ZVZgkWE,梅玲玲;VwZW0fHQ,吴佳容;ekHXbehl,秦建华;1Zgisa9o,邓根秀;yLAcJ01V,傅淑萍;A79p4Lkr,李仙榕;giaTTcKS,吴雅霜;jRxpGxPh,洪绍伟;a3dXOtZA,丁桂兰;duudA6Un,伍星飞;qav9I5gh,胡来琴;veF1GSyg,曹宇峰;DG9gquxN,连碧钦;3vRHbYjA,陈永福;x6RDSdDI,蔡秋月;3rEXAG4e,李菁酶;ry94PLI4,吴玉环;7KwQGP4Y,吕建英;LJPQC1yu,陈明贵;IJZdQipw,张舒怡;DTxsp4eT,蒋雅卿;IFjeT7OJ,许恒韬;7BPd8bwr,钟嫦娥;pWjMMK4r,丁鼎;tmY6RKqK,邹贵生;DNQmaT1O,高子敬;17JtqR90,严文李;aIqatosB,夏雪萍;KAfKY370,李佳玲;CFVtubD4,林俊;GxqKu9HC,郭牡香;B0RRPr0H,曾群;iLaz3rP0,傅秋云;hClFwXuh,陈用辉;ubijRpno,许燕芳;D4yPz6r1,陈诗彤;3NKclSIQ,周建云;IvQz9ayv,胡怀天;VfsvV8Es,林志艺;qinSzBZR,张士强;V8blKxza,邓丽梅;sh3heAjy,吴赞金;zcVEgsS3,张国雄;7nci17wi,刘添贤;sOFitDZN,张诗佳;jfmn2KQw,陈艺红;UzYhlQvh,李艳秋;KKzN3lxR,方素丹;yld8kSv1,林耀佳;xVbe3ehq,黄冰;xIAmYfqD,尤柳青;sKzBNhtr,朱绪章;DYhiliYg,朱震;DL8MBXfi,李新仁;hxUMyKuS,吴磷辉;BBA0AVqB,沈志锋;XDJUvwer,刘文林;cRdOF7yn,陈锦坤;QZp3vVg4,吴志刚;mYRLwYXb,施宇锋;eNXYuqgP,郑桂丽;aJ5qfBwT,李光阳;eOcg23rG,吴敏;y7P4PwSM,陈玲玲;nsb9LB6M,刘栩屹;aHLEPikN,刘梅;JIiTaB96,戴乐平;vX9AWuDW,王雪贵;8AirsFfm,林晓菲;tlKapTIp,杜五丽;JL6s2C51,赖晓梅;CijEbLH8,邹和军;Nj2eMzKl,林清莹;2wDImUO8,叶文杰;ohcPuWH6,陈赛梅;SyxCuQs2,黄文英;lhOPBKMH,赵华月;nezkmyuV,吴焕;Az6zUqKk,李艳春;2mj3v0Tq,徐敏;oYy8OIqQ,田荣妹;6WLYC4h5,沈恩萍;tDWoP1Xx,陈春山;TOS9eGgG,王洪刚;6wxUcb1B,洪丽霞;qO1ccSfc,甘武勇;2dI0wK0l,王智;oCzt9W8K,林小连;i5wsxIwp,陈子涵;TzVbSUOz,周火保;JgfkRVmy,陈秀云;j10Z2OAj,出淑端;Dat6SG5R,欧阳秋收;R2PXdM3K,林碧华;f1vRvtMg,张健;M9w0Rmre,胡栋才;5iGRmTkz,柯建忠;oFqNFXIt,田洪雨;tzHMzoqq,朱健;fWMF1pkt,朱丽荣;n3kmYgxo,杨毅清;LFx8zY0C,吴江毅;H54Zkl3h,傅艺芳;55rKXaYk,陈玉红;BMHqEDfL,彭丽华;H8ppT32S,艾瑞儿;eqg4fv37,庄子川;HkBYNAEP,郭清辉;VCcCtSVm,赖庆彬;qTzCNrTk,林凤英;1BZ2CRQT,陈冬琳;sROtCAmZ,张紫芬;0tphmlED,林启雄;PIjYcC7y,王福娇;cE2sE6iQ,邓丽娟;UjNyl85S,李波;iq3ymkwh,郑碧仙;LNAdmlXF,刘芬;TK59YINz,邱井香;YIkKEP8b,杨湘蓉;NjdD5wXu,戴春生;oYvgpn4b,徐忠凯;sh5a6vLA,方细凯;7wdVaRKM,舒银娥;k9nLJUYU,叶郑艺芸;kpVBPyFI,方志雄;3lSqphzo,周森林;B8j6mc1T,吴佩;7hNgFTk5,刘志辉;bPi1k3mM,陈世添;o9z2Gs6z,汤爱青;2HAJ48pI,冯青;WiXciwjE,叶芳;IV5UOCag,张振海;zI0x0U4F,张娟;Sha8oSjy,黄联庆;8ChrVh0S,林长成;TKt55vnw,谢丽琴;qxrlGtSQ,郑志明;Ev72Gi55,梁旭容;v73xbz2p,吴盛发;7mSzoeWk,林军福;zQNhHVdV,范春秀;3m4N09xD,周广华;j7WVap2F,蓝建勤;AgVNjd2i,曹远海;2UBsutda,李海玉;E7ZfqyAf,伍佰东;YmG1kASy,李燕;ON1Oh9fh,林晓毅;Anfy5bbr,陈天水;FphbXMaS,侯双明;sQPhBRlN,施芳梅;C3B1G7rN,叶丽;ecKMOxv3,王碧华;2xXBVOLd,张端莲;N3ipPmVk,郑小春;oqHejYvL,黄胜海;sY4aSb2p,吴敏玲;MsYxxLNJ,方芳;We1WAxhr,邵元超;BJEPTXeO,方天东;lDz7eQub,陈秀云;xAG4U5Pz,林丽宽;FgtoLTPj,吴声飘;F9OUJxYy,杨娟娟;hb2VWwE6,胡恩琪;RdPWWFGC,余建辉;gMq8l2Ha,李菊;w1g3uviX,林娟娟;NS1j5EZB,洪燕;XAwDtR4I,李妍;pZ0dwDrV,梁红星;9OAiJiLC,吴世瑶;TzzAMshf,范四锋;26pzxV8E,黎鸿诣;QPiIKddZ,黄树生;GizQbJNT,张秀春;fuRtj9LR,王石妹;IfJMlDeH,夏勇;AkjAbeQ3,罗甜;o18wNS5N,朱红梅;I08i9DBF,许丽萍;Zn96FbfY,胡荣樟;A5xE3jbu,谢春绵;zVNa3eyN,侯松建;c3fNVC5Q,黄春生;B4Dik7QP,陈少燕;PhzywjX7,林清莹;QnAQTp3X,李莉;8X8t6uHV,陈瑾;GoaYIXbZ,代丽萍;RzVSvbQe,饶官群;f5nQOPfQ,李春玉;N6Tvx2XV,林亚梅;fOGUuSp2,苏炳山;hzOWvOZL,束江涛;wpVVdA5t,方娇;8D9cjqi4,赵芳;BCAtbB8k,卓仙花;lJyZyxZE,尹小红;9k7LQlHv,李承希;hYRH86xN,陈武镜;48h3gtU3,张幼兰;keS79b4g,侯宇君;Zc1VbDgh,曾诗雄;FyjyEvll,谭继群;MZ9qyEqt,蔡一豪;zDWQEuR0,戴志强;a8e4dTXi,帅紫文;ZI8TjanM,许彩敏;f09SEEjC,常建超;enyqh9pz,邓火根;LntulUgQ,彭上华;MABl3yKW,张叶庭;X9AkHKK0,刘凤鸣;JfOhCBtz,毕忠香;0fuXjnOg,刘明辉;AsvTKvte,钟和生;VD50EwfP,吴美金;w6R4ud6y,邢驷;PdZ5eBVN,黄立杰;ECkLXXnj,温才明;yhKFfVT5,李美玉;CPSRhNLA,江曦情;dRjpQe7t,章冰;CzG2CT4W,高燕挥;sfonb5vH,乔兵;3sELETDc,尤明凯;OX9POO7C,何育才;0UQx7K34,叶茂英;36hkffWN,陈文其;2GXnNSU3,叶小春;3gUfnAV6,鲁艳平;35PtQflS,胡玉琴;sXdbDF6i,朱家彬;oVyvWJCc,谢显招;u8SeWoq2,邹美儿;OFffKPgA,沈岚青;aHEtmapa,赖春连;7ifYHdfz,廖惠珠;z2VndWyQ,胡治国;Y5Sjn3iS,郑玉琼;PNU0EQED,洪彬彬;P1xeQwwl,沈海鹭;YsWpXlce,张志发;3fJXUhei,蔡旭娜;cK8IqCXx,张海燕;pZm1K4BV,程水平;R4zBqrWd,王亚男;R1Irrlgt,高婧娴;WEuPOvNN,舒孟琴;gWCtBjqF,林美阳;1uRrUPrY,陈国正;vNbqkV8M,邓春华;ojyOdgGk,张小明;HQzMUuQm,张香梅;kn6XA6Io,付饶;JIB6F6iO,郭玉红;aXI5sdH1,李建;bJvvzjsU,郭齐取;rH5JPrhN,曾庆丰;LtZt54BC,黎玉香;uKoM82bM,黄春华;Oc9xoBbz,徐淑红;BDlMDa6E,蔡晓芳;q45gnTa4,温国花;IVLe8MoK,刘瑞凡;rjXJZ3yH,耿显朋;KkXofuNA,吴冬颖;FqHITXzL,张文建;V94o867b,谢嘉炜;9mRojF8I,郑永滨;x1lU2wFs,黄毅娜;c3m1HkbV,罗莉媛;Z9AG1cZ0,陈杏芳;GCJXi7bC,黄振兴;6XKc10kY,李向阳;V3ynJwwZ,王宝爱;25hf33Sf,李成伟;SuWPJ7Vy,王巧荣;xRXRhhTU,莫昌熹;XuiDO90y,郭大表;UAwYp65P,庄丽娜;zDZmgth5,陈小琴;DGWoZzxX,李耀超;iV0D6PF9,周毅;1wKt2PJA,陈万发;b3XTZMPV,刘青女;ESfONBCg,刘永谅;4hA7OGoP,张琦;ITvX4y7a,刘丹珍;m8hGLmFf,吴晓灵;JjnneZXx,宋翠凤;4ZWuAvn6,董宏英;cbMWK38Z,李雪群;SVJlJOkK,林东旭;LOmjtKlu,徐鸿维;siGIT90v,温露鑫;WURrVmgw,沈建梅;Le3Wy4wy,王继奎;Pq4Kl9rv,韩爱平;oXFZ2t5Z,蒋晓妹;NwHMzeHi,程加聪;bJdZhpZq,章建国;KT4YriPh,陈玉坤;zn7Oyrvo,骆明鑫;LAmy6fQx,高春芳;PZd3vaJg,吴萍琴;4tblv2VY,李碧梅;45cbJVTx,罗景胤;eSgNzQDa,孟勇;tAjyhtin,黄俊高;5j76xXp9,黄玮玮;9F2Q4Do1,丁勇;VLYtwhr9,谢雪花;ehrOAsHI,姚燕红;wuvKkUIF,何奕验;UZ5nW1M3,柯燕山;6d9QVCET,蒋黎欣;GX0qLX6y,董巧云;ESfGILnB,曾春梅;lJcZ7tfY,贾妮;sF0IB2gs,裴荣仙;Jk7gm4Tj,陈海滨;PXpKCslp,廖杭发;cKlJxxLy,邓志峰;ZGJmQPiK,章淑惠;rL6ReI98,黄冬梅;NlZqAuOn,邵长武;15PzslqH,陈惠琴;orPgUzHM,足斯满;7RM0Vz22,陈宇东;edRiFfXx,李佳伟;ow7dBFqy,林柏松;1v15Nf1H,潘美宝;TDtf2pfF,林华春;pla2xEzN,林少华;PZCoJNsP,王黎霞;DKSoohAu,余家雁;7I1Z3tUt,叶嘉辉;v5aqRn03,曹新颖;CRVOv0Wj,张凤玲;uCN9XeLT,杨小丹;p3n85XQd,陈智群;7tsMFsl4,葛锦添;OSnayGgX,范雄群;FHRIzj09,赵美华;NJruinTE,黄亮;H2XSOCE1,陈舒柠;qgsiOrYK,林文忠;w3ok9fWM,吴建集;Gw7uLtZw,郭剑敏;9NCuMPfJ,黄国文;SNNXiYEX,陈岳彬;0Q2SnrKb,祝艳;Gp4N2cij,黄三容;vo87tywh,张园园;HTt4E41C,林晓虹;bAkBsBiA,黄彩莲;DVOedQtu,方永生;aJN9NoTM,杜开鑫;lvgCeoEN,李方剑;bb891bLr,尤景宗;IFhXAVmH,孙俊彥;cBPaOARY,王燕清;IV64FFbC,张家欣;ze6OiKuk,韩腾福;fvIpkJjf,张翔;u4gHZpXw,周鸿锟;KeaKlMkH,郑定强;Qw1Y9by9,王洛;jPULxNhN,吴洋璟;qj9LpNG5,尤粒吉;tXgjP2eZ,王海燕;ejTMhuPp,陈海歌;r7yFfr4I,张美凤;DCNLmqjt,傅智洺;VKOUsMzu,杜钰欣;u5nmz3Uy,林娟;FxG2FdtW,朱园;aMmmjBTB,王晓明;8qq3Ube3,刘素敏;NaTCjPnB,颜明艺;vg0wiZJ3,田岩岩;OdAmxb7b,周立松;0Z0pio0Z,张金刚;DrFPRBiT,黄木桂;TJIJXyBU,蔡惠芬;oQAnPG0v,林春兰;XjjEQKL9,陈平;r29xb3JU,张亚松;Mlna2LlF,张锡平;4ARu1NRS,廖巨川;tvkJm1Di,姜明姬;sqEujZMk,卢子炀;kUMSztwK,方小俊;mxsC9KTl,陈小莲;4rHGinXK,徐友群;Qe1DNfUi,张国珍;IDpWyvJF,路锋;FDZVttpn,刘建清;0drokoFi,王欣;MtCaOtbR,王淼宁;MyiRYm1Y,林国军;3bIQLDor,牛红萍;5Ah2gBkf,唐金龙;aIqy1x9m,朱星宇;4i4WnpLO,黄志钦;Rmu5ugDa,周益;Gh8JMpx4,周清;TnhByHAu,李镇;cNeYtuJS,符程宇;PfD0DK3r,韩恩典;fBvmSuaW,刘亚兰;cAZROZZY,尤文进;YJmzNuJa,李蔚萍;G9HzB08c,程毅娜;ceVtsmBH,林琪表;sKdkRV6X,苏春萍;3493pgy8,尤源臻;XmQcLEXZ,罗扬;Rqlk3Guu,欧天宝;qgLW3HCE,何凤霞;SF9fQJTE,商治涛;la8l6EOW,张潇洒;bZIMPATC,吴志强;LhdnnRrv,黄坤钰;r9qYV4ji,侯好雪;FsUDua0d,王有成;c4KQvTiR,陈惠芳;KA3h3Kxu,庄婷彬;uCZeRIkh,薛艳玲;jOaoX9Ca,王振红;YqkcqYgv,沈思琳;gRBg6b1D,徐建英;zHqJGiAj,蔡宏梅;u6qWru4j,尹博豪;1Vw2T8Ch,吴成霞;VwVs3Hel,林美秀;eulUWgZ1,詹燕;uMqculjQ,陈志浩;JU2sBFjy,王潇;OTkz4EZC,杨镒;HkD2hrMN,黄思朴;woHNOJ4O,翁钰涵;rt9o6Jtw,何艺娇;HZfs7LFQ,陈月梅;eGwYAVr9,褚玉榕;RZNnIRYw,林俊杰;2WkrQAk7,李凤玉;QcfVB6Op,林旭;eqehYa6z,吴端表;Hrt5VaDQ,原玉芹;RCW083QU,傅明炎;LxlJALot,徐健;NGfSPHA3,刘涛;MJxfkxER,陈顺吉;Jv8EHThV,陈萍霞;v8txJYDb,李隆;1Yw9LzDL,王丽燕;yx6loAk4,李凤莲;e8aNzes9,陈振达;aiMtmuV7,李和琼;jFzg5JGT,胡鹏飞;8i9TaS3H,王风国;WNe3Cxkg,罗荣根;LxHmhHlg,张正昊;N0rFnzUq,黄晓鹭;J9WjyAis,温建新;o4P8RPgj,林漫萱;Ekgisb7I,郑剑锋;qTt94kHB,蔡俊杰;CKCnKXlu,庄芩;uSo9gxpZ,吴雅玲;Ltlj2cqP,杨勇;INYeBLlx,柯小凤;n2TWfDG6,叶鹭波;rxChE7XT,施秋林;4N5c12f9,余联俏;023L8UT8,文光兵;4TClKveh,陈佳馨;Ysc6yPQK,蔡明阳;4fDzF0xp,陈惠蓉;a7RKUQJC,林郁;PBTYdA3z,苏美娜;HQiODSNz,魏秀红;fncwsDOH,武雯雯;sxfvvocs,孙徽;MGaq9Bfj,商苏丹;d1Rd8RFM,甘荣杰;HQxCpB0i,黄乌金;ggKZO2yx,叶伟群;yXZZ6vvT,杨秋金;0tiz4sQo,沈雅玲;hZmo2KwN,罗良建;w00UNEM5,张钰涵;sBxwRKrJ,刘扬喜;JP1KfZdT,封文祥;tka679xX,康再兴;BzZafUcQ,尤长枞;T87rih1H,汪腊枚;fpJCNrx2,陈庆发;VFpsPvQ6,陈丽珍;gObRkMaN,祝于芝;BW2x7jcl,王斌;P8ZPTwYe,沈炜聪;Y8HuxoKA,陈龙娥;9jqJx3mV,李永波;ubMHl0wr,李慕楠;8vyix8PZ,林秀惠;9aKoM2s6,谌琳;fWDWb1qg,陈潘静宜;fqX8xyxU,高翔宇;TjRH09sq,李碧月;SrRNyrCN,王奎;gDXwLqRg,蔡泉泉;rcs22myC,黄勤伟;Qz8kCX2x,吴晓东;9vxn3ex0,庄鸿清;F2B3EQRy,汪惠波;9D4YMRqI,李幼丽;kbAKwA2E,胡尧;cZjB6wbs,邓隆珍;7bexEDh4,陈泽龙;XIr2LdVS,林文全;9bN4Jm6z,涂育琛;lqkK1OzP,郑晓萍;O2svM4Xx,康臻煜;t87Exdtf,赖新财;xjVuLTZp,祝钰;POMzaJbw,许信宗;CVxCv7ZL,程超颖;77iXBy2T,王厂;9fTkbXdW,曾似锦;onVvjcC1,张书杭;xoZVN5Ow,郑银花;ksHUauxM,叶丽香;ulKLgtEx,陈德福;VCIZC6hr,王艺璇;EWZZfgvp,王慧;GitLHo6m,陈清名;T0qhOcE3,陈福澎;Zj9KC9qY,罗小乐;fWRvqidS,李少杰;rUySj1Ib,李宗松;3uVF0Q4j,仲锐阳;lygmk8Pe,何早生;5N3Fr2Rc,陈国琳;z39igdvH,陈杨洋;JPYQNlxD,张志航;zr3RbNKa,刘小平;8hD2VYUH,聂奇珍;TkcnCzSl,谢玛琍;9FAXog6k,赖宝娇;TdtmrKEa,江娈;oNgZNVBS,陈健;mmG07BWj,江金宇;onOBRLlR,徐进;v8lVnKpw,陈小艳;0a9kadpx,林清梅;47b8KajY,童祥添;7Ifev7kM,彭娟;Rct0RgAE,陈茜;Tla0mIZZ,高美丽;j3hFsFS2,沈赞扬;fl8LtNl7,谭国明;k1zff76q,罗霄;ddDqk7Xt,范臣敏;juifuvai,周思政;GX3tOvih,李小玲;cpKLpJeu,吴福龙;hDk7vaqs,严娥;Xdc9sSDn,许峻榕;1LNXtqwX,张海红;0jgNNOQm,卢爱凤;q2PJ9i6D,吴翠娥;exF9tlwP,吴瑞腾;ZugjBYAX,赖瑞珠;Md66xUwo,姚嘉新;jf63agS4,何晓杰;gFkyCgrF,陈凡英;bByikx1x,林松青;NCF8E9Ew,黄丽娟;yGRAOzf6,洪思勇;PscUefN1,黄思涵;5tdkpYwv,黄丽均;NYj2JJ96,刘凤宝;994J0ko5,刘玉梅;fUnmcGMZ,黄龙芳;BTDmfwLt,杨琴;geRv8yGU,何江锋;A9apTZ6N,林海英;NF9ya5gH,陈勇;tsJHMhLz,吴小兰;SCnRf6e9,钟沸;KR0QR57t,伊良梅;czM21cqF,梁喜雪;6ZilkhAm,钟微;qZhjmjWd,王争会;JGDWkRQg,庄舒婉;mz2SbLi3,林倪明;B9Ou9TYp,苏雅真;xTi03B8M,林丽香;OMleHvVo,林凤辉;1efp1fhW,蔡达云;kFEi6Xh8,林秋碧;XrklykjO,林仁仔;c73Mi1H3,饶晓虹;J9JUseV2,吴爱英;bANqQxJZ,李玲;7fB4TcQt,邓加爱;LqF7b0F3,钟双红;FIlb8vtT,林丽娜;b98iZsz4,乔玲;OJZdCZSH,张凡;7rpLwoj4,罗晓敏;87N6qO3o,宋迎祥;08oVDf3k,黄燕华;GcneFN2g,曹莉;aWyOUKtE,蒋维富;0nSmzOIQ,李双红;SOYaaybX,赵斐;7bzAHncF,宋长发;NZ9ZqZeR,贾鹏;Af7sACqy,游明华;58AHCdFX,关紫风;hFtFMAgP,高佳会;JWRrqszQ,张晓;crW0n8yy,刘德标;KkyCPqVc,王圣军;DHl5rGP3,陈素华;hTlMC6Ny,杨朝燕;8pan3fCd,凌永灵;zwVCd9Z3,耿宇;d9QGl3uU,杨金梅;qQzZm1Fo,张清翠;dZECTXck,徐敏;sKoiFKSn,杜利;f4m6j0c5,杨建峰;nOGCBQBx,陈敏;wO7GtLrg,张友福;8uvam4d6,郭心如;LaLRIwBr,林燕风;d4sJKyrm,冯喜鸿;nU9a7iVZ,谢廷漳;EoAkhHHW,周琳;tueP8Zat,秦国;5WacSkZc,余黔鹭;ElakjTmP,陈伟;HDIE00Ig,吴伟伟;ubRJepyH,陈阳平;6kBC0oC3,陈喆;HXpAkjYH,张忠艳;FatcQ64G,黄惠琼;FSEzBtba,邢丙瑞;ArazoLN3,黎晶;MaGcxnym,夏绪琼;rdKNm0IN,马翠锋;APzob4y5,陈惠雪;qMmDn8ui,陈杰;9HoXLiLi,高征;1H7HiLhU,温根水;roaaTrpn,乔玲;9ilh8cbp,王丽云;1gtaCHqy,黄张悦;l68v1ct5,余学金;FgIwZ2b5,郭依晴;ialMYSol,叶加凤;P4zGyNyW,张秋燕;bV1IVhxp,许玉芬;8kQnD9Ij,王贵鹏;8zHXWRIp,相福清;vzGVZ0FE,龚珍;blvzhkTd,陈晓倩;18JIQHGm,李丽芬;BL7dVQYU,邱石杰;My4MYWPj,柳春梅;RkGhDOvo,陈雪英;EN5Gm3FF,许宗辉;4GS3FRQn,陈顺昌;EMEPAFdm,张永平;0JzJDUvA,肖李方;IpBPqjks,刘涵;pcMYopWA,黄泓明;eUi3mtj5,朱焕英;utaSlk07,冯亚成;6n1WDAbY,张艳泽;CfBtjJu5,苑霞;Go42TYKa,曾国华;1ARNaXky,蔡怡婧;RoMmkaCA,林梅连;iprug7kX,罗仁海;afikVMAJ,李开芸;rvCfUYY6,黄森;umBMJDCU,蔡惠丽;Afjc4mw0,凤培轩;n9i2PbEY,石颜;WITW806E,黄坤斌;aETfhHVZ,胡勇;nIqqrx0U,吴茂琴;0IuABln8,周欢;xlEbvhIn,潘岁将;wOHqmXhy,童巧玲;knEzJHCS,熊德奎;uLRpqrf4,赵凤美;lfDsMBR0,尹忠鸥;dAIo3Cja,张里欢;difcbWma,刘子亮;IQYNenRk,张丁丁;yrCIy7VJ,郑尾宝;dwb3Myw3,赖作权;Rrhhp6CF,陈凯燕;pqAuKGf2,古洪;E5tT0Q9a,赖宝琴;uMsLzcuq,陈炜;u76TmTPQ,蒋金渌;1BGN3jmS,郑丽青;HMrTWLeH,鲁道信;DhTzQzPV,黄小玉;I0XEFDYv,魏玮;GI4p9LDd,黄小玲;Zh6tJoxe,陈赐福;uDbi8nLf,李泰然;0vVMTZ9e,吴祥娟;Dz32zn4x,郑奇奇;BwYYRloH,肖小斌;0J7K7VAs,沈美霞;xaFJknI7,陈小文;C3axw8gx,魏晓芳;T0quGVix,陈月珍;SZt1ZNLe,戴玉招;HfJBuu7n,袁丽莹;pJ5uJORA,孙寒;mVXZ1Uxi,官麟;HRobOqqC,倪少宝;mRu0iQd8,刘园;vvNjopVc,林亚梅;gBzp5chG,黄志琴;2mwbV8lp,赖爱芬;p51ae0Fb,潘雪映;y3BFZv6M,彭秀光;E1kfYVap,吴强;G9d7Wdkt,王萍萍;CsOGY8as,朱百香;mt74FBZq,卢熠梅;X7QpCv46,王晓萍;iIAmkp2b,黄国伟;Ve8bGlZl,陈立;GWabVZQx,吴荣臻;dBf2DfHX,严雪强;UtLKCCuO,陈红英;3Y45ZISI,计光划;Xxva0DoE,洪微;jtyj2rW3,吴国洪;Zt3lKrxC,蒋敏;vpenJPGG,李勇珠;nGHHQwiw,张丽珠;f2iF4fTo,欧阳佳兴;042WQQ74,范彬;YDENHQJ0,胡哲;cSOUceCj,陈晓明;dKt3dqb9,马旭英;kSV0nBA4,刘启宇;rwa4F5oZ,林雯蓉;crZGFCJk,苏素玉;VN1uUarg,郝天真;r3F0WjV8,唐波;0BijSrrQ,林杰雄;twQwPONR,田雪梅;OKRDDB0Y,覃发均;0XRUDrnz,邵玉会;rrNha9ww,郑明珍;edxsfe8l,崔彩林;qwPEHAfQ,孟玉清;J2uXuO0S,邹加珍;u8MNfgQa,宋清玉;NvKeSBpS,李学聪;xleR6ik5,罗贤敏;HClqUnOa,袁秀台;meUMQrG6,朱俊超;dO4K7zat,白燕红;JEerxFL6,杨秀英;MY1hgF2e,程海莉;JIeSHQxf,余思豫;0iz2c9OQ,龚晓萍;kQpgaC7G,薛子军;bEscC4do,石艺月;zmxjpSJy,何天泉;nw5C9lY7,张龙辉;WmsBYwYn,柯诗雅;vBtMVCk0,陈志尚;KZR1KVi6,黄志文;0EbJt1tC,马国熠;X1EvmhuG,连广贡;uL9Hv9Xx,张勤;xwcAfU1Z,刘斌;xLE88s1N,黄永霞;BnrHUHus,徐雅芬;zxxSvHYH,胡小妮;MSUg9B5G,李观;MuvL2QmY,王清芬;YefCD8Q3,曹银辉;VTnWe3P9,杨位尚;tb5RHXFI,叶衍钦;DsxeVoHW,杨泰红;2scKLsFU,黄育亭;kNpGC8FB,龙伟;1d2XWhNh,杨春桂;wz1rzJUW,卢衍虹;TMwOP7U7,柯华女;CeELHNKY,庄建东;18030278015,林梅香;18559681023,邵帅;4kchjtXO,万丽丽;hpDiCn00,丘福汀;yUnkWnd0,侯德扬;HiIBQyKr,张佑连;wiJJVeQM,陈少芳;wqEqrgYP,李丽金;yMTOuE5u,李志东;M3nMjSHV,陈久珍;NPYOSXFC,罗楠;yaWEt4sJ,刘裕峰;SO3kuIei,刘思佳;dgm4TpdQ,赖崇文;Xg8xPnzO,卢增雄;K1Svzt01,徐健霖;flXy3eRd,郑豪;MnnNAOOO,黄纯纯;oFvRIVx9,郑思睿;7EW5TICi,章进炫;fW2NIt3x,邱建华;JrFgYoMy,戴清宁;bPqV1JPJ,陈添勇;hopUEhn2,张井明;83qSySTs,杨家梁;zAjNDuit,谢晓玲;5XIFREAb,黄淑琼;qy05rWVJ,宋军;G5M9LHvT,肖薇;F7xNOgsF,王艳辉;TBlkLVYE,方君;bm8dyjFm,杨光波;BzCNiOn2,高海霞;e5Fe9pjL,沈舒铭;REj2W845,厉梦月;WjIFxmyw,沈雪珍;ghNRBUco,赖锦洲;1nsSFQ3x,杨慧敏;jWuM1bSF,陈小钰;vMIlR1j6,王冬梅;ZshA1qgN,王文怡;U9sX1MBZ,林枫萍;cQk9KUAm,蔡燕琳;zH18yoq8,易娟;26n7OwPn,张莺;zM2x149R,范淑萍;4PxNr4NJ,李立新;ZRuTObtE,厉梦月;Mew3HEeu,周惠卿;pYKUmSGd,王玉梅;3FK2MpWX,蓝钰如;klR027hB,胡叶美;9doS2BYQ,黄燕青;O0rgzwOB,庄苏琴;dppzT2v0,刘俊锋;WnfdOiXQ,吴炳金;nzVEM05u,郑清娥;WPjYHMZG,石永其;5ZTTuFfj,严家勤;etS13lY3,曾晓非;M4f41Eet,彭忠华;1HJ0Pm3w,陈琳鸿;lTxdGKKV,李代兵;sqVIKxP5,李水先;zsy7Uorj,李艳;5V5bNbkb,许丽春;TANNrchY,熊旺;YVlje81d,邹佳玲;p23MrlgT,胡泽华;iPf0WTvt,连绍商;w93atWmo,杨梅秀;O2h1rGjC";
//        String[] arrays = a.split(",");
//        String[] arr;String urli;
//        for (String str : arrays) {
//            arr = str.split(";");
//            urli = "http://identify.bcxin.com.cn/identify/api/tencent/get-tencent-sig?name="+arr[0]+"&mobilePhone="+arr[1];
//            System.out.println(urli+"  --- >  "+HttpUtils.doGet(urli, Lists.newArrayList()));
//        }
//        System.out.println("------------ end");
//    }

    /**
     * <b> 腾讯IM设置登陆用户资料 </b>
     * @author ZXF
     * @create 2021/01/30 0030 10:33
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/create-im-portrait")
    @ResponseBody
    public Result createImPortrait(HttpServletRequest request) {
        String name = request.getParameter("name");
        String mobilePhone = request.getParameter("mobilePhone");
        String photoUrl = request.getParameter("photoUrl");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/create-im-portrait】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("name",name);
        params.put("mobilePhone",mobilePhone);
        params.put("photoUrl",photoUrl);
        if (StrUtil.isEmpty(params.get("name"))
                || StrUtil.isEmpty(params.get("mobilePhone"))
                || StrUtil.isEmpty(params.get("photoUrl"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/create-im-portrait】腾讯IM设置登陆用户资料对流程开始。");
        Result result = tencentIMService.createImPortrait(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/create-im-portrait】腾讯IM设置登陆用户资料对流程结束。");
        return result;
    }


    /**
     * <b> 腾讯IM查询单聊消息 </b>
     * @author ZXF
     * @create 2021/11/22 0022 13:36
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-im-roammsg")
    @ResponseBody
    public Result getImRoammsg(HttpServletRequest request) {
        String fromAccount = request.getParameter("fromAccount");
        String toAccount = request.getParameter("toAccount");
        String keyword = request.getParameter("keyword");
        String pcNo = request.getParameter("pcNo");
        String pageSize = request.getParameter("pageSize");
        String pageNumber = request.getParameter("pageNumber");
        if(StringUtil.isEmpty(pcNo)){
            pageSize = "1";
            pageNumber = "100";
        }
        Map<String,String> params = Maps.newHashMap();
        params.put("fromAccount",fromAccount);
        params.put("toAccount",toAccount);
        params.put("keyword",keyword);
        params.put("pcNo",pcNo);
        params.put("pageSize",pageSize);
        params.put("pageNumber",pageNumber);

        if (StrUtil.isEmpty(params.get("fromAccount"))
                || StrUtil.isEmpty(params.get("toAccount"))
                || StrUtil.isEmpty(params.get("keyword"))
        ) {
            return Result.fail("参数不完整");
        }
        if(StringUtil.isNotEmpty(pcNo)&&(StrUtil.isEmpty(params.get("pageSize")) || StrUtil.isEmpty(params.get("pageNumber")))){
            return Result.fail("分页参数不能为空");
        }
        log.debug("接口【/identify/api/tencent/get-im-roammsg】腾讯IM查询单聊消息流程开始。");
        Result result = tencentIMService.getImRoammsg(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/get-im-roammsg】腾讯IM查询单聊消息流程结束。");
        return result;
    }

    /**
     * <b> 腾讯IM圈定范围建群 </b>
     * @author ZXF
     * @create 2021/01/30 0030 10:33
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/scope-im-create-group")
    @ResponseBody
    public Result scopeImCreateGroup(HttpServletRequest request) {
        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/scope-im-create-group】token:"+token);
        Claims claims;
        try {
            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
        } catch (Exception e) {
            return Result.fail("秘钥不对，解密失败");
        }
        String subject = claims.getSubject();
        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });

        if (StrUtil.isEmpty(params.get("members"))
                || StrUtil.isEmpty(params.get("groupName"))
                || StrUtil.isEmpty(params.get("groupType"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/scope-im-create-group】腾讯IM圈定范围建群对流程开始。");
        Result result = tencentIMService.scopeImCreateGroup(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/scope-im-create-group】腾讯IM圈定范围建群对流程结束。");
        return result;
    }

    /**
     * <b> 腾讯IM解散音视频房间 </b>
     * @author ZXF
     * @create 2021/01/30 0030 10:33
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/trtc-video-room")
    @ResponseBody
    public Result trtcVideoRoom(HttpServletRequest request) {
        String roomNo = request.getParameter("roomNo");
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/trtc-video-room】roomNo:"+roomNo);
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        if (StrUtil.isEmpty(params.get("roomNo"))
//                || StrUtil.isEmpty(params.get("region"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/trtc-video-room】腾讯IM解散音视频房间对流程开始。");
        Result result = tencentIMService.trtcVideoRoom(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/trtc-video-room】腾讯IM解散音视频房间对流程结束。");
        return result;
    }

    /**
     * <b> 推送音视频房间号给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "send-video-room-msg")
    @ResponseBody
    public Result sendVideoRoomMsg(HttpServletRequest request) {
        String roomNo = request.getParameter("RoomNo");
        String memberList = request.getParameter("MemberList");
        String useList = request.getParameter("UseList");
        String comId = request.getParameter("ComId");
        String Yardman_Name = request.getParameter("Yardman_Name");
        String Yardman_Task_Name = request.getParameter("Yardman_Task_Name");
        String Yardman_Type = request.getParameter("Yardman_Type");//Yardman_Type 1:视频调度；2：视频上拉
        String originator = request.getParameter("Originator");
        String transcriber = request.getParameter("Transcriber");
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/send-video-room-msg】roomNo:"+roomNo);
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        params.put("memberList",memberList);
        params.put("useList",useList);
        params.put("comId",comId);
        params.put("Yardman_Name",Yardman_Name);
        params.put("Yardman_Task_Name",Yardman_Task_Name);
        params.put("Yardman_Type",Yardman_Type);
        params.put("originator",originator);
        params.put("transcriber",transcriber);
        if (StrUtil.isEmpty(params.get("roomNo"))
                || StrUtil.isEmpty(params.get("comId"))
                || StrUtil.isEmpty(params.get("memberList"))
                || StrUtil.isEmpty(params.get("useList"))
                || StrUtil.isEmpty(params.get("Yardman_Name"))
                || StrUtil.isEmpty(params.get("Yardman_Type"))
                || StrUtil.isEmpty(params.get("Yardman_Task_Name"))
                || StrUtil.isEmpty(params.get("originator"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/send-video-room-msg】推送音视频房间号给指定人员。");
        Result result = tencentIMService.sendVideoRoomMsg(new HashMap<>(params));
//        Result result = tencentIMService.sendVideoRoomMsgToUni2(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/send-video-room-msg】推送音视频房间号给指定人员。");
        return result;
    }

    /**
     * <b> (调用uni2.0推送)推送音视频房间号给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "send-video-room-msg-to-uni2")
    @ResponseBody
    public Result sendVideoRoomMsgToUni2(HttpServletRequest request) {
        String roomNo = request.getParameter("RoomNo");
        String memberList = request.getParameter("MemberList");
        String useList = request.getParameter("UseList");
        String comId = request.getParameter("ComId");
        String Yardman_Name = request.getParameter("Yardman_Name");
        String Yardman_Task_Name = request.getParameter("Yardman_Task_Name");
        String Yardman_Type = request.getParameter("Yardman_Type");//Yardman_Type 1:视频调度；2：视频上拉
        String originator = request.getParameter("Originator");
        String transcriber = request.getParameter("Transcriber");
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/send-video-room-msg】roomNo:"+roomNo);
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        params.put("memberList",memberList);
        params.put("useList",useList);
        params.put("comId",comId);
        params.put("Yardman_Name",Yardman_Name);
        params.put("Yardman_Task_Name",Yardman_Task_Name);
        params.put("Yardman_Type",Yardman_Type);
        params.put("originator",originator);
        params.put("transcriber",transcriber);
        if (StrUtil.isEmpty(params.get("roomNo"))
                || StrUtil.isEmpty(params.get("comId"))
                || StrUtil.isEmpty(params.get("memberList"))
                || StrUtil.isEmpty(params.get("useList"))
                || StrUtil.isEmpty(params.get("Yardman_Name"))
                || StrUtil.isEmpty(params.get("Yardman_Type"))
                || StrUtil.isEmpty(params.get("Yardman_Task_Name"))
                || StrUtil.isEmpty(params.get("originator"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/send-video-room-msg】推送音视频房间号给指定人员。");
        Result result = tencentIMService.sendVideoRoomMsgToUni2(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/send-video-room-msg】推送音视频房间号给指定人员。");
        return result;
    }

    /**
     * <b> 通过uni2.0方式推送消息给指定人员（支持鸿蒙） </b>
     * @author ZXF
     * @create 2024/12/02 0002 16:32
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "send-video-msg-by-uni2")
    @ResponseBody
    public Result sendVideoMsgByUni2(HttpServletRequest request,@RequestBody PushUni2DTO pushUni2DTO) {
        log.debug("接口【/identify/api/tencent/send-video-msg-by-uni2】通过uni2.0方式推送消息给指定人员（支持鸿蒙）.pushUni2DTO:"+JSON.toJSONString(pushUni2DTO));
        if (StrUtil.isEmpty(pushUni2DTO.getContent())
                || StrUtil.isEmpty(pushUni2DTO.getTitle())
                || pushUni2DTO.getClientids()==null
        ) {
            return Result.fail("参数不完整");
        }
        Result result = tencentIMService.sendVideoMsgByUni2(pushUni2DTO);
        log.debug("接口【/identify/api/tencent/send-video-msg-by-uni2】通过uni2.0方式推送消息给指定人员（支持鸿蒙）.result:"+JSON.toJSONString(result));
        log.debug("接口【/identify/api/tencent/send-video-msg-by-uni2】通过uni2.0方式推送消息给指定人员（支持鸿蒙）：end。");
        return result;
    }

    /**
     * <b> 继续推送音视频房间号给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "continue-send-video-room-msg")
    @ResponseBody
    public Result continueSendVideoRoomMsg(HttpServletRequest request) {
        String roomNo = request.getParameter("RoomNo");
        String memberList = request.getParameter("MemberList");
        String useList = request.getParameter("UseList");
        String comId = request.getParameter("ComId");
        String Yardman_Task_Name = request.getParameter("Yardman_Task_Name");
        String transcriber = request.getParameter("Transcriber");
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】roomNo:"+roomNo);
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        params.put("memberList",memberList);
        params.put("useList",useList);
        params.put("comId",comId);
        params.put("Yardman_Task_Name",Yardman_Task_Name);
        params.put("transcriber",transcriber);
        if (StrUtil.isEmpty(params.get("roomNo"))
                || StrUtil.isEmpty(params.get("comId"))
                || StrUtil.isEmpty(params.get("memberList"))
                || StrUtil.isEmpty(params.get("useList"))
                || StrUtil.isEmpty(params.get("Yardman_Task_Name"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】推送音视频房间号给指定人员。");
        Result result = tencentIMService.continueSendVideoRoomMsg(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】推送音视频房间号给指定人员。");
        return result;
    }

    /**
     * <b> (调用uni2.0推送)继续推送音视频房间号给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "continue-send-video-room-msg-to-uni2")
    @ResponseBody
    public Result continueSendVideoRoomMsgToUni2(HttpServletRequest request) {
        String roomNo = request.getParameter("RoomNo");
        String memberList = request.getParameter("MemberList");
        String useList = request.getParameter("UseList");
        String comId = request.getParameter("ComId");
        String Yardman_Task_Name = request.getParameter("Yardman_Task_Name");
        String transcriber = request.getParameter("Transcriber");
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】roomNo:"+roomNo);
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        params.put("memberList",memberList);
        params.put("useList",useList);
        params.put("comId",comId);
        params.put("Yardman_Task_Name",Yardman_Task_Name);
        params.put("transcriber",transcriber);
        if (StrUtil.isEmpty(params.get("roomNo"))
                || StrUtil.isEmpty(params.get("comId"))
                || StrUtil.isEmpty(params.get("memberList"))
                || StrUtil.isEmpty(params.get("useList"))
                || StrUtil.isEmpty(params.get("Yardman_Task_Name"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】推送音视频房间号给指定人员。");
        Result result = tencentIMService.continueSendVideoRoomMsgToUni2(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/continue-send-video-room-msg】推送音视频房间号给指定人员。");
        return result;
    }

    /**
     * <b> 发送广播消息给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "send-broadcast-msg")
    @ResponseBody
    public Result sendBroadcastMsg(@RequestBody BroadcastDto dto) {
//        String token = request.getParameter("token");
        log.debug("接口【/identify/api/tencent/send-broadcast-msg】number:"+dto.getContent());
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        log.debug("接口【/identify/api/tencent/send-broadcast-msg】发送广播消息给指定人员。");
        Result result = tencentIMService.sendBroadcastMsg(dto);
        log.debug("接口【/identify/api/tencent/send-broadcast-msg】发送广播消息给指定人员。");
        return result;
    }

    /**
     * <b> (调用uni2.0推送)发送广播消息给指定人员 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "send-broadcast-msg-to-uni2")
    @ResponseBody
    public Result sendBroadcastMsgToUni2(@RequestBody BroadcastDto dto) {
        log.debug("接口【/identify/api/tencent/send-broadcast-msg-to-uni2】number:"+dto.getContent());
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        log.debug("接口【/identify/api/tencent/send-broadcast-msg-to-uni2】发送广播消息给指定人员。");
        Result result = tencentIMService.sendBroadcastMsgToUni2(dto);
        log.debug("接口【/identify/api/tencent/send-broadcast-msg-to-uni2】发送广播消息给指定人员。");
        return result;
    }

    /**
     * <b> 录屏回调测试方法 </b>
     * @author ZXF
     * @create 2020/06/17 0017 10:19
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "video-call-back")
    @ResponseBody
    public Result videoCallBack(HttpServletRequest request) throws BusinessException {
        Map<String,Object> param = getDataFromRequest(request);
        log.debug("接口【/identify/api/tencent/video-call-back】param:"+param.toString());
        return tencentIMService.videoCallBack(param);
    }

    private Map<String,Object> getDataFromRequest(HttpServletRequest request){
        Gson gson = new Gson();
        String type = request.getContentType();
        Map<String,Object> receiveMap = new HashMap<String,Object>();
        if("application/x-www-form-urlencoded".equals(type)){
            Enumeration<String> enu = request.getParameterNames();
            while (enu.hasMoreElements()) {
                String key = String.valueOf(enu.nextElement());
                String value = request.getParameter(key);
                receiveMap.put(key, value);
            }
        }else{	//else是text/plain、application/json这两种情况
            StringBuilder sb = new StringBuilder();
            try(BufferedReader reader = new BufferedReader(new InputStreamReader(request.getInputStream(), "utf-8"))) {
                String line = null;
                while ((line = reader.readLine()) != null){
                    System.out.println(line);
                    sb.append(line);
                }
            } catch (IOException e){
                e.printStackTrace();
            }
            //把JSON字符串转为对象
            receiveMap = gson.fromJson(sb.toString(), new TypeToken<Map<String, String>>(){}.getType());
        }
        return receiveMap;
    }

    /**
     * <b> 获取腾讯音视频sig信息 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @GetMapping(value = "get-tencent-ysp-sig")
    @ResponseBody
    public Result getTencentYSPSig(HttpServletRequest request) {
        String cid = request.getParameter("cid");
        String name = request.getParameter("name");
        String photoUrl = request.getParameter("photoUrl");
        String isShare = request.getParameter("isShare");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("cid",cid);
        params.put("name",name);
        params.put("photoUrl",photoUrl);
        params.put("isShare",isShare);
        log.debug("接口【/identify/api/tencent/get-tencent-ysp-sig】params:"+params.toString());
            if (StrUtil.isEmpty(params.get("cid"))
                || StrUtil.isEmpty(params.get("name"))
            ) {
                return Result.fail("参数不完整");
            }
            log.debug("接口【/identify/api/tencent/get-tencent-ysp-sig】获取腾讯音视频sig信息。");
            Result result = tencentIMService.getTencentYSPSig(new HashMap<>(params));
            log.debug("接口【/identify/api/tencent/get-tencent-ysp-sig】获取腾讯音视频sig信息。");
            return result;
    }

//    @GetMapping(value = "test1")
//    @ResponseBody
//    public Result test1() {
//        return tencentIMService.test1();
//    }

    /**
     * <b> 分页查询调度记录 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "find-com-video-room-page")
    @ResponseBody
    public Result findComVideoRoomPage(HttpServletRequest request) {
        String comId = request.getParameter("comId");
        String pageNumber = request.getParameter("pageNumber");
        String pageSize = request.getParameter("pageSize");
        String yardmanTaskName = request.getParameter("yardmanTaskName");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("comId",comId);
        params.put("pageNumber",pageNumber);
        params.put("pageSize",pageSize);
        params.put("yardmanTaskName",yardmanTaskName);
        log.debug("接口【/identify/api/tencent/find-com-video-room-page】params:"+params.toString());
        if (StrUtil.isEmpty(params.get("comId"))
                || StrUtil.isEmpty(params.get("pageNumber"))
                || StrUtil.isEmpty(params.get("pageSize"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/find-com-video-room-page】分页查询调度记录。");
        Result result = tencentIMService.findComVideoRoomPage(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/find-com-video-room-page】分页查询调度记录。");
        return result;
    }

    /**
     * <b> 调度记录详情 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "get-video-room-detail")
    @ResponseBody
    public Result getVideoRoomDetail(HttpServletRequest request) {
        String comVideoRoomId = request.getParameter("comVideoRoomId");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("comVideoRoomId",comVideoRoomId);
        log.debug("接口【/identify/api/tencent/get-video-room-detail】params:"+params.toString());
        if (StrUtil.isEmpty(params.get("comVideoRoomId"))
//                || StrUtil.isEmpty(params.get("pageNumber"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/get-video-room-detail】调度记录详情。");
        Result result = tencentIMService.getVideoRoomDetail(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/get-video-room-detail】调度记录详情。");
        return result;
    }

    /**
     * <b> 设置房间结束时间 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "update-room-end-time")
    @ResponseBody
    public Result updateRoomEndTime(HttpServletRequest request) {
            String roomNo = request.getParameter("roomNo");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
            Map<String,String> params = Maps.newHashMap();
            params.put("roomNo",roomNo);
            log.debug("接口【/identify/api/tencent/update-room-end-time】params:"+params.toString());
            if (StrUtil.isEmpty(params.get("roomNo"))
//                || StrUtil.isEmpty(params.get("pageNumber"))
            ) {
                return Result.fail("参数不完整");
            }
            log.debug("接口【/identify/api/tencent/update-room-end-time】设置房间结束时间。");
            Result result = tencentIMService.updateRoomEndTime(new HashMap<>(params));
            log.debug("接口【/identify/api/tencent/update-room-end-time】设置房间结束时间。");
            return result;
    }

    /**
     * <b> APP设置参会人员视频接听状态 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:35
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "update-per-video-room-status")
    @ResponseBody
    public Result updatePerVideoRoomStatus(HttpServletRequest request) {
        String roomNo = request.getParameter("roomNo");
        String cid = request.getParameter("cid");
        String useid = request.getParameter("useid");
        String attendExpoStatus = request.getParameter("attendExpoStatus");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        params.put("cid",cid);
        params.put("useid",useid);
        params.put("attendExpoStatus",attendExpoStatus);
        log.debug("接口【/identify/api/tencent/update-per-video-room-status】params:"+params.toString());
        if (StrUtil.isEmpty(params.get("roomNo"))
            || StrUtil.isEmpty(params.get("attendExpoStatus"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/update-per-video-room-status】APP设置参会人员视频接听状态。");
        Result result = tencentIMService.updatePerVideoRoomStatus(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/update-per-video-room-status】APP设置参会人员视频接听状态。");
        return result;
    }

    /**
     * <b> 统计当前在房间人数 </b>
     * @author ZXF
     * @create 2021/05/12 0012 15:32
     * @version
     * @注意事项 </b>
     */
    @PostMapping(value = "statistics-per-num")
    @ResponseBody
    public Result statisticsPerNum(HttpServletRequest request) {
        String roomNo = request.getParameter("roomNo");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/tencent/trtc-video-room】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("roomNo",roomNo);
        log.debug("接口【/identify/api/tencent/statistics-per-num】params:"+params.toString());
        if (StrUtil.isEmpty(params.get("roomNo"))
//                || StrUtil.isEmpty(params.get("attendExpoStatus"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/tencent/statistics-per-num】统计当前在房间人数。");
        Result result = tencentIMService.statisticsPerNum(new HashMap<>(params));
        log.debug("接口【/identify/api/tencent/statistics-per-num】统计当前在房间人数。");
        return result;
    }
}
