!function(t,e){"object"==typeof exports&&"object"==typeof module?module.exports=e():"function"==typeof define&&define.amd?define("vue-cropper",[],e):"object"==typeof exports?exports["vue-cropper"]=e():t["vue-cropper"]=e()}(self,(()=>(()=>{"use strict";var t={814:(t,e,n)=>{n.d(e,{Z:()=>u});var i=n(537),r=n.n(i),o=n(645),s=n.n(o),a=n(667),h=n.n(a),c=new URL(n(738),n.b),p=s()(r()),l=h()(c);p.push([t.id,`\n.vue-cropper[data-v-998fa048] {\n  position: relative;\n  width: 100%;\n  height: 100%;\n  box-sizing: border-box;\n  user-select: none;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  direction: ltr;\n  touch-action: none;\n  text-align: left;\n  background-image: url(${l});\n}\n.cropper-box[data-v-998fa048],\n.cropper-box-canvas[data-v-998fa048],\n.cropper-drag-box[data-v-998fa048],\n.cropper-crop-box[data-v-998fa048],\n.cropper-face[data-v-998fa048] {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  user-select: none;\n}\n.cropper-box-canvas img[data-v-998fa048] {\n  position: relative;\n  text-align: left;\n  user-select: none;\n  transform: none;\n  max-width: none;\n  max-height: none;\n}\n.cropper-box[data-v-998fa048] {\n  overflow: hidden;\n}\n.cropper-move[data-v-998fa048] {\n  cursor: move;\n}\n.cropper-crop[data-v-998fa048] {\n  cursor: crosshair;\n}\n.cropper-modal[data-v-998fa048] {\n  background: rgba(0, 0, 0, 0.5);\n}\n.cropper-crop-box[data-v-998fa048] {\n  /*border: 2px solid #39f;*/\n}\n.cropper-view-box[data-v-998fa048] {\n  display: block;\n  overflow: hidden;\n  width: 100%;\n  height: 100%;\n  outline: 1px solid #39f;\n  outline-color: rgba(51, 153, 255, 0.75);\n  user-select: none;\n}\n.cropper-view-box img[data-v-998fa048] {\n  user-select: none;\n  text-align: left;\n  max-width: none;\n  max-height: none;\n}\n.cropper-face[data-v-998fa048] {\n  top: 0;\n  left: 0;\n  background-color: #fff;\n  opacity: 0.1;\n}\n.crop-info[data-v-998fa048] {\n  position: absolute;\n  left: 0px;\n  min-width: 65px;\n  text-align: center;\n  color: white;\n  line-height: 20px;\n  background-color: rgba(0, 0, 0, 0.8);\n  font-size: 12px;\n}\n.crop-line[data-v-998fa048] {\n  position: absolute;\n  display: block;\n  width: 100%;\n  height: 100%;\n  opacity: 0.1;\n}\n.line-w[data-v-998fa048] {\n  top: -3px;\n  left: 0;\n  height: 5px;\n  cursor: n-resize;\n}\n.line-a[data-v-998fa048] {\n  top: 0;\n  left: -3px;\n  width: 5px;\n  cursor: w-resize;\n}\n.line-s[data-v-998fa048] {\n  bottom: -3px;\n  left: 0;\n  height: 5px;\n  cursor: s-resize;\n}\n.line-d[data-v-998fa048] {\n  top: 0;\n  right: -3px;\n  width: 5px;\n  cursor: e-resize;\n}\n.crop-point[data-v-998fa048] {\n  position: absolute;\n  width: 8px;\n  height: 8px;\n  opacity: 0.75;\n  background-color: #39f;\n  border-radius: 100%;\n}\n.point1[data-v-998fa048] {\n  top: -4px;\n  left: -4px;\n  cursor: nw-resize;\n}\n.point2[data-v-998fa048] {\n  top: -5px;\n  left: 50%;\n  margin-left: -3px;\n  cursor: n-resize;\n}\n.point3[data-v-998fa048] {\n  top: -4px;\n  right: -4px;\n  cursor: ne-resize;\n}\n.point4[data-v-998fa048] {\n  top: 50%;\n  left: -4px;\n  margin-top: -3px;\n  cursor: w-resize;\n}\n.point5[data-v-998fa048] {\n  top: 50%;\n  right: -4px;\n  margin-top: -3px;\n  cursor: e-resize;\n}\n.point6[data-v-998fa048] {\n  bottom: -5px;\n  left: -4px;\n  cursor: sw-resize;\n}\n.point7[data-v-998fa048] {\n  bottom: -5px;\n  left: 50%;\n  margin-left: -3px;\n  cursor: s-resize;\n}\n.point8[data-v-998fa048] {\n  bottom: -5px;\n  right: -4px;\n  cursor: se-resize;\n}\n@media screen and (max-width: 500px) {\n.crop-point[data-v-998fa048] {\n    position: absolute;\n    width: 20px;\n    height: 20px;\n    opacity: 0.45;\n    background-color: #39f;\n    border-radius: 100%;\n}\n.point1[data-v-998fa048] {\n    top: -10px;\n    left: -10px;\n}\n.point2[data-v-998fa048],\n  .point4[data-v-998fa048],\n  .point5[data-v-998fa048],\n  .point7[data-v-998fa048] {\n    display: none;\n}\n.point3[data-v-998fa048] {\n    top: -10px;\n    right: -10px;\n}\n.point4[data-v-998fa048] {\n    top: 0;\n    left: 0;\n}\n.point6[data-v-998fa048] {\n    bottom: -10px;\n    left: -10px;\n}\n.point8[data-v-998fa048] {\n    bottom: -10px;\n    right: -10px;\n}\n}\n`,"",{version:3,sources:["webpack://./src/vue-cropper.vue"],names:[],mappings:";AAs7DA;EACA,kBAAA;EACA,WAAA;EACA,YAAA;EACA,sBAAA;EACA,iBAAA;EACA,yBAAA;EACA,sBAAA;EACA,qBAAA;EACA,cAAA;EACA,kBAAA;EACA,gBAAA;EACA,yDAAA;AACA;AAEA;;;;;EAKA,kBAAA;EACA,MAAA;EACA,QAAA;EACA,SAAA;EACA,OAAA;EACA,iBAAA;AACA;AAEA;EACA,kBAAA;EACA,gBAAA;EACA,iBAAA;EACA,eAAA;EACA,eAAA;EACA,gBAAA;AACA;AAEA;EACA,gBAAA;AACA;AAEA;EACA,YAAA;AACA;AAEA;EACA,iBAAA;AACA;AAEA;EACA,8BAAA;AACA;AAEA;EACA,0BAAA;AACA;AAEA;EACA,cAAA;EACA,gBAAA;EACA,WAAA;EACA,YAAA;EACA,uBAAA;EACA,uCAAA;EACA,iBAAA;AACA;AAEA;EACA,iBAAA;EACA,gBAAA;EACA,eAAA;EACA,gBAAA;AACA;AAEA;EACA,MAAA;EACA,OAAA;EACA,sBAAA;EACA,YAAA;AACA;AAEA;EACA,kBAAA;EACA,SAAA;EACA,eAAA;EACA,kBAAA;EACA,YAAA;EACA,iBAAA;EACA,oCAAA;EACA,eAAA;AACA;AAEA;EACA,kBAAA;EACA,cAAA;EACA,WAAA;EACA,YAAA;EACA,YAAA;AACA;AAEA;EACA,SAAA;EACA,OAAA;EACA,WAAA;EACA,gBAAA;AACA;AAEA;EACA,MAAA;EACA,UAAA;EACA,UAAA;EACA,gBAAA;AACA;AAEA;EACA,YAAA;EACA,OAAA;EACA,WAAA;EACA,gBAAA;AACA;AAEA;EACA,MAAA;EACA,WAAA;EACA,UAAA;EACA,gBAAA;AACA;AAEA;EACA,kBAAA;EACA,UAAA;EACA,WAAA;EACA,aAAA;EACA,sBAAA;EACA,mBAAA;AACA;AAEA;EACA,SAAA;EACA,UAAA;EACA,iBAAA;AACA;AAEA;EACA,SAAA;EACA,SAAA;EACA,iBAAA;EACA,gBAAA;AACA;AAEA;EACA,SAAA;EACA,WAAA;EACA,iBAAA;AACA;AAEA;EACA,QAAA;EACA,UAAA;EACA,gBAAA;EACA,gBAAA;AACA;AAEA;EACA,QAAA;EACA,WAAA;EACA,gBAAA;EACA,gBAAA;AACA;AAEA;EACA,YAAA;EACA,UAAA;EACA,iBAAA;AACA;AAEA;EACA,YAAA;EACA,SAAA;EACA,iBAAA;EACA,gBAAA;AACA;AAEA;EACA,YAAA;EACA,WAAA;EACA,iBAAA;AACA;AAEA;AACA;IACA,kBAAA;IACA,WAAA;IACA,YAAA;IACA,aAAA;IACA,sBAAA;IACA,mBAAA;AACA;AAEA;IACA,UAAA;IACA,WAAA;AACA;AAEA;;;;IAIA,aAAA;AACA;AAEA;IACA,UAAA;IACA,YAAA;AACA;AAEA;IACA,MAAA;IACA,OAAA;AACA;AAEA;IACA,aAAA;IACA,WAAA;AACA;AAEA;IACA,aAAA;IACA,YAAA;AACA;AACA",sourcesContent:['<template>\n  <div class="vue-cropper" ref="cropper" @mouseover="scaleImg" @mouseout="cancelScale">\n    <div class="cropper-box" v-if="imgs">\n      <div\n        class="cropper-box-canvas"\n        v-show="!loading"\n        :style="{\n\t\t\t\t\t\'width\': trueWidth + \'px\',\n\t\t\t\t\t\'height\': trueHeight + \'px\',\n\t\t\t\t\t\'transform\': \'scale(\' + scale + \',\' + scale + \') \' + \'translate3d(\'+ x / scale + \'px,\' + y / scale + \'px,\' + \'0)\'\n\t\t\t\t\t+ \'rotateZ(\'+ rotate * 90 +\'deg)\'\n\t\t\t\t\t}"\n      >\n        <img :src="imgs" alt="cropper-img" ref="cropperImg">\n      </div>\n    </div>\n    <div\n      class="cropper-drag-box"\n      :class="{\'cropper-move\': move && !crop, \'cropper-crop\': crop, \'cropper-modal\': cropping}"\n      @mousedown="startMove"\n      @touchstart="startMove"\n    ></div>\n    <div\n      v-show="cropping"\n      class="cropper-crop-box"\n      :style="{\n\t\t\t\t\t\'width\': cropW + \'px\',\n\t\t\t\t\t\'height\': cropH + \'px\',\n\t\t\t\t\t\'transform\': \'translate3d(\'+ cropOffsertX + \'px,\' + cropOffsertY + \'px,\' + \'0)\'\n\t\t\t\t}"\n    >\n      <span class="cropper-view-box">\n        <img\n          :style="{\n\t\t\t\t\t\t\'width\': trueWidth + \'px\',\n\t\t\t\t\t\t\'height\': trueHeight + \'px\',\n\t\t\t\t\t\t\'transform\': \'scale(\' + scale + \',\' + scale + \') \' + \'translate3d(\'+ (x - cropOffsertX) / scale  + \'px,\' + (y - cropOffsertY) / scale + \'px,\' + \'0)\'\n\t\t\t\t\t\t+ \'rotateZ(\'+ rotate * 90 +\'deg)\'\n\t\t\t\t\t\t}"\n          :src="imgs"\n          alt="cropper-img"\n        >\n      </span>\n      <span class="cropper-face cropper-move" @mousedown="cropMove" @touchstart="cropMove"></span>\n      <span\n        class="crop-info"\n        v-if="info"\n        :style="{\'top\': cropInfo.top}"\n      >{{ cropInfo.width }} × {{ cropInfo.height }}</span>\n      <span v-if="!fixedBox">\n        <span\n          class="crop-line line-w"\n          @mousedown="changeCropSize($event, false, true, 0, 1)"\n          @touchstart="changeCropSize($event, false, true, 0, 1)"\n        ></span>\n        <span\n          class="crop-line line-a"\n          @mousedown="changeCropSize($event, true, false, 1, 0)"\n          @touchstart="changeCropSize($event, true, false, 1, 0)"\n        ></span>\n        <span\n          class="crop-line line-s"\n          @mousedown="changeCropSize($event, false, true, 0, 2)"\n          @touchstart="changeCropSize($event, false, true, 0, 2)"\n        ></span>\n        <span\n          class="crop-line line-d"\n          @mousedown="changeCropSize($event, true, false, 2, 0)"\n          @touchstart="changeCropSize($event, true, false, 2, 0)"\n        ></span>\n        <span\n          class="crop-point point1"\n          @mousedown="changeCropSize($event, true, true, 1, 1)"\n          @touchstart="changeCropSize($event, true, true, 1, 1)"\n        ></span>\n        <span\n          class="crop-point point2"\n          @mousedown="changeCropSize($event, false, true, 0, 1)"\n          @touchstart="changeCropSize($event, false, true, 0, 1)"\n        ></span>\n        <span\n          class="crop-point point3"\n          @mousedown="changeCropSize($event, true, true, 2, 1)"\n          @touchstart="changeCropSize($event, true, true, 2, 1)"\n        ></span>\n        <span\n          class="crop-point point4"\n          @mousedown="changeCropSize($event, true, false, 1, 0)"\n          @touchstart="changeCropSize($event, true, false, 1, 0)"\n        ></span>\n        <span\n          class="crop-point point5"\n          @mousedown="changeCropSize($event, true, false, 2, 0)"\n          @touchstart="changeCropSize($event, true, false, 2, 0)"\n        ></span>\n        <span\n          class="crop-point point6"\n          @mousedown="changeCropSize($event, true, true, 1, 2)"\n          @touchstart="changeCropSize($event, true, true, 1, 2)"\n        ></span>\n        <span\n          class="crop-point point7"\n          @mousedown="changeCropSize($event, false, true, 0, 2)"\n          @touchstart="changeCropSize($event, false, true, 0, 2)"\n        ></span>\n        <span\n          class="crop-point point8"\n          @mousedown="changeCropSize($event, true, true, 2, 2)"\n          @touchstart="changeCropSize($event, true, true, 2, 2)"\n        ></span>\n      </span>\n    </div>\n  </div>\n</template>\n\n<script>\nimport exifmin from "./exif-js-min";\n\nexport default {\n  data: function() {\n    return {\n      // 容器高宽\n      w: 0,\n      h: 0,\n      // 图片缩放比例\n      scale: 1,\n      // 图片偏移x轴\n      x: 0,\n      // 图片偏移y轴\n      y: 0,\n      // 图片加载\n      loading: true,\n      // 图片真实宽度\n      trueWidth: 0,\n      // 图片真实高度\n      trueHeight: 0,\n      move: true,\n      // 移动的x\n      moveX: 0,\n      // 移动的y\n      moveY: 0,\n      // 开启截图\n      crop: false,\n      // 正在截图\n      cropping: false,\n      // 裁剪框大小\n      cropW: 0,\n      cropH: 0,\n      cropOldW: 0,\n      cropOldH: 0,\n      // 判断是否能够改变\n      canChangeX: false,\n      canChangeY: false,\n      // 改变的基准点\n      changeCropTypeX: 1,\n      changeCropTypeY: 1,\n      // 裁剪框的坐标轴\n      cropX: 0,\n      cropY: 0,\n      cropChangeX: 0,\n      cropChangeY: 0,\n      cropOffsertX: 0,\n      cropOffsertY: 0,\n      // 支持的滚动事件\n      support: "",\n      // 移动端手指缩放\n      touches: [],\n      touchNow: false,\n      // 图片旋转\n      rotate: 0,\n      isIos: false,\n      orientation: 0,\n      imgs: "",\n      // 图片缩放系数\n      coe: 0.2,\n      // 是否正在多次缩放\n      scaling: false,\n      scalingSet: "",\n      coeStatus: "",\n      // 控制emit触发频率\n      isCanShow: true\n    };\n  },\n  props: {\n    img: {\n      type: [String, Blob, null, File],\n      default: ""\n    },\n    // 输出图片压缩比\n    outputSize: {\n      type: Number,\n      default: 1\n    },\n    outputType: {\n      type: String,\n      default: "jpeg"\n    },\n    info: {\n      type: Boolean,\n      default: true\n    },\n    // 是否开启滚轮放大缩小\n    canScale: {\n      type: Boolean,\n      default: true\n    },\n    // 是否自成截图框\n    autoCrop: {\n      type: Boolean,\n      default: false\n    },\n    autoCropWidth: {\n      type: [Number, String],\n      default: 0\n    },\n    autoCropHeight: {\n      type: [Number, String],\n      default: 0\n    },\n    // 是否开启固定宽高比\n    fixed: {\n      type: Boolean,\n      default: false\n    },\n    // 宽高比 w/h\n    fixedNumber: {\n      type: Array,\n      default: () => {\n        return [1, 1];\n      }\n    },\n    // 固定大小 禁止改变截图框大小\n    fixedBox: {\n      type: Boolean,\n      default: false\n    },\n    // 输出截图是否缩放\n    full: {\n      type: Boolean,\n      default: false\n    },\n    // 是否可以拖动图片\n    canMove: {\n      type: Boolean,\n      default: true\n    },\n    // 是否可以拖动截图框\n    canMoveBox: {\n      type: Boolean,\n      default: true\n    },\n    // 上传图片按照原始比例显示\n    original: {\n      type: Boolean,\n      default: false\n    },\n    // 截图框能否超过图片\n    centerBox: {\n      type: Boolean,\n      default: false\n    },\n    // 是否根据dpr输出高清图片\n    high: {\n      type: Boolean,\n      default: true\n    },\n    // 截图框展示宽高类型\n    infoTrue: {\n      type: Boolean,\n      default: false\n    },\n    // 可以压缩图片宽高  默认不超过200\n    maxImgSize: {\n      type: [Number, String],\n      default: 2000\n    },\n    // 倍数  可渲染当前截图框的n倍 0 - 1000;\n    enlarge: {\n      type: [Number, String],\n      default: 1\n    },\n\n    // 自动预览的固定宽度\n    preW: {\n      type: [Number, String],\n      default: 0\n    },\n    /*\n      图片布局方式 mode 实现和css背景一样的效果\n      contain  居中布局 默认不会缩放 保证图片在容器里面 mode: \'contain\'\n      cover    拉伸布局 填充整个容器  mode: \'cover\'\n      如果仅有一个数值被给定，这个数值将作为宽度值大小，高度值将被设定为auto。 mode: \'50px\'\n      如果有两个数值被给定，第一个将作为宽度值大小，第二个作为高度值大小。 mode: \'50px 60px\'\n    */\n    mode: {\n      type: String,\n      default: "contain"\n    },\n    //限制最小区域,可传1以上的数字和字符串，限制长宽都是这么大\n    // 也可以传数组[90,90] \n    limitMinSize: {\n      type: [Number, Array, String],\n      default: () => {\n        return 10;\n      },\n      validator: function (value) {\n        if (Array.isArray(value)) {\n          return Number(value[0]) >= 0 && Number(value[1]) >= 0;\n        } else {\n          return Number(value) >= 0;\n        }\n      },\n    },\n    // 导出时,填充背景颜色\n    fillColor: {\n      type: String,\n      default: "",\n    },\n  },\n  computed: {\n    cropInfo() {\n      let obj = {};\n      obj.top = this.cropOffsertY > 21 ? "-21px" : "0px";\n      obj.width = this.cropW > 0 ? this.cropW : 0;\n      obj.height = this.cropH > 0 ? this.cropH : 0;\n      if (this.infoTrue) {\n        let dpr = 1;\n        if (this.high && !this.full) {\n          dpr = window.devicePixelRatio;\n        }\n        if ((this.enlarge !== 1) & !this.full) {\n          dpr = Math.abs(Number(this.enlarge));\n        }\n        obj.width = obj.width * dpr;\n        obj.height = obj.height * dpr;\n        if (this.full) {\n          obj.width = obj.width / this.scale;\n          obj.height = obj.height / this.scale;\n        }\n      }\n      obj.width = obj.width.toFixed(0);\n      obj.height = obj.height.toFixed(0);\n      return obj;\n    },\n\n    isIE() {\n      var userAgent = navigator.userAgent; //取得浏览器的userAgent字符串\n      const isIE = !!window.ActiveXObject || \'ActiveXObject\' in window; //判断是否IE浏览器\n      return isIE;\n    },\n\n    passive () {\n      return this.isIE ? null : {\n        passive: false\n      }\n    }\n  },\n  watch: {\n    // 如果图片改变， 重新布局\n    img() {\n      // 当传入图片时, 读取图片信息同时展示\n      this.checkedImg();\n    },\n    imgs(val) {\n      if (val === "") {\n        return;\n      }\n      this.reload();\n    },\n    cropW() {\n      this.showPreview();\n    },\n    cropH() {\n      this.showPreview();\n    },\n    cropOffsertX() {\n      this.showPreview();\n    },\n    cropOffsertY() {\n      this.showPreview();\n    },\n    scale(val, oldVal) {\n      this.showPreview();\n    },\n    x() {\n      this.showPreview();\n    },\n    y() {\n      this.showPreview();\n    },\n    autoCrop(val) {\n      if (val) {\n        this.goAutoCrop();\n      }\n    },\n    // 修改了自动截图框\n    autoCropWidth() {\n      if (this.autoCrop) {\n        this.goAutoCrop();\n      }\n    },\n    autoCropHeight() {\n      if (this.autoCrop) {\n        this.goAutoCrop();\n      }\n    },\n    mode() {\n      this.checkedImg();\n    },\n    rotate() {\n      this.showPreview();\n      if (this.autoCrop) {\n        this.goAutoCrop(this.cropW, this.cropH);\n      } else {\n        if (this.cropW > 0 || this.cropH > 0) {\n          this.goAutoCrop(this.cropW, this.cropH);\n        }\n      }\n    }\n  },\n  methods: {\n    getVersion (name) {\n      var arr = navigator.userAgent.split(\' \'); \n      var chromeVersion = \'\';\n      let result = 0;\n      const reg = new RegExp(name, \'i\')\n      for(var i=0;i < arr.length;i++){\n          if(reg.test(arr[i]))\n          chromeVersion = arr[i]\n      }\n      if(chromeVersion){\n          result = chromeVersion.split(\'/\')[1].split(\'.\');\n      } else {\n          result = [\'0\', \'0\', \'0\'];\n      }\n      return result\n    },\n    checkOrientationImage(img, orientation, width, height) {\n      // 如果是 chrome内核版本在81 safari 在 605 以上不处理图片旋转\n      // alert(navigator.userAgent)\n      if (this.getVersion(\'chrome\')[0] >= 81) {\n        orientation = -1\n      } else {\n        if (this.getVersion(\'safari\')[0] >= 605 ) {\n          const safariVersion = this.getVersion(\'version\')\n          if (safariVersion[0] > 13 && safariVersion[1] > 1) {\n              orientation = -1\n          }\n        } else {\n          //  判断 ios 版本进行处理\n         // 针对 ios 版本大于 13.4的系统不做图片旋转\n         const isIos  = navigator.userAgent.toLowerCase().match(/cpu iphone os (.*?) like mac os/)\n         if (isIos) {\n           let version = isIos[1]\n           version = version.split(\'_\')\n           if (version[0] > 13 ||  (version[0] >= 13 && version[1] >= 4)) {\n             orientation = -1\n           }\n         }\n        }\n      }\n      \n      // alert(`当前处理的orientation${orientation}`)\n      let canvas = document.createElement("canvas");\n      let ctx = canvas.getContext("2d");\n      ctx.save();\n      \n      switch (orientation) {\n        case 2:\n          canvas.width = width;\n          canvas.height = height;\n          // horizontal flip\n          ctx.translate(width, 0);\n          ctx.scale(-1, 1);\n          break;\n        case 3:\n          canvas.width = width;\n          canvas.height = height;\n          //180 graus\n          ctx.translate(width / 2, height / 2);\n          ctx.rotate((180 * Math.PI) / 180);\n          ctx.translate(-width / 2, -height / 2);\n          break;\n        case 4:\n          canvas.width = width;\n          canvas.height = height;\n          // vertical flip\n          ctx.translate(0, height);\n          ctx.scale(1, -1);\n          break;\n        case 5:\n          // vertical flip + 90 rotate right\n          canvas.height = width;\n          canvas.width = height;\n          ctx.rotate(0.5 * Math.PI);\n          ctx.scale(1, -1);\n          break;\n        case 6:\n          canvas.width = height;\n          canvas.height = width;\n          //90 graus\n          ctx.translate(height / 2, width / 2);\n          ctx.rotate((90 * Math.PI) / 180);\n          ctx.translate(-width / 2, -height / 2);\n          break;\n        case 7:\n          // horizontal flip + 90 rotate right\n          canvas.height = width;\n          canvas.width = height;\n          ctx.rotate(0.5 * Math.PI);\n          ctx.translate(width, -height);\n          ctx.scale(-1, 1);\n          break;\n        case 8:\n          canvas.height = width;\n          canvas.width = height;\n          //-90 graus\n          ctx.translate(height / 2, width / 2);\n          ctx.rotate((-90 * Math.PI) / 180);\n          ctx.translate(-width / 2, -height / 2);\n          break;\n        default:\n          canvas.width = width;\n          canvas.height = height;\n      }\n\n      ctx.drawImage(img, 0, 0, width, height);\n      ctx.restore();\n      canvas.toBlob(\n        blob => {\n          let data = URL.createObjectURL(blob);\n          URL.revokeObjectURL(this.imgs)\n          this.imgs = data;\n        },\n        "image/" + this.outputType,\n        1\n      );\n    },\n\n    // checkout img\n    checkedImg() {\n      if (this.img === null || this.img === \'\') {\n        this.imgs = \'\'\n        this.clearCrop()\n        return\n      }\n      this.loading = true;\n      this.scale = 1;\n      this.rotate = 0;\n      this.clearCrop();\n      let img = new Image();\n      img.onload = () => {\n        if (this.img === "") {\n          this.$emit("imgLoad", "error");\n          this.$emit("img-load", "error");\n          this.$emit("img-load", new Error(\'图片不能为空\'));\n          return false;\n        }\n\n        let width = img.width;\n        let height = img.height;\n        exifmin.getData(img).then(data => {\n          this.orientation = data.orientation || 1;\n          let max = Number(this.maxImgSize);\n          if (!this.orientation && (width < max) & (height < max)) {\n            this.imgs = this.img;\n            return;\n          }\n\n          if (width > max) {\n            height = (height / width) * max;\n            width = max;\n          }\n\n          if (height > max) {\n            width = (width / height) * max;\n            height = max;\n          }\n          this.checkOrientationImage(img, this.orientation, width, height);\n        }).catch(error => {\n          this.$emit("img-load", "error");\n          this.$emit("img-load-error", error);\n        });\n      };\n\n      img.onerror = () => {\n        this.$emit("imgLoad", "error");\n        this.$emit("img-load", "error");\n        this.$emit("img-load-error", error);\n      };\n\n      // 判断如果不是base64图片 再添加crossOrigin属性，否则会导致iOS低版本(10.2)无法显示图片\n      if (this.img.substr(0, 4) !== "data") {\n        img.crossOrigin = "";\n      }\n\n      if (this.isIE) {\n        var xhr = new XMLHttpRequest();\n        xhr.onload = function() {\n          var url = URL.createObjectURL(this.response);\n          img.src = url;\n        };\n        xhr.open("GET", this.img, true);\n        xhr.responseType = "blob";\n        xhr.send();\n      } else {\n        img.src = this.img;\n      }\n    },\n    // 当按下鼠标键\n    startMove(e) {\n      e.preventDefault();\n      // 如果move 为true 表示当前可以拖动\n      if (this.move && !this.crop) {\n        if (!this.canMove) {\n          return false;\n        }\n        // 开始移动\n        this.moveX = (\'clientX\' in e ? e.clientX : e.touches[0].clientX) - this.x;\n        this.moveY = (\'clientY\' in e ? e.clientY : e.touches[0].clientY) - this.y;\n        if (e.touches) {\n          window.addEventListener("touchmove", this.moveImg);\n          window.addEventListener("touchend", this.leaveImg);\n          if (e.touches.length == 2) {\n            // 记录手指刚刚放上去\n            this.touches = e.touches;\n            window.addEventListener("touchmove", this.touchScale);\n            window.addEventListener("touchend", this.cancelTouchScale);\n          }\n        } else {\n          window.addEventListener("mousemove", this.moveImg);\n          window.addEventListener("mouseup", this.leaveImg);\n        }\n        // 触发图片移动事件\n        this.$emit("imgMoving", {\n          moving: true,\n          axis: this.getImgAxis()\n        });\n        this.$emit("img-moving", {\n          moving: true,\n          axis: this.getImgAxis()\n        });\n      } else {\n        // 截图ing\n        this.cropping = true;\n        // 绑定截图事件\n        window.addEventListener("mousemove", this.createCrop);\n        window.addEventListener("mouseup", this.endCrop);\n        window.addEventListener("touchmove", this.createCrop);\n        window.addEventListener("touchend", this.endCrop);\n        this.cropOffsertX = e.offsetX\n          ? e.offsetX\n          : e.touches[0].pageX - this.$refs.cropper.offsetLeft;\n        this.cropOffsertY = e.offsetY\n          ? e.offsetY\n          : e.touches[0].pageY - this.$refs.cropper.offsetTop;\n        this.cropX = \'clientX\' in e ? e.clientX : e.touches[0].clientX;\n        this.cropY = \'clientY\' in e ? e.clientY : e.touches[0].clientY;\n        this.cropChangeX = this.cropOffsertX;\n        this.cropChangeY = this.cropOffsertY;\n        this.cropW = 0;\n        this.cropH = 0;\n      }\n    },\n\n    // 移动端缩放\n    touchScale(e) {\n      e.preventDefault();\n      let scale = this.scale;\n      // 记录变化量\n      // 第一根手指\n      var oldTouch1 = {\n        x: this.touches[0].clientX,\n        y: this.touches[0].clientY\n      };\n      var newTouch1 = {\n        x: e.touches[0].clientX,\n        y: e.touches[0].clientY\n      };\n      // 第二根手指\n      var oldTouch2 = {\n        x: this.touches[1].clientX,\n        y: this.touches[1].clientY\n      };\n      var newTouch2 = {\n        x: e.touches[1].clientX,\n        y: e.touches[1].clientY\n      };\n      var oldL = Math.sqrt(\n        Math.pow(oldTouch1.x - oldTouch2.x, 2) +\n          Math.pow(oldTouch1.y - oldTouch2.y, 2)\n      );\n      var newL = Math.sqrt(\n        Math.pow(newTouch1.x - newTouch2.x, 2) +\n          Math.pow(newTouch1.y - newTouch2.y, 2)\n      );\n      var cha = newL - oldL;\n      // 根据图片本身大小 决定每次改变大小的系数, 图片越大系数越小\n      // 1px - 0.2\n      var coe = 1;\n      coe =\n        coe / this.trueWidth > coe / this.trueHeight\n          ? coe / this.trueHeight\n          : coe / this.trueWidth;\n      coe = coe > 0.1 ? 0.1 : coe;\n      var num = coe * cha;\n      if (!this.touchNow) {\n        this.touchNow = true;\n        if (cha > 0) {\n          scale += Math.abs(num);\n        } else if (cha < 0) {\n          scale > Math.abs(num) ? (scale -= Math.abs(num)) : scale;\n        }\n        this.touches = e.touches;\n        setTimeout(() => {\n          this.touchNow = false;\n        }, 8);\n        if (!this.checkoutImgAxis(this.x, this.y, scale)) {\n          return false;\n        }\n        this.scale = scale;\n      }\n    },\n\n    cancelTouchScale(e) {\n      window.removeEventListener("touchmove", this.touchScale);\n    },\n\n    // 移动图片\n    moveImg(e) {\n      e.preventDefault();\n      if (e.touches && e.touches.length === 2) {\n        this.touches = e.touches;\n        window.addEventListener("touchmove", this.touchScale);\n        window.addEventListener("touchend", this.cancelTouchScale);\n        window.removeEventListener("touchmove", this.moveImg);\n        return false;\n      }\n      let nowX = \'clientX\' in e ? e.clientX : e.touches[0].clientX;\n      let nowY = \'clientY\' in e ? e.clientY : e.touches[0].clientY;\n\n      let changeX, changeY;\n      changeX = nowX - this.moveX;\n      changeY = nowY - this.moveY;\n\n      this.$nextTick(() => {\n        if (this.centerBox) {\n          let axis = this.getImgAxis(changeX, changeY, this.scale);\n          let cropAxis = this.getCropAxis();\n          let imgW = this.trueHeight * this.scale;\n          let imgH = this.trueWidth * this.scale;\n          let maxLeft, maxTop, maxRight, maxBottom;\n          switch (this.rotate) {\n            case 1:\n            case -1:\n            case 3:\n            case -3:\n              maxLeft =\n                this.cropOffsertX -\n                (this.trueWidth * (1 - this.scale)) / 2 +\n                (imgW - imgH) / 2;\n              maxTop =\n                this.cropOffsertY -\n                (this.trueHeight * (1 - this.scale)) / 2 +\n                (imgH - imgW) / 2;\n              maxRight = maxLeft - imgW + this.cropW;\n              maxBottom = maxTop - imgH + this.cropH;\n              break;\n            default:\n              maxLeft =\n                this.cropOffsertX - (this.trueWidth * (1 - this.scale)) / 2;\n              maxTop =\n                this.cropOffsertY - (this.trueHeight * (1 - this.scale)) / 2;\n              maxRight = maxLeft - imgH + this.cropW;\n              maxBottom = maxTop - imgW + this.cropH;\n              break;\n          }\n\n          // 图片左边 图片不能超过截图框\n          if (axis.x1 >= cropAxis.x1) {\n            changeX = maxLeft;\n          }\n\n          // 图片上边 图片不能超过截图框\n          if (axis.y1 >= cropAxis.y1) {\n            changeY = maxTop;\n          }\n\n          // 图片右边\n          if (axis.x2 <= cropAxis.x2) {\n            changeX = maxRight;\n          }\n\n          // 图片下边\n          if (axis.y2 <= cropAxis.y2) {\n            changeY = maxBottom;\n          }\n        }\n        this.x = changeX;\n        this.y = changeY;\n        // 触发图片移动事件\n        this.$emit("imgMoving", {\n          moving: true,\n          axis: this.getImgAxis()\n        });\n        this.$emit("img-moving", {\n          moving: true,\n          axis: this.getImgAxis()\n        });\n      });\n    },\n    // 移动图片结束\n    leaveImg(e) {\n      window.removeEventListener("mousemove", this.moveImg);\n      window.removeEventListener("touchmove", this.moveImg);\n      window.removeEventListener("mouseup", this.leaveImg);\n      window.removeEventListener("touchend", this.leaveImg);\n      // 触发图片移动事件\n      this.$emit("imgMoving", {\n        moving: false,\n        axis: this.getImgAxis()\n      });\n      this.$emit("img-moving", {\n        moving: false,\n        axis: this.getImgAxis()\n      });\n    },\n    // 缩放图片\n    scaleImg() {\n      if (this.canScale) {\n        window.addEventListener(this.support, this.changeSize, this.passive);\n      }\n    },\n    // 移出框\n    cancelScale() {\n      if (this.canScale) {\n        window.removeEventListener(this.support, this.changeSize);\n      }\n    },\n    // 改变大小函数\n    changeSize(e) {\n      e.preventDefault();\n      let scale = this.scale;\n      var change = e.deltaY || e.wheelDelta;\n      // 根据图片本身大小 决定每次改变大小的系数, 图片越大系数越小\n      var isFirefox = navigator.userAgent.indexOf("Firefox");\n      change = isFirefox > 0 ? change * 30 : change;\n      // 修复ie的滚动缩放\n      if (this.isIE) {\n        change = -change;\n      }\n      // 1px - 0.2\n      var coe = this.coe;\n      coe =\n        coe / this.trueWidth > coe / this.trueHeight\n          ? coe / this.trueHeight\n          : coe / this.trueWidth;\n      var num = coe * change;\n      num < 0\n        ? (scale += Math.abs(num))\n        : scale > Math.abs(num)\n        ? (scale -= Math.abs(num))\n        : scale;\n      // 延迟0.1s 每次放大大或者缩小的范围\n      let status = num < 0 ? "add" : "reduce";\n      if (status !== this.coeStatus) {\n        this.coeStatus = status;\n        this.coe = 0.2;\n      }\n      if (!this.scaling) {\n        this.scalingSet = setTimeout(() => {\n          this.scaling = false;\n          this.coe = this.coe += 0.01;\n        }, 50);\n      }\n      this.scaling = true;\n      if (!this.checkoutImgAxis(this.x, this.y, scale)) {\n        return false;\n      }\n      this.scale = scale;\n    },\n\n    // 修改图片大小函数\n    changeScale(num) {\n      let scale = this.scale;\n      num = num || 1;\n      var coe = 20;\n      coe =\n        coe / this.trueWidth > coe / this.trueHeight\n          ? coe / this.trueHeight\n          : coe / this.trueWidth;\n      num = num * coe;\n      num > 0\n        ? (scale += Math.abs(num))\n        : scale > Math.abs(num)\n        ? (scale -= Math.abs(num))\n        : scale;\n      if (!this.checkoutImgAxis(this.x, this.y, scale)) {\n        return false;\n      }\n      this.scale = scale;\n    },\n    // 创建截图框\n    createCrop(e) {\n      e.preventDefault();\n      // 移动生成大小\n      var nowX = \'clientX\' in e ? e.clientX : e.touches ? e.touches[0].clientX : 0;\n      var nowY = \'clientY\' in e ? e.clientY : e.touches ? e.touches[0].clientY : 0;\n      this.$nextTick(() => {\n        var fw = nowX - this.cropX;\n        var fh = nowY - this.cropY;\n        if (fw > 0) {\n          this.cropW =\n            fw + this.cropChangeX > this.w ? this.w - this.cropChangeX : fw;\n          this.cropOffsertX = this.cropChangeX;\n        } else {\n          this.cropW =\n            this.w - this.cropChangeX + Math.abs(fw) > this.w\n              ? this.cropChangeX\n              : Math.abs(fw);\n          this.cropOffsertX =\n            this.cropChangeX + fw > 0 ? this.cropChangeX + fw : 0;\n        }\n\n        if (!this.fixed) {\n          if (fh > 0) {\n            this.cropH =\n              fh + this.cropChangeY > this.h ? this.h - this.cropChangeY : fh;\n            this.cropOffsertY = this.cropChangeY;\n          } else {\n            this.cropH =\n              this.h - this.cropChangeY + Math.abs(fh) > this.h\n                ? this.cropChangeY\n                : Math.abs(fh);\n            this.cropOffsertY =\n              this.cropChangeY + fh > 0 ? this.cropChangeY + fh : 0;\n          }\n        } else {\n          var fixedHeight =\n            (this.cropW / this.fixedNumber[0]) * this.fixedNumber[1];\n          if (fixedHeight + this.cropOffsertY > this.h) {\n            this.cropH = this.h - this.cropOffsertY;\n            this.cropW =\n              (this.cropH / this.fixedNumber[1]) * this.fixedNumber[0];\n            if (fw > 0) {\n              this.cropOffsertX = this.cropChangeX;\n            } else {\n              this.cropOffsertX = this.cropChangeX - this.cropW;\n            }\n          } else {\n            this.cropH = fixedHeight;\n          }\n          this.cropOffsertY = this.cropOffsertY;\n        }\n      });\n    },\n\n    // 改变截图框大小\n    changeCropSize(e, w, h, typeW, typeH) {\n      e.preventDefault();\n      window.addEventListener("mousemove", this.changeCropNow);\n      window.addEventListener("mouseup", this.changeCropEnd);\n      window.addEventListener("touchmove", this.changeCropNow);\n      window.addEventListener("touchend", this.changeCropEnd);\n      this.canChangeX = w;\n      this.canChangeY = h;\n      this.changeCropTypeX = typeW;\n      this.changeCropTypeY = typeH;\n      this.cropX = \'clientX\' in e ? e.clientX : e.touches[0].clientX;\n      this.cropY = \'clientY\' in e ? e.clientY : e.touches[0].clientY;\n      this.cropOldW = this.cropW;\n      this.cropOldH = this.cropH;\n      this.cropChangeX = this.cropOffsertX;\n      this.cropChangeY = this.cropOffsertY;\n      if (this.fixed) {\n        if (this.canChangeX && this.canChangeY) {\n          this.canChangeY = 0;\n        }\n      }\n      this.$emit(\'changeCropSize\', {\n        width: this.cropW,\n        height: this.cropH\n      })\n      this.$emit(\'change-crop-size\', {\n        width: this.cropW,\n        height: this.cropH\n      })\n    },\n\n    // 正在改变\n    changeCropNow(e) {\n      e.preventDefault();\n      var nowX = \'clientX\' in e ? e.clientX : e.touches ? e.touches[0].clientX : 0;\n      var nowY = \'clientY\' in e ? e.clientY : e.touches ? e.touches[0].clientY : 0;\n      // 容器的宽高\n      let wrapperW = this.w;\n      let wrapperH = this.h;\n\n      // 不能超过的坐标轴\n      let minX = 0;\n      let minY = 0;\n\n      if (this.centerBox) {\n        let axis = this.getImgAxis();\n        let imgW = axis.x2;\n        let imgH = axis.y2;\n        minX = axis.x1 > 0 ? axis.x1 : 0;\n        minY = axis.y1 > 0 ? axis.y1 : 0;\n        if (wrapperW > imgW) {\n          wrapperW = imgW;\n        }\n\n        if (wrapperH > imgH) {\n          wrapperH = imgH;\n        }\n      }\n      const [minCropW,minCropH] = this.checkCropLimitSize()\n      this.$nextTick(() => {\n        var fw = nowX - this.cropX;\n        var fh = nowY - this.cropY;\n        if (this.canChangeX) {\n          if (this.changeCropTypeX === 1) {\n            if (this.cropOldW - fw < minCropW) {\n              this.cropW = minCropW\n              this.cropOffsertX = this.cropOldW + this.cropChangeX - minX - minCropW\n            } else if (this.cropOldW - fw > 0) {\n              this.cropW =\n                wrapperW - this.cropChangeX - fw <= wrapperW - minX\n                  ? this.cropOldW - fw\n                  : this.cropOldW + this.cropChangeX - minX;\n              this.cropOffsertX =\n                wrapperW - this.cropChangeX - fw <= wrapperW - minX\n                  ? this.cropChangeX + fw\n                  : minX;\n            } else {\n              this.cropW =\n                Math.abs(fw) + this.cropChangeX <= wrapperW\n                  ? Math.abs(fw) - this.cropOldW\n                  : wrapperW - this.cropOldW - this.cropChangeX;\n              this.cropOffsertX = this.cropChangeX + this.cropOldW;\n            }\n          } else if (this.changeCropTypeX === 2) {\n            if (this.cropOldW + fw < minCropW) {\n              this.cropW = minCropW\n            } else if (this.cropOldW + fw > 0) {\n              this.cropW =\n                this.cropOldW + fw + this.cropOffsertX <= wrapperW\n                  ? this.cropOldW + fw\n                  : wrapperW - this.cropOffsertX;\n              this.cropOffsertX = this.cropChangeX;\n            } else {\n              // 右侧坐标抽 超过左侧\n              this.cropW =\n                wrapperW - this.cropChangeX + Math.abs(fw + this.cropOldW) <=\n                wrapperW - minX\n                  ? Math.abs(fw + this.cropOldW)\n                  : this.cropChangeX - minX;\n              this.cropOffsertX =\n                wrapperW - this.cropChangeX + Math.abs(fw + this.cropOldW) <=\n                wrapperW - minX\n                  ? this.cropChangeX - Math.abs(fw + this.cropOldW)\n                  : minX;\n            }\n          }\n        }\n\n        if (this.canChangeY) {\n          if (this.changeCropTypeY === 1) {\n            if (this.cropOldH - fh < minCropH) {\n              this.cropH = minCropH\n              this.cropOffsertY = this.cropOldH + this.cropChangeY - minY - minCropH\n            } else if (this.cropOldH - fh > 0) {\n              this.cropH =\n                wrapperH - this.cropChangeY - fh <= wrapperH - minY\n                  ? this.cropOldH - fh\n                  : this.cropOldH + this.cropChangeY - minY;\n              this.cropOffsertY =\n                wrapperH - this.cropChangeY - fh <= wrapperH - minY\n                  ? this.cropChangeY + fh\n                  : minY;\n            } else {\n              this.cropH =\n                Math.abs(fh) + this.cropChangeY <= wrapperH\n                  ? Math.abs(fh) - this.cropOldH\n                  : wrapperH - this.cropOldH - this.cropChangeY;\n              this.cropOffsertY = this.cropChangeY + this.cropOldH;\n            }\n          } else if (this.changeCropTypeY === 2) {\n            if (this.cropOldH + fh < minCropH) {\n              this.cropH = minCropH\n            } else if (this.cropOldH + fh > 0) {\n              this.cropH =\n                this.cropOldH + fh + this.cropOffsertY <= wrapperH\n                  ? this.cropOldH + fh\n                  : wrapperH - this.cropOffsertY;\n              this.cropOffsertY = this.cropChangeY;\n            } else {\n              this.cropH =\n                wrapperH - this.cropChangeY + Math.abs(fh + this.cropOldH) <=\n                wrapperH - minY\n                  ? Math.abs(fh + this.cropOldH)\n                  : this.cropChangeY - minY;\n              this.cropOffsertY =\n                wrapperH - this.cropChangeY + Math.abs(fh + this.cropOldH) <=\n                wrapperH - minY\n                  ? this.cropChangeY - Math.abs(fh + this.cropOldH)\n                  : minY;\n            }\n          }\n        }\n\n        if (this.canChangeX && this.fixed) {\n          var fixedHeight =\n            (this.cropW / this.fixedNumber[0]) * this.fixedNumber[1];\n          if (fixedHeight < minCropH) {\n            this.cropH = minCropH\n            this.cropW = this.fixedNumber[0] * minCropH / this.fixedNumber[1]\n            // 这里需要去修改 offsetX的值，去调整因为高度变化而导致的宽度变化\n            if (this.changeCropTypeX === 1) {\n              this.cropOffsertX = this.cropChangeX + (this.cropOldW - this.cropW)\n            }\n          } else if (fixedHeight + this.cropOffsertY > wrapperH) {\n            this.cropH = wrapperH - this.cropOffsertY;\n            this.cropW =\n              (this.cropH / this.fixedNumber[1]) * this.fixedNumber[0];\n            if (this.changeCropTypeX === 1) {\n              this.cropOffsertX = this.cropChangeX + (this.cropOldW - this.cropW)\n            }\n          } else {\n            this.cropH = fixedHeight;\n          }\n        }\n\n        if (this.canChangeY && this.fixed) {\n          var fixedWidth =\n            (this.cropH / this.fixedNumber[1]) * this.fixedNumber[0];\n          if (fixedWidth < minCropW) {\n            this.cropW = minCropW\n            this.cropH = this.fixedNumber[1] * minCropW / this.fixedNumber[0];\n          } else if (fixedWidth + this.cropOffsertX > wrapperW) {\n            this.cropW = wrapperW - this.cropOffsertX;\n            this.cropH =\n              (this.cropW / this.fixedNumber[0]) * this.fixedNumber[1];\n          } else {\n            this.cropW = fixedWidth;\n          }\n        }\n\t// 触发截图框改变大小事件\n\tthis.$emit(\'cropSizing\', {cropW: this.cropW, cropH: this.cropH})\n\tthis.$emit(\'crop-sizing\', {cropW: this.cropW, cropH: this.cropH})\n      });\n    },\n\n    checkCropLimitSize () {\n      let { cropW, cropH, limitMinSize } = this;\n\n      let limitMinNum = new Array;\n      if (!Array.isArray(limitMinSize)) {\n        limitMinNum = [limitMinSize, limitMinSize]\n      } else {\n        limitMinNum = limitMinSize\n      }\n      \n      //限制最小宽度和高度\n      cropW = parseFloat(limitMinNum[0])\n      cropH = parseFloat(limitMinNum[1])\n      return [cropW, cropH]\n    },\n    // 结束改变\n    changeCropEnd(e) {\n      window.removeEventListener("mousemove", this.changeCropNow);\n      window.removeEventListener("mouseup", this.changeCropEnd);\n      window.removeEventListener("touchmove", this.changeCropNow);\n      window.removeEventListener("touchend", this.changeCropEnd);\n    },\n    // 根据比例x/y，最小宽度，最小高度，现有宽度，现有高度，得到应该有的宽度和高度\n    calculateSize(x, y, minX, minY, w, h) {\n      const ratio = x / y;\n      let width = w;\n      let height = h;\n      // 先根据最小宽度来计算高度\n      if (width < minX) {\n        width = minX;\n        height = Math.ceil(width / ratio);\n      }\n      // 如果计算出来的高度小于最小高度，则根据最小高度来重新计算宽度和高度\n      if (height < minY) {\n        height = minY;\n        width = Math.ceil(height * ratio);\n        // 如果重新计算的宽度仍然小于最小宽度，则使用最小宽度，并重新计算高度\n        if (width < minX) {\n          width = minX;\n          height = Math.ceil(width / ratio);\n        }\n      }\n      // 如果计算出来的宽度或高度小于输入的宽度或高度，则分别使用输入的宽度或高度\n      if (width < w) {\n        width = w;\n        height = Math.ceil(width / ratio);\n      }\n      if (height < h) {\n        height = h;\n        width = Math.ceil(height * ratio);\n      }\n      return { width, height };\n    },\n    // 创建完成\n    endCrop() {\n      if (this.cropW === 0 && this.cropH === 0) {\n        this.cropping = false;\n      }\n      let [minCropW, minCropH] = this.checkCropLimitSize();\n      const { width, height } = this.fixed ? this.calculateSize(\n        this.fixedNumber[0],\n        this.fixedNumber[1],\n        minCropW,\n        minCropH,\n        this.cropW,\n        this.cropH\n      ) : { width: minCropW, height: minCropH }\n      if (width > this.cropW) {\n        this.cropW = width;\n        if (this.cropOffsertX + width > this.w) {\n          this.cropOffsertX = this.w - width;\n        }\n      }\n      if (height > this.cropH) {\n        this.cropH = height;\n        if (this.cropOffsertY + height > this.h) {\n          this.cropOffsertY = this.h - height;\n        }\n      }\n      window.removeEventListener("mousemove", this.createCrop);\n      window.removeEventListener("mouseup", this.endCrop);\n      window.removeEventListener("touchmove", this.createCrop);\n      window.removeEventListener("touchend", this.endCrop);\n    },\n    // 开始截图\n    startCrop() {\n      this.crop = true;\n    },\n    // 停止截图\n    stopCrop() {\n      this.crop = false;\n    },\n    // 清除截图\n    clearCrop() {\n      this.cropping = false;\n      this.cropW = 0;\n      this.cropH = 0;\n    },\n    // 截图移动\n    cropMove(e) {\n      e.preventDefault();\n      if (!this.canMoveBox) {\n        this.crop = false;\n        this.startMove(e);\n        return false;\n      }\n\n      if (e.touches && e.touches.length === 2) {\n        this.crop = false;\n        this.startMove(e);\n        this.leaveCrop();\n        return false;\n      }\n      window.addEventListener("mousemove", this.moveCrop);\n      window.addEventListener("mouseup", this.leaveCrop);\n      window.addEventListener("touchmove", this.moveCrop);\n      window.addEventListener("touchend", this.leaveCrop);\n      let x = \'clientX\' in e ? e.clientX : e.touches[0].clientX;\n      let y = \'clientY\' in e ? e.clientY : e.touches[0].clientY;\n      let newX, newY;\n      newX = x - this.cropOffsertX;\n      newY = y - this.cropOffsertY;\n      this.cropX = newX;\n      this.cropY = newY;\n      // 触发截图框移动事件\n      this.$emit("cropMoving", {\n        moving: true,\n        axis: this.getCropAxis()\n      });\n      this.$emit("crop-moving", {\n        moving: true,\n        axis: this.getCropAxis()\n      });\n    },\n\n    moveCrop(e, isMove) {\n      let nowX = 0;\n      let nowY = 0;\n      if (e) {\n        e.preventDefault();\n        nowX = \'clientX\' in e ? e.clientX : e.touches[0].clientX;\n        nowY = \'clientY\' in e ? e.clientY : e.touches[0].clientY;\n      }\n      this.$nextTick(() => {\n        let cx, cy;\n        let fw = nowX - this.cropX;\n        let fh = nowY - this.cropY;\n        if (isMove) {\n          fw = this.cropOffsertX;\n          fh = this.cropOffsertY;\n        }\n        // 不能超过外层容器\n        if (fw <= 0) {\n          cx = 0;\n        } else if (fw + this.cropW > this.w) {\n          cx = this.w - this.cropW;\n        } else {\n          cx = fw;\n        }\n\n        if (fh <= 0) {\n          cy = 0;\n        } else if (fh + this.cropH > this.h) {\n          cy = this.h - this.cropH;\n        } else {\n          cy = fh;\n        }\n\n        // 不能超过图片\n        if (this.centerBox) {\n          let axis = this.getImgAxis();\n          // 横坐标判断\n          if (cx <= axis.x1) {\n            cx = axis.x1;\n          }\n\n          if (cx + this.cropW > axis.x2) {\n            cx = axis.x2 - this.cropW;\n          }\n\n          // 纵坐标纵轴\n          if (cy <= axis.y1) {\n            cy = axis.y1;\n          }\n\n          if (cy + this.cropH > axis.y2) {\n            cy = axis.y2 - this.cropH;\n          }\n        }\n\n        this.cropOffsertX = cx;\n        this.cropOffsertY = cy;\n\n        // 触发截图框移动事件\n        this.$emit("cropMoving", {\n          moving: true,\n          axis: this.getCropAxis()\n        });\n        this.$emit("crop-moving", {\n          moving: true,\n          axis: this.getCropAxis()\n        });\n      });\n    },\n\n    // 算出不同场景下面 图片相对于外层容器的坐标轴\n    getImgAxis(x, y, scale) {\n      x = x || this.x;\n      y = y || this.y;\n      scale = scale || this.scale;\n      // 如果设置了截图框在图片内， 那么限制截图框不能超过图片的坐标\n      // 图片的坐标\n      let obj = {\n        x1: 0,\n        x2: 0,\n        y1: 0,\n        y2: 0\n      };\n      let imgW = this.trueWidth * scale;\n      let imgH = this.trueHeight * scale;\n      switch (this.rotate) {\n        case 0:\n          obj.x1 = x + (this.trueWidth * (1 - scale)) / 2;\n          obj.x2 = obj.x1 + this.trueWidth * scale;\n          obj.y1 = y + (this.trueHeight * (1 - scale)) / 2;\n          obj.y2 = obj.y1 + this.trueHeight * scale;\n          break;\n        case 1:\n        case -1:\n        case 3:\n        case -3:\n          obj.x1 = x + (this.trueWidth * (1 - scale)) / 2 + (imgW - imgH) / 2;\n          obj.x2 = obj.x1 + this.trueHeight * scale;\n          obj.y1 = y + (this.trueHeight * (1 - scale)) / 2 + (imgH - imgW) / 2;\n          obj.y2 = obj.y1 + this.trueWidth * scale;\n          break;\n        default:\n          obj.x1 = x + (this.trueWidth * (1 - scale)) / 2;\n          obj.x2 = obj.x1 + this.trueWidth * scale;\n          obj.y1 = y + (this.trueHeight * (1 - scale)) / 2;\n          obj.y2 = obj.y1 + this.trueHeight * scale;\n          break;\n      }\n      return obj;\n    },\n\n    // 获取截图框的坐标轴\n    getCropAxis() {\n      let obj = {\n        x1: 0,\n        x2: 0,\n        y1: 0,\n        y2: 0\n      };\n      obj.x1 = this.cropOffsertX;\n      obj.x2 = obj.x1 + this.cropW;\n      obj.y1 = this.cropOffsertY;\n      obj.y2 = obj.y1 + this.cropH;\n      return obj;\n    },\n\n    leaveCrop(e) {\n      window.removeEventListener("mousemove", this.moveCrop);\n      window.removeEventListener("mouseup", this.leaveCrop);\n      window.removeEventListener("touchmove", this.moveCrop);\n      window.removeEventListener("touchend", this.leaveCrop);\n      // 触发截图框移动事件\n      this.$emit("cropMoving", {\n        moving: false,\n        axis: this.getCropAxis()\n      });\n      this.$emit("crop-moving", {\n        moving: false,\n        axis: this.getCropAxis()\n      });\n    },\n\n    getCropChecked(cb) {\n      let canvas = document.createElement("canvas");\n      let img = new Image();\n      let rotate = this.rotate;\n      let trueWidth = this.trueWidth;\n      let trueHeight = this.trueHeight;\n      let cropOffsertX = this.cropOffsertX;\n      let cropOffsertY = this.cropOffsertY;\n      img.onload = () => {\n        if (this.cropW !== 0) {\n          let ctx = canvas.getContext("2d");\n          let dpr = 1;\n          if (this.high & !this.full) {\n            dpr = window.devicePixelRatio;\n          }\n          if ((this.enlarge !== 1) & !this.full) {\n            dpr = Math.abs(Number(this.enlarge));\n          }\n          let width = this.cropW * dpr;\n          let height = this.cropH * dpr;\n          let imgW = trueWidth * this.scale * dpr;\n          let imgH = trueHeight * this.scale * dpr;\n          // 图片x轴偏移\n          let dx =\n            (this.x - cropOffsertX + (this.trueWidth * (1 - this.scale)) / 2) *\n            dpr;\n          // 图片y轴偏移\n          let dy =\n            (this.y - cropOffsertY + (this.trueHeight * (1 - this.scale)) / 2) *\n            dpr;\n          //保存状态\n          setCanvasSize(width, height);\n          ctx.save();\n          // 填充背景颜色\n          if (this.fillColor) {\n            ctx.fillStyle = this.fillColor;\n            ctx.fillRect(0, 0, canvas.width, canvas.height);\n          }\n          switch (rotate) {\n            case 0:\n              if (!this.full) {\n                ctx.drawImage(img, dx, dy, imgW, imgH);\n              } else {\n                // 输出原图比例截图\n                setCanvasSize(width / this.scale, height / this.scale);\n                ctx.drawImage(\n                  img,\n                  dx / this.scale,\n                  dy / this.scale,\n                  imgW / this.scale,\n                  imgH / this.scale\n                );\n              }\n              break;\n            case 1:\n            case -3:\n              if (!this.full) {\n                // 换算图片旋转后的坐标弥补\n                dx = dx + (imgW - imgH) / 2;\n                dy = dy + (imgH - imgW) / 2;\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                ctx.drawImage(img, dy, -dx - imgH, imgW, imgH);\n              } else {\n                setCanvasSize(width / this.scale, height / this.scale);\n                // 换算图片旋转后的坐标弥补\n                dx =\n                  dx / this.scale + (imgW / this.scale - imgH / this.scale) / 2;\n                dy =\n                  dy / this.scale + (imgH / this.scale - imgW / this.scale) / 2;\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                ctx.drawImage(\n                  img,\n                  dy,\n                  -dx - imgH / this.scale,\n                  imgW / this.scale,\n                  imgH / this.scale\n                );\n              }\n              break;\n            case 2:\n            case -2:\n              if (!this.full) {\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                ctx.drawImage(img, -dx - imgW, -dy - imgH, imgW, imgH);\n              } else {\n                setCanvasSize(width / this.scale, height / this.scale);\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                dx = dx / this.scale;\n                dy = dy / this.scale;\n                ctx.drawImage(\n                  img,\n                  -dx - imgW / this.scale,\n                  -dy - imgH / this.scale,\n                  imgW / this.scale,\n                  imgH / this.scale\n                );\n              }\n              break;\n            case 3:\n            case -1:\n              if (!this.full) {\n                // 换算图片旋转后的坐标弥补\n                dx = dx + (imgW - imgH) / 2;\n                dy = dy + (imgH - imgW) / 2;\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                ctx.drawImage(img, -dy - imgW, dx, imgW, imgH);\n              } else {\n                setCanvasSize(width / this.scale, height / this.scale);\n                // 换算图片旋转后的坐标弥补\n                dx =\n                  dx / this.scale + (imgW / this.scale - imgH / this.scale) / 2;\n                dy =\n                  dy / this.scale + (imgH / this.scale - imgW / this.scale) / 2;\n                ctx.rotate((rotate * 90 * Math.PI) / 180);\n                ctx.drawImage(\n                  img,\n                  -dy - imgW / this.scale,\n                  dx,\n                  imgW / this.scale,\n                  imgH / this.scale\n                );\n              }\n              break;\n            default:\n              if (!this.full) {\n                ctx.drawImage(img, dx, dy, imgW, imgH);\n              } else {\n                // 输出原图比例截图\n                setCanvasSize(width / this.scale, height / this.scale);\n                ctx.drawImage(\n                  img,\n                  dx / this.scale,\n                  dy / this.scale,\n                  imgW / this.scale,\n                  imgH / this.scale\n                );\n              }\n          }\n          ctx.restore();\n        } else {\n          let width = trueWidth * this.scale;\n          let height = trueHeight * this.scale;\n          let ctx = canvas.getContext("2d");\n          ctx.save();\n          // 填充背景颜色\n          if (this.fillColor) {\n            ctx.fillStyle = this.fillColor;\n            ctx.fillRect(0, 0, canvas.width, canvas.height);\n          }\n          switch (rotate) {\n            case 0:\n              setCanvasSize(width, height);\n              ctx.drawImage(img, 0, 0, width, height);\n              break;\n            case 1:\n            case -3:\n              // 旋转90度 或者-270度 宽度和高度对调\n              setCanvasSize(height, width);\n              ctx.rotate((rotate * 90 * Math.PI) / 180);\n              ctx.drawImage(img, 0, -height, width, height);\n              break;\n            case 2:\n            case -2:\n              setCanvasSize(width, height);\n              ctx.rotate((rotate * 90 * Math.PI) / 180);\n              ctx.drawImage(img, -width, -height, width, height);\n              break;\n            case 3:\n            case -1:\n              setCanvasSize(height, width);\n              ctx.rotate((rotate * 90 * Math.PI) / 180);\n              ctx.drawImage(img, -width, 0, width, height);\n              break;\n            default:\n              setCanvasSize(width, height);\n              ctx.drawImage(img, 0, 0, width, height);\n          }\n          ctx.restore();\n        }\n        cb(canvas);\n      };\n      // 判断图片是否是base64\n      var s = this.img.substr(0, 4);\n      if (s !== "data") {\n        img.crossOrigin = "Anonymous";\n      }\n      img.src = this.imgs;\n\n      function setCanvasSize(width, height) {\n        canvas.width = Math.round(width);\n        canvas.height = Math.round(height);\n      }\n    },\n\n    // 获取转换成base64 的图片信息\n    getCropData(cb) {\n      this.getCropChecked(data => {\n        cb(data.toDataURL("image/" + this.outputType, this.outputSize));\n      });\n    },\n\n    //canvas获取为blob对象\n    getCropBlob(cb) {\n      this.getCropChecked(data => {\n        data.toBlob(\n          blob => cb(blob),\n          "image/" + this.outputType,\n          this.outputSize\n        );\n      });\n    },\n\n    // 自动预览函数\n    showPreview() {\n      // 优化不要多次触发\n      if (this.isCanShow) {\n        this.isCanShow = false;\n        setTimeout(() => {\n          this.isCanShow = true;\n        }, 16);\n      } else {\n        return false;\n      }\n      let w = this.cropW;\n      let h = this.cropH;\n      let scale = this.scale;\n      var obj = {};\n      obj.div = {\n        width: `${w}px`,\n        height: `${h}px`\n      };\n      let transformX = (this.x - this.cropOffsertX) / scale;\n      let transformY = (this.y - this.cropOffsertY) / scale;\n      let transformZ = 0;\n      obj.w = w;\n      obj.h = h;\n      obj.url = this.imgs;\n      obj.img = {\n        width: `${this.trueWidth}px`,\n        height: `${this.trueHeight}px`,\n        transform: `scale(${scale})translate3d(${transformX}px, ${transformY}px, ${transformZ}px)rotateZ(${this\n          .rotate * 90}deg)`\n      };\n      obj.html = `\n      <div class="show-preview" style="width: ${obj.w}px; height: ${\n        obj.h\n      }px; overflow: hidden">\n        <div style="width: ${w}px; height: ${h}px">\n          <img src=${obj.url} style="width: ${this.trueWidth}px; height: ${\n        this.trueHeight\n      }px; transform:\n          scale(${scale})translate3d(${transformX}px, ${transformY}px, ${transformZ}px)rotateZ(${this\n        .rotate * 90}deg)">\n        </div>\n      </div>`;\n      this.$emit("realTime", obj);\n      this.$emit("real-time", obj);\n    },\n    // reload 图片布局函数\n    reload() {\n      let img = new Image();\n      img.onload = () => {\n        // 读取图片的信息原始信息， 解析是否需要旋转\n        // 读取图片的旋转信息\n        // 得到外层容器的宽度高度\n        this.w = parseFloat(window.getComputedStyle(this.$refs.cropper).width);\n        this.h = parseFloat(window.getComputedStyle(this.$refs.cropper).height);\n\n        // 存入图片真实高度\n        this.trueWidth = img.width;\n        this.trueHeight = img.height;\n\n        // 判断是否需要压缩大图\n        if (!this.original) {\n          // 判断布局方式 mode\n          this.scale = this.checkedMode();\n        } else {\n          this.scale = 1;\n        }\n\n        this.$nextTick(() => {\n          this.x =\n            -(this.trueWidth - this.trueWidth * this.scale) / 2 +\n            (this.w - this.trueWidth * this.scale) / 2;\n          this.y =\n            -(this.trueHeight - this.trueHeight * this.scale) / 2 +\n            (this.h - this.trueHeight * this.scale) / 2;\n          this.loading = false;\n          // // 获取是否开启了自动截图\n          if (this.autoCrop) {\n            this.goAutoCrop();\n          }\n          // 图片加载成功的回调\n          this.$emit("img-load", "success");\n          this.$emit("imgLoad", "success");        \n          setTimeout(() => {\n            this.showPreview();\n          }, 20);\n        });\n      };\n      img.onerror = () => {\n        this.$emit("imgLoad", "error");\n        this.$emit("img-load", "error");\n      };\n      img.src = this.imgs;\n    },\n    // 背景布局的函数\n    checkedMode() {\n      let scale = 1;\n      // 通过字符串分割\n      let imgW = this.trueWidth;\n      let imgH = this.trueHeight;\n      const arr = this.mode.split(" ");\n      switch (arr[0]) {\n        case "contain":\n          if (this.trueWidth > this.w) {\n            // 如果图片宽度大于容器宽度\n            scale = this.w / this.trueWidth;\n          }\n\n          if (this.trueHeight * scale > this.h) {\n            scale = this.h / this.trueHeight;\n          }\n          break;\n        case "cover":\n          // 扩展布局 默认填充满整个容器\n          // 图片宽度大于容器\n          imgW = this.w;\n          scale = imgW / this.trueWidth;\n          imgH = imgH * scale;\n          // 如果扩展之后高度小于容器的外层高度 继续扩展高度\n          if (imgH < this.h) {\n            imgH = this.h;\n            scale = imgH / this.trueHeight;\n          }\n          break;\n        default:\n          try {\n            let str = arr[0];\n            if (str.search("px") !== -1) {\n              str = str.replace("px", "");\n              imgW = parseFloat(str);\n              const scaleX = imgW / this.trueWidth;\n              let scaleY = 1;\n              let strH = arr[1];\n              if (strH.search("px") !== -1) {\n                strH = strH.replace("px", "");\n                imgH = parseFloat(strH);\n                scaleY = imgH / this.trueHeight;\n              }\n              scale = Math.min(scaleX,scaleY)\n\n            }\n            if (str.search("%") !== -1) {\n              str = str.replace("%", "");\n              imgW = (parseFloat(str) / 100) * this.w;\n              scale = imgW / this.trueWidth;\n            }\n\n            if (arr.length === 2 && str === "auto") {\n              let str2 = arr[1];\n              if (str2.search("px") !== -1) {\n                str2 = str2.replace("px", "");\n                imgH = parseFloat(str2);\n                scale = imgH / this.trueHeight;\n              }\n              if (str2.search("%") !== -1) {\n                str2 = str2.replace("%", "");\n                imgH = (parseFloat(str2) / 100) * this.h;\n                scale = imgH / this.trueHeight;\n              }\n            }\n          } catch (error) {\n            scale = 1;\n          }\n      }\n      return scale;\n    },\n    // 自动截图函数\n    goAutoCrop(cw, ch) {\n      if (this.imgs === \'\' || this.imgs === null) return\n      this.clearCrop();\n      this.cropping = true;\n      let maxWidth = this.w;\n      let maxHeight = this.h;\n      if (this.centerBox) {\n        const switchWH = Math.abs(this.rotate) % 2 > 0\n        let imgW = (switchWH ? this.trueHeight : this.trueWidth) * this.scale;\n        let imgH = (switchWH ? this.trueWidth : this.trueHeight) * this.scale;\n        maxWidth = imgW < maxWidth ? imgW : maxWidth;\n        maxHeight = imgH < maxHeight ? imgH : maxHeight;\n      }\n      // 截图框默认大小\n      // 如果为0 那么计算容器大小 默认为80%\n      var w = cw ? cw : parseFloat(this.autoCropWidth);\n      var h = ch ? ch : parseFloat(this.autoCropHeight);\n      if (w === 0 || h === 0) {\n        w = maxWidth * 0.8;\n        h = maxHeight * 0.8;\n      }\n      w = w > maxWidth ? maxWidth : w;\n      h = h > maxHeight ? maxHeight : h;\n      if (this.fixed) {\n        h = (w / this.fixedNumber[0]) * this.fixedNumber[1];\n      }\n      // 如果比例之后 高度大于h\n      if (h > this.h) {\n        h = this.h;\n        w = (h / this.fixedNumber[1]) * this.fixedNumber[0];\n      }\n      this.changeCrop(w, h);\n    },\n    // 手动改变截图框大小函数\n    changeCrop(w, h) {\n      if (this.centerBox) {\n        // 修复初始化时候在centerBox=true情况下\n        let axis = this.getImgAxis();\n        if (w > axis.x2 - axis.x1) {\n          // 宽度超标\n          w = axis.x2 - axis.x1;\n          h = (w / this.fixedNumber[0]) * this.fixedNumber[1];\n        }\n        if (h > axis.y2 - axis.y1) {\n          // 高度超标\n          h = axis.y2 - axis.y1;\n          w = (h / this.fixedNumber[1]) * this.fixedNumber[0];\n        }\n      }\n      // 判断是否大于容器\n      this.cropW = w;\n      this.cropH = h;\n      this.checkCropLimitSize()\n      this.$nextTick(() => {\n        // 居中走一走\n        this.cropOffsertX = (this.w - this.cropW) / 2;\n        this.cropOffsertY = (this.h - this.cropH) / 2;\n        if (this.centerBox) {\n          this.moveCrop(null, true);\n        }\n      });\n    },\n    // 重置函数， 恢复组件置初始状态\n    refresh() {\n      let img = this.img;\n      this.imgs = "";\n      this.scale = 1;\n      this.crop = false;\n      this.rotate = 0;\n      this.w = 0;\n      this.h = 0;\n      this.trueWidth = 0;\n      this.trueHeight = 0;\n      this.clearCrop();\n      this.$nextTick(() => {\n        this.checkedImg();\n      });\n    },\n\n    // 向左边旋转\n    rotateLeft() {\n      this.rotate = this.rotate <= -3 ? 0 : this.rotate - 1;\n    },\n\n    // 向右边旋转\n    rotateRight() {\n      this.rotate = this.rotate >= 3 ? 0 : this.rotate + 1;\n    },\n\n    // 清除旋转\n    rotateClear() {\n      this.rotate = 0;\n    },\n\n    // 图片坐标点校验\n    checkoutImgAxis(x, y, scale) {\n      x = x || this.x;\n      y = y || this.y;\n      scale = scale || this.scale;\n      let canGo = true;\n      // 开始校验 如果说缩放之后的坐标在截图框外 则阻止缩放\n      if (this.centerBox) {\n        let axis = this.getImgAxis(x, y, scale);\n        let cropAxis = this.getCropAxis();\n        // 左边的横坐标 图片不能超过截图框\n        if (axis.x1 >= cropAxis.x1) {\n          canGo = false;\n        }\n\n        // 右边横坐标\n        if (axis.x2 <= cropAxis.x2) {\n          canGo = false;\n        }\n\n        // 纵坐标上面\n        if (axis.y1 >= cropAxis.y1) {\n          canGo = false;\n        }\n\n        // 纵坐标下面\n        if (axis.y2 <= cropAxis.y2) {\n          canGo = false;\n        }\n      }\n      return canGo;\n    }\n  },\n  mounted() {\n    this.support =\n      "onwheel" in document.createElement("div")\n        ? "wheel"\n        : document.onmousewheel !== undefined\n        ? "mousewheel"\n        : "DOMMouseScroll";\n    let that = this;\n    var u = navigator.userAgent;\n    this.isIOS = !!u.match(/\\(i[^;]+;( U;)? CPU.+Mac OS X/);\n    // 兼容blob\n    if (!HTMLCanvasElement.prototype.toBlob) {\n      Object.defineProperty(HTMLCanvasElement.prototype, "toBlob", {\n        value: function(callback, type, quality) {\n          var binStr = atob(this.toDataURL(type, quality).split(",")[1]),\n            len = binStr.length,\n            arr = new Uint8Array(len);\n          for (var i = 0; i < len; i++) {\n            arr[i] = binStr.charCodeAt(i);\n          }\n          callback(new Blob([arr], { type: that.type || "image/png" }));\n        }\n      });\n    }\n    this.showPreview();\n    this.checkedImg();\n  },\n  destroyed() {\n    window.removeEventListener("mousemove", this.moveCrop);\n    window.removeEventListener("mouseup", this.leaveCrop);\n    window.removeEventListener("touchmove", this.moveCrop);\n    window.removeEventListener("touchend", this.leaveCrop);\n    this.cancelScale()\n  }\n};\n<\/script>\n\n<style scoped lang="css">\n.vue-cropper {\n  position: relative;\n  width: 100%;\n  height: 100%;\n  box-sizing: border-box;\n  user-select: none;\n  -webkit-user-select: none;\n  -moz-user-select: none;\n  -ms-user-select: none;\n  direction: ltr;\n  touch-action: none;\n  text-align: left;\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQAQMAAAAlPW0iAAAAA3NCSVQICAjb4U/gAAAABlBMVEXMzMz////TjRV2AAAACXBIWXMAAArrAAAK6wGCiw1aAAAAHHRFWHRTb2Z0d2FyZQBBZG9iZSBGaXJld29ya3MgQ1M26LyyjAAAABFJREFUCJlj+M/AgBVhF/0PAH6/D/HkDxOGAAAAAElFTkSuQmCC");\n}\n\n.cropper-box,\n.cropper-box-canvas,\n.cropper-drag-box,\n.cropper-crop-box,\n.cropper-face {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  user-select: none;\n}\n\n.cropper-box-canvas img {\n  position: relative;\n  text-align: left;\n  user-select: none;\n  transform: none;\n  max-width: none;\n  max-height: none;\n}\n\n.cropper-box {\n  overflow: hidden;\n}\n\n.cropper-move {\n  cursor: move;\n}\n\n.cropper-crop {\n  cursor: crosshair;\n}\n\n.cropper-modal {\n  background: rgba(0, 0, 0, 0.5);\n}\n\n.cropper-crop-box {\n  /*border: 2px solid #39f;*/\n}\n\n.cropper-view-box {\n  display: block;\n  overflow: hidden;\n  width: 100%;\n  height: 100%;\n  outline: 1px solid #39f;\n  outline-color: rgba(51, 153, 255, 0.75);\n  user-select: none;\n}\n\n.cropper-view-box img {\n  user-select: none;\n  text-align: left;\n  max-width: none;\n  max-height: none;\n}\n\n.cropper-face {\n  top: 0;\n  left: 0;\n  background-color: #fff;\n  opacity: 0.1;\n}\n\n.crop-info {\n  position: absolute;\n  left: 0px;\n  min-width: 65px;\n  text-align: center;\n  color: white;\n  line-height: 20px;\n  background-color: rgba(0, 0, 0, 0.8);\n  font-size: 12px;\n}\n\n.crop-line {\n  position: absolute;\n  display: block;\n  width: 100%;\n  height: 100%;\n  opacity: 0.1;\n}\n\n.line-w {\n  top: -3px;\n  left: 0;\n  height: 5px;\n  cursor: n-resize;\n}\n\n.line-a {\n  top: 0;\n  left: -3px;\n  width: 5px;\n  cursor: w-resize;\n}\n\n.line-s {\n  bottom: -3px;\n  left: 0;\n  height: 5px;\n  cursor: s-resize;\n}\n\n.line-d {\n  top: 0;\n  right: -3px;\n  width: 5px;\n  cursor: e-resize;\n}\n\n.crop-point {\n  position: absolute;\n  width: 8px;\n  height: 8px;\n  opacity: 0.75;\n  background-color: #39f;\n  border-radius: 100%;\n}\n\n.point1 {\n  top: -4px;\n  left: -4px;\n  cursor: nw-resize;\n}\n\n.point2 {\n  top: -5px;\n  left: 50%;\n  margin-left: -3px;\n  cursor: n-resize;\n}\n\n.point3 {\n  top: -4px;\n  right: -4px;\n  cursor: ne-resize;\n}\n\n.point4 {\n  top: 50%;\n  left: -4px;\n  margin-top: -3px;\n  cursor: w-resize;\n}\n\n.point5 {\n  top: 50%;\n  right: -4px;\n  margin-top: -3px;\n  cursor: e-resize;\n}\n\n.point6 {\n  bottom: -5px;\n  left: -4px;\n  cursor: sw-resize;\n}\n\n.point7 {\n  bottom: -5px;\n  left: 50%;\n  margin-left: -3px;\n  cursor: s-resize;\n}\n\n.point8 {\n  bottom: -5px;\n  right: -4px;\n  cursor: se-resize;\n}\n\n@media screen and (max-width: 500px) {\n  .crop-point {\n    position: absolute;\n    width: 20px;\n    height: 20px;\n    opacity: 0.45;\n    background-color: #39f;\n    border-radius: 100%;\n  }\n\n  .point1 {\n    top: -10px;\n    left: -10px;\n  }\n\n  .point2,\n  .point4,\n  .point5,\n  .point7 {\n    display: none;\n  }\n\n  .point3 {\n    top: -10px;\n    right: -10px;\n  }\n\n  .point4 {\n    top: 0;\n    left: 0;\n  }\n\n  .point6 {\n    bottom: -10px;\n    left: -10px;\n  }\n\n  .point8 {\n    bottom: -10px;\n    right: -10px;\n  }\n}\n</style>\n'],sourceRoot:""}]);const u=p},645:t=>{t.exports=function(t){var e=[];return e.toString=function(){return this.map((function(e){var n="",i=void 0!==e[5];return e[4]&&(n+="@supports (".concat(e[4],") {")),e[2]&&(n+="@media ".concat(e[2]," {")),i&&(n+="@layer".concat(e[5].length>0?" ".concat(e[5]):""," {")),n+=t(e),i&&(n+="}"),e[2]&&(n+="}"),e[4]&&(n+="}"),n})).join("")},e.i=function(t,n,i,r,o){"string"==typeof t&&(t=[[null,t,void 0]]);var s={};if(i)for(var a=0;a<this.length;a++){var h=this[a][0];null!=h&&(s[h]=!0)}for(var c=0;c<t.length;c++){var p=[].concat(t[c]);i&&s[p[0]]||(void 0!==o&&(void 0===p[5]||(p[1]="@layer".concat(p[5].length>0?" ".concat(p[5]):""," {").concat(p[1],"}")),p[5]=o),n&&(p[2]?(p[1]="@media ".concat(p[2]," {").concat(p[1],"}"),p[2]=n):p[2]=n),r&&(p[4]?(p[1]="@supports (".concat(p[4],") {").concat(p[1],"}"),p[4]=r):p[4]="".concat(r)),e.push(p))}},e}},667:t=>{t.exports=function(t,e){return e||(e={}),t?(t=String(t.__esModule?t.default:t),/^['"].*['"]$/.test(t)&&(t=t.slice(1,-1)),e.hash&&(t+=e.hash),/["'() \t\n]|(%20)/.test(t)||e.needQuotes?'"'.concat(t.replace(/"/g,'\\"').replace(/\n/g,"\\n"),'"'):t):t}},537:t=>{t.exports=function(t){var e=t[1],n=t[3];if(!n)return e;if("function"==typeof btoa){var i=btoa(unescape(encodeURIComponent(JSON.stringify(n)))),r="sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(i),o="/*# ".concat(r," */");return[e].concat([o]).join("\n")}return[e].join("\n")}},379:t=>{var e=[];function n(t){for(var n=-1,i=0;i<e.length;i++)if(e[i].identifier===t){n=i;break}return n}function i(t,i){for(var o={},s=[],a=0;a<t.length;a++){var h=t[a],c=i.base?h[0]+i.base:h[0],p=o[c]||0,l="".concat(c," ").concat(p);o[c]=p+1;var u=n(l),g={css:h[1],media:h[2],sourceMap:h[3],supports:h[4],layer:h[5]};if(-1!==u)e[u].references++,e[u].updater(g);else{var f=r(g,i);i.byIndex=a,e.splice(a,0,{identifier:l,updater:f,references:1})}s.push(l)}return s}function r(t,e){var n=e.domAPI(e);return n.update(t),function(e){if(e){if(e.css===t.css&&e.media===t.media&&e.sourceMap===t.sourceMap&&e.supports===t.supports&&e.layer===t.layer)return;n.update(t=e)}else n.remove()}}t.exports=function(t,r){var o=i(t=t||[],r=r||{});return function(t){t=t||[];for(var s=0;s<o.length;s++){var a=n(o[s]);e[a].references--}for(var h=i(t,r),c=0;c<o.length;c++){var p=n(o[c]);0===e[p].references&&(e[p].updater(),e.splice(p,1))}o=h}}},569:t=>{var e={};t.exports=function(t,n){var i=function(t){if(void 0===e[t]){var n=document.querySelector(t);if(window.HTMLIFrameElement&&n instanceof window.HTMLIFrameElement)try{n=n.contentDocument.head}catch(t){n=null}e[t]=n}return e[t]}(t);if(!i)throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");i.appendChild(n)}},216:t=>{t.exports=function(t){var e=document.createElement("style");return t.setAttributes(e,t.attributes),t.insert(e,t.options),e}},565:(t,e,n)=>{t.exports=function(t){var e=n.nc;e&&t.setAttribute("nonce",e)}},795:t=>{t.exports=function(t){if("undefined"==typeof document)return{update:function(){},remove:function(){}};var e=t.insertStyleElement(t);return{update:function(n){!function(t,e,n){var i="";n.supports&&(i+="@supports (".concat(n.supports,") {")),n.media&&(i+="@media ".concat(n.media," {"));var r=void 0!==n.layer;r&&(i+="@layer".concat(n.layer.length>0?" ".concat(n.layer):""," {")),i+=n.css,r&&(i+="}"),n.media&&(i+="}"),n.supports&&(i+="}");var o=n.sourceMap;o&&"undefined"!=typeof btoa&&(i+="\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(o))))," */")),e.styleTagTransform(i,t,e.options)}(e,t,n)},remove:function(){!function(t){if(null===t.parentNode)return!1;t.parentNode.removeChild(t)}(e)}}}},589:t=>{t.exports=function(t,e){if(e.styleSheet)e.styleSheet.cssText=t;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(t))}}},738:t=>{t.exports="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQAQMAAAAlPW0iAAAAA3NCSVQICAjb4U/gAAAABlBMVEXMzMz////TjRV2AAAACXBIWXMAAArrAAAK6wGCiw1aAAAAHHRFWHRTb2Z0d2FyZQBBZG9iZSBGaXJld29ya3MgQ1M26LyyjAAAABFJREFUCJlj+M/AgBVhF/0PAH6/D/HkDxOGAAAAAElFTkSuQmCC"}},e={};function n(i){var r=e[i];if(void 0!==r)return r.exports;var o=e[i]={id:i,exports:{}};return t[i](o,o.exports,n),o.exports}n.m=t,n.n=t=>{var e=t&&t.__esModule?()=>t.default:()=>t;return n.d(e,{a:e}),e},n.d=(t,e)=>{for(var i in e)n.o(e,i)&&!n.o(t,i)&&Object.defineProperty(t,i,{enumerable:!0,get:e[i]})},n.o=(t,e)=>Object.prototype.hasOwnProperty.call(t,e),n.r=t=>{"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(t,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(t,"__esModule",{value:!0})},n.b=document.baseURI||self.location.href,n.nc=void 0;var i={};return(()=>{n.r(i),n.d(i,{VueCropper:()=>y,default:()=>W});var t=function(){var t=this,e=t._self._c;return e("div",{ref:"cropper",staticClass:"vue-cropper",on:{mouseover:t.scaleImg,mouseout:t.cancelScale}},[t.imgs?e("div",{staticClass:"cropper-box"},[e("div",{directives:[{name:"show",rawName:"v-show",value:!t.loading,expression:"!loading"}],staticClass:"cropper-box-canvas",style:{width:t.trueWidth+"px",height:t.trueHeight+"px",transform:"scale("+t.scale+","+t.scale+") translate3d("+t.x/t.scale+"px,"+t.y/t.scale+"px,0)rotateZ("+90*t.rotate+"deg)"}},[e("img",{ref:"cropperImg",attrs:{src:t.imgs,alt:"cropper-img"}})])]):t._e(),t._v(" "),e("div",{staticClass:"cropper-drag-box",class:{"cropper-move":t.move&&!t.crop,"cropper-crop":t.crop,"cropper-modal":t.cropping},on:{mousedown:t.startMove,touchstart:t.startMove}}),t._v(" "),e("div",{directives:[{name:"show",rawName:"v-show",value:t.cropping,expression:"cropping"}],staticClass:"cropper-crop-box",style:{width:t.cropW+"px",height:t.cropH+"px",transform:"translate3d("+t.cropOffsertX+"px,"+t.cropOffsertY+"px,0)"}},[e("span",{staticClass:"cropper-view-box"},[e("img",{style:{width:t.trueWidth+"px",height:t.trueHeight+"px",transform:"scale("+t.scale+","+t.scale+") translate3d("+(t.x-t.cropOffsertX)/t.scale+"px,"+(t.y-t.cropOffsertY)/t.scale+"px,0)rotateZ("+90*t.rotate+"deg)"},attrs:{src:t.imgs,alt:"cropper-img"}})]),t._v(" "),e("span",{staticClass:"cropper-face cropper-move",on:{mousedown:t.cropMove,touchstart:t.cropMove}}),t._v(" "),t.info?e("span",{staticClass:"crop-info",style:{top:t.cropInfo.top}},[t._v(t._s(t.cropInfo.width)+" × "+t._s(t.cropInfo.height))]):t._e(),t._v(" "),t.fixedBox?t._e():e("span",[e("span",{staticClass:"crop-line line-w",on:{mousedown:function(e){return t.changeCropSize(e,!1,!0,0,1)},touchstart:function(e){return t.changeCropSize(e,!1,!0,0,1)}}}),t._v(" "),e("span",{staticClass:"crop-line line-a",on:{mousedown:function(e){return t.changeCropSize(e,!0,!1,1,0)},touchstart:function(e){return t.changeCropSize(e,!0,!1,1,0)}}}),t._v(" "),e("span",{staticClass:"crop-line line-s",on:{mousedown:function(e){return t.changeCropSize(e,!1,!0,0,2)},touchstart:function(e){return t.changeCropSize(e,!1,!0,0,2)}}}),t._v(" "),e("span",{staticClass:"crop-line line-d",on:{mousedown:function(e){return t.changeCropSize(e,!0,!1,2,0)},touchstart:function(e){return t.changeCropSize(e,!0,!1,2,0)}}}),t._v(" "),e("span",{staticClass:"crop-point point1",on:{mousedown:function(e){return t.changeCropSize(e,!0,!0,1,1)},touchstart:function(e){return t.changeCropSize(e,!0,!0,1,1)}}}),t._v(" "),e("span",{staticClass:"crop-point point2",on:{mousedown:function(e){return t.changeCropSize(e,!1,!0,0,1)},touchstart:function(e){return t.changeCropSize(e,!1,!0,0,1)}}}),t._v(" "),e("span",{staticClass:"crop-point point3",on:{mousedown:function(e){return t.changeCropSize(e,!0,!0,2,1)},touchstart:function(e){return t.changeCropSize(e,!0,!0,2,1)}}}),t._v(" "),e("span",{staticClass:"crop-point point4",on:{mousedown:function(e){return t.changeCropSize(e,!0,!1,1,0)},touchstart:function(e){return t.changeCropSize(e,!0,!1,1,0)}}}),t._v(" "),e("span",{staticClass:"crop-point point5",on:{mousedown:function(e){return t.changeCropSize(e,!0,!1,2,0)},touchstart:function(e){return t.changeCropSize(e,!0,!1,2,0)}}}),t._v(" "),e("span",{staticClass:"crop-point point6",on:{mousedown:function(e){return t.changeCropSize(e,!0,!0,1,2)},touchstart:function(e){return t.changeCropSize(e,!0,!0,1,2)}}}),t._v(" "),e("span",{staticClass:"crop-point point7",on:{mousedown:function(e){return t.changeCropSize(e,!1,!0,0,2)},touchstart:function(e){return t.changeCropSize(e,!1,!0,0,2)}}}),t._v(" "),e("span",{staticClass:"crop-point point8",on:{mousedown:function(e){return t.changeCropSize(e,!0,!0,2,2)},touchstart:function(e){return t.changeCropSize(e,!0,!0,2,2)}}})])])])};function e(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function r(t,n){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var n=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=n){var i,r,o,s,a=[],h=!0,c=!1;try{if(o=(n=n.call(t)).next,0===e){if(Object(n)!==n)return;h=!1}else for(;!(h=(i=o.call(n)).done)&&(a.push(i.value),a.length!==e);h=!0);}catch(t){c=!0,r=t}finally{try{if(!h&&null!=n.return&&(s=n.return(),Object(s)!==s))return}finally{if(c)throw r}}return a}}(t,n)||function(t,n){if(t){if("string"==typeof t)return e(t,n);var i=Object.prototype.toString.call(t).slice(8,-1);return"Object"===i&&t.constructor&&(i=t.constructor.name),"Map"===i||"Set"===i?Array.from(t):"Arguments"===i||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(i)?e(t,n):void 0}}(t,n)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}t._withStripped=!0;var o={};o.getData=function(t){return new Promise((function(e,n){var i={};(function(t){var e=null;return new Promise((function(n,i){if(t.src)if(/^data\:/i.test(t.src))e=function(t,e){e=e||t.match(/^data\:([^\;]+)\;base64,/im)[1]||"",t=t.replace(/^data\:([^\;]+)\;base64,/gim,"");for(var n=atob(t),i=n.length%2==0?n.length:n.length+1,r=new ArrayBuffer(i),o=new Uint16Array(r),s=0;s<i;s++)o[s]=n.charCodeAt(s);return r}(t.src),n(e);else if(/^blob\:/i.test(t.src)){var r=new FileReader;r.onload=function(t){e=t.target.result,n(e)},function(t,e){var n=new XMLHttpRequest;n.open("GET",t,!0),n.responseType="blob",n.onload=function(t){var e;200!=this.status&&0!==this.status||(e=this.response,r.readAsArrayBuffer(e))},n.send()}(t.src)}else{var o=new XMLHttpRequest;o.onload=function(){if(200!=this.status&&0!==this.status)throw"Could not load image";e=o.response,n(e),o=null},o.open("GET",t.src,!0),o.responseType="arraybuffer",o.send(null)}else i("img error")}))})(t).then((function(t){i.arrayBuffer=t;try{i.orientation=function(t){var e,n,i,r,o,s,a,h,c,p=new DataView(t),l=p.byteLength;if(255===p.getUint8(0)&&216===p.getUint8(1))for(h=2;h<l;){if(255===p.getUint8(h)&&225===p.getUint8(h+1)){s=h;break}h++}if(s&&(n=s+10,"Exif"===function(t,e,n){var i,r="";for(i=e,n+=e;i<n;i++)r+=String.fromCharCode(t.getUint8(i));return r}(p,s+4,4)&&((r=18761===(o=p.getUint16(n)))||19789===o)&&42===p.getUint16(n+2,r)&&(i=p.getUint32(n+4,r))>=8&&(a=n+i)),a)for(l=p.getUint16(a,r),c=0;c<l;c++)if(h=a+12*c+2,274===p.getUint16(h,r)){h+=8,e=p.getUint16(h,r);break}return e}(t)}catch(t){i.orientation=-1}e(i)})).catch((function(t){n(t)}))}))};const s=o,a={data:function(){return{w:0,h:0,scale:1,x:0,y:0,loading:!0,trueWidth:0,trueHeight:0,move:!0,moveX:0,moveY:0,crop:!1,cropping:!1,cropW:0,cropH:0,cropOldW:0,cropOldH:0,canChangeX:!1,canChangeY:!1,changeCropTypeX:1,changeCropTypeY:1,cropX:0,cropY:0,cropChangeX:0,cropChangeY:0,cropOffsertX:0,cropOffsertY:0,support:"",touches:[],touchNow:!1,rotate:0,isIos:!1,orientation:0,imgs:"",coe:.2,scaling:!1,scalingSet:"",coeStatus:"",isCanShow:!0}},props:{img:{type:[String,Blob,null,File],default:""},outputSize:{type:Number,default:1},outputType:{type:String,default:"jpeg"},info:{type:Boolean,default:!0},canScale:{type:Boolean,default:!0},autoCrop:{type:Boolean,default:!1},autoCropWidth:{type:[Number,String],default:0},autoCropHeight:{type:[Number,String],default:0},fixed:{type:Boolean,default:!1},fixedNumber:{type:Array,default:function(){return[1,1]}},fixedBox:{type:Boolean,default:!1},full:{type:Boolean,default:!1},canMove:{type:Boolean,default:!0},canMoveBox:{type:Boolean,default:!0},original:{type:Boolean,default:!1},centerBox:{type:Boolean,default:!1},high:{type:Boolean,default:!0},infoTrue:{type:Boolean,default:!1},maxImgSize:{type:[Number,String],default:2e3},enlarge:{type:[Number,String],default:1},preW:{type:[Number,String],default:0},mode:{type:String,default:"contain"},limitMinSize:{type:[Number,Array,String],default:function(){return 10},validator:function(t){return Array.isArray(t)?Number(t[0])>=0&&Number(t[1])>=0:Number(t)>=0}},fillColor:{type:String,default:""}},computed:{cropInfo:function(){var t={};if(t.top=this.cropOffsertY>21?"-21px":"0px",t.width=this.cropW>0?this.cropW:0,t.height=this.cropH>0?this.cropH:0,this.infoTrue){var e=1;this.high&&!this.full&&(e=window.devicePixelRatio),1!==this.enlarge&!this.full&&(e=Math.abs(Number(this.enlarge))),t.width=t.width*e,t.height=t.height*e,this.full&&(t.width=t.width/this.scale,t.height=t.height/this.scale)}return t.width=t.width.toFixed(0),t.height=t.height.toFixed(0),t},isIE:function(){return navigator.userAgent,!!window.ActiveXObject||"ActiveXObject"in window},passive:function(){return this.isIE?null:{passive:!1}}},watch:{img:function(){this.checkedImg()},imgs:function(t){""!==t&&this.reload()},cropW:function(){this.showPreview()},cropH:function(){this.showPreview()},cropOffsertX:function(){this.showPreview()},cropOffsertY:function(){this.showPreview()},scale:function(t,e){this.showPreview()},x:function(){this.showPreview()},y:function(){this.showPreview()},autoCrop:function(t){t&&this.goAutoCrop()},autoCropWidth:function(){this.autoCrop&&this.goAutoCrop()},autoCropHeight:function(){this.autoCrop&&this.goAutoCrop()},mode:function(){this.checkedImg()},rotate:function(){this.showPreview(),(this.autoCrop||this.cropW>0||this.cropH>0)&&this.goAutoCrop(this.cropW,this.cropH)}},methods:{getVersion:function(t){for(var e=navigator.userAgent.split(" "),n="",i=new RegExp(t,"i"),r=0;r<e.length;r++)i.test(e[r])&&(n=e[r]);return n?n.split("/")[1].split("."):["0","0","0"]},checkOrientationImage:function(t,e,n,i){var r=this;if(this.getVersion("chrome")[0]>=81)e=-1;else if(this.getVersion("safari")[0]>=605){var o=this.getVersion("version");o[0]>13&&o[1]>1&&(e=-1)}else{var s=navigator.userAgent.toLowerCase().match(/cpu iphone os (.*?) like mac os/);if(s){var a=s[1];((a=a.split("_"))[0]>13||a[0]>=13&&a[1]>=4)&&(e=-1)}}var h=document.createElement("canvas"),c=h.getContext("2d");switch(c.save(),e){case 2:h.width=n,h.height=i,c.translate(n,0),c.scale(-1,1);break;case 3:h.width=n,h.height=i,c.translate(n/2,i/2),c.rotate(180*Math.PI/180),c.translate(-n/2,-i/2);break;case 4:h.width=n,h.height=i,c.translate(0,i),c.scale(1,-1);break;case 5:h.height=n,h.width=i,c.rotate(.5*Math.PI),c.scale(1,-1);break;case 6:h.width=i,h.height=n,c.translate(i/2,n/2),c.rotate(90*Math.PI/180),c.translate(-n/2,-i/2);break;case 7:h.height=n,h.width=i,c.rotate(.5*Math.PI),c.translate(n,-i),c.scale(-1,1);break;case 8:h.height=n,h.width=i,c.translate(i/2,n/2),c.rotate(-90*Math.PI/180),c.translate(-n/2,-i/2);break;default:h.width=n,h.height=i}c.drawImage(t,0,0,n,i),c.restore(),h.toBlob((function(t){var e=URL.createObjectURL(t);URL.revokeObjectURL(r.imgs),r.imgs=e}),"image/"+this.outputType,1)},checkedImg:function(){var t=this;if(null===this.img||""===this.img)return this.imgs="",void this.clearCrop();this.loading=!0,this.scale=1,this.rotate=0,this.clearCrop();var e=new Image;if(e.onload=function(){if(""===t.img)return t.$emit("imgLoad","error"),t.$emit("img-load","error"),t.$emit("img-load",new Error("图片不能为空")),!1;var n=e.width,i=e.height;s.getData(e).then((function(r){t.orientation=r.orientation||1;var o=Number(t.maxImgSize);!t.orientation&&n<o&i<o?t.imgs=t.img:(n>o&&(i=i/n*o,n=o),i>o&&(n=n/i*o,i=o),t.checkOrientationImage(e,t.orientation,n,i))})).catch((function(e){t.$emit("img-load","error"),t.$emit("img-load-error",e)}))},e.onerror=function(){t.$emit("imgLoad","error"),t.$emit("img-load","error"),t.$emit("img-load-error",error)},"data"!==this.img.substr(0,4)&&(e.crossOrigin=""),this.isIE){var n=new XMLHttpRequest;n.onload=function(){var t=URL.createObjectURL(this.response);e.src=t},n.open("GET",this.img,!0),n.responseType="blob",n.send()}else e.src=this.img},startMove:function(t){if(t.preventDefault(),this.move&&!this.crop){if(!this.canMove)return!1;this.moveX=("clientX"in t?t.clientX:t.touches[0].clientX)-this.x,this.moveY=("clientY"in t?t.clientY:t.touches[0].clientY)-this.y,t.touches?(window.addEventListener("touchmove",this.moveImg),window.addEventListener("touchend",this.leaveImg),2==t.touches.length&&(this.touches=t.touches,window.addEventListener("touchmove",this.touchScale),window.addEventListener("touchend",this.cancelTouchScale))):(window.addEventListener("mousemove",this.moveImg),window.addEventListener("mouseup",this.leaveImg)),this.$emit("imgMoving",{moving:!0,axis:this.getImgAxis()}),this.$emit("img-moving",{moving:!0,axis:this.getImgAxis()})}else this.cropping=!0,window.addEventListener("mousemove",this.createCrop),window.addEventListener("mouseup",this.endCrop),window.addEventListener("touchmove",this.createCrop),window.addEventListener("touchend",this.endCrop),this.cropOffsertX=t.offsetX?t.offsetX:t.touches[0].pageX-this.$refs.cropper.offsetLeft,this.cropOffsertY=t.offsetY?t.offsetY:t.touches[0].pageY-this.$refs.cropper.offsetTop,this.cropX="clientX"in t?t.clientX:t.touches[0].clientX,this.cropY="clientY"in t?t.clientY:t.touches[0].clientY,this.cropChangeX=this.cropOffsertX,this.cropChangeY=this.cropOffsertY,this.cropW=0,this.cropH=0},touchScale:function(t){var e=this;t.preventDefault();var n=this.scale,i=this.touches[0].clientX,r=this.touches[0].clientY,o=t.touches[0].clientX,s=t.touches[0].clientY,a=this.touches[1].clientX,h=this.touches[1].clientY,c=t.touches[1].clientX,p=t.touches[1].clientY,l=Math.sqrt(Math.pow(i-a,2)+Math.pow(r-h,2)),u=Math.sqrt(Math.pow(o-c,2)+Math.pow(s-p,2))-l,g=1,f=(g=(g=g/this.trueWidth>g/this.trueHeight?g/this.trueHeight:g/this.trueWidth)>.1?.1:g)*u;if(!this.touchNow){if(this.touchNow=!0,u>0?n+=Math.abs(f):u<0&&n>Math.abs(f)&&(n-=Math.abs(f)),this.touches=t.touches,setTimeout((function(){e.touchNow=!1}),8),!this.checkoutImgAxis(this.x,this.y,n))return!1;this.scale=n}},cancelTouchScale:function(t){window.removeEventListener("touchmove",this.touchScale)},moveImg:function(t){var e=this;if(t.preventDefault(),t.touches&&2===t.touches.length)return this.touches=t.touches,window.addEventListener("touchmove",this.touchScale),window.addEventListener("touchend",this.cancelTouchScale),window.removeEventListener("touchmove",this.moveImg),!1;var n,i,r="clientX"in t?t.clientX:t.touches[0].clientX,o="clientY"in t?t.clientY:t.touches[0].clientY;n=r-this.moveX,i=o-this.moveY,this.$nextTick((function(){if(e.centerBox){var t,r,o,s,a=e.getImgAxis(n,i,e.scale),h=e.getCropAxis(),c=e.trueHeight*e.scale,p=e.trueWidth*e.scale;switch(e.rotate){case 1:case-1:case 3:case-3:t=e.cropOffsertX-e.trueWidth*(1-e.scale)/2+(c-p)/2,r=e.cropOffsertY-e.trueHeight*(1-e.scale)/2+(p-c)/2,o=t-c+e.cropW,s=r-p+e.cropH;break;default:t=e.cropOffsertX-e.trueWidth*(1-e.scale)/2,r=e.cropOffsertY-e.trueHeight*(1-e.scale)/2,o=t-p+e.cropW,s=r-c+e.cropH}a.x1>=h.x1&&(n=t),a.y1>=h.y1&&(i=r),a.x2<=h.x2&&(n=o),a.y2<=h.y2&&(i=s)}e.x=n,e.y=i,e.$emit("imgMoving",{moving:!0,axis:e.getImgAxis()}),e.$emit("img-moving",{moving:!0,axis:e.getImgAxis()})}))},leaveImg:function(t){window.removeEventListener("mousemove",this.moveImg),window.removeEventListener("touchmove",this.moveImg),window.removeEventListener("mouseup",this.leaveImg),window.removeEventListener("touchend",this.leaveImg),this.$emit("imgMoving",{moving:!1,axis:this.getImgAxis()}),this.$emit("img-moving",{moving:!1,axis:this.getImgAxis()})},scaleImg:function(){this.canScale&&window.addEventListener(this.support,this.changeSize,this.passive)},cancelScale:function(){this.canScale&&window.removeEventListener(this.support,this.changeSize)},changeSize:function(t){var e=this;t.preventDefault();var n=this.scale,i=t.deltaY||t.wheelDelta;i=navigator.userAgent.indexOf("Firefox")>0?30*i:i,this.isIE&&(i=-i);var r=this.coe,o=(r=r/this.trueWidth>r/this.trueHeight?r/this.trueHeight:r/this.trueWidth)*i;o<0?n+=Math.abs(o):n>Math.abs(o)&&(n-=Math.abs(o));var s=o<0?"add":"reduce";if(s!==this.coeStatus&&(this.coeStatus=s,this.coe=.2),this.scaling||(this.scalingSet=setTimeout((function(){e.scaling=!1,e.coe=e.coe+=.01}),50)),this.scaling=!0,!this.checkoutImgAxis(this.x,this.y,n))return!1;this.scale=n},changeScale:function(t){var e=this.scale;t=t||1;var n=20;if((t*=n=n/this.trueWidth>n/this.trueHeight?n/this.trueHeight:n/this.trueWidth)>0?e+=Math.abs(t):e>Math.abs(t)&&(e-=Math.abs(t)),!this.checkoutImgAxis(this.x,this.y,e))return!1;this.scale=e},createCrop:function(t){var e=this;t.preventDefault();var n="clientX"in t?t.clientX:t.touches?t.touches[0].clientX:0,i="clientY"in t?t.clientY:t.touches?t.touches[0].clientY:0;this.$nextTick((function(){var t=n-e.cropX,r=i-e.cropY;if(t>0?(e.cropW=t+e.cropChangeX>e.w?e.w-e.cropChangeX:t,e.cropOffsertX=e.cropChangeX):(e.cropW=e.w-e.cropChangeX+Math.abs(t)>e.w?e.cropChangeX:Math.abs(t),e.cropOffsertX=e.cropChangeX+t>0?e.cropChangeX+t:0),e.fixed){var o=e.cropW/e.fixedNumber[0]*e.fixedNumber[1];o+e.cropOffsertY>e.h?(e.cropH=e.h-e.cropOffsertY,e.cropW=e.cropH/e.fixedNumber[1]*e.fixedNumber[0],e.cropOffsertX=t>0?e.cropChangeX:e.cropChangeX-e.cropW):e.cropH=o,e.cropOffsertY=e.cropOffsertY}else r>0?(e.cropH=r+e.cropChangeY>e.h?e.h-e.cropChangeY:r,e.cropOffsertY=e.cropChangeY):(e.cropH=e.h-e.cropChangeY+Math.abs(r)>e.h?e.cropChangeY:Math.abs(r),e.cropOffsertY=e.cropChangeY+r>0?e.cropChangeY+r:0)}))},changeCropSize:function(t,e,n,i,r){t.preventDefault(),window.addEventListener("mousemove",this.changeCropNow),window.addEventListener("mouseup",this.changeCropEnd),window.addEventListener("touchmove",this.changeCropNow),window.addEventListener("touchend",this.changeCropEnd),this.canChangeX=e,this.canChangeY=n,this.changeCropTypeX=i,this.changeCropTypeY=r,this.cropX="clientX"in t?t.clientX:t.touches[0].clientX,this.cropY="clientY"in t?t.clientY:t.touches[0].clientY,this.cropOldW=this.cropW,this.cropOldH=this.cropH,this.cropChangeX=this.cropOffsertX,this.cropChangeY=this.cropOffsertY,this.fixed&&this.canChangeX&&this.canChangeY&&(this.canChangeY=0),this.$emit("changeCropSize",{width:this.cropW,height:this.cropH}),this.$emit("change-crop-size",{width:this.cropW,height:this.cropH})},changeCropNow:function(t){var e=this;t.preventDefault();var n="clientX"in t?t.clientX:t.touches?t.touches[0].clientX:0,i="clientY"in t?t.clientY:t.touches?t.touches[0].clientY:0,o=this.w,s=this.h,a=0,h=0;if(this.centerBox){var c=this.getImgAxis(),p=c.x2,l=c.y2;a=c.x1>0?c.x1:0,h=c.y1>0?c.y1:0,o>p&&(o=p),s>l&&(s=l)}var u=r(this.checkCropLimitSize(),2),g=u[0],f=u[1];this.$nextTick((function(){var t=n-e.cropX,r=i-e.cropY;if(e.canChangeX&&(1===e.changeCropTypeX?e.cropOldW-t<g?(e.cropW=g,e.cropOffsertX=e.cropOldW+e.cropChangeX-a-g):e.cropOldW-t>0?(e.cropW=o-e.cropChangeX-t<=o-a?e.cropOldW-t:e.cropOldW+e.cropChangeX-a,e.cropOffsertX=o-e.cropChangeX-t<=o-a?e.cropChangeX+t:a):(e.cropW=Math.abs(t)+e.cropChangeX<=o?Math.abs(t)-e.cropOldW:o-e.cropOldW-e.cropChangeX,e.cropOffsertX=e.cropChangeX+e.cropOldW):2===e.changeCropTypeX&&(e.cropOldW+t<g?e.cropW=g:e.cropOldW+t>0?(e.cropW=e.cropOldW+t+e.cropOffsertX<=o?e.cropOldW+t:o-e.cropOffsertX,e.cropOffsertX=e.cropChangeX):(e.cropW=o-e.cropChangeX+Math.abs(t+e.cropOldW)<=o-a?Math.abs(t+e.cropOldW):e.cropChangeX-a,e.cropOffsertX=o-e.cropChangeX+Math.abs(t+e.cropOldW)<=o-a?e.cropChangeX-Math.abs(t+e.cropOldW):a))),e.canChangeY&&(1===e.changeCropTypeY?e.cropOldH-r<f?(e.cropH=f,e.cropOffsertY=e.cropOldH+e.cropChangeY-h-f):e.cropOldH-r>0?(e.cropH=s-e.cropChangeY-r<=s-h?e.cropOldH-r:e.cropOldH+e.cropChangeY-h,e.cropOffsertY=s-e.cropChangeY-r<=s-h?e.cropChangeY+r:h):(e.cropH=Math.abs(r)+e.cropChangeY<=s?Math.abs(r)-e.cropOldH:s-e.cropOldH-e.cropChangeY,e.cropOffsertY=e.cropChangeY+e.cropOldH):2===e.changeCropTypeY&&(e.cropOldH+r<f?e.cropH=f:e.cropOldH+r>0?(e.cropH=e.cropOldH+r+e.cropOffsertY<=s?e.cropOldH+r:s-e.cropOffsertY,e.cropOffsertY=e.cropChangeY):(e.cropH=s-e.cropChangeY+Math.abs(r+e.cropOldH)<=s-h?Math.abs(r+e.cropOldH):e.cropChangeY-h,e.cropOffsertY=s-e.cropChangeY+Math.abs(r+e.cropOldH)<=s-h?e.cropChangeY-Math.abs(r+e.cropOldH):h))),e.canChangeX&&e.fixed){var c=e.cropW/e.fixedNumber[0]*e.fixedNumber[1];c<f?(e.cropH=f,e.cropW=e.fixedNumber[0]*f/e.fixedNumber[1],1===e.changeCropTypeX&&(e.cropOffsertX=e.cropChangeX+(e.cropOldW-e.cropW))):c+e.cropOffsertY>s?(e.cropH=s-e.cropOffsertY,e.cropW=e.cropH/e.fixedNumber[1]*e.fixedNumber[0],1===e.changeCropTypeX&&(e.cropOffsertX=e.cropChangeX+(e.cropOldW-e.cropW))):e.cropH=c}if(e.canChangeY&&e.fixed){var p=e.cropH/e.fixedNumber[1]*e.fixedNumber[0];p<g?(e.cropW=g,e.cropH=e.fixedNumber[1]*g/e.fixedNumber[0]):p+e.cropOffsertX>o?(e.cropW=o-e.cropOffsertX,e.cropH=e.cropW/e.fixedNumber[0]*e.fixedNumber[1]):e.cropW=p}e.$emit("cropSizing",{cropW:e.cropW,cropH:e.cropH}),e.$emit("crop-sizing",{cropW:e.cropW,cropH:e.cropH})}))},checkCropLimitSize:function(){this.cropW,this.cropH;var t=this.limitMinSize,e=new Array;return e=Array.isArray(t)?t:[t,t],[parseFloat(e[0]),parseFloat(e[1])]},changeCropEnd:function(t){window.removeEventListener("mousemove",this.changeCropNow),window.removeEventListener("mouseup",this.changeCropEnd),window.removeEventListener("touchmove",this.changeCropNow),window.removeEventListener("touchend",this.changeCropEnd)},calculateSize:function(t,e,n,i,r,o){var s=t/e,a=r,h=o;return a<n&&(a=n,h=Math.ceil(a/s)),h<i&&(h=i,(a=Math.ceil(h*s))<n&&(a=n,h=Math.ceil(a/s))),a<r&&(a=r,h=Math.ceil(a/s)),h<o&&(h=o,a=Math.ceil(h*s)),{width:a,height:h}},endCrop:function(){0===this.cropW&&0===this.cropH&&(this.cropping=!1);var t=r(this.checkCropLimitSize(),2),e=t[0],n=t[1],i=this.fixed?this.calculateSize(this.fixedNumber[0],this.fixedNumber[1],e,n,this.cropW,this.cropH):{width:e,height:n},o=i.width,s=i.height;o>this.cropW&&(this.cropW=o,this.cropOffsertX+o>this.w&&(this.cropOffsertX=this.w-o)),s>this.cropH&&(this.cropH=s,this.cropOffsertY+s>this.h&&(this.cropOffsertY=this.h-s)),window.removeEventListener("mousemove",this.createCrop),window.removeEventListener("mouseup",this.endCrop),window.removeEventListener("touchmove",this.createCrop),window.removeEventListener("touchend",this.endCrop)},startCrop:function(){this.crop=!0},stopCrop:function(){this.crop=!1},clearCrop:function(){this.cropping=!1,this.cropW=0,this.cropH=0},cropMove:function(t){if(t.preventDefault(),!this.canMoveBox)return this.crop=!1,this.startMove(t),!1;if(t.touches&&2===t.touches.length)return this.crop=!1,this.startMove(t),this.leaveCrop(),!1;window.addEventListener("mousemove",this.moveCrop),window.addEventListener("mouseup",this.leaveCrop),window.addEventListener("touchmove",this.moveCrop),window.addEventListener("touchend",this.leaveCrop);var e,n,i="clientX"in t?t.clientX:t.touches[0].clientX,r="clientY"in t?t.clientY:t.touches[0].clientY;e=i-this.cropOffsertX,n=r-this.cropOffsertY,this.cropX=e,this.cropY=n,this.$emit("cropMoving",{moving:!0,axis:this.getCropAxis()}),this.$emit("crop-moving",{moving:!0,axis:this.getCropAxis()})},moveCrop:function(t,e){var n=this,i=0,r=0;t&&(t.preventDefault(),i="clientX"in t?t.clientX:t.touches[0].clientX,r="clientY"in t?t.clientY:t.touches[0].clientY),this.$nextTick((function(){var t,o,s=i-n.cropX,a=r-n.cropY;if(e&&(s=n.cropOffsertX,a=n.cropOffsertY),t=s<=0?0:s+n.cropW>n.w?n.w-n.cropW:s,o=a<=0?0:a+n.cropH>n.h?n.h-n.cropH:a,n.centerBox){var h=n.getImgAxis();t<=h.x1&&(t=h.x1),t+n.cropW>h.x2&&(t=h.x2-n.cropW),o<=h.y1&&(o=h.y1),o+n.cropH>h.y2&&(o=h.y2-n.cropH)}n.cropOffsertX=t,n.cropOffsertY=o,n.$emit("cropMoving",{moving:!0,axis:n.getCropAxis()}),n.$emit("crop-moving",{moving:!0,axis:n.getCropAxis()})}))},getImgAxis:function(t,e,n){t=t||this.x,e=e||this.y,n=n||this.scale;var i={x1:0,x2:0,y1:0,y2:0},r=this.trueWidth*n,o=this.trueHeight*n;switch(this.rotate){case 0:i.x1=t+this.trueWidth*(1-n)/2,i.x2=i.x1+this.trueWidth*n,i.y1=e+this.trueHeight*(1-n)/2,i.y2=i.y1+this.trueHeight*n;break;case 1:case-1:case 3:case-3:i.x1=t+this.trueWidth*(1-n)/2+(r-o)/2,i.x2=i.x1+this.trueHeight*n,i.y1=e+this.trueHeight*(1-n)/2+(o-r)/2,i.y2=i.y1+this.trueWidth*n;break;default:i.x1=t+this.trueWidth*(1-n)/2,i.x2=i.x1+this.trueWidth*n,i.y1=e+this.trueHeight*(1-n)/2,i.y2=i.y1+this.trueHeight*n}return i},getCropAxis:function(){var t={x1:0,x2:0,y1:0,y2:0};return t.x1=this.cropOffsertX,t.x2=t.x1+this.cropW,t.y1=this.cropOffsertY,t.y2=t.y1+this.cropH,t},leaveCrop:function(t){window.removeEventListener("mousemove",this.moveCrop),window.removeEventListener("mouseup",this.leaveCrop),window.removeEventListener("touchmove",this.moveCrop),window.removeEventListener("touchend",this.leaveCrop),this.$emit("cropMoving",{moving:!1,axis:this.getCropAxis()}),this.$emit("crop-moving",{moving:!1,axis:this.getCropAxis()})},getCropChecked:function(t){var e=this,n=document.createElement("canvas"),i=new Image,r=this.rotate,o=this.trueWidth,s=this.trueHeight,a=this.cropOffsertX,h=this.cropOffsertY;function c(t,e){n.width=Math.round(t),n.height=Math.round(e)}i.onload=function(){if(0!==e.cropW){var p=n.getContext("2d"),l=1;e.high&!e.full&&(l=window.devicePixelRatio),1!==e.enlarge&!e.full&&(l=Math.abs(Number(e.enlarge)));var u=e.cropW*l,g=e.cropH*l,f=o*e.scale*l,d=s*e.scale*l,m=(e.x-a+e.trueWidth*(1-e.scale)/2)*l,A=(e.y-h+e.trueHeight*(1-e.scale)/2)*l;switch(c(u,g),p.save(),e.fillColor&&(p.fillStyle=e.fillColor,p.fillRect(0,0,n.width,n.height)),r){case 0:e.full?(c(u/e.scale,g/e.scale),p.drawImage(i,m/e.scale,A/e.scale,f/e.scale,d/e.scale)):p.drawImage(i,m,A,f,d);break;case 1:case-3:e.full?(c(u/e.scale,g/e.scale),m=m/e.scale+(f/e.scale-d/e.scale)/2,A=A/e.scale+(d/e.scale-f/e.scale)/2,p.rotate(90*r*Math.PI/180),p.drawImage(i,A,-m-d/e.scale,f/e.scale,d/e.scale)):(m+=(f-d)/2,A+=(d-f)/2,p.rotate(90*r*Math.PI/180),p.drawImage(i,A,-m-d,f,d));break;case 2:case-2:e.full?(c(u/e.scale,g/e.scale),p.rotate(90*r*Math.PI/180),m/=e.scale,A/=e.scale,p.drawImage(i,-m-f/e.scale,-A-d/e.scale,f/e.scale,d/e.scale)):(p.rotate(90*r*Math.PI/180),p.drawImage(i,-m-f,-A-d,f,d));break;case 3:case-1:e.full?(c(u/e.scale,g/e.scale),m=m/e.scale+(f/e.scale-d/e.scale)/2,A=A/e.scale+(d/e.scale-f/e.scale)/2,p.rotate(90*r*Math.PI/180),p.drawImage(i,-A-f/e.scale,m,f/e.scale,d/e.scale)):(m+=(f-d)/2,A+=(d-f)/2,p.rotate(90*r*Math.PI/180),p.drawImage(i,-A-f,m,f,d));break;default:e.full?(c(u/e.scale,g/e.scale),p.drawImage(i,m/e.scale,A/e.scale,f/e.scale,d/e.scale)):p.drawImage(i,m,A,f,d)}p.restore()}else{var v=o*e.scale,w=s*e.scale,x=n.getContext("2d");switch(x.save(),e.fillColor&&(x.fillStyle=e.fillColor,x.fillRect(0,0,n.width,n.height)),r){case 0:c(v,w),x.drawImage(i,0,0,v,w);break;case 1:case-3:c(w,v),x.rotate(90*r*Math.PI/180),x.drawImage(i,0,-w,v,w);break;case 2:case-2:c(v,w),x.rotate(90*r*Math.PI/180),x.drawImage(i,-v,-w,v,w);break;case 3:case-1:c(w,v),x.rotate(90*r*Math.PI/180),x.drawImage(i,-v,0,v,w);break;default:c(v,w),x.drawImage(i,0,0,v,w)}x.restore()}t(n)},"data"!==this.img.substr(0,4)&&(i.crossOrigin="Anonymous"),i.src=this.imgs},getCropData:function(t){var e=this;this.getCropChecked((function(n){t(n.toDataURL("image/"+e.outputType,e.outputSize))}))},getCropBlob:function(t){var e=this;this.getCropChecked((function(n){n.toBlob((function(e){return t(e)}),"image/"+e.outputType,e.outputSize)}))},showPreview:function(){var t=this;if(!this.isCanShow)return!1;this.isCanShow=!1,setTimeout((function(){t.isCanShow=!0}),16);var e=this.cropW,n=this.cropH,i=this.scale,r={};r.div={width:"".concat(e,"px"),height:"".concat(n,"px")};var o=(this.x-this.cropOffsertX)/i,s=(this.y-this.cropOffsertY)/i;r.w=e,r.h=n,r.url=this.imgs,r.img={width:"".concat(this.trueWidth,"px"),height:"".concat(this.trueHeight,"px"),transform:"scale(".concat(i,")translate3d(").concat(o,"px, ").concat(s,"px, ").concat(0,"px)rotateZ(").concat(90*this.rotate,"deg)")},r.html='\n      <div class="show-preview" style="width: '.concat(r.w,"px; height: ").concat(r.h,'px; overflow: hidden">\n        <div style="width: ').concat(e,"px; height: ").concat(n,'px">\n          <img src=').concat(r.url,' style="width: ').concat(this.trueWidth,"px; height: ").concat(this.trueHeight,"px; transform:\n          scale(").concat(i,")translate3d(").concat(o,"px, ").concat(s,"px, ").concat(0,"px)rotateZ(").concat(90*this.rotate,'deg)">\n        </div>\n      </div>'),this.$emit("realTime",r),this.$emit("real-time",r)},reload:function(){var t=this,e=new Image;e.onload=function(){t.w=parseFloat(window.getComputedStyle(t.$refs.cropper).width),t.h=parseFloat(window.getComputedStyle(t.$refs.cropper).height),t.trueWidth=e.width,t.trueHeight=e.height,t.original?t.scale=1:t.scale=t.checkedMode(),t.$nextTick((function(){t.x=-(t.trueWidth-t.trueWidth*t.scale)/2+(t.w-t.trueWidth*t.scale)/2,t.y=-(t.trueHeight-t.trueHeight*t.scale)/2+(t.h-t.trueHeight*t.scale)/2,t.loading=!1,t.autoCrop&&t.goAutoCrop(),t.$emit("img-load","success"),t.$emit("imgLoad","success"),setTimeout((function(){t.showPreview()}),20)}))},e.onerror=function(){t.$emit("imgLoad","error"),t.$emit("img-load","error")},e.src=this.imgs},checkedMode:function(){var t=1,e=(this.trueWidth,this.trueHeight),n=this.mode.split(" ");switch(n[0]){case"contain":this.trueWidth>this.w&&(t=this.w/this.trueWidth),this.trueHeight*t>this.h&&(t=this.h/this.trueHeight);break;case"cover":(e*=t=this.w/this.trueWidth)<this.h&&(t=(e=this.h)/this.trueHeight);break;default:try{var i=n[0];if(-1!==i.search("px")){i=i.replace("px","");var r=parseFloat(i)/this.trueWidth,o=1,s=n[1];-1!==s.search("px")&&(s=s.replace("px",""),o=(e=parseFloat(s))/this.trueHeight),t=Math.min(r,o)}if(-1!==i.search("%")&&(i=i.replace("%",""),t=parseFloat(i)/100*this.w/this.trueWidth),2===n.length&&"auto"===i){var a=n[1];-1!==a.search("px")&&(a=a.replace("px",""),t=(e=parseFloat(a))/this.trueHeight),-1!==a.search("%")&&(a=a.replace("%",""),t=(e=parseFloat(a)/100*this.h)/this.trueHeight)}}catch(e){t=1}}return t},goAutoCrop:function(t,e){if(""!==this.imgs&&null!==this.imgs){this.clearCrop(),this.cropping=!0;var n=this.w,i=this.h;if(this.centerBox){var r=Math.abs(this.rotate)%2>0,o=(r?this.trueHeight:this.trueWidth)*this.scale,s=(r?this.trueWidth:this.trueHeight)*this.scale;n=o<n?o:n,i=s<i?s:i}var a=t||parseFloat(this.autoCropWidth),h=e||parseFloat(this.autoCropHeight);0!==a&&0!==h||(a=.8*n,h=.8*i),a=a>n?n:a,h=h>i?i:h,this.fixed&&(h=a/this.fixedNumber[0]*this.fixedNumber[1]),h>this.h&&(a=(h=this.h)/this.fixedNumber[1]*this.fixedNumber[0]),this.changeCrop(a,h)}},changeCrop:function(t,e){var n=this;if(this.centerBox){var i=this.getImgAxis();t>i.x2-i.x1&&(e=(t=i.x2-i.x1)/this.fixedNumber[0]*this.fixedNumber[1]),e>i.y2-i.y1&&(t=(e=i.y2-i.y1)/this.fixedNumber[1]*this.fixedNumber[0])}this.cropW=t,this.cropH=e,this.checkCropLimitSize(),this.$nextTick((function(){n.cropOffsertX=(n.w-n.cropW)/2,n.cropOffsertY=(n.h-n.cropH)/2,n.centerBox&&n.moveCrop(null,!0)}))},refresh:function(){var t=this;this.img,this.imgs="",this.scale=1,this.crop=!1,this.rotate=0,this.w=0,this.h=0,this.trueWidth=0,this.trueHeight=0,this.clearCrop(),this.$nextTick((function(){t.checkedImg()}))},rotateLeft:function(){this.rotate=this.rotate<=-3?0:this.rotate-1},rotateRight:function(){this.rotate=this.rotate>=3?0:this.rotate+1},rotateClear:function(){this.rotate=0},checkoutImgAxis:function(t,e,n){t=t||this.x,e=e||this.y,n=n||this.scale;var i=!0;if(this.centerBox){var r=this.getImgAxis(t,e,n),o=this.getCropAxis();r.x1>=o.x1&&(i=!1),r.x2<=o.x2&&(i=!1),r.y1>=o.y1&&(i=!1),r.y2<=o.y2&&(i=!1)}return i}},mounted:function(){this.support="onwheel"in document.createElement("div")?"wheel":void 0!==document.onmousewheel?"mousewheel":"DOMMouseScroll";var t=this,e=navigator.userAgent;this.isIOS=!!e.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/),HTMLCanvasElement.prototype.toBlob||Object.defineProperty(HTMLCanvasElement.prototype,"toBlob",{value:function(e,n,i){for(var r=atob(this.toDataURL(n,i).split(",")[1]),o=r.length,s=new Uint8Array(o),a=0;a<o;a++)s[a]=r.charCodeAt(a);e(new Blob([s],{type:t.type||"image/png"}))}}),this.showPreview(),this.checkedImg()},destroyed:function(){window.removeEventListener("mousemove",this.moveCrop),window.removeEventListener("mouseup",this.leaveCrop),window.removeEventListener("touchmove",this.moveCrop),window.removeEventListener("touchend",this.leaveCrop),this.cancelScale()}};var h=n(379),c=n.n(h),p=n(795),l=n.n(p),u=n(569),g=n.n(u),f=n(565),d=n.n(f),m=n(216),A=n.n(m),v=n(589),w=n.n(v),x=n(814),C={};C.styleTagTransform=w(),C.setAttributes=d(),C.insert=g().bind(null,"head"),C.domAPI=l(),C.insertStyleElement=A(),c()(x.Z,C),x.Z&&x.Z.locals&&x.Z.locals;var b=function(t,e,n,i,r,o,s,a){var h,c="function"==typeof t?t.options:t;if(e&&(c.render=e,c.staticRenderFns=[],c._compiled=!0),o&&(c._scopeId="data-v-"+o),h)if(c.functional){c._injectStyles=h;var p=c.render;c.render=function(t,e){return h.call(e),p(t,e)}}else{var l=c.beforeCreate;c.beforeCreate=l?[].concat(l,h):[h]}return{exports:t,options:c}}(a,t,0,0,0,"998fa048");const y=b.exports;var H=function(t){t.component("VueCropper",y)};"undefined"!=typeof window&&window.Vue&&H(window.Vue);const W={version:"0.6.4",install:H,VueCropper:y,vueCropper:y}})(),i})()));
//# sourceMappingURL=index.js.map