# @turf/triangle-grid

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## triangleGrid

Creates a grid of triangular polygons.

### Parameters

*   `bbox` **[BBox][1]** extent of grid in \[minX, minY, maxX, maxY] order
*   `cellSide` **[number][2]** dimension of each grid cell.  Two triangles are created in each cell.
*   `options` **[Object][3]** Optional parameters (optional, default `{}`)

    *   `options.units` **Units** used in calculating cellSide.  Supports all valid Turf [Units][4] (optional, default `'kilometers'`)
    *   `options.mask` **[Feature][5]<[Polygon][6]>?** if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
    *   `options.properties` **[Object][3]** passed to each point of the grid (optional, default `{}`)

### Examples

```javascript
var bbox = [-95, 30 ,-85, 40];
var cellSide = 50;
var options = {units: 'miles'};

var triangleGrid = turf.triangleGrid(bbox, cellSide, options);

//addToMap
var addToMap = [triangleGrid];
```

Returns **[FeatureCollection][7]<[Polygon][6]>** grid of polygons

[1]: https://tools.ietf.org/html/rfc7946#section-5

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://github.com/Turfjs/turf/blob/master/packages/turf-helpers/README_UNITS.md

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[7]: https://tools.ietf.org/html/rfc7946#section-3.3

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/triangle-grid
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
