# @turf/transform-scale

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## transformScale

Scale GeoJSON objects from a given point by a scaling factor e.g. factor=2
would make each object 200% larger.
If a FeatureCollection is provided, the origin point will be calculated
based on each individual feature *unless* an exact

### Parameters

*   `geojson` **([GeoJSON][1] | [GeometryCollection][2])** objects to be scaled
*   `factor` **[number][3]** of scaling, positive values greater than 0. Numbers between 0 and 1 will shrink the geojson, numbers greater than 1 will expand it, a factor of 1 will not change the geojson.
*   `options` **[Object][4]** Optional parameters (optional, default `{}`)

    *   `options.origin` **(Corners | [Coord][5])** Point from which the scaling will occur (string options: sw/se/nw/ne/center/centroid) (optional, default `'centroid'`)
    *   `options.mutate` **[boolean][6]** allows GeoJSON input to be mutated (significant performance improvement if true) (optional, default `false`)

### Examples

```javascript
const poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
const scaledPoly = turf.transformScale(poly, 3);

//addToMap
const addToMap = [poly, scaledPoly];
scaledPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **([GeoJSON][1] | [GeometryCollection][2])** scaled GeoJSON

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.8

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/transform-scale
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
