# @turf/transform-rotate

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## transformRotate

Rotates any geojson Feature or Geometry of a specified angle, around its `centroid` or a given `pivot` point.

### Parameters

*   `geojson` **[GeoJSON][1]** object to be rotated
*   `angle` **[number][2]** of rotation in decimal degrees, positive clockwise
*   `options` **[Object][3]** Optional parameters (optional, default `{}`)

    *   `options.pivot` **[Coord][4]** point around which the rotation will be performed (optional, default `'centroid'`)
    *   `options.mutate` **[boolean][5]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
const poly = turf.polygon([[[0,29],[3.5,29],[2.5,32],[0,29]]]);
const options = {pivot: [0, 25]};
const rotatedPoly = turf.transformRotate(poly, 10, options);

//addToMap
const addToMap = [poly, rotatedPoly];
rotatedPoly.properties = {stroke: '#F00', 'stroke-width': 4};
```

Returns **[GeoJSON][1]** the rotated GeoJSON feature

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/transform-rotate
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
