# @turf/tag

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## tag

Takes a set of [points][1] and a set of [polygons][2] and/or [multipolygons][3] and performs a spatial join.

### Parameters

*   `points` **[FeatureCollection][4]<[Point][1]>** input points
*   `polygons` **[FeatureCollection][4]<([Polygon][2] | [MultiPolygon][3])>** input (multi)polygons
*   `field` **[string][5]** property in `polygons` to add to joined {<Point>} features
*   `outField` **[string][5]** property in `points` in which to store joined property from `polygons`

### Examples

```javascript
var pt1 = turf.point([-77, 44]);
var pt2 = turf.point([-77, 38]);
var poly1 = turf.polygon([[
  [-81, 41],
  [-81, 47],
  [-72, 47],
  [-72, 41],
  [-81, 41]
]], {pop: 3000});
var poly2 = turf.polygon([[
  [-81, 35],
  [-81, 41],
  [-72, 41],
  [-72, 35],
  [-81, 35]
]], {pop: 1000});

var points = turf.featureCollection([pt1, pt2]);
var polygons = turf.featureCollection([poly1, poly2]);

var tagged = turf.tag(points, polygons, 'pop', 'population');

//addToMap
var addToMap = [tagged, polygons]
```

Returns **[FeatureCollection][4]<[Point][1]>** points with `containingPolyId` property containing values from `polyId`

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[4]: https://tools.ietf.org/html/rfc7946#section-3.3

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/tag
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
