# @turf/simplify

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## simplify

Takes a [GeoJSON][1] object and returns a simplified version. Internally uses the 2d version of
[simplify-js][2] to perform simplification using the Ramer-Douglas-Peucker algorithm.

### Parameters

*   `geojson` **[GeoJSON][1]** object to be simplified
*   `options` **[Object][3]** Optional parameters (optional, default `{}`)

    *   `options.tolerance` **[number][4]** simplification tolerance (optional, default `1`)
    *   `options.highQuality` **[boolean][5]** whether or not to spend more time to create a higher-quality simplification with a different algorithm (optional, default `false`)
    *   `options.mutate` **[boolean][5]** allows GeoJSON input to be mutated (significant performance increase if true) (optional, default `false`)

### Examples

```javascript
var geojson = turf.polygon([[
  [-70.603637, -33.399918],
  [-70.614624, -33.395332],
  [-70.639343, -33.392466],
  [-70.659942, -33.394759],
  [-70.683975, -33.404504],
  [-70.697021, -33.419406],
  [-70.701141, -33.434306],
  [-70.700454, -33.446339],
  [-70.694274, -33.458369],
  [-70.682601, -33.465816],
  [-70.668869, -33.472117],
  [-70.646209, -33.473835],
  [-70.624923, -33.472117],
  [-70.609817, -33.468107],
  [-70.595397, -33.458369],
  [-70.587158, -33.442901],
  [-70.587158, -33.426283],
  [-70.590591, -33.414248],
  [-70.594711, -33.406224],
  [-70.603637, -33.399918]
]]);
var options = {tolerance: 0.01, highQuality: false};
var simplified = turf.simplify(geojson, options);

//addToMap
var addToMap = [geojson, simplified]
```

Returns **[GeoJSON][1]** a simplified GeoJSON

[1]: https://tools.ietf.org/html/rfc7946#section-3

[2]: http://mourner.github.io/simplify-js/

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/simplify
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
