# @turf/sample

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## sample

Takes a [FeatureCollection][1] and returns a FeatureCollection with given number of [features][2] at random.

### Parameters

*   `fc` **[FeatureCollection][1]\<T>**&#x20;
*   `num` **[number][3]** number of features to select
*   `featurecollection` **[FeatureCollection][1]** set of input features

### Examples

```javascript
var points = turf.randomPoint(100, {bbox: [-80, 30, -60, 60]});

var sample = turf.sample(points, 5);

//addToMap
var addToMap = [points, sample]
turf.featureEach(sample, function (currentFeature) {
  currentFeature.properties['marker-size'] = 'large';
  currentFeature.properties['marker-color'] = '#000';
});
```

Returns **[FeatureCollection][1]** a FeatureCollection with `n` features

[1]: https://tools.ietf.org/html/rfc7946#section-3.3

[2]: https://tools.ietf.org/html/rfc7946#section-3.2

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/sample
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
