"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _helpers = require('@turf/helpers');
var _invariant = require('@turf/invariant');
function rhumbDistance(from, to, options = {}) {
  const origin = _invariant.getCoord.call(void 0, from);
  const destination = _invariant.getCoord.call(void 0, to);
  destination[0] += destination[0] - origin[0] > 180 ? -360 : origin[0] - destination[0] > 180 ? 360 : 0;
  const distanceInMeters = calculateRhumbDistance(origin, destination);
  const distance = _helpers.convertLength.call(void 0, distanceInMeters, "meters", options.units);
  return distance;
}
function calculateRhumbDistance(origin, destination, radius) {
  radius = radius === void 0 ? _helpers.earthRadius : Number(radius);
  const R = radius;
  const phi1 = origin[1] * Math.PI / 180;
  const phi2 = destination[1] * Math.PI / 180;
  const DeltaPhi = phi2 - phi1;
  let DeltaLambda = Math.abs(destination[0] - origin[0]) * Math.PI / 180;
  if (DeltaLambda > Math.PI) {
    DeltaLambda -= 2 * Math.PI;
  }
  const DeltaPsi = Math.log(
    Math.tan(phi2 / 2 + Math.PI / 4) / Math.tan(phi1 / 2 + Math.PI / 4)
  );
  const q = Math.abs(DeltaPsi) > 1e-11 ? DeltaPhi / DeltaPsi : Math.cos(phi1);
  const delta = Math.sqrt(
    DeltaPhi * DeltaPhi + q * q * DeltaLambda * DeltaLambda
  );
  const dist = delta * R;
  return dist;
}
var turf_rhumb_distance_default = rhumbDistance;



exports.default = turf_rhumb_distance_default; exports.rhumbDistance = rhumbDistance;
//# sourceMappingURL=index.cjs.map