"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _booleanintersects = require('@turf/boolean-intersects');




var _helpers = require('@turf/helpers');
function rectangleGrid(bbox, cellWidth, cellHeight, options = {}) {
  const results = [];
  const west = bbox[0];
  const south = bbox[1];
  const east = bbox[2];
  const north = bbox[3];
  const bboxWidth = east - west;
  const cellWidthDeg = _helpers.convertLength.call(void 0, cellWidth, options.units, "degrees");
  const bboxHeight = north - south;
  const cellHeightDeg = _helpers.convertLength.call(void 0, cellHeight, options.units, "degrees");
  const columns = Math.floor(Math.abs(bboxWidth) / cellWidthDeg);
  const rows = Math.floor(Math.abs(bboxHeight) / cellHeightDeg);
  const deltaX = (bboxWidth - columns * cellWidthDeg) / 2;
  const deltaY = (bboxHeight - rows * cellHeightDeg) / 2;
  let currentX = west + deltaX;
  for (let column = 0; column < columns; column++) {
    let currentY = south + deltaY;
    for (let row = 0; row < rows; row++) {
      const cellPoly = _helpers.polygon.call(void 0, 
        [
          [
            [currentX, currentY],
            [currentX, currentY + cellHeightDeg],
            [currentX + cellWidthDeg, currentY + cellHeightDeg],
            [currentX + cellWidthDeg, currentY],
            [currentX, currentY]
          ]
        ],
        options.properties
      );
      if (options.mask) {
        if (_booleanintersects.booleanIntersects.call(void 0, options.mask, cellPoly)) {
          results.push(cellPoly);
        }
      } else {
        results.push(cellPoly);
      }
      currentY += cellHeightDeg;
    }
    currentX += cellWidthDeg;
  }
  return _helpers.featureCollection.call(void 0, results);
}
var turf_rectangle_grid_default = rectangleGrid;



exports.default = turf_rectangle_grid_default; exports.rectangleGrid = rectangleGrid;
//# sourceMappingURL=index.cjs.map