import { Polygon, MultiPolygon, GeoJsonProperties, Feature, LineString, MultiLineString, FeatureCollection } from 'geojson';

/**
 * Converts a {@link Polygon} to {@link LineString|(Multi)LineString} or {@link MultiPolygon} to a
 * {@link FeatureCollection} of {@link LineString|(Multi)LineString}.
 *
 * @function
 * @param {Feature<Polygon|MultiPolygon>} poly Feature to convert
 * @param {Object} [options={}] Optional parameters
 * @param {Object} [options.properties={}] translates GeoJSON properties to Feature
 * @returns {FeatureCollection|Feature<LineString|MultiLinestring>} converted (Multi)Polygon to (Multi)LineString
 * @example
 * var poly = turf.polygon([[[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]]);
 *
 * var line = turf.polygonToLine(poly);
 *
 * //addToMap
 * var addToMap = [line];
 */
declare function polygonToLine<G extends Polygon | MultiPolygon, P extends GeoJsonProperties = GeoJsonProperties>(poly: Feature<G, P> | G, options?: {
    properties?: any;
}): Feature<LineString | MultiLineString, P> | FeatureCollection<LineString | MultiLineString, P>;
/**
 * @private
 */
declare function singlePolygonToLine<G extends Polygon, P extends GeoJsonProperties = GeoJsonProperties>(poly: Feature<G, P> | G, options?: {
    properties?: any;
}): Feature<LineString | MultiLineString, P>;
/**
 * @private
 */
declare function multiPolygonToLine<G extends MultiPolygon, P extends GeoJsonProperties = GeoJsonProperties>(multiPoly: Feature<G, P> | G, options?: {
    properties?: P;
}): FeatureCollection<LineString | MultiLineString, P>;
/**
 * @private
 */
declare function coordsToLine<P extends GeoJsonProperties = GeoJsonProperties>(coords: number[][][], properties: P): Feature<LineString | MultiLineString, P>;

export { coordsToLine, polygonToLine as default, multiPolygonToLine, polygonToLine, singlePolygonToLine };
