# @turf/polygon-tangents

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## polygonTangents

Finds the tangents of a [(Multi)Polygon][1] from a [Point][2].

### Parameters

*   `pt` **[Coord][3]** to calculate the tangent points from
*   `polygon` **[Feature][4]<([Polygon][1] | [MultiPolygon][5])>** to get tangents from

### Examples

```javascript
var polygon = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
var point = turf.point([61, 5]);

var tangents = turf.polygonTangents(point, polygon)

//addToMap
var addToMap = [tangents, point, polygon];
```

Returns **[FeatureCollection][6]<[Point][2]>** Feature Collection containing the two tangent points

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.6

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[4]: https://tools.ietf.org/html/rfc7946#section-3.2

[5]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[6]: https://tools.ietf.org/html/rfc7946#section-3.3

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/polygon-tangents
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
