// index.ts
import { featureCollection, multiPolygon, polygon } from "@turf/helpers";
import { coordEach, geomEach } from "@turf/meta";
function polygonSmooth(inputPolys, options) {
  options = options || {};
  options.iterations = options.iterations || 1;
  const { iterations } = options;
  const outPolys = [];
  if (!inputPolys) throw new Error("inputPolys is required");
  geomEach(inputPolys, function(geom, geomIndex, properties) {
    if (geom.type === "Polygon") {
      let outCoords = [[]];
      for (let i = 0; i < iterations; i++) {
        let tempOutput = [];
        let poly = geom;
        if (i > 0) {
          poly = polygon(outCoords).geometry;
        }
        processPolygon(poly, tempOutput);
        outCoords = tempOutput.slice(0);
      }
      outPolys.push(polygon(outCoords, properties));
    } else if (geom.type === "MultiPolygon") {
      let outCoords = [[[]]];
      for (let y = 0; y < iterations; y++) {
        let tempOutput = [];
        let poly = geom;
        if (y > 0) {
          poly = multiPolygon(outCoords).geometry;
        }
        processMultiPolygon(poly, tempOutput);
        outCoords = tempOutput.slice(0);
      }
      outPolys.push(multiPolygon(outCoords, properties));
    } else {
      throw new Error("geometry is invalid, must be Polygon or MultiPolygon");
    }
  });
  return featureCollection(outPolys);
}
function processPolygon(poly, tempOutput) {
  var previousCoord;
  var previousGeometryIndex;
  coordEach(
    poly,
    function(currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
      if (previousGeometryIndex !== geometryIndex) {
        tempOutput.push([]);
      } else {
        var p0x = previousCoord[0];
        var p0y = previousCoord[1];
        var p1x = currentCoord[0];
        var p1y = currentCoord[1];
        tempOutput[geometryIndex].push([
          0.75 * p0x + 0.25 * p1x,
          0.75 * p0y + 0.25 * p1y
        ]);
        tempOutput[geometryIndex].push([
          0.25 * p0x + 0.75 * p1x,
          0.25 * p0y + 0.75 * p1y
        ]);
      }
      previousCoord = currentCoord;
      previousGeometryIndex = geometryIndex;
    },
    false
  );
  tempOutput.forEach(function(ring) {
    ring.push(ring[0]);
  });
}
function processMultiPolygon(poly, tempOutput) {
  let previousCoord;
  let previousMultiFeatureIndex;
  let previousGeometryIndex;
  coordEach(
    poly,
    function(currentCoord, coordIndex, featureIndex, multiFeatureIndex, geometryIndex) {
      if (previousMultiFeatureIndex !== multiFeatureIndex) {
        tempOutput.push([[]]);
      } else if (previousGeometryIndex !== geometryIndex) {
        tempOutput[multiFeatureIndex].push([]);
      } else {
        var p0x = previousCoord[0];
        var p0y = previousCoord[1];
        var p1x = currentCoord[0];
        var p1y = currentCoord[1];
        tempOutput[multiFeatureIndex][geometryIndex].push([
          0.75 * p0x + 0.25 * p1x,
          0.75 * p0y + 0.25 * p1y
        ]);
        tempOutput[multiFeatureIndex][geometryIndex].push([
          0.25 * p0x + 0.75 * p1x,
          0.25 * p0y + 0.75 * p1y
        ]);
      }
      previousCoord = currentCoord;
      previousMultiFeatureIndex = multiFeatureIndex;
      previousGeometryIndex = geometryIndex;
    },
    false
  );
  tempOutput.forEach(function(poly2) {
    poly2.forEach(function(ring) {
      ring.push(ring[0]);
    });
  });
}
var turf_polygon_smooth_default = polygonSmooth;
export {
  turf_polygon_smooth_default as default,
  polygonSmooth
};
//# sourceMappingURL=index.js.map