"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _booleanpointinpolygon = require('@turf/boolean-point-in-polygon');
var _helpers = require('@turf/helpers');
var _meta = require('@turf/meta');
function pointsWithinPolygon(points, polygons) {
  const results = [];
  _meta.featureEach.call(void 0, points, function(point) {
    let contained = false;
    if (point.geometry.type === "Point") {
      _meta.geomEach.call(void 0, polygons, function(polygon) {
        if (_booleanpointinpolygon.booleanPointInPolygon.call(void 0, point, polygon)) {
          contained = true;
        }
      });
      if (contained) {
        results.push(point);
      }
    } else if (point.geometry.type === "MultiPoint") {
      var pointsWithin = [];
      _meta.geomEach.call(void 0, polygons, function(polygon) {
        _meta.coordEach.call(void 0, point, function(pointCoord) {
          if (_booleanpointinpolygon.booleanPointInPolygon.call(void 0, pointCoord, polygon)) {
            contained = true;
            pointsWithin.push(pointCoord);
          }
        });
      });
      if (contained) {
        results.push(
          _helpers.multiPoint.call(void 0, pointsWithin, point.properties)
        );
      }
    } else {
      throw new Error("Input geometry must be a Point or MultiPoint");
    }
  });
  return _helpers.featureCollection.call(void 0, results);
}
var turf_points_within_polygon_default = pointsWithinPolygon;



exports.default = turf_points_within_polygon_default; exports.pointsWithinPolygon = pointsWithinPolygon;
//# sourceMappingURL=index.cjs.map