// index.ts
import { polygon as createPolygon, multiPolygon } from "@turf/helpers";
import * as polyclip from "polyclip-ts";
import { clone } from "@turf/clone";
function mask(polygon, mask2, options) {
  var _a;
  const mutate = (_a = options == null ? void 0 : options.mutate) != null ? _a : false;
  let maskTemplate = mask2;
  if (mask2 && mutate === false) {
    maskTemplate = clone(mask2);
  }
  const maskPolygon = createMask(maskTemplate);
  let polygonOuters = null;
  if (polygon.type === "FeatureCollection") {
    polygonOuters = unionFc(polygon);
  } else if (polygon.type === "Feature") {
    polygonOuters = createGeomFromPolygonClippingOutput(
      polyclip.union(polygon.geometry.coordinates)
    );
  } else {
    polygonOuters = createGeomFromPolygonClippingOutput(
      polyclip.union(polygon.coordinates)
    );
  }
  polygonOuters.geometry.coordinates.forEach(function(contour) {
    maskPolygon.geometry.coordinates.push(contour[0]);
  });
  return maskPolygon;
}
function unionFc(fc) {
  const unioned = fc.features.length === 2 ? polyclip.union(
    fc.features[0].geometry.coordinates,
    fc.features[1].geometry.coordinates
  ) : polyclip.union.apply(
    polyclip,
    fc.features.map(function(f) {
      return f.geometry.coordinates;
    })
  );
  return createGeomFromPolygonClippingOutput(unioned);
}
function createGeomFromPolygonClippingOutput(unioned) {
  return multiPolygon(unioned);
}
function createMask(mask2) {
  const world = [
    [
      [180, 90],
      [-180, 90],
      [-180, -90],
      [180, -90],
      [180, 90]
    ]
  ];
  let coordinates = world;
  if (mask2) {
    if (mask2.type === "Feature") {
      coordinates = mask2.geometry.coordinates;
    } else {
      coordinates = mask2.coordinates;
    }
  }
  return createPolygon(coordinates);
}
var turf_mask_default = mask;
export {
  turf_mask_default as default,
  mask
};
//# sourceMappingURL=index.js.map