import { Polygon, MultiPolygon, Feature, FeatureCollection } from 'geojson';

/**
 * Takes polygons or multipolygons and an optional mask, and returns an exterior
 * ring polygon with holes.
 *
 * @function
 * @param {Polygon|MultiPolygon|Feature<Polygon|MultiPolygon>|FeatureCollection<Polygon|MultiPolygon>} polygon GeoJSON polygon used as interior rings or holes
 * @param {Polygon|Feature<Polygon>} [mask] GeoJSON polygon used as the exterior ring (if undefined, the world extent is used)
 * @param {Object} [options={}] Optional parameters
 * @param {boolean} [options.mutate=false] allows the `mask` GeoJSON input to be mutated (performance improvement if true)
 * @returns {Feature<Polygon>} Masked Polygon (exterior ring with holes)
 * @example
 * const polygon = turf.polygon([[[112, -21], [116, -36], [146, -39], [153, -24], [133, -10], [112, -21]]]);
 * const mask = turf.polygon([[[90, -55], [170, -55], [170, 10], [90, 10], [90, -55]]]);
 *
 * const masked = turf.mask(polygon, mask);
 *
 * //addToMap
 * const addToMap = [masked]
 */
declare function mask<T extends Polygon | MultiPolygon>(polygon: T | Feature<T> | FeatureCollection<T>, mask?: Polygon | Feature<Polygon>, options?: {
    mutate?: boolean;
}): Feature<Polygon>;

export { mask as default, mask };
