"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _bbox = require('@turf/bbox');
var _invariant = require('@turf/invariant');
var _helpers = require('@turf/helpers');
var _clone = require('@turf/clone');
function lineToPolygon(lines, options = {}) {
  var _a, _b, _c;
  var properties = options.properties;
  var autoComplete = (_a = options.autoComplete) != null ? _a : true;
  var orderCoords = (_b = options.orderCoords) != null ? _b : true;
  var mutate = (_c = options.mutate) != null ? _c : false;
  if (!mutate) {
    lines = _clone.clone.call(void 0, lines);
  }
  switch (lines.type) {
    case "FeatureCollection":
      var coords = [];
      lines.features.forEach(function(line) {
        coords.push(
          _invariant.getCoords.call(void 0, lineStringToPolygon(line, {}, autoComplete, orderCoords))
        );
      });
      return _helpers.multiPolygon.call(void 0, coords, properties);
    default:
      return lineStringToPolygon(lines, properties, autoComplete, orderCoords);
  }
}
function lineStringToPolygon(line, properties, autoComplete, orderCoords) {
  properties = properties ? properties : line.type === "Feature" ? line.properties : {};
  var geom = _invariant.getGeom.call(void 0, line);
  var coords = geom.coordinates;
  var type = geom.type;
  if (!coords.length) throw new Error("line must contain coordinates");
  switch (type) {
    case "LineString":
      if (autoComplete) coords = autoCompleteCoords(coords);
      return _helpers.polygon.call(void 0, [coords], properties);
    case "MultiLineString":
      var multiCoords = [];
      var largestArea = 0;
      coords.forEach(function(coord) {
        if (autoComplete) coord = autoCompleteCoords(coord);
        if (orderCoords) {
          var area = calculateArea(_bbox.bbox.call(void 0, _helpers.lineString.call(void 0, coord)));
          if (area > largestArea) {
            multiCoords.unshift(coord);
            largestArea = area;
          } else multiCoords.push(coord);
        } else {
          multiCoords.push(coord);
        }
      });
      return _helpers.polygon.call(void 0, multiCoords, properties);
    default:
      throw new Error("geometry type " + type + " is not supported");
  }
}
function autoCompleteCoords(coords) {
  var first = coords[0];
  var x1 = first[0];
  var y1 = first[1];
  var last = coords[coords.length - 1];
  var x2 = last[0];
  var y2 = last[1];
  if (x1 !== x2 || y1 !== y2) {
    coords.push(first);
  }
  return coords;
}
function calculateArea(bbox) {
  var west = bbox[0];
  var south = bbox[1];
  var east = bbox[2];
  var north = bbox[3];
  return Math.abs(west - east) * Math.abs(south - north);
}
var turf_line_to_polygon_default = lineToPolygon;



exports.default = turf_line_to_polygon_default; exports.lineToPolygon = lineToPolygon;
//# sourceMappingURL=index.cjs.map