export declare function parseVersion(version: any): "next" | {
    major: number;
    minor: number;
};
/**
 * Get the CDN url for a given version
 *
 * @param version Ex: '4.17' or '3.34'. Defaults to the latest 4.x version.
 */
export declare function getCdnUrl(version?: string): string;
/**
 * Get the CDN url for a the CSS for a given version and/or theme
 *
 * @param version Ex: '4.17', '3.34', or 'next'. Defaults to the latest 4.x version.
 */
export declare function getCdnCssUrl(version?: string): string;
