package com.bcxin.ars.webservice.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.bj.PersonInfo;
import com.bcxin.ars.dto.bj.ResultPerson;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.text.StringUtils;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.bcxin.ars.webservice.dto.*;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.*;

/**
 * 背景筛查 + 人口库  北京库
 * @author linqinglin
 * @date 2019/04/17 0017 17:48
 */
@Service("backGroupCensorService_110000")
public class BJBackGroupCensorServiceImpl extends BackGroupCensorServiceImpl implements BackGroupCensorService {

    private static Logger logger = LoggerFactory.getLogger(BJBackGroupCensorServiceImpl.class);

    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Autowired
    private SecurityPersonDao securityPersonDao;

    @Autowired
    private ConfigService configService;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    @Value("${BJ_RKK_PHOTO_URL}")
    private String BJ_RKK_PHOTO_URL;

    private static Map<String,String> map;

    static {
        /**
         * 北京与陕西读取数据类型映射
         * 统一数据类型
         */
        map = new HashMap<>();
        map.put(Constants.INFO_XM, Constants.INFO_XM_BJ);
        map.put(Constants.INFO_XP, Constants.INFO_XP_BJ);
        map.put(Constants.INFO_DETAIL_ADDRESS, Constants.INFO_ZZXZ_BJ);

    }

    /**
     * 获取系统当前登录用户
     * @return
     */
    public User getCurrentUser() {
        User user = SecurityContext.currentUser.get();
        return user;
    }

    /****
     * 背景筛查
     * 不同省份不同实现
     * @param dto 业务信息
     */
    @Override
    public List<BackgroundApproval> censorFromBase(BackgroundApprovalDto dto,boolean needCZ) {
        List<BackgroundApproval> list = new ArrayList<>();
        try {
            //业务ID
            Long businessid = dto.getBusinessid();
            //业务类型
            String businesstype = dto.getBusinesstype();
            //身份证号
            String idNumber = dto.getIdNumber();
            //姓名
            String name = dto.getRealName();
            //背景筛查
            BackgroundApproval cz_BackgroundApproval = new BackgroundApproval();
            cz_BackgroundApproval.setActive(true);
            cz_BackgroundApproval.setCreateTime(new Date());
            cz_BackgroundApproval.setUpdateTime(new Date());
            cz_BackgroundApproval.setApprovaldate(new Date());
            cz_BackgroundApproval.setBusinessid(businessid);
            cz_BackgroundApproval.setBusinesstype(businesstype);
            /**
             * 克隆对象，减少重复创建对象赋值代码
             * 自定义类需要实现Cloneable的clone()方法
             */
            BackgroundApproval tempBackgroundApproval = cz_BackgroundApproval.clone();
            if(needCZ) {
                boolean policeInterface = true;

                if (!Constants.AUTH_STATE_PASS.equals(dto.getAuthState())) {
                    if(Constants.BAYZ.equals(businesstype) || Constants.PERSONGRADE_CENSORSTATUS.equals(businesstype)){
                        SecurityPerson person = securityPersonDao.findByIdCardAndActive(idNumber);
                        if(person != null && Constants.AUTH_STATE_PASS.equals(person.getIdentityAuthState())){
                            policeInterface = false;
                        }
                    }
                }else{
                    policeInterface = false;
                }

                if(policeInterface){
                    bjCensorCZ(idNumber, name, cz_BackgroundApproval);
                }else{
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }
                list.add(cz_BackgroundApproval);
            }
            checkPersonInfo(list, idNumber, tempBackgroundApproval.clone());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            if (e instanceof ArsException) {
                throw new ArsException(e.getMessage());
            }
        }
        return list;
    }



    public final void bjCensorCZ(String idnum,String name,BackgroundApproval cz_BackgroundApproval){
        // 人口库
        try {
            cz_BackgroundApproval.setLibraryType(Constants.LIBRARYTYPE_CZ);

            if (StringUtil.isNotEmpty(getPhoto(idnum, name))) {
                cz_BackgroundApproval.setApprovalreason("主项信息符合");
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                return;
            }

            PersonBaseInfo personBaseInfo = getPopulationInfo(idnum,false);

            if(personBaseInfo != null){
                if(StringUtil.isNotEmpty(personBaseInfo.getName()) && name.equals(personBaseInfo.getName())){
                    cz_BackgroundApproval.setApprovalreason("主项信息符合");
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_TG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_TG);
                }else{
                    //姓名信息不匹配
                    cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL_MESSAGE);
                    cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                    cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                }
            }else{
                cz_BackgroundApproval.setApprovalreason(Constants.LIBRARYTYPE_CZ_FAIL);
                cz_BackgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                cz_BackgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
            }


        }catch(Exception e){
            logger.error(e.getMessage(),e);
            throw new ArsException("查询人口库异常！");
        }

    }

    /**
     * 背景核查
     * 核查接口地址：http://14.62.38.214:9006/zzxt/jk/helu/checkPersonBaseInfo
     * 接口参数:
     * deviceid=60:EB:69:8F:82:9C
     * policesfzh=110101197002285038
     * policename=李京海
     * sfzh=被查询人的身份证号
     * 接口请求头:
     * uid=1100002200000700
     * username=baxt
     * userpwd=Bzxt*bzxt
     * 返回值:
     * {
     * "uuid": "bca0d07e-c5ad-4be6-92de-867e650474f7",
     * "msg": "ok",
     * "status": 0,
     * "results": [
     * {
     * "value": "违法犯罪(其他)",
     * "disposalWay": "",
     * "color": "yellow",
     * "resourceName": "违法犯罪",
     * "order": "2",
     * "key": "criminalType"
     * }
     * ]
     * }
     *
     * @param list
     * @param idNumber
     * @param backgroundApproval
     */
    public void checkPersonInfo(List<BackgroundApproval> list, String idNumber, BackgroundApproval backgroundApproval) {
        try {

            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, Constants.BEIJING_CHECK_PERSON_BASE_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResponseContext(result);
            log.setRequestContext(paramMap.toString());
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            logger.info("身份证号:{},北京核查库返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                VerifyResult censorResult = JSONObject.parseObject(result, VerifyResult.class);
                List<Results> results = censorResult.getResults();
                if (results != null && !results.isEmpty()) {
                    //背景筛查原因列表
                    for (Results item : results) {
                        //如果返回值color为green 则为正常.
                       //if (Constants.BEIJING_CHECK_PERSON_BASE_INFO_COLOR_GREEN.equals(item.getColor())) {
                           // continue;
                        //}

                       if (Constants.BEIJING_BG_BAY.equals(item.getValue())||
                               Constants.BEIJING_BG_BSGZRY.equals(item.getValue())||
                               Constants.BEIJING_BG_BXYKZWJMRY.equals(item.getValue())||
                               Constants.BEIJING_BG_JGGZRY.equals(item.getValue())||
                               Constants.BEIJING_BG_JJZ.equals(item.getValue())||
                               Constants.BEIJING_BG_JSY.equals(item.getValue())||
                               Constants.BEIJING_BG_LDRKGZGLCCRY.equals(item.getValue())||
                               Constants.BEIJING_BG_MPRY.equals(item.getValue())||
                               Constants.BEIJING_BG_SJDMXRY.equals(item.getValue())||
                               Constants.BEIJING_BG_TAMDQRXRY.equals(item.getValue())||
                               Constants.BEIJING_BG_YJJJHCSJ.equals(item.getValue())||
                               Constants.BEIJING_BG_YQR.equals(item.getValue())
                       ){
                           continue;
                       }



                        //不通过原因
                        backgroundApproval.setApprovalreason(item.getValue());
                        //背景筛查不通过
                        backgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                        backgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                        //公安核查库
                        backgroundApproval.setLibraryType(Constants.LIBRARYTYPE_BJ_HC);
                        list.add(backgroundApproval);
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("北京核查库调用异常！！");

        }
    }

    /*
    背景核查
    核查接口地址：http://14.28.2.32:8080/verify
    接口参数
    userid:必填（通常填写警号）
    key:核查证件号码
    返回值位：JSON
    */
    private void checkPersonInfoOld(List<BackgroundApproval> list, String idNumber, BackgroundApproval backgroundApproval){
        try {
            /**
             * 从数据库读取北京核查库地址
             */
            String url = StringUtil.EMPTY;
            Config censorConfig = configService.getConfigByKey(Constants.ZAURL_BJ);
            if(censorConfig == null){
                throw new ArsException("Config中北京人口库及核查库地址未配置,key:"+ Constants.ZAURL_BJ);
            }else{
                url = censorConfig.getValue();
            }
            HashMap<String, Object> paramMap = new HashMap<>();
            //警号
            User user = getCurrentUser();
            if(user!=null){
                paramMap.put("userid",user.getCodeNo());
            }else {
                paramMap.put("userid", Constants.POLICEMANID);
            }
            //身份证号转成大写
            paramMap.put("key", idNumber.toUpperCase());
            String result = HttpUtil.get(url, paramMap, Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT);

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResponseContext(result);
            log.setRequestContext(paramMap.toString());
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            logger.info("身份证号：" + idNumber + "，北京核查库返回数据:"+result);
            if(StringUtil.isNotEmpty(result)) {
                CensorResult censorResult = JSONObject.parseObject(result, CensorResult.class);
                String type = censorResult.getType();
                if (StringUtil.isNotEmpty(type)) {
                    //背景筛查原因列表
                    String[] types = type.split(",");
                    for (String t : types) {
                        //不通过原因
                        backgroundApproval.setApprovalreason(t);
                        //背景筛查不通过
                        backgroundApproval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                        backgroundApproval.setRgapprovalstate(Constants.APPROVALSTATE_BTG);
                        //公安核查库
                        backgroundApproval.setLibraryType(Constants.LIBRARYTYPE_BJ_HC);
                        list.add(backgroundApproval);
                    }
                }
            }
        }catch(Exception e){
            logger.error(e.getMessage(),e);
            throw new ArsException("北京核查库调用异常！！");

        }
    }

    @Override
    public String getPhoto(String idNumber, String name) {
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put("device_id", Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put("police_idcard", Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put("police_name", Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put("des_idcard", idNumber);
            paramMap.put("des_name", name);

            logger.error("北京人员照片基本信息接口请求参数:{}", JSON.toJSONString(paramMap));
            logger.error("北京人员照片基本信息接口请求地址:{}", Constants.BEIJING_PERSON_BASE_INFO_PHOTO_URL);
            //第四步：发送HttpPost请求，获取返回值
            String result = postWithJson(Constants.BEIJING_PERSON_BASE_INFO_PHOTO_URL,paramMap); //调接口获取返回值时，必须用此方法

            //增加日志
            BjRestLog log = new BjRestLog();
            //log.setResponseContext(result);
            log.setRequestContext(paramMap.toString());
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);
            logger.error("身份证号:{},北京人员照片基本信息接口返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                JSONObject perInfoResult = JSONObject.parseObject(result);
                if(perInfoResult.get("msg") != null && perInfoResult.get("msg").toString().equals("未授权的IP地址")){
                    throw new ArsException("北京人员照片基本信息接口调用异常 -- 未授权的IP地址");
                }
                if(perInfoResult.get("data") != null){
                    JSONArray perInfoArr = JSONArray.parseArray(JSON.toJSONString(perInfoResult.get("data")));
                    if(perInfoArr.size() > 0) {
                        JSONObject perInfo = JSON.parseObject(JSON.toJSONString(perInfoArr.get(0)));
                        return perInfo.get("XP").toString();
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("北京人员照片基本信息接口调用异常！！");
        }

        return StringUtil.EMPTY;
    }


    private String postWithJson(String requestUrl, Map<String, Object> paramMap){
        String returnValue = StringUtils.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try{
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(requestUrl);

            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT);
            requestConfig.setConnectionRequestTimeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT);
            requestConfig.setSocketTimeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE);
            //请求头username 固定值
            httpPost.setHeader(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE);
            //请求头user pwd 固定值
            httpPost.setHeader(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, "Baxt*RKK");
            httpPost.setConfig(requestConfig.build());

            httpPost.setEntity(requestEntity);

            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法
        }catch(Exception e){
            e.printStackTrace();
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        //第五步：处理返回值
        return returnValue;
    }


    @Override
    public PersonBaseInfo getPopulationInfo(String idNumber,boolean needPhoto) {
        PersonBaseInfo infoDto = new PersonBaseInfo();
        infoDto.setIdnum(idNumber);
        ResultPerson person = getPopulationInfoFromBase(idNumber);
        if(person != null && person.getData() != null) {
            infoDto.setName(person.getData().getPersonname());
            infoDto.setAddress(person.getData().getPersonhuji());
            if(needPhoto){
                infoDto.setPhoto(getPhoto(idNumber,infoDto.getName()));
            }
        }

        return infoDto;
    }

    /***
     * 北京调用人口库方式
     * @param idNumber 身份证号
     * @return
     */
    private ResultPerson getPopulationInfoFromBase(String idNumber){
        ResultPerson person = null;
        try {
            //请求参数
            Map<String, Object> paramMap = Maps.newHashMapWithExpectedSize(8);
            //mac地址 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_DEVICE_ID, Constants.BEIJING_DEVICE_ID);
            //查询民警身份证号 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_IDENTITY_NUMBER, Constants.POLICESFZH);
            //查询民警姓名 固定值
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_POLICE_NAME, Constants.POLICENAME);
            //被查询人员的身份证号
            paramMap.put(Constants.BEIJING_CHECK_PERSON_BASE_INFO_PARAM_BE_QUERIED_IDENTITY_NUMBER, idNumber);

            //构建请求
            HttpResponse response = HttpUtil
                    .createRequest(Method.GET, Constants.BEIJING_PERSON_BASE_INFO_URL)
                    .form(paramMap)
                    //设置三十秒超时时间
                    .timeout(Constants.BEIJING_CHECK_PERSON_BASE_INFO_TIMEOUT)
                    //需携带请求头uid 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_UID_VALUE)
                    //请求头username 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USERNAME_VALUE)
                    //请求头user pwd 固定值
                    .header(Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD, Constants.BEIJING_CHECK_PERSON_BASE_INFO_HEADER_USER_PWD_VALUE)
                    .execute();
            String result = response.body();

            //增加日志
            BjRestLog log = new BjRestLog();
            log.setResponseContext(result);
            log.setRequestContext(paramMap.toString());
            //创建时间
            log.setCreateTime(new Date());
            //有效标记
            log.setActive(true);
            //更新时间
            log.setUpdateTime(new Date());
            //更新者
            log.setUpdateBy(Constants.APPROVAL_SYSTEM);
            bjRestLogDao.save(log);

            logger.info("身份证号:{},北京人员基本信息接口返回数据:{}", idNumber, result);
            if (StringUtil.isNotEmpty(result)) {
                PerInfoResult perInfoResult = JSONObject.parseObject(result, PerInfoResult.class);
                person = new ResultPerson();
                person.setCode(perInfoResult.getStatus()+"");
                person.setMsg(perInfoResult.getMsg());

                PersonInfo personInfo = new PersonInfo();
                List<PerInfoDto> results = perInfoResult.getResults();
                if (results != null && !results.isEmpty()) {
                    PerInfoDto perInfoDto = results.get(0);
                    personInfo.setPersonhuji(perInfoDto.getHouseHolds());
                    personInfo.setPersonname(perInfoDto.getName());
                    person.setData(personInfo);
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("北京人员基本信息接口调用异常！！");

        }

        return person;
    }

    public static void main(String[] args) {
        String result = "{\"code\":1,\"data\":[],\"gmsfhm\":\"372928196904176315\",\"msg\":\"\\u6ca1\\u6709\\u67e5\\u8be2\\u5230\\u76f8\\u5173\\u4fe1\\u606f\",\"xm\":\"\\u4e3b\\u7ba1\\u7406\\u5458\"}";
        JSONObject perInfoResult = JSONObject.parseObject(result);
        if(perInfoResult.get("data") != null){
            JSONArray perInfoArr = JSONArray.parseArray(JSON.toJSONString(perInfoResult.get("data")));
            if(perInfoArr.size() > 0) {
                JSONObject perInfo = JSON.parseObject(JSON.toJSONString(perInfoArr.get(0)));
                System.out.println(perInfo.get("XP").toString());
            }
        }
    }

}
