/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer.background;

import com.bcxin.ars.dao.ThirdTrainBackgroundDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.model.ThirdTrainBackground;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.StringUtil;
import com.beust.jcommander.internal.Lists;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThirdPeopleBackgroundScreeningService {
    private final Logger logger = LoggerFactory.getLogger(ThirdPeopleBackgroundScreeningService.class);
    @Resource
    private ConfigUtils configUtils;
    @Value(value="${timeFlag}")
    private String timeFlag;
    @Resource
    private JobRunLogService jobRunLogService;
    @Resource
    private ThirdTrainBackgroundDao thirdTrainBackgroundDao;
    @Resource
    private PersoncertificateDao personcertificateDao;
    @Resource
    private PersonGradeDao personGradeDao;

    public void run() {
        if (!"11".equals(this.configUtils.getCurrentNative()) || this.configUtils.isIntranet() || !"true".equals(this.timeFlag)) {
            return;
        }
        JobRunLog jobRunLog = new JobRunLog();
        long start = System.currentTimeMillis();
        List thirdTrainBackgrounds = this.thirdTrainBackgroundDao.listPeopleForScreening();
        List gradeIdNumberList = Lists.newArrayList();
        List certificateIdNumberList = Lists.newArrayList();
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgrounds) {
            String businessType = thirdTrainBackground.getBusinessType();
            String idNumber = thirdTrainBackground.getIdNumber();
            if (StringUtil.isBlank((CharSequence)idNumber)) continue;
            if ("01".equals(businessType)) {
                gradeIdNumberList.add(idNumber);
            }
            if (!"02".equals(businessType)) continue;
            certificateIdNumberList.add(idNumber);
        }
        List personCertificateList = this.personcertificateDao.findCensorStatusByIdNumbers(certificateIdNumberList);
        Map personCertificateMap = personCertificateList.stream().collect(HashMap::new, (m, v) -> m.put(v.getCardnumber(), v.getCensorStatus()), HashMap::putAll);
        this.logger.info("{}", (Object)personCertificateMap);
        List gradeCertificateList = this.personGradeDao.findCensorStatusByIdNumbers(gradeIdNumberList);
        Map gradeCertificateMap = gradeCertificateList.stream().collect(HashMap::new, (m, v) -> m.put(v.getIdNum(), v.getCensorStatus()), HashMap::putAll);
        this.logger.info("{}", (Object)gradeCertificateMap);
        for (ThirdTrainBackground thirdTrainBackground : thirdTrainBackgrounds) {
            String businessType = thirdTrainBackground.getBusinessType();
            String idNumber = thirdTrainBackground.getIdNumber();
            if ("01".equals(businessType)) {
                thirdTrainBackground.setScreeningResults((String)gradeCertificateMap.get(idNumber));
                continue;
            }
            if (!"02".equals(businessType)) continue;
            thirdTrainBackground.setScreeningResults((String)personCertificateMap.get(idNumber));
        }
        this.thirdTrainBackgroundDao.saveBatch(thirdTrainBackgrounds);
        long end = System.currentTimeMillis();
        Date startDate = new Date(start);
        jobRunLog.setJobName(this.getClass().getName());
        jobRunLog.setActive(Boolean.valueOf(true));
        jobRunLog.setCreateTime(startDate);
        jobRunLog.setUpdateTime(startDate);
        jobRunLog.setUpdateBy("system");
        jobRunLog.setRunTime(startDate);
        jobRunLog.setRunTimeLength(new Date(end - start) + "ms");
        this.jobRunLogService.insert(jobRunLog);
    }
}

