/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.timer;

import com.bcxin.ars.dao.BJThreeCerDao;
import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import com.bcxin.ars.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThreeCerToGovService
extends BaseService {
    private static Logger logger = LoggerFactory.getLogger(ThreeCerToGovService.class);
    private static final String hostname = "14.16.176.2";
    private static final int port = 21;
    private static final String username = "basc";
    private static final String password = "zazd#32A13";
    private static final String pathname = "/ars";
    @Autowired
    PersonBaseInfoDao personBaseInfoDao;
    @Autowired
    BJThreeCerDao threeCerDao;
    @Autowired
    ConfigUtils configUtils;
    @Autowired
    IdWorker idWorker;
    @Autowired
    private JobRunLogService jobRunLogService;

    public void sendToGov() {
        if ("11".equals(this.configUtils.getCurrentNative()) && this.configUtils.isIntranet() && this.configUtils.timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(Boolean.valueOf(true));
            log.setUpdateBy("jobSystem");
            long startTime = System.currentTimeMillis();
            ArrayList<String> filePaths = new ArrayList<String>();
            try {
                this.createBAFWGS(filePaths);
                this.threeCerDao.updateBAFWGSPush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.createBAPXDW(filePaths);
                this.threeCerDao.updateBAPXDWPush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                this.createBAYZGZ(filePaths);
                this.threeCerDao.updateBAYZGZPush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(ThreeCerToGovService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength(endTime - startTime + "ms");
            this.jobRunLogService.insert(log);
        }
    }

    private void createBAFWGS(List<String> filePaths) {
        String[] headerClums = new String[]{"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "XKZZJH", "ZS", "FR", "FWFW", "ZCZB", "PZWH"};
        List data = this.threeCerDao.createBAFWGS();
        this.writeTxt(data, filePaths, headerClums, "bafwxkz");
    }

    private void createBAPXDW(List<String> filePaths) {
        String[] headerClums = new String[]{"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "XKZZJH", "FR", "PXNR", "PZWH", "ZS"};
        List data = this.threeCerDao.createBAPXDW();
        this.writeTxt(data, filePaths, headerClums, "bapxxkz");
    }

    private void createBAYZGZ(List<String> filePaths) {
        String[] headerClums = new String[]{"ZZMC", "ZZHM", "CYRMC", "CYRSFZJLX", "CYRSFZJHM", "FZJGMC", "FZJGZZJGDM", "FZJGSSXZQHDM", "FZRQ", "YXQJSRQ", "MZ", "CSRQ", "ZZ", "ZP"};
        List data = this.threeCerDao.createBAYZGZ();
        if (data.size() < 1) {
            logger.error("\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u4fdd\u5b89\u5458\u8bc1");
            return;
        }
        String idnum = null;
        int limit = 40;
        String threeCerLimit = this.configUtils.getValueByKey(Constants.THREECERLIMIT);
        try {
            limit = Integer.parseInt(threeCerLimit);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int count = new Double(Math.ceil((double)data.size() * 1.0 / (double)limit)).intValue();
        List<Map<Object, Object>> subList = null;
        for (int i = 0; i < count; ++i) {
            subList = data.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
            for (Map map : subList) {
                idnum = map.get("CYRSFZJHM").toString();
                PersonBaseInfo personBaseInfo = this.personBaseInfoDao.findByIdNum(idnum);
                if (personBaseInfo == null || !StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) continue;
                try {
                    map.put("ZP", GetPersonImgUtil.GetImageStr((String)this.getResourcePath(personBaseInfo.getImgPath())).replaceAll("\n", "").replaceAll("\r", "").replaceAll("\r\n", ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.writeTxt(subList, filePaths, headerClums, "zhrmghgbayz");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(List<String> filePaths) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(3600000);
        ftpClient.setControlEncoding("UTF-8");
        try {
            ftpClient.connect(hostname, 21);
            ftpClient.login(username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                logger.error("14.16.176.2ftp \u8fde\u63a5\u5931\u8d25");
                boolean bl = flag;
                return bl;
            }
            logger.error("===========\u767b\u5f55FTP\u6210\u529f\u4e86==========");
            ftpClient.setFileType(2);
            ftpClient.changeWorkingDirectory(pathname);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setBufferSize(0x1400000);
            ftpClient.setKeepAlive(true);
            File file = null;
            String fileName = null;
            FileInputStream inputStream = null;
            for (String filePath : filePaths) {
                try {
                    file = new File(filePath);
                    fileName = file.getName();
                    inputStream = new FileInputStream(file);
                    boolean result = ftpClient.storeFile(new String(fileName.getBytes("utf-8"), "iso-8859-1"), (InputStream)inputStream);
                    if (result) {
                        logger.error(fileName + "===========\u521b\u5efa\u6587\u4ef6\u6210\u529f==============");
                    } else {
                        logger.error(fileName + "===========\u521b\u5efa\u6587\u4ef6\u5931\u8d25==============");
                    }
                    file.delete();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    inputStream.close();
                }
            }
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    private void writeTxt(List<Map<Object, Object>> data, List<String> filePaths, String[] headerClums, String fileName) {
        if (data == null || data.size() < 1) {
            return;
        }
        fileName = fileName + "_" + this.idWorker.nextId() + ".txt";
        String filePath = "";
        filePath = this.configUtils.tempfolder + "/" + DateUtil.getCurrentDate() + "/";
        File dir = new File(filePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        filePath = filePath + fileName;
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(filePath));
            StringBuilder lineValue = null;
            for (int i = 0; i < data.size(); ++i) {
                lineValue = new StringBuilder();
                if (i > 0) {
                    bw.newLine();
                }
                for (int j = 0; j < headerClums.length; ++j) {
                    if (data.get(i).get(headerClums[j]) != null) {
                        lineValue.append(String.valueOf(data.get(i).get(headerClums[j])) + "|");
                        continue;
                    }
                    lineValue.append("|");
                }
                bw.write(lineValue.toString().substring(0, lineValue.toString().length() - 1));
            }
            bw.close();
            filePaths.add(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String fileName, FileInputStream inputStream) {
        boolean flag = false;
        FTPClient ftpClient = new FTPClient();
        ftpClient.setConnectTimeout(3600000);
        ftpClient.setControlEncoding("UTF-8");
        try {
            ftpClient.connect(hostname, 21);
            ftpClient.login(username, password);
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                logger.error("14.16.176.2ftp \u8fde\u63a5\u5931\u8d25");
                boolean bl = flag;
                return bl;
            }
            logger.error("===========\u767b\u5f55FTP\u6210\u529f\u4e86==========");
            ftpClient.setFileType(2);
            ftpClient.changeWorkingDirectory(pathname);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setBufferSize(0x1400000);
            ftpClient.setKeepAlive(true);
            boolean result = ftpClient.storeFile(new String(fileName.getBytes("utf-8"), "iso-8859-1"), (InputStream)inputStream);
            if (result) {
                logger.error(fileName + "===========\u521b\u5efa\u6587\u4ef6\u6210\u529f==============");
            } else {
                logger.error(fileName + "===========\u521b\u5efa\u6587\u4ef6\u5931\u8d25==============");
            }
            inputStream.close();
            ftpClient.logout();
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    private String createExcel(List<Map<Object, Object>> data, String[] headers, String[] headerClums, String fileName) {
        String filePath = "";
        try {
            if (data.size() > 0) {
                Cell cell;
                int i;
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet(fileName);
                Row row = sheet.createRow(0);
                for (i = 0; i < headers.length; ++i) {
                    cell = row.createCell(i);
                    cell.setCellType(1);
                    cell.setCellValue(headers[i]);
                }
                for (i = 1; i <= data.size(); ++i) {
                    row = sheet.createRow(i);
                    for (int j = 0; j < headerClums.length; ++j) {
                        cell = row.createCell(j);
                        cell.setCellType(1);
                        if (data.get(i - 1).get(headerClums[j]) != null) {
                            cell.setCellValue(String.valueOf(data.get(i - 1).get(headerClums[j])));
                            continue;
                        }
                        cell.setCellValue("");
                    }
                }
                filePath = this.configUtils.tempfolder + "/" + DateUtil.getCurrentDate() + "/";
                File dir = new File(filePath);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                filePath = filePath + fileName + "_" + DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + ".xlsx";
                wb.write((OutputStream)new FileOutputStream(filePath));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }
}

