package com.bcxin.ars.timer.personAdapt;

import com.bcxin.ars.dao.sb.PersonAdaptDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.PersonAdapt;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.webservice.BackGroupCensorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 岗位适应性报名自动背景筛查
 */
@Service
public class PersonAdaptCensorStatusService {
    /***
     * 日志
     */
    private static  final  Logger logger = LoggerFactory.getLogger(PersonAdaptCensorStatusService.class);

    @Autowired
    private PersonAdaptDao personAdaptDao;

    @Value("${timeFlag}")
    private String timeFlag = "";

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private JobRunLogService jobRunLogService;

    private static BackGroupCensorService backGroupCensorService;

    /***
     * 先获取背景筛查实现类对
     */
    private void getBackGroupCensorService(){
        if(backGroupCensorService == null){
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }


    public void run() {
        if (configUtils.isIntranet() && timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                getBackGroupCensorService();
                /****
                 * 未背景筛查列表
                 */
                List<PersonAdapt> personList = personAdaptDao.findNoCensorStatus();
                if (personList != null && personList.size() > 0) {
                    for (PersonAdapt personAdapt : personList) {
                        this.getCensorStatus(personAdapt);
                    }
                    /***
                     * 批量更新
                     */
                    personAdaptDao.saveBatch(personList);
                }
            }catch (Exception e){
                logger.error(e.getMessage(),e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(PersonAdaptCensorStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }

    private void getCensorStatus(PersonAdapt personAdapt){
        try {
            Boolean pass = true;
            Date now = new Date();
            //背景筛查开始
            BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
            backgroundApprovalDto.setBusinessid(personAdapt.getId());
            backgroundApprovalDto.setBusinesstype(Constants.PERSONADAPT_CENSORSTATUS);
            backgroundApprovalDto.setIdNumber(personAdapt.getIdNum());
            backgroundApprovalDto.setRealName(personAdapt.getName());

            //背景筛查
            List<BackgroundApproval> list = backGroupCensorService.censor(backgroundApprovalDto);

            //查询结果
            String approvalReason = null;
            //背景筛查结果为空则证明背景筛查异常
            if(list == null || list.size()==0){
                return;
            }
            for (BackgroundApproval backgroundApproval : list) {
                if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                    if (Constants.LIBRARYTYPE_CZ.equals(backgroundApproval.getLibraryType())) {
                        approvalReason = "背景筛查不通过，原因：" + backgroundApproval.getApprovalreason();
                    } else {
                        approvalReason = Constants.BACKGROUNDAPPROVAL_FAIL;
                    }
                    pass = false;
                    break;
                }
            }
            personAdapt.setApprovalReason(approvalReason);
            if (pass) {
                //背景筛查通过
                personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_ZC);
                //审批中
                personAdapt.setApprovalState(Constants.APPLYSTATUS_DSH);
            } else {
                //背景筛查不通过
                personAdapt.setCensorStatus(Constants.BACKGROUNDSTATUS_GZ);
                //审批中
                //#6085573 【公安】现由于添加了申诉入口，等级证报名后背景筛查不通过，审批状态应该变成“审核中”，如果申诉后背景筛查不通过，审批状态才变为“审批不通过”
                personAdapt.setApprovalState(Constants.APPLYSTATUS_DSH);
            }
            //更新背景筛查状态
            personAdapt.setUpdateTime(now);
            personAdapt.setUpdateflag(true);
        }catch (Exception e){
            logger.error("异常"+personAdapt.getIdNum());
        }
    }
}
