package com.bcxin.ars;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.log.LogMessageDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.log.LogMessage;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.HttpClientUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName：BktUserSynchronizationService
 * @Decription: 百课堂用户同步
 * @author：zhongjianhui
 * @date：2018/6/21 9:56
 */
@Service
public class BktUserSynchronizationService {
    private Logger logger = LoggerFactory.getLogger(BktUserSynchronizationService.class);
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private LogMessageDao logMessageDao;

    /***
     * 用户
     */
    @Autowired
    private UserService userService;
    /**
     * 百课堂返回状态--成功
     */
    static public String IS_SUCCESS = "0";
    /**
     * 百课堂返回状态--失败
     */
    static public String IS_FAIL = "-1";

    /**
     * @return void
     * @Decription:同步方法
     * @author：zhongjianhui
     * @method run
     * @date：2018/6/21 9:56
     * @params： * @param
     */
    public void run() {
        //获取数据库公安配置
        Config config = configDao.findByKey(Constants.POLICE);
        String message="";
        //是否为外网，外网才需要同步
        if (config != null && config.getValue() != null && !Constants.ISPOLICE_YES.equals(config.getValue())) {

            try {

                /***
                 * 最后同步日期
                 */
                Config lastDateConfig = configDao.findByKey(Constants.BKT_LASTTIME);
                Boolean isflag = true;
                if (lastDateConfig != null) {
                    String lastDate = lastDateConfig.getValue();
                    String now = DateUtil.getCurrentDate("yyyy-MM-dd");
                    //查找所有的公司用户
                    List<Map> listMap = userService.searchAllCompanyUser(lastDate, now);
                    message="更新的listSize:"+listMap.size();
                    if (listMap.size() > 0) {
                        isflag = false;
                        Map dataMap = new HashMap(listMap.size());
                        dataMap.put("data", JSON.toJSONString(listMap));
                        // dataMap.put("data","dfsf");
                        //获取百课堂配置地址
                        Config configURL = configDao.findByKey(Constants.BKT_DATA_URL);

                        if (configURL != null && configURL.getValue() != null) {
                            //"http://192.168.30.99:8888/"
                            String url = configURL.getValue() + Constants.BTKBATCH_REGIST;
                        //地址访问
                            String btkRtn = HttpClientUtils.doPost(url, dataMap, "utf-8");
                            if (btkRtn != null) {
                                message="返回btkRtn:"+btkRtn;
                                //转成json
                                JSONObject jsonObject = JSONObject.parseObject(btkRtn);
                                //获取状态值
                                String retType = jsonObject.get("retType").toString();
                                String   data = jsonObject.get("data").toString();
                                //判断非空且
                                if (!StringUtils.isEmpty(retType) && IS_SUCCESS.equals(retType)) {
                                    isflag = true;
                                    logger.info("百课堂用户同步成功");
                                } else {
                                    logger.info("百课堂用户同步失败");
                                }
                                if (!StringUtils.isEmpty(data)) {
                                        this.saveLogMessage(message);
                                    }
                            }else {
                                message="访问百课堂返回为空:"+btkRtn;
                                this.saveLogMessage(message);
                            }
                        }
                    }
                    if (isflag) {
                        Config updateConfig = new Config();
                        updateConfig.setKey(Constants.BKT_LASTTIME);
                        updateConfig.setValue(DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2));
                        configDao.update(updateConfig);
                        this.saveLogMessage(message);
                    }
                }
            } catch (Exception e) {
                this.saveLogMessage("抛出错误："+message);
                logger.error(e.getMessage(),e);
            }
        }

    }

    private LogMessage saveLogMessage(String message) {
        LogMessage logMessage = new LogMessage();
        logMessage.setLogger_title("百课堂账号同步");
        logMessage.setCreateTime(new Date());
        logMessage.setLogger_context(message);
        //保持错误日志
        logMessageDao.save(logMessage);
        return logMessage;
    }
}

