package com.bcxin.ars.timer.task;

import com.bcxin.ars.dao.task.ComTaskDao;
import com.bcxin.ars.dao.task.ComTaskDaoAop;
import com.bcxin.ars.dao.task.ComTaskPerDao;
import com.bcxin.ars.dao.task.ComTempTaskDao;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.model.task.ComTask;
import com.bcxin.ars.service.sys.JobRunLogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * @author linqinglin
 * @date 2020/03/26 0026 13:08
 */
@Service
public class ComTaskStatusService {

    private Logger logger = LoggerFactory.getLogger(ComTaskStatusService.class);

    @Autowired
    ComTaskDao comTaskDao;

    @Autowired
    ComTempTaskDao comTempTaskDao;

    @Autowired
    ComTaskDaoAop comTaskDaoAop;

    @Autowired
    private ComTaskPerDao comTaskPerDao;

    @Autowired
    private JobRunLogService jobRunLogService;
    @Value("${timeFlag}")
    private String timeFlag = "";


    public synchronized void autoUpdateTaskStatus(){
        if(timeFlag.equals("true")) {
            JobRunLog log = new JobRunLog();
            log.setCreateTime(new Date());
            log.setActive(true);
            log.setUpdateBy("jobSystem");
            //开始时间
            long startTime = System.currentTimeMillis();
            try {
                comTaskDao.updateStartTaskStatus();
                comTempTaskDao.updateStartTaskStatus();

                List<ComTask> taskList = comTaskDao.findEndTaskList();
                if (taskList.size() > 0) {
                    comTaskDaoAop.endTaskStatus(taskList);
                    comTaskDao.removeRelationTaskList(taskList);
                    comTaskPerDao.deleteByTaskList(taskList);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                log.setExceptionMsg(e.toString());
            }
            //日志信息
            long endTime = System.currentTimeMillis();
            log.setUpdateTime(new Date());
            log.setJobName(ComTaskStatusService.class.getName());
            log.setRunTime(new Date());
            log.setRunTimeLength((endTime - startTime) + "ms");
            jobRunLogService.insert(log);
        }
    }
}
