package com.bcxin.ars.timer.problemPerson;


import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/****
 *
 * 半年一次重新背景筛查人员状态
 * @author subh
 */
@Service
public class RefreshPersonCensorStatus {

    private Logger logger = LoggerFactory.getLogger(RefreshPersonCensorStatus.class);

    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private JobRunLogService jobRunLogService;

    @Value("${ZAFLAG}")
    private String ZAFLAG;

    public void run() {
        //判断是否为公安内网，只有内网才重置状态
        if( configUtils.isIntranet() && ZAFLAG!=null && Constants.ZAFLAG_YES.equals(ZAFLAG)) {
            if(!Constants.BEIJING.equals(configUtils.getCurrentNative())){
                return;
            }
            //查询所有人员
            List<SecurityPerson> personList = securityPersonService.findUnCensor();
            //当背景筛查人数小于10的时候，重置状态
            if(personList!=null && personList.size()<10) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                //重置状态
                securityPersonService.refreshPersonCensorStatus();
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(RefreshPersonCensorStatus.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        }

    }
}
