package com.bcxin.ars.timer.police;

import com.abcxin.smart.validator.annotation.JobLogAnnotation;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 自动背景筛查
 */
@Service
public class OldPersonCensorJob {
	
	private Logger logger = LoggerFactory.getLogger(OldPersonCensorJob.class);

	@Autowired
	private PersoncertificateService personcertificateService;

	@Value("${timeFlag}")
	private String timeFlag = "";

	@Autowired
	private ConfigUtils configUtils;

	private boolean lock = false;

	@JobLogAnnotation(getJobClazz = CerPhotoJob.class)
	public void run() {
		if (lock) {
			return;
		}
		lock = true;

		try {
			String bg_switch = configUtils.getValueByKey("bg_switch");
			if ("0".equals(bg_switch)) {
				return;
			}
			if(!Constants.SHANGXI.equals(configUtils.getCurrentNative())){
				return;
			}

			if (configUtils.isIntranet() && timeFlag.equals("true")) {
				personcertificateService.autoUpdateCensorForImportOldData();
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {
			lock = false;
		}
	}
	
}
