package com.bcxin.ars.timer.person;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.model.sys.JobRunLog;
import com.bcxin.ars.service.sb.ExportService;
import com.bcxin.ars.service.sys.JobRunLogService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 广西自动导出新增，修改的保安员数据
 *
 * @author subh
 */
@Service
public class AutoExportPerson {
    private Logger logger = LoggerFactory.getLogger(AutoExportPerson.class);
    /***
     * 人员
     */
    @Autowired
    private ExportService exportService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private JobRunLogService jobRunLogService;


    private boolean lock = false;

    public void run() {
        if (lock) {
            return;
        }
        lock = true;
        try {

            if (!Constants.GUANGXI.equals(configUtils.getCurrentNative())) {
                return;
            }
            //判断是否为公安内网，只有内网才背景筛查
            if (configUtils.isIntranet()) {
                JobRunLog log = new JobRunLog();
                log.setCreateTime(new Date());
                log.setActive(true);
                log.setUpdateBy("jobSystem");
                //开始时间
                long startTime = System.currentTimeMillis();
                try {

                    PropertiesDTO propertiesDTO = new PropertiesDTO();
                    propertiesDTO.setTableName("v_security_person_export");
                    propertiesDTO.setExcelName("保安员信息");
                    propertiesDTO.setModelPath("com.bcxin.ars.dto.export.AutoSecurityPersonExportDto");
                    //获取昨天的日期
                    Calendar cal = Calendar.getInstance();
                    cal.add(Calendar.DATE, -1);
                    String yesterday = new SimpleDateFormat("yyyy-MM-dd ").format(cal.getTime());
                    //配置查询条件
                    Map searchParams = new HashMap();
                    searchParams.put("areaCode", "450000");
                    searchParams.put("updateTime",yesterday);
                    //所需要查询的字段
                    String jsonStr="[{\"modekey\":\"realName\"},{\"modekey\":\"idNumber\"},{\"modekey\":\"zgcredential\"}," +
                            "{\"modekey\":\"companyName\"},{\"modekey\":\"orgName\"},{\"modekey\":\"districtOrgName\"}," +
                            "{\"modekey\":\"certificateState\"},{\"modekey\":\"identityAuthState\"},{\"modekey\":\"identityAuthTime\"}," +
                            "{\"modekey\":\"personType\"},{\"modekey\":\"gender\"},{\"modekey\":\"incumbencyStatus\"}," +
                            "{\"modekey\":\"inputDate\"},{\"modekey\":\"entrydate\"},{\"modekey\":\"leaveDate\"}," +
                            "{\"modekey\":\"idCardAddress\"},{\"modekey\":\"currentAddress\"},{\"modekey\":\"phone\"}," +
                            "{\"modekey\":\"nation\"},{\"modekey\":\"nativeName\"},{\"modekey\":\"stature\"}," +
                            "{\"modekey\":\"blood\"},{\"modekey\":\"age\"},{\"modekey\":\"edu\"},{\"modekey\":\"professionLevel\"}," +
                            "{\"modekey\":\"credential\"},{\"modekey\":\"outTimeDay\"},{\"modekey\":\"insured\"},{\"modekey\":\"comTaskFlag\"}]";

                    exportService.autoExportPersonInfo(propertiesDTO, jsonStr, searchParams, "保安员信息");
                } catch (Exception e) {
                    logger.error(e.getMessage(), e);
                    log.setExceptionMsg(e.toString());
                    e.printStackTrace();
                }
                //日志信息
                long endTime = System.currentTimeMillis();
                log.setUpdateTime(new Date());
                log.setJobName(AutoExportPerson.class.getName());
                log.setRunTime(new Date());
                log.setRunTimeLength((endTime - startTime) + "ms");
                jobRunLogService.insert(log);
            }
        } finally {
            lock = false;
        }
    }

}


